"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PortalService = void 0;
const device_1 = require("./device");
const native_1 = require("./native");
const signals_1 = require("./signals");
const util_1 = require("util");
class PortalService {
    constructor({ clusterParams = null, controlParams = null } = {}) {
        const impl = new native_1.binding.PortalService(clusterParams, controlParams);
        this.impl = impl;
        this.device = new device_1.Device(impl.device);
        const { signals } = impl;
        this.nodeConnected = new signals_1.Signal(signals, "node-connected");
        this.nodeJoined = new signals_1.Signal(signals, "node-joined");
        this.nodeLeft = new signals_1.Signal(signals, "node-left");
        this.nodeDisconnected = new signals_1.Signal(signals, "node-disconnected");
        this.controllerConnected = new signals_1.Signal(signals, "controller-connected");
        this.controllerDisconnected = new signals_1.Signal(signals, "controller-disconnected");
        this.authenticated = new signals_1.Signal(signals, "authenticated");
        this.subscribe = new signals_1.Signal(signals, "subscribe");
        this.message = new signals_1.Signal(signals, "message");
    }
    start(cancellable) {
        return this.impl.start(cancellable);
    }
    stop(cancellable) {
        return this.impl.stop(cancellable);
    }
    post(connectionId, message, data = null) {
        this.impl.post(connectionId, message, data);
    }
    narrowcast(tag, message, data = null) {
        this.impl.narrowcast(tag, message, data);
    }
    broadcast(message, data = null) {
        this.impl.broadcast(message, data);
    }
    enumerateTags(connectionId) {
        return this.impl.enumerateTags(connectionId);
    }
    tag(connectionId, tag) {
        this.impl.tag(connectionId, tag);
    }
    untag(connectionId, tag) {
        this.impl.untag(connectionId, tag);
    }
    [util_1.inspect.custom]() {
        return "PortalService {}";
    }
}
exports.PortalService = PortalService;
