/// <reference types="node" />
/// <reference types="node" />
import { Cancellable } from "./cancellable";
import { Crash } from "./crash";
import { PortalMembership } from "./portal_membership";
import { Relay } from "./relay";
import { Script, ScriptOptions, SnapshotOptions } from "./script";
import { Signal } from "./signals";
import { inspect } from "util";
export declare class Session {
    private impl;
    detached: Signal<SessionDetachedHandler>;
    constructor(impl: any);
    get pid(): number;
    get persistTimeout(): number;
    get isDetached(): boolean;
    detach(cancellable?: Cancellable): Promise<void>;
    resume(cancellable?: Cancellable): Promise<void>;
    enableChildGating(cancellable?: Cancellable): Promise<void>;
    disableChildGating(cancellable?: Cancellable): Promise<void>;
    createScript(source: string, options?: ScriptOptions, cancellable?: Cancellable): Promise<Script>;
    createScriptFromBytes(bytes: Buffer, options?: ScriptOptions, cancellable?: Cancellable): Promise<Script>;
    compileScript(source: string, options?: ScriptOptions, cancellable?: Cancellable): Promise<Buffer>;
    snapshotScript(embedScript: string, options?: SnapshotOptions, cancellable?: Cancellable): Promise<Buffer>;
    setupPeerConnection(options?: PeerOptions, cancellable?: Cancellable): Promise<void>;
    joinPortal(address: string, options?: PortalOptions, cancellable?: Cancellable): Promise<PortalMembership>;
    [inspect.custom](depth: any, options: any): string;
}
export declare type SessionDetachedHandler = (reason: SessionDetachReason, crash: Crash | null) => void;
export declare enum SessionDetachReason {
    ApplicationRequested = "application-requested",
    ProcessReplaced = "process-replaced",
    ProcessTerminated = "process-terminated",
    ConnectionTerminated = "connection-terminated",
    DeviceLost = "device-lost"
}
export interface PeerOptions {
    stunServer?: string;
    relays?: Relay[];
}
export interface PortalOptions {
    certificate?: string;
    token?: string;
    acl?: string[];
}
