export interface Signals {
    connect(name: string, handler: SignalHandler): void;
    disconnect(name: string, handler: SignalHandler): void;
}
export declare class Signal<T extends SignalHandler> {
    private signals;
    private name;
    constructor(signals: Signals, name: string);
    connect(handler: T): void;
    disconnect(handler: T): void;
}
export declare type SignalHandler = (...args: any[]) => void;
export declare class SignalAdapter implements Signals {
    protected signals: Signals;
    private proxyHandlers;
    constructor(signals: Signals);
    connect(name: string, handler: SignalHandler): void;
    disconnect(name: string, handler: SignalHandler): void;
    protected getProxy(name: string, userHandler: SignalHandler): SignalHandler | null;
}
