"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SignalAdapter = exports.Signal = void 0;
class Signal {
    constructor(signals, name) {
        this.signals = signals;
        this.name = name;
    }
    connect(handler) {
        this.signals.connect(this.name, handler);
    }
    disconnect(handler) {
        this.signals.disconnect(this.name, handler);
    }
}
exports.Signal = Signal;
class SignalAdapter {
    constructor(signals) {
        this.signals = signals;
        this.proxyHandlers = new Map();
    }
    connect(name, handler) {
        const proxyHandler = this.getProxy(name, handler);
        if (proxyHandler !== null) {
            this.proxyHandlers.set(handler, proxyHandler);
            this.signals.connect(name, proxyHandler);
        }
        else {
            this.signals.connect(name, handler);
        }
    }
    disconnect(name, handler) {
        const proxyHandler = this.proxyHandlers.get(handler);
        this.signals.disconnect(name, (proxyHandler !== undefined) ? proxyHandler : handler);
    }
    getProxy(name, userHandler) {
        return null;
    }
}
exports.SignalAdapter = SignalAdapter;
