require 'winapi'

winapi.set_encoding(winapi.CP_UTF8)

function winapi.temp_name() return os.tmpname() end -- overwrite winapi's bug temp_name()

function winapi.files(mask,subdirs,attrib)
    local flags = '/B '
    if subdirs then flags = flags..' /S' end
    if attrib then flags = flags..' /A:'..attrib end
    local ret, text = winapi.execute('dir '..flags..' "'..mask..'"','ansi') --unicode
    if ret ~= 0 then return nil,text end
    return text:gmatch('[^\r\n]+')
end

app_folders = {}

local function bind_to_folder(fpath, tbl)
    local root = tbl
    local paths = fpath:gmatch('[^\\]+')
    local fname
    print(fpath)
    for pname in paths do
      fname = pname
      if root[pname] then
        root = root[pname]
      end
    end
    root[fname] = fpath
end

local function load_programs(drv)
  app_folders[drv] = {}
  local t = app_folders[drv]

  -- create the dir struct first
  local root_path = drv .. [[:\ProgramData\Microsoft\Windows\Start Menu\Programs\]]
  local items, err = winapi.files(root_path .. '*.*', true, 'D')
  if not items then return print(err) end

  local rpath, paths
  local root = nil
  for f in items do
    rpath = f:gsub(root_path, '')
    root = t
    paths = rpath:gmatch('[^\\]+')
    for pname in paths do
      if root[pname] then
        root = root[pname]
      else
        root[pname] = {}
      end
    end
  end

  items, err = winapi.files(root_path .. '*.*', true, '-D')
  if not items then return print(err) end
  local lpath = ''
  	  table.print(t)
  for f in items do
    rpath = f:gsub(root_path, '')
    if not rpath:lower():match('desktop.ini$') then
      bind_to_folder(rpath, t)
    end
  end
  -- table.print(app_folders['C'])
end

local function pairsByKeys (t, f)
  local a = {}
  for n in pairs(t) do table.insert(a, n) end
  table.sort(a, f)
  local i = 0      -- iterator variable
  local iter = function ()   -- iterator function
    i = i + 1
    if a[i] == nil then return nil
    else return a[i], t[a[i]]
    end
  end
  return iter
end

local function space(n)
  return string.rep('   ', n)
end

local xml = ''
local function app_walk(t, level, fpath)
    local str = ''
    local vis = [[folderattr="selected=&quot;true&quot;"]]
    if level > 0 then vis = [[folderattr="selected=&quot;false&quot;" visible="false"]] end
    for k, v in pairsByKeys(t) do
        if type(v) == 'table' then
            --print(space(level) .. k)
            str = string.format([[<TreeNode text="%s" %s style="folder_node" >]] .. '\n', k, vis)
            xml = xml .. space(level) .. str
            app_walk(v, level + 1, fpath .. '\\' .. k)
            xml = xml .. space(level) .. '</TreeNode>\n'
        else
            --print(string.rep('   ', level) .. k)
            local text = string.match(k, '[^\\.]+')
            xml = xml .. space(level) ..
            string.format([[<TreeNode text="%s" %s style="item_node" itemattr="bkimage=&quot;file='%s,F' dest='4,4,28,28'&quot;" />]] .. '\n', text, vis, fpath .. '\\' .. k)
        end
    end
end

function app_tree_xml(drv)
  xml = ''
  load_programs(drv)
  local tree = app_folders[drv]
  --table.print(tree)
  app_walk(tree, 0, drv .. [[:\ProgramData\Microsoft\Windows\Start Menu\Programs\]])
   -- print(xml)
  return xml
end
