

dofile(sui:info('uipath') .. 'apps_tree.lua')

local function update_date_cell()
  local today = os.time()
  label_weekname.text = string.format('%%{info_w%s}', os.date('%w', today))
  label_date.text = string.format('%d', os.date('%d', today))
end

function onload()
  label_weekname = sui:find('label_weekname')
  label_date = sui:find('label_date')
  update_date_cell() -- update in onshow() event only, maybe good if updating with a TIMER
  local lp = sui:find('$left_panel')
  local xml = app_tree_xml('C')
  lp:add([[<elem><Treeview name="app_tree" visible="true" width="300" vscrollbar="true"]] ..
         [[style="ct-bkpanel" itemhotbkcolor="#FF196AA8" itemselectedbkcolor="#FF196AA8" >]] ..
         xml .. [[</Treeview></elem>]])
  --app_tree = sui:find('app_tree')
end

function onshow()
  if label_weekname == nil then return end
  update_date_cell()
end

function onclick(ctrl)
  if ctrl == "firefox" then
    suilib.call("run", "C:\\Program Files (x86)\\Mozilla Firefox\\firefox.exe")
  elseif ctrl == "calc" then
    suilib.call("run", "calc.exe")
  elseif ctrl == "notepad" then
    suilib.call("run", "notepad.exe")
  elseif ctrl == "notepad_paramter" then
    suilib.call("run", "notepad.exe", "C:\\setup.log")
  end
end

