fixscreen_opt = ''
if App:HasOption('-fixscreen') then fixscreen_opt = '-fixscreen' end

UI_Path = sui:info('uipath')

dofile(UI_Path .. 'parts\\page.systeminfo.lua')
dofile(UI_Path .. 'parts\\page.display.lua')
dofile(UI_Path .. 'parts\\page.colors.lua')
dofile(UI_Path .. 'parts\\page.folderoptions.lua')
dofile(UI_Path .. 'parts\\page.taskbar.lua')
dofile(UI_Path .. 'parts\\tab.nav.lua')

local function init_navtab()
  NavTab = NavTab_Init()
  NavTab.OnClick = NavTab_OnClick
end

local function init_pages_settings()
  UIPages:Init('SystemInfo', NavTab)
  UIPages:Init('Display', NavTab)
  UIPages:Init('Background', NavTab)
  UIPages:Init('Colors', NavTab)
  UIPages:Init('FolderOptions', NavTab)
  UIPages:Init('Taskbar', NavTab)
end

function UIWindow.Init()
  if not os.exists("%windir%\\Fonts\\segmdl2.ttf") then
    App:LoadFont(App.Path .. '\\wxsUI\\segmdl2.ttf')
  end
  if not os.exists("%windir%\\Fonts\\SegoeIcons.ttf") then
    App:LoadFont(App.Path .. '\\wxsUI\\SegoeIcons.ttf')
  end
end

function UIWindow.OnLoad()
  -- TODO: more simple way for resource string
  for i = 1, 6 do
    UI.UpdateText('#res_' .. i)  -- expand resource string
  end

  if App:Var('RoundedCornersEnabled') and os.winname == 'Win11' then
    sui:find('::body').padding = '0,0,0,0'
  end

  UI.UpdateText('compmgmt_button')
  UI.UpdateText('$Opt.SysColorTheme[light]')
  UI.UpdateText('$Opt.SysColorTheme[dark]')

  init_navtab()
  init_pages_settings()

  UIWindow.Inited = 1
  if App:HasOption('-systeminfo') then
    NavTab:Click('SystemInfo')
  elseif App:HasOption('-display') then
    NavTab:Click('Display')
  elseif App:HasOption('-colors') then
    NavTab:Click('Colors')
  else
    NavTab:Click('Taskbar')
  end
end

