
UIPages['Colors'] = {
  Name = 'Colors'
}

UIPages['Colors'].Init = function()
    local ct_name = 'dark'
    if System:GetSetting('SysColorTheme') == 1 then ct_name = 'light' end
    local opt = sui:find('$Opt.SysColorTheme[' .. ct_name .. ']')
    opt.selected = 1
  
    UIOption.Set('$Opt.SysColorTheme[?]',
      System:GetSetting('SysColorTheme') == 1, {'light', 'dark'})

    UIOption.Set('$Opt.AppsColorTheme[?]',
      System:GetSetting('AppsColorTheme') == 1, {'light', 'dark'})

    local onoff = System:GetSetting('Colors.Transparency')
    UISwitch.Set('$Switch.ColorsTransparency', onoff)

    if System:GetSetting('ShellColorPrevalence') == 1 then UICheckBox.Check('$Chk.ApplyACShell') end
    if System:GetSetting('WindowColorPrevalence') == 1 then UICheckBox.Check('$Chk.ApplyACWindow') end
end


local function restart()
  wxsUI('UI_Settings','main.jcfg','-colors ' .. fixscreen_opt)
  suilib.close()
end


UI.OnClick['$Opt.SysColorTheme'] = function(opt)
  System:SysColorTheme(opt)
end

UI.OnClick['$Opt.AppsColorTheme'] = function(opt)
  System:AppsColorTheme(opt)
  restart()
end

UI.OnChanged['$Switch.ColorsTransparency'] = function(val)
  System:SetSetting('Colors.Transparency', val)
end

UI.OnChanged['$Chk.ApplyACShell'] = function(val)
  System:SetSetting('ShellColorPrevalence', val)
end

UI.OnChanged['$Chk.ApplyACWindow'] = function(val)
  System:SetSetting('WindowColorPrevalence', val)
end
