
AUTO_RESTORE_SEC = 15
dpi_list = {["100"] = 0, ["125"] = 1, ["150"] = 2, ["175"] = 3, ["200"] = 4, ["225"] = 5, ["250"] = 6, ["300"] = 7}


UIPages['Display'] = {
  Name = 'Display'
}

UIPages['Display'].Init = function(self, tab)
    dpi_combo = sui:find('dpi_combo')
    resolution_combo = sui:find('resolution_combo')
    rotate_combo = sui:find('rotate_combo')
    display_applybtn = sui:find('display_applybtn')
    display_restorebtn = sui:find('display_restorebtn')
    org_display_restorebtn_text = display_restorebtn.text -- save origin retore button text for retore timer
  
    if sui:i18n('DPI_Desc') == '${display:none}' then
      sui:find('DPI_Label').height = 40
      sui:find('DPI_Desc').visible = 0
    end

    if sui:i18n('Resolution_Desc') == '${display:none}' then
      sui:find('Resolution_Label').height = 40
      sui:find('Resolution_Desc').visible = 0
    end

    tab:OnClick(self.Name) -- be visible for changing combobox index
  
    last_dpi = 0
    local cdpi =Screen:Get('DPI')
    local dpi_index = dpi_list['' .. cdpi]
    if dpi_index ~= nil then
      dpi_combo.index = dpi_index
    else
      if cdpi > 100 then
        dpi_index = (cdpi - 100 + 5) // 25
      end
    end
    last_dpi = dpi_index
    resolution_combo.list = suilib.call('GetResolutionList')
    resolution_combo.index = suilib.call('GetCurrentResolution')
  
    rotate_combo.index = suilib.call('GetRotation')
  
    last_resolution = resolution_combo.text
    last_rotate = rotate_combo.index
  
    brightness_slider = sui:find('brightness_slider')
    brightness_val = Screen:Get('brightness')
    brightness_slider.value = brightness_val
end

local function fixscreen()
  print("fixscreen", tostring(fixscreen_opt))
  if fixscreen_opt ~= '' then
      App:Call('Desktop::UpdateWallpaper')
      App:Sleep(200)
      App:Call('Taskbar::ChangeNotify')
  end
end

local function display_ui_restore(mouse, visible)
  resolution_combo.mouse = mouse
  rotate_combo.mouse = mouse
  display_applybtn.visible = visible
  display_restorebtn.visible = visible
end

local function display_combo_changed()
  fixscreen()
  -- set auto restore timer
  display_restore_counter = AUTO_RESTORE_SEC

  display_ui_restore('false', 1)

  display_restorebtn.text = string.format('[%d]%s', display_restore_counter, org_display_restorebtn_text)
  UI:SetTimer('AUTO_RESTORE_COUNTER', 1000)
end

local function display_applybtn_click()
  UI:KillTimer('AUTO_RESTORE_COUNTER')

  last_resolution = resolution_combo.text
  last_rotate = rotate_combo.index

  display_ui_restore('true', 0)
end

local function display_restorebtn_click()
  UI:KillTimer('AUTO_RESTORE_COUNTER')

  suilib.call('SetResolution', last_resolution)
  suilib.call('SetRotation', last_rotate)
  fixscreen()
  resolution_combo.index = last_resolution
  rotate_combo.index = last_rotate

  display_ui_restore('true', 0)
end


UI.OnChanged['resolution_combo'] = function(val)
  if last_resolution == resolution_combo.text then return end

  suilib.call('SetResolution', resolution_combo.text)
  display_combo_changed()
end

UI.OnChanged['rotate_combo'] = function(val)
  if last_rotate == val then return end

  suilib.call('SetRotation', val)
  display_combo_changed()
end

UI.OnChanged['dpi_combo'] = function(val)
  if val == 7 then
    Screen:Set('DPI', 300)
  else
    Screen:Set('DPI', (val * 25) + 100) -- TODO: custom dpi
  end
end

UI.OnChanged['brightness_slider'] = function(val, ctrl)
  brightness_val = val
  UI:SetTimer('RESET.BRIGHTNESS_TIMER', 200)
end

UI.OnClick['display_applybtn'] = function(ctrl)
  display_applybtn_click()
end

UI.OnClick['display_restorebtn'] = function(ctrl)
  display_restorebtn_click()
end

UI.OnTimer['AUTO_RESTORE_COUNTER'] = function(tid)
  display_restore_counter = display_restore_counter - 1
  display_restorebtn.text = string.format('[%d]%s', display_restore_counter, org_display_restorebtn_text)
  -- auto restore
  if (display_restore_counter <= 0) then
      display_restorebtn_click()
  end
end

UI.OnTimer['RESET.BRIGHTNESS_TIMER'] = function(tid)
  local val = math.floor(brightness_val / 10 + 0.5) * 10;
  Screen:Set('brightness', val)
end
