
UIPages['SystemInfo'] = {
  Name = 'SystemInfo'
}

UICached = {} 
local function set_text(name, text)
  if not UICached[name] then
    UICached[name] = sui:find(name)
  end
  UICached[name].text = text
end

local function set_res(name, id, file)
  file = file or 'systemcpl.dll'
  set_text(name, str.format('#{@%s,%s}', file, id))
end

local ui_device_panel
local ui_network_panel
local ui_device_panel_initedheight = 0
local ui_network_panel_initedheight = 0

UIPages['SystemInfo'].Init = function()

  set_text('username_text', os.getenv('USERNAME'))

  set_res('card_cpu_label', 1562)

  local memlabel = sui:i18n('MemCardLabel')
  if memlabel == '' then
    set_text('card_mem_label', 'RAM:')
  end

  local computername = Reg:Read([[HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ComputerName\ComputerName]]
        , 'ComputerName')
  set_text('hostname_text', computername)
  set_text('host_text', computername)

  -- BIOS
  local bios_mf = Reg:Read([[HKEY_LOCAL_MACHINE\HARDWARE\DESCRIPTION\System\BIOS]], "SystemManufacturer")
  local bios_pn = Reg:Read([[HKEY_LOCAL_MACHINE\HARDWARE\DESCRIPTION\System\BIOS]], "SystemProductName")
  if bios_mf == nil then bios_mf = 'N/A' end
  if bios_pn == nil then bios_pn = 'N/A' end

  set_res('mfgr_label', 1572)
  set_res('model_label', 1574)
  set_res('cpu_label', 1562)
  set_res('mem_label', 1564)
  set_res('arch_label',1571)

  set_text('mfgr_text', bios_mf)
  set_text('model_text', bios_pn)

  local cpu_t = os.info('CPU')

  if cpu_t then
    local cpu_f = cpu_t['~MHz']
    cpu_f = cpu_f / 1000
    cpu_fstr = str.format("%.2fGHz", cpu_f)

    -- shorter CPU name
    local card_cpuname = cpu_t['name']
    -- Intel
    card_cpuname = card_cpuname:gsub(" CPU", '')
    if #card_cpuname > 36 then
      card_cpuname = card_cpuname:gsub("Intel%(R%)", 'Intel')
      card_cpuname = card_cpuname:gsub("Core%(TM%)", 'Core')
    end
    -- AMD
      -- ' Threadripper ' => ' TR '
      -- 'Quad-Core' => '4-Core'
      -- 'Six-Core' => '6-Core'
      -- 'Eight-Core' => '8-Core'
      -- '-Core Processor' => '-Core'
    card_cpuname = card_cpuname:gsub(' Threadripper ', ' TR ')
    card_cpuname = card_cpuname:gsub('Quad%-Core', '4-Core')
    card_cpuname = card_cpuname:gsub('Six%-Core', '6-Core')
    card_cpuname = card_cpuname:gsub('Eight%-Core', '8-Core')
    card_cpuname = card_cpuname:gsub(' Processor', '')

    set_text('card_cpuname_text', card_cpuname)
    set_text('card_cpuMHz_text', cpu_fstr)
    set_text('cpu_text', cpu_t['name'] .. ' ' .. cpu_fstr)
  end

  -- local mem_format = mui_str('systemcpl.dll', 45)
  local mem_format = string.resstr('#{@systemcpl.dll,45}')

  local mem_t = os.info('MEM')
  local total_phys = str.format("%.2f GB", mem_t['total_gb'])

  local avail_phys = mem_t['total'] / 0x40000000 -- 1024*1024*1024
  avail_phys = str.format("%.2f GB", avail_phys)

  local now_avail = str.format("#{@shell32.dll,9307} %.2f GB", mem_t['avail_gb'])
  local mem_s = str.format(mem_format, total_phys, avail_phys)
  set_text('mem_text', mem_s)

  set_text('card_memsize_text', total_phys)
  if os.localename == 'zh-CN' or os.localename == 'zh-TW' then
    set_text('card_memavail_label', '#{@shell32.dll,9307}')
  else
    set_text('card_memavail_label', '#{@crypt32.dll,7033}')
  end
  set_text('card_memavail_text', str.format("%.2f GB", mem_t['avail_gb']))
  set_text('card_memusage_text', mem_t['used%'] .. '%')

  local diskinfo = os.info('disk')
  set_text('card_disksize_text', diskinfo['total_desc'])
  local fmt = sui:i18n('FmtDiskNum')
  set_text('card_disknum_text', str.format(fmt, diskinfo['count']))

  local gpuinfo = os.info('gpu')
  set_text('card_gpumem_text', gpuinfo['memsize_info'])
  set_text('card_gpuname_text', gpuinfo['name'])

  local arch_id = 0
  if ARCH == 'x86' then
    arch_id = 56 -- Windows 10
    if vernum == "6.1" then arch_id = 23 end -- Windows 7
  else
    arch_id = 60 -- Windows 10
    if vernum == "6.1" then arch_id = 24 end -- Windows 7
  end
  set_res('arch_text', arch_id)

  local ver_info = Reg:Read([[HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion]]
    ,{'ProductName', 'CSDVersion', 'DisplayVersion'})

  local pname = os.info('osver')['ProductName']
  -- test long product name
  -- pname =  'Windows Server 2025 Datacenter Edition'
  if #pname >= 28 then
    sui:find('product_text').width = 300
    sui:find('hostname_text').width = 300
  end
  set_text('product_text', pname)

  if ver_info['DisplayVersion'] == nil then
    set_text('vername_text', os.info('winver')['ver'])
  else
    set_text('vername_text', str.format("%s (%s)", ver_info['DisplayVersion'], os.info('winver')['ver']))
  end
  local arch_env = Reg:Read([[HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment]], 'PROCESSOR_ARCHITECTURE')
  set_text('arch_env_text', arch_env)

  local wg = os.getenv('USERDNSDOMAIN') or 'WorkGroup'
  set_text('workgroup_text', wg)
  set_res('host_settings_btn', 1546)

  -- FirmwareType
  set_text('firmwaretype_text', os.info('FirmwareType'))

  set_text('disk_text[1]', "KINGSTON SA400S37480G (480 GB)")
  set_text('disk_text[2]', "KINGSTON SANV2S1000G (1.0 TB)")
  set_text('disk_text[3]', "Romex RAMDISK SCSI Device (6 GB)")

  sui:find('devmgmt_btn').text = '#{@systemcpl.dll,100}'
  sui:find('rmt_btn').text = '#{@systemcpl.dll,101}'
  sui:find('adv_btn').text = '#{@systemcpl.dll,103}'

  local btn_width = ''
  btn_width = sui:i18n('devmgmt_btn.width')
  if btn_width ~= '' then
    sui:find('devmgmt_btn').width = tonumber(btn_width)
  end

  btn_width = sui:i18n('rmt_btn.width')
  if btn_width ~= '' then
    sui:find('rmt_btn').width = tonumber(btn_width)
  end

  btn_width = sui:i18n('adv_btn.width')
  if btn_width ~= '' then
    sui:find('adv_btn').width = tonumber(btn_width)
  end

  ui_device_panel = sui:find('device_panel')
  ui_network_panel = sui:find('network_panel')

  ui_device_panel_initedheight = ui_device_panel.fixedheight
  ui_network_panel_initedheight = ui_network_panel.fixedheight
  ui_network_panel.height = 60 + 2

  set_text('card_cpuusage_text', os.info('CPUUsage') .. '%')
  UI:SetTimer('Update Cards Info', 3000)
end


UI.OnTimer['Update Cards Info'] = function()
  set_text('card_cpuusage_text', os.info('CPUUsage') .. '%')
  set_text('card_memusage_text', os.info('MEM')['used%'] .. '%')
end

UI.OnChanged['device_header'] = function(val)
  if val == 1 then
    ui_device_panel.height = 60 + 2
  else
    ui_device_panel.height = ui_device_panel_initedheight
  end
end

UI.OnChanged['network_header'] = function(val)
  if val == 1 then
    ui_network_panel.height = 60 + 2
    return
  end

  ui_network_panel.height = ui_network_panel_initedheight
  local stdout = Cmd.Stdout('cmd.exe /c ipconfig.exe /all')
  stdout = stdout:gsub(". . . . . :", ":")
  stdout = stdout:gsub("                                       ", "                             ")
  set_text('network_edit', stdout)
end

UI.OnClick['devmgmt_btn'] = function()
  -- lua built-in function, but with cmd.exe's black window flushing
  --os.execute('start devmgmt.msc')
  App:Run('devmgmt.msc')
end

UI.OnClick['rmt_btn'] = function()
  App:Run('systempropertiesremote.exe')
end

UI.OnClick['adv_btn'] = function()
  App:Run('systempropertiesadvanced.exe')
end
