UIPages['Taskbar'] = {}

UIPages['Taskbar'].Init = function()
    local onoff = Taskbar:GetSetting('AutoHide')
    UISwitch.Set('$Switch.TaskbarAutoHide', onoff)

    onoff = (Taskbar:GetSetting('TaskbarSmallIcons') or 0) | 0 -- to integer
    UISwitch.Set('$Switch.TaskbarSmallIcons', onoff)

    local glomlevel = (Taskbar:GetSetting('TaskbarGlomLevel') or 2) | 0
    UIOption.Set('$Opt.CombineButtons[?]', glomlevel + 1, {'always', 'auto', 'never'})
end

UI.OnChanged['$Switch.TaskbarAutoHide'] = function(val)
  Taskbar:AutoHide(val)
end

UI.OnChanged['$Switch.TaskbarSmallIcons'] = function(val)
  Taskbar:UseSmallIcons(val)
end

UI.OnClick['$Opt.CombineButtons'] = function(opt)
  Taskbar:CombineButtons(opt)
end
