
applybtn = sui:find('applybtn')
cancelbtn = sui:find('cancelbtn')
restorebtn = sui:find('restorebtn')
closebtn = sui:find('closebtn')

resolution_combo = sui:find('resolution_combo')
rotate_combo = sui:find('rotate_combo')

RESTORE_TIMER_ID = 1000
AUTO_RESTORE_SEC = 15
restore_counter = AUTO_RESTORE_SEC
org_restorebtn_text = restorebtn.text -- save origin retore button text for retore timer

function onload()
    resolution_combo.list = suilib.call('GetResolutionList')
    resolution_combo.index = suilib.call('GetCurrentResolution')

    rotate_combo.index = suilib.call('GetRotation')
    last_resolution = resolution_combo.text
    last_rotate = rotate_combo.index
    applybtn.enabled = 0 -- disable apply button
    if App:HasOption('-direct') then
        direct_mode = 1
    end
    loaded = true
end


function onchanged(ctrl)
    if not loaded then return end
    if ctrl == "resolution_combo" or ctrl == "rotate_combo" then
        -- change the resolution/rotate directly if has '-direct' option
        if direct_mode == 1 then
            -- oops, you can change the settings even in auto restore counting.
            -- Can you fix this?
            applybtn_click()
        else
            applybtn.enabled = 1
        end
    end
end

function ontimer(id)
    suilib.print('ontimer:' .. id)
    if (id == RESTORE_TIMER_ID) then
        restore_counter = restore_counter - 1
        restorebtn.text = string.format('[%d]%s', restore_counter, org_restorebtn_text)
        -- auto restore
        if (restore_counter <= 0) then
            suilib.call('KillTimer', id)
            restorebtn_click()
        end
    end
end

function applybtn_click()
    suilib.call('SetResolution', resolution_combo.text)
    suilib.call('SetRotation', rotate_combo.index)
    applybtn.visible = 0
    cancelbtn.visible = 0
    closebtn.visible = 1
    restorebtn.visible = 1
    -- set auto restore timer
    restore_counter = AUTO_RESTORE_SEC
    restorebtn.text = string.format('[%d]%s', restore_counter, org_restorebtn_text)
    suilib.call('SetTimer', RESTORE_TIMER_ID, 1000)
end


function restorebtn_click()
    suilib.call('KillTimer', RESTORE_TIMER_ID)
    suilib.call('SetResolution', last_resolution)
    suilib.call('SetRotation', last_rotate)
    resolution_combo.index = last_resolution
    rotate_combo.index = last_rotate
    applybtn.visible = 1
    cancelbtn.visible = 1
    closebtn.visible = 0
    restorebtn.visible = 0
    applybtn.enabled = 0
end

function onclick(ctrl)
    if ctrl == "applybtn" then
        applybtn_click()
    elseif ctrl == "restorebtn" then
        restorebtn_click()
    elseif ctrl == "closebtn" or ctrl == "cancelbtn" then
        sui:close()
    end
end
