local trayIconFiles = {
  IconType = "FILE",

  ICID_TRAY_NET_WIRED_DIS = "trayicons/%SuiTray.Theme%/tray_network_wired_dis.ico",
  ICID_TRAY_NET_WIRED_LAN = "trayicons/%SuiTray.Theme%/tray_network_wired_lan.ico",
  ICID_TRAY_NET_WIRED_INTERNET = "trayicons/%SuiTray.Theme%/tray_network_wired_internet.ico",
  ICID_TRAY_NET_WIRELESS_DIS = "trayicons/%SuiTray.Theme%/tray_network_wireless_dis.ico",
  ICID_TRAY_NET_WIRELESS_NOCONN_LEGACY = "trayicons/%SuiTray.Theme%/tray_network_wireless_noconn_legacy.ico",
  ICID_TRAY_NET_WIRELESS_NOCONN = "trayicons/%SuiTray.Theme%/tray_network_wireless_noconn.ico",
  ICID_TRAY_NET_WIRELESS_LAN = "trayicons/%SuiTray.Theme%/tray_network_wireless_lan.ico",

  ICID_TRAY_NET_SIGNAL_NONE = "trayicons/%SuiTray.Theme%/tray_network_signal_0.ico",
  ICID_TRAY_NET_SIGNAL_QUARTER1 = "trayicons/%SuiTray.Theme%/tray_network_signal_25.ico",
  ICID_TRAY_NET_SIGNAL_QUARTER2 = "trayicons/%SuiTray.Theme%/tray_network_signal_50.ico",
  ICID_TRAY_NET_SIGNAL_QUARTER3 = "trayicons/%SuiTray.Theme%/tray_network_signal_75.ico",
  ICID_TRAY_NET_SIGNAL_QUARTER4 = "trayicons/%SuiTray.Theme%/tray_network_signal_100.ico",
}


local traySymbolIcons = {
  IconType = "SymbolIcon",
  IconFont = "Segoe Fluent Icons",

  ICID_TRAY_NET_WIRED_DIS = "&#xEB55",
  ICID_TRAY_NET_WIRED_LAN = "&#xEB56",
  ICID_TRAY_NET_WIRED_INTERNET = "&#xE904",
  ICID_TRAY_NET_WIRELESS_DIS = "&#xE904",
  ICID_TRAY_NET_WIRELESS_NOCONN_LEGACY = "&#xE904",
  ICID_TRAY_NET_WIRELESS_NOCONN = "&#xE904",
  ICID_TRAY_NET_WIRELESS_LAN = "&#xE904",

  ICID_TRAY_NET_SIGNAL_NONE = "&#xE904",
  ICID_TRAY_NET_SIGNAL_QUARTER1 = "&#xEC3C",
  ICID_TRAY_NET_SIGNAL_QUARTER2 = "&#xEC3D",
  ICID_TRAY_NET_SIGNAL_QUARTER3 = "&#xEC3E",
  ICID_TRAY_NET_SIGNAL_QUARTER4 = "&#xEC3F",
}

function UIWindow:Init()
  SuiTray = {}
  SuiTray.Theme = 'default'
  SuiTray.Icons = trayIconFiles

  local theme = sui:jcfg('res_theme')
  if theme == 'light' then SuiTray.Theme = 'dark' end

  if os.info('winver')[3] >= 22000 then
    SuiTray.Theme = 'win11' .. SuiTray.Theme
  end
end

function UIWindow:OnLoad()
  UIWindow.Inited = 1
end

UI.OnClick['dialup'] = function()
  App:Run('rasphone.exe')
end

UI.OnClick['netsettings'] = function()
  --control.exe /name Microsoft.NetworkAndSharingCenter
  App:Run('WinXShell.exe', 'wxs-open:netsettings')
end

UI.OnClick['proxysettings'] = function()
  App:Run('rundll32.exe', 'Shell32.dll,Control_RunDLL inetcpl.cpl,,4')
end

UI.OnClick['launch_osk'] = function()
    App:Run('osk.exe')
end
