--[[
      Leap Month           L
      14 13 12 11 | 10 F E D | C B A 9 | 8 7 6 5 | 4 3 2 1
2018   0  0  0  0 |  1 1 0 0 | 1 1 0 1 | 0 1 0 0 | 1 0 1 0
2019   0  0  0  0 |  1 1 0 0 | 1 1 0 0 | 1 0 0 1 | 0 1 0 1
2020   0  1  0  0 |  1 1 0 0 | 1 0 1 0 | 1 0 0 1 | 1 1 1 0
2021   0  0  0  0 |  1 0 0 0 | 0 1 0 1 | 0 1 0 1 | 0 1 1 0
2022   0  0  0  0 |  0 1 0 0 | 1 0 1 0 | 1 0 1 1 | 0 1 0 1
2023   0  0  1  0 |  1 0 0 0 | 1 0 1 0 | 1 1 0 1 | 1 0 1 0
2024   0  0  0  0 |  1 0 0 0 | 0 1 1 0 | 1 1 0 1 | 0 0 1 0
2025   0  1  1  0 |  0 1 0 0 | 0 1 1 1 | 0 1 1 0 | 0 1 0 1
2026   0  0  0  0 |  0 1 0 0 | 0 1 1 1 | 0 0 1 0 | 0 1 0 1
]]

lunar_data = {
    ["2018"] = {0,11,15,0x0CD4A},
    ["2019"] = {0,11,26,0x0CC95},
    ["2020"] = {0,12, 7,0x4CA9E},
    ["2021"] = {0,11,18,0x08956},
    ["2022"] = {0,11,29,0x04AB5},
    ["2023"] = {0,12,10,0x28ADA},
    ["2024"] = {0,11,20,0x086D2},
    ["2025"] = {0,12, 2,0x64765},
    ["2026"] = {0,11,13,0x04725},
}

lunar_cache = {}

local function get_month_day(year, mon)
  local days = {31,28,31,30,31,30,31,31,30,31,30,31}
  if mon == 2 and year % 4 == 0 then  -- enough for 1901~2099
    return 29
  else
    return days[mon]
  end
end

local lunar = {}
local lunar_enabled = false

function lunar_init()
    local locale =  sui:jcfg('lunar')
    if locale == 'none' then return end
    if locale == nil or locale == 'auto' then locale = os.info('locale') end

    local lf = sui:info('uipath') .. 'lunar.' .. locale .. '.lua'
    if not File.Exists(lf) then return end

    dofile(lf)
    -- month_days_area.height = 482
    for i=1,6 do
        for j=1,7 do
          d[i ..j].multiline = "true"
        end
    end
    sui:move(0, -72, 0, 72)
    lunar_enabled = true
end

function lunar.get_disp_text(m, d, leap)
   local key_md = string.format("%02d%02d", m, d)
    if lunar_specs[key_md] ~= nil then return lunar_specs[key_md] end
    if d == 1 then
        local str_m = lunar_months[m]
        if leap == 1 then str_m =  '<f 12>' .. lunar_leap_name .. str_m .. '</f>' end
        return str_m 
    end
    return lunar_days[d]
end

function lunar.init_month_text(y, m, lm, ld, leap, lbits, lm_shift)
    local ym = string.format("%02d%02d", y, m)

    local mon_text = {}
    local n = get_month_day(y, m)

    local leap_month = lbits & 0xF0000
    leap_month = leap_month >> 16

    local be30d = lbits & (1 << (lm + lm_shift - 1))
    if leap == 1 then be30d = lbits & (1 << 12) end
    if be30d > 0 then be30d = 1 end
    App:Print(ym .. ":[" .. lm .. "," .. ld .. "] " .. be30d)
    for d = 1, n do
        mon_text[d] = lunar.get_disp_text(lm, ld, leap)
        if be30d == 0 and lm == 12 and ld == 29 then
            mon_text[d] = lunar.get_disp_text(12, 30, 0)
        end
        -- App:Print(d .. ":" .. mon_text[d])
        -- next lunar day
        ld = ld + 1
        if ld > 29 + be30d then
            ld = 1
            -- next month
            if (leap == 0 and leap_month == lm) then
                leap = 1
            else 
                lm = lm + 1
                if leap == 1 then leap = 0 end
            end
            if lm == 13 then
                lm_shift = 0
                lm = 1
            end
            if leap == 1 then
                be30d = lbits & (1 << 12)
            else
                be30d = lbits & (1 << (lm + lm_shift - 1))
            end
            if be30d > 0 then be30d = 1 end
        end
    end
    lunar_cache[ym] = mon_text
    return lm, ld, leap, lm_shift
end

function lunar.get_year_text(y)
    local str_y = string.format("%d", y)
    -- return from lunar_cache
    if lunar_cache[str_y] ~= nil then return lunar_cache[str_y] end

    local ldata = lunar_data[str_y]
    if ldata == nil then return nil end

    local mon_text = {}
    local lm = ldata[2]  -- lunar month
    local ld = ldata[3]  -- lunar day
    local leap = 0
    local lbits = ldata[4] -- lunar bits
    local lm_shift = 4
    local m = 1
    for m = 1, 12 do
        lm, ld, leap, lm_shift = lunar.init_month_text(y, m, lm, ld, leap, lbits, lm_shift)
    end
    lunar_cache[str_y] = 1
    return 1
end

function lunar.get_month_text(y, m)
    local ym = string.format("%02d%02d", y, m)
    -- return from lunar_cache
    if lunar_cache[ym] ~= nil then return lunar_cache[ym] end

    if lunar.get_year_text(y) == nil then return nil end
    return lunar_cache[ym]
end

function get_day_text(y, m, d)
    if not lunar_enabled then return d end

    local ldata = lunar.get_month_text(y, m)
    if  ldata == nil then return d end
    return d .. '\n' .. ldata[d]
    -- return d .. '\n' .. d
end
