// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

namespace MQTTnet.Internal;

public abstract class Disposable : IDisposable
{
    protected bool IsDisposed { get; private set; }

    protected void ThrowIfDisposed()
    {
        ObjectDisposedException.ThrowIf(IsDisposed, GetType());
    }

    protected virtual void Dispose(bool disposing)
    {
    }

    // This code added to correctly implement the disposable pattern.
    public void Dispose()
    {
        // Do not change this code. Put cleanup code in Dispose(bool disposing) above.

        if (IsDisposed)
        {
            return;
        }

        IsDisposed = true;

        Dispose(true);
        GC.SuppressFinalize(this);
    }
}