/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.config;

import java.net.URL;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.redisson.api.NameMapper;
import org.redisson.client.DefaultCredentialsResolver;
import org.redisson.config.CommandMapper;
import org.redisson.config.CredentialsResolver;
import org.redisson.config.SslProvider;
import org.redisson.config.SslVerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseConfig<T extends BaseConfig<T>> {
    protected static final Logger log = LoggerFactory.getLogger((String)"config");
    private int idleConnectionTimeout = 10000;
    private int connectTimeout = 10000;
    private int timeout = 3000;
    private int subscriptionTimeout = 7500;
    private int retryAttempts = 3;
    private int retryInterval = 1500;
    private String password;
    private String username;
    private CredentialsResolver credentialsResolver = new DefaultCredentialsResolver();
    private int subscriptionsPerConnection = 5;
    private String clientName;
    private SslVerificationMode sslVerificationMode = SslVerificationMode.STRICT;
    private String sslKeystoreType;
    private SslProvider sslProvider = SslProvider.JDK;
    private URL sslTruststore;
    private String sslTruststorePassword;
    private URL sslKeystore;
    private String sslKeystorePassword;
    private String[] sslProtocols;
    private String[] sslCiphers;
    private TrustManagerFactory sslTrustManagerFactory;
    private KeyManagerFactory sslKeyManagerFactory;
    private int pingConnectionInterval = 30000;
    private boolean keepAlive;
    private int tcpKeepAliveCount;
    private int tcpKeepAliveIdle;
    private int tcpKeepAliveInterval;
    private int tcpUserTimeout;
    private boolean tcpNoDelay = true;
    private NameMapper nameMapper = NameMapper.direct();
    private CommandMapper commandMapper = CommandMapper.direct();

    BaseConfig() {
    }

    BaseConfig(T config) {
        this.setPassword(((BaseConfig)config).getPassword());
        this.setUsername(((BaseConfig)config).getUsername());
        this.setSubscriptionsPerConnection(((BaseConfig)config).getSubscriptionsPerConnection());
        this.setRetryAttempts(((BaseConfig)config).getRetryAttempts());
        this.setRetryInterval(((BaseConfig)config).getRetryInterval());
        this.setTimeout(((BaseConfig)config).getTimeout());
        this.setClientName(((BaseConfig)config).getClientName());
        this.setConnectTimeout(((BaseConfig)config).getConnectTimeout());
        this.setIdleConnectionTimeout(((BaseConfig)config).getIdleConnectionTimeout());
        this.setSslProvider(((BaseConfig)config).getSslProvider());
        this.setSslTruststore(((BaseConfig)config).getSslTruststore());
        this.setSslTruststorePassword(((BaseConfig)config).getSslTruststorePassword());
        this.setSslKeystoreType(((BaseConfig)config).getSslKeystoreType());
        this.setSslKeystore(((BaseConfig)config).getSslKeystore());
        this.setSslKeystorePassword(((BaseConfig)config).getSslKeystorePassword());
        this.setSslProtocols(((BaseConfig)config).getSslProtocols());
        this.setSslCiphers(((BaseConfig)config).getSslCiphers());
        this.setSslKeyManagerFactory(((BaseConfig)config).getSslKeyManagerFactory());
        this.setSslTrustManagerFactory(((BaseConfig)config).getSslTrustManagerFactory());
        this.setPingConnectionInterval(((BaseConfig)config).getPingConnectionInterval());
        this.setKeepAlive(((BaseConfig)config).isKeepAlive());
        this.setTcpKeepAliveCount(((BaseConfig)config).getTcpKeepAliveCount());
        this.setTcpKeepAliveIdle(((BaseConfig)config).getTcpKeepAliveIdle());
        this.setTcpKeepAliveInterval(((BaseConfig)config).getTcpKeepAliveInterval());
        this.setTcpUserTimeout(((BaseConfig)config).getTcpUserTimeout());
        this.setTcpNoDelay(((BaseConfig)config).isTcpNoDelay());
        this.setNameMapper(((BaseConfig)config).getNameMapper());
        this.setCredentialsResolver(((BaseConfig)config).getCredentialsResolver());
        this.setCommandMapper(((BaseConfig)config).getCommandMapper());
        this.setSslVerificationMode(((BaseConfig)config).getSslVerificationMode());
        this.setSubscriptionTimeout(((BaseConfig)config).getSubscriptionTimeout());
    }

    public T setSubscriptionsPerConnection(int subscriptionsPerConnection) {
        this.subscriptionsPerConnection = subscriptionsPerConnection;
        return (T)this;
    }

    public int getSubscriptionsPerConnection() {
        return this.subscriptionsPerConnection;
    }

    public T setPassword(String password) {
        this.password = password;
        return (T)this;
    }

    public String getPassword() {
        return this.password;
    }

    public T setUsername(String username) {
        this.username = username;
        return (T)this;
    }

    public String getUsername() {
        return this.username;
    }

    public T setRetryAttempts(int retryAttempts) {
        this.retryAttempts = retryAttempts;
        return (T)this;
    }

    public int getRetryAttempts() {
        return this.retryAttempts;
    }

    public T setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
        return (T)this;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public T setTimeout(int timeout) {
        this.timeout = timeout;
        return (T)this;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getSubscriptionTimeout() {
        return this.subscriptionTimeout;
    }

    public T setSubscriptionTimeout(int subscriptionTimeout) {
        this.subscriptionTimeout = subscriptionTimeout;
        return (T)this;
    }

    public T setClientName(String clientName) {
        this.clientName = clientName;
        return (T)this;
    }

    public String getClientName() {
        return this.clientName;
    }

    public T setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return (T)this;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public T setIdleConnectionTimeout(int idleConnectionTimeout) {
        this.idleConnectionTimeout = idleConnectionTimeout;
        return (T)this;
    }

    public int getIdleConnectionTimeout() {
        return this.idleConnectionTimeout;
    }

    @Deprecated
    public boolean isSslEnableEndpointIdentification() {
        return this.sslVerificationMode == SslVerificationMode.STRICT;
    }

    @Deprecated
    public T setSslEnableEndpointIdentification(boolean sslEnableEndpointIdentification) {
        log.warn("sslEnableEndpointIdentification setting is deprecated. Use sslVerificationMode setting instead.");
        this.sslVerificationMode = sslEnableEndpointIdentification ? SslVerificationMode.STRICT : SslVerificationMode.NONE;
        return (T)this;
    }

    public SslProvider getSslProvider() {
        return this.sslProvider;
    }

    public T setSslProvider(SslProvider sslProvider) {
        this.sslProvider = sslProvider;
        return (T)this;
    }

    public URL getSslTruststore() {
        return this.sslTruststore;
    }

    public T setSslTruststore(URL sslTruststore) {
        this.sslTruststore = sslTruststore;
        return (T)this;
    }

    public String getSslTruststorePassword() {
        return this.sslTruststorePassword;
    }

    public T setSslTruststorePassword(String sslTruststorePassword) {
        this.sslTruststorePassword = sslTruststorePassword;
        return (T)this;
    }

    public URL getSslKeystore() {
        return this.sslKeystore;
    }

    public T setSslKeystore(URL sslKeystore) {
        this.sslKeystore = sslKeystore;
        return (T)this;
    }

    public String getSslKeystorePassword() {
        return this.sslKeystorePassword;
    }

    public T setSslKeystorePassword(String sslKeystorePassword) {
        this.sslKeystorePassword = sslKeystorePassword;
        return (T)this;
    }

    public String[] getSslProtocols() {
        return this.sslProtocols;
    }

    public T setSslProtocols(String[] sslProtocols) {
        this.sslProtocols = sslProtocols;
        return (T)this;
    }

    public int getPingConnectionInterval() {
        return this.pingConnectionInterval;
    }

    public T setPingConnectionInterval(int pingConnectionInterval) {
        this.pingConnectionInterval = pingConnectionInterval;
        return (T)this;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public T setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
        return (T)this;
    }

    public int getTcpKeepAliveCount() {
        return this.tcpKeepAliveCount;
    }

    public T setTcpKeepAliveCount(int tcpKeepAliveCount) {
        this.tcpKeepAliveCount = tcpKeepAliveCount;
        return (T)this;
    }

    public int getTcpKeepAliveIdle() {
        return this.tcpKeepAliveIdle;
    }

    public T setTcpKeepAliveIdle(int tcpKeepAliveIdle) {
        this.tcpKeepAliveIdle = tcpKeepAliveIdle;
        return (T)this;
    }

    public int getTcpKeepAliveInterval() {
        return this.tcpKeepAliveInterval;
    }

    public T setTcpKeepAliveInterval(int tcpKeepAliveInterval) {
        this.tcpKeepAliveInterval = tcpKeepAliveInterval;
        return (T)this;
    }

    public int getTcpUserTimeout() {
        return this.tcpUserTimeout;
    }

    public T setTcpUserTimeout(int tcpUserTimeout) {
        this.tcpUserTimeout = tcpUserTimeout;
        return (T)this;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public T setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
        return (T)this;
    }

    public NameMapper getNameMapper() {
        return this.nameMapper;
    }

    public T setNameMapper(NameMapper nameMapper) {
        this.nameMapper = nameMapper;
        return (T)this;
    }

    public CredentialsResolver getCredentialsResolver() {
        return this.credentialsResolver;
    }

    public T setCredentialsResolver(CredentialsResolver credentialsResolver) {
        this.credentialsResolver = credentialsResolver;
        return (T)this;
    }

    public String getSslKeystoreType() {
        return this.sslKeystoreType;
    }

    public T setSslKeystoreType(String sslKeystoreType) {
        this.sslKeystoreType = sslKeystoreType;
        return (T)this;
    }

    public String[] getSslCiphers() {
        return this.sslCiphers;
    }

    public T setSslCiphers(String[] sslCiphers) {
        this.sslCiphers = sslCiphers;
        return (T)this;
    }

    public TrustManagerFactory getSslTrustManagerFactory() {
        return this.sslTrustManagerFactory;
    }

    public T setSslTrustManagerFactory(TrustManagerFactory trustManagerFactory) {
        this.sslTrustManagerFactory = trustManagerFactory;
        return (T)this;
    }

    public KeyManagerFactory getSslKeyManagerFactory() {
        return this.sslKeyManagerFactory;
    }

    public BaseConfig<T> setSslKeyManagerFactory(KeyManagerFactory keyManagerFactory) {
        this.sslKeyManagerFactory = keyManagerFactory;
        return this;
    }

    public CommandMapper getCommandMapper() {
        return this.commandMapper;
    }

    public T setCommandMapper(CommandMapper commandMapper) {
        this.commandMapper = commandMapper;
        return (T)this;
    }

    public SslVerificationMode getSslVerificationMode() {
        return this.sslVerificationMode;
    }

    public T setSslVerificationMode(SslVerificationMode sslVerificationMode) {
        this.sslVerificationMode = sslVerificationMode;
        return (T)this;
    }
}

