/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection.decoder;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.decoder.MultiDecoder;

public class MapNativeAllDecoder
implements MultiDecoder<Map<Object, Object>> {
    private final List<Object> args;
    private final Class<?> valueClass;

    public MapNativeAllDecoder(List<Object> args, Class<?> valueClass) {
        this.args = args;
        this.valueClass = valueClass;
    }

    @Override
    public Map<Object, Object> decode(List<Object> parts, State state) {
        if (parts.isEmpty()) {
            return new HashMap<Object, Object>();
        }
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>(parts.size());
        for (int index = 0; index < parts.size(); ++index) {
            Long value = (Long)parts.get(index);
            if (value == -2L && this.valueClass != Long.class) continue;
            if (this.valueClass == Boolean.class) {
                result.put(this.args.get(index), value == 1L);
                continue;
            }
            result.put(this.args.get(index), value);
        }
        return result;
    }
}

