/*
 * Decompiled with CFR 0.152.
 */
package web.controller.api;

import book.appCtx;
import book.model.BookChapter;
import book.util.FileUtils;
import book.webBook.localBook.LocalBook;
import java.io.File;
import java.io.Serializable;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.core.handle.UploadedFile;
import org.noear.solon.core.util.DataThrowable;
import org.noear.solon.web.cors.annotation.CrossOrigin;
import web.controller.api.BaseController;
import web.controller.api.ReadController;
import web.mapper.BooklistMapper;
import web.model.Booklist;
import web.model.Users;
import web.notification.Book;
import web.response.JsonResponse;
import web.response.StaticKt;
import web.util.cache.CacheKt;
import web.util.hash.Md5Kt;

@Controller
@Mapping(value="/api/{v}")
@CrossOrigin(origins="*")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0017J\u001c\u0010\u0012\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lweb/controller/api/LocalBookController;", "Lweb/controller/api/BaseController;", "<init>", "()V", "imagesDir", "Ljava/io/File;", "booklistMapper", "Lweb/mapper/BooklistMapper;", "getBooklistMapper", "()Lweb/mapper/BooklistMapper;", "setBooklistMapper", "(Lweb/mapper/BooklistMapper;)V", "importBookPreview", "Lweb/response/JsonResponse;", "accessToken", "", "file", "Lorg/noear/solon/core/handle/UploadedFile;", "uploadimage", "solon-read"})
public class LocalBookController
extends BaseController {
    @NotNull
    private final File imagesDir;
    @Inject
    public BooklistMapper booklistMapper;

    public LocalBookController() {
        String[] stringArray = new String[]{"assets", "images"};
        this.imagesDir = FileUtils.INSTANCE.createFolderIfNotExist(appCtx.INSTANCE.getExternalFiles(), stringArray);
    }

    @NotNull
    public final BooklistMapper getBooklistMapper() {
        BooklistMapper booklistMapper = this.booklistMapper;
        if (booklistMapper != null) {
            return booklistMapper;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"booklistMapper");
        return null;
    }

    public final void setBooklistMapper(@NotNull BooklistMapper booklistMapper) {
        Intrinsics.checkNotNullParameter((Object)booklistMapper, (String)"<set-?>");
        this.booklistMapper = booklistMapper;
    }

    @Mapping(value="/importBookPreview")
    @NotNull
    public JsonResponse importBookPreview(@Nullable String accessToken, @Nullable UploadedFile file) {
        String uploadDir;
        File ufile;
        Object $i$a$-runCatching-LocalBookController$importBookPreview$1$22;
        LocalBookController $this$importBookPreview_u24lambda_u243 = this;
        boolean bl = false;
        if (file == null) {
            throw new DataThrowable().data((Object)new JsonResponse(false, StaticKt.getNOT_BANK()));
        }
        if (file.isEmpty()) {
            throw new DataThrowable().data((Object)new JsonResponse(false, StaticKt.getNOT_BANK()));
        }
        Users user = $this$importBookPreview_u24lambda_u243.getuserbytocken(accessToken);
        if (!Intrinsics.areEqual((Object)user.getAllowUpTxt(), (Object)true)) {
            throw new DataThrowable().data((Object)new JsonResponse(false, StaticKt.getNOT_ALLOW_TXT()));
        }
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!StringsKt.endsWith$default((String)string, (String)".txt", (boolean)false, (int)2, null)) {
            String string2 = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            if (!StringsKt.endsWith$default((String)string2, (String)".epub", (boolean)false, (int)2, null)) {
                throw new DataThrowable().data((Object)new JsonResponse(false, StaticKt.getNOT_TXT()));
            }
        }
        String f1 = null;
        f1 = file.getName();
        try {
            boolean $i$a$-runCatching-LocalBookController$importBookPreview$1$22 = false;
            f1 = URLDecoder.decode(f1, "UTF-8");
            $i$a$-runCatching-LocalBookController$importBookPreview$1$22 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            $i$a$-runCatching-LocalBookController$importBookPreview$1$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        String string3 = f1;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"element");
        String unifiedPath = StringsKt.replace$default((String)string3, (String)"\\", (String)"/", (boolean)false, (int)4, null);
        f1 = StringsKt.substringAfterLast$default((String)unifiedPath, (char)'/', null, (int)2, null);
        String string4 = user.getUsername();
        if (string4 == null) {
            string4 = "";
        }
        if (!(ufile = new File(uploadDir = CacheKt.getlocalpath(string4))).exists()) {
            ufile.mkdirs();
        }
        String localpath = uploadDir + "/" + f1;
        File uploadedFile = new File(localpath);
        byte[] byArray = file.getContentAsBytes();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getContentAsBytes(...)");
        FilesKt.writeBytes((File)uploadedFile, (byte[])byArray);
        book.model.Book book = book.model.Book.Companion.initLocalBook(localpath, localpath, "");
        ArrayList<BookChapter> chapters = LocalBook.INSTANCE.getChapterList(book);
        Booklist booklist = Booklist.bookto$default(new Booklist().create(), book, false, false, 6, null);
        BooklistMapper booklistMapper = $this$importBookPreview_u24lambda_u243.getBooklistMapper();
        String string5 = user.getId();
        Intrinsics.checkNotNull((Object)string5);
        Booklist booklist2 = booklistMapper.getbook(string5, book.getBookUrl());
        if (booklist2 != null) {
            Booklist it = booklist2;
            boolean bl2 = false;
            booklist.setDurChapterTitle(it.getDurChapterTitle());
            booklist.setDurChapterPos(it.getDurChapterPos());
            booklist.setDurChapterIndex(it.getDurChapterIndex());
            $this$importBookPreview_u24lambda_u243.getBooklistMapper().deleteById((Serializable)((Object)it.getId()));
        }
        booklist.setOriginName("\u672c\u5730");
        booklist.setUserid(user.getId());
        booklist.setLastCheckTime(System.currentTimeMillis());
        booklist.setLastCheckCount(chapters.size());
        booklist.setTotalChapterNum(chapters.size());
        booklist.setLatestChapterTitle(chapters.get(chapters.size() - 1).getTitle());
        booklist.setLatestChapterTime(System.currentTimeMillis());
        $this$importBookPreview_u24lambda_u243.getBooklistMapper().insert(booklist);
        Book.INSTANCE.sendNotification(user);
        ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, () -> LocalBookController.importBookPreview$lambda$3$lambda$2(book, user, chapters), (int)31, null);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"books", (Object)book), TuplesKt.to((Object)"chapters", chapters)};
        return new JsonResponse(true, StaticKt.getSUCCESS()).Data(MapsKt.mapOf((Pair[])pairArray));
    }

    @Mapping(value="/uploadimage")
    @NotNull
    public JsonResponse uploadimage(@Nullable String accessToken, @Nullable UploadedFile file) {
        LocalBookController $this$uploadimage_u24lambda_u244 = this;
        boolean bl = false;
        if (file == null) {
            throw new DataThrowable().data((Object)new JsonResponse(false, StaticKt.getNOT_BANK()));
        }
        if (file.isEmpty()) {
            throw new DataThrowable().data((Object)new JsonResponse(false, StaticKt.getNOT_BANK()));
        }
        byte[] fb = file.getContentAsBytes();
        Intrinsics.checkNotNull((Object)fb);
        String f1 = Md5Kt.Md5(fb) + ".png";
        String[] stringArray = new String[]{f1};
        File valueFile = FileUtils.INSTANCE.createFileIfNotExist($this$uploadimage_u24lambda_u244.imagesDir, stringArray);
        FilesKt.writeBytes((File)valueFile, (byte[])fb);
        return new JsonResponse(true).Data("http//assets/images/" + f1);
    }

    private static final Unit importBookPreview$lambda$3$lambda$2(book.model.Book $book, Users $user, ArrayList $chapters) {
        String string = $book.getBookUrl();
        String string2 = $user.getId();
        Intrinsics.checkNotNull((Object)string2);
        ReadController.Companion.removeChapterListbycache(string, string2);
        String string3 = $book.getBookUrl();
        String string4 = $user.getId();
        Intrinsics.checkNotNull((Object)string4);
        ReadController.Companion.removeallBookContentbycache(string3, string4);
        String string5 = $book.getBookUrl();
        List list = $chapters;
        String string6 = $user.getId();
        Intrinsics.checkNotNull((Object)string6);
        ReadController.Companion.setChapterListbycache(string5, list, string6);
        return Unit.INSTANCE;
    }
}

