/*
 * Decompiled with CFR 0.152.
 */
package web.cron;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.noear.solon.annotation.Inject;
import org.noear.solon.scheduling.annotation.Scheduled;

@Scheduled(fixedRate=86400000L)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lweb/cron/JsonFileJob;", "Ljava/lang/Runnable;", "<init>", "()V", "filepath", "", "getFilepath", "()Ljava/lang/String;", "cron", "", "getCron", "()Z", "setCron", "(Z)V", "run", "", "solon-read"})
@SourceDebugExtension(value={"SMAP\nJsonFileJob.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonFileJob.kt\nweb/cron/JsonFileJob\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,35:1\n1317#2,2:36\n*S KotlinDebug\n*F\n+ 1 JsonFileJob.kt\nweb/cron/JsonFileJob\n*L\n21#1:36,2\n*E\n"})
public final class JsonFileJob
implements Runnable {
    @NotNull
    private final String filepath;
    @Inject(value="${admin.cron:true}", autoRefreshed=true)
    private boolean cron = true;

    public JsonFileJob() {
        this.filepath = "storage/assets/json";
    }

    @NotNull
    public final String getFilepath() {
        return this.filepath;
    }

    public final boolean getCron() {
        return this.cron;
    }

    public final void setCron(boolean bl) {
        this.cron = bl;
    }

    @Override
    public void run() {
        if (!this.cron) {
            return;
        }
        File file = new File(this.filepath);
        Sequence $this$forEach$iv = (Sequence)FilesKt.walk$default((File)file, null, (int)1, null).maxDepth(1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            File it = (File)element$iv;
            boolean bl = false;
            if (!it.isFile() || !Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"json")) continue;
            try {
                boolean bl2 = false;
                BasicFileAttributes attributes = Files.readAttributes(it.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                FileTime creationTime = attributes.creationTime();
                Instant instant = creationTime.toInstant();
                long time = (System.currentTimeMillis() - instant.toEpochMilli()) / (long)86400000;
                if (time > 7L) {
                    it.delete();
                }
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
        }
    }
}

