/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.transport;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.smartboot.socket.MessageProcessor;
import org.smartboot.socket.Protocol;
import org.smartboot.socket.buffer.BufferPagePool;
import org.smartboot.socket.enhance.EnhanceAsynchronousChannelProvider;
import org.smartboot.socket.transport.AioSession;
import org.smartboot.socket.transport.IOUtil;
import org.smartboot.socket.transport.IoServerConfig;
import org.smartboot.socket.transport.TcpAioSession;

public final class AioQuickClient {
    private static final ScheduledExecutorService CONNECT_TIMEOUT_EXECUTOR = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread thread = new Thread(r, "connection-timeout-monitor");
        thread.setDaemon(true);
        return thread;
    });
    private TcpAioSession session;
    private AsynchronousChannelGroup asynchronousChannelGroup;
    private SocketAddress localAddress;
    private int connectTimeout;
    private final IoServerConfig config = new IoServerConfig();
    private BufferPagePool writeBufferPool = null;
    private BufferPagePool readBufferPool = null;
    private boolean lowMemory = true;

    public <T> AioQuickClient(String host, int port, Protocol<T> protocol, MessageProcessor<T> messageProcessor) {
        this.config.setHost(host);
        this.config.setPort(port);
        this.config.setProtocol(protocol);
        this.config.setProcessor(messageProcessor);
    }

    public <A> void start(A attachment, CompletionHandler<AioSession, ? super A> handler) throws IOException {
        this.asynchronousChannelGroup = new EnhanceAsynchronousChannelProvider(this.lowMemory).openAsynchronousChannelGroup(2, Thread::new);
        this.start(this.asynchronousChannelGroup, attachment, handler);
    }

    public <A> void start(AsynchronousChannelGroup asynchronousChannelGroup, final A attachment, final CompletionHandler<AioSession, ? super A> handler) throws IOException {
        AsynchronousSocketChannel socketChannel = AsynchronousSocketChannel.open(asynchronousChannelGroup);
        if (this.connectTimeout > 0) {
            CONNECT_TIMEOUT_EXECUTOR.schedule(() -> {
                if (this.session == null) {
                    IOUtil.close(socketChannel);
                    this.shutdownNow();
                }
            }, (long)this.connectTimeout, TimeUnit.MILLISECONDS);
        }
        if (this.writeBufferPool == null) {
            this.writeBufferPool = BufferPagePool.DEFAULT_BUFFER_PAGE_POOL;
        }
        if (this.readBufferPool == null) {
            this.readBufferPool = BufferPagePool.DEFAULT_BUFFER_PAGE_POOL;
        }
        if (this.config.getSocketOptions() != null) {
            for (Map.Entry<SocketOption<Object>, Object> entry : this.config.getSocketOptions().entrySet()) {
                socketChannel.setOption((SocketOption)entry.getKey(), entry.getValue());
            }
        }
        if (this.localAddress != null) {
            socketChannel.bind(this.localAddress);
        }
        socketChannel.connect(new InetSocketAddress(this.config.getHost(), this.config.getPort()), socketChannel, new CompletionHandler<Void, AsynchronousSocketChannel>(){

            @Override
            public void completed(Void result, AsynchronousSocketChannel socketChannel) {
                try {
                    AsynchronousSocketChannel connectedChannel = socketChannel;
                    if (AioQuickClient.this.config.getMonitor() != null) {
                        connectedChannel = AioQuickClient.this.config.getMonitor().shouldAccept(socketChannel);
                    }
                    if (connectedChannel == null) {
                        throw new RuntimeException("NetMonitor refuse channel");
                    }
                    AioQuickClient.this.session = new TcpAioSession(connectedChannel, AioQuickClient.this.config, AioQuickClient.this.writeBufferPool.allocateBufferPage(), () -> AioQuickClient.this.readBufferPool.allocateBufferPage().allocate(AioQuickClient.this.config.getReadBufferSize()));
                    handler.completed(AioQuickClient.this.session, attachment);
                }
                catch (Exception e) {
                    this.failed((Throwable)e, socketChannel);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void failed(Throwable exc, AsynchronousSocketChannel socketChannel) {
                try {
                    handler.failed(exc, attachment);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (socketChannel != null) {
                        IOUtil.close(socketChannel);
                    }
                    AioQuickClient.this.shutdownNow();
                }
            }
        });
    }

    public AioSession start(AsynchronousChannelGroup asynchronousChannelGroup) throws IOException {
        CompletableFuture future = new CompletableFuture();
        this.start(asynchronousChannelGroup, future, new CompletionHandler<AioSession, CompletableFuture<AioSession>>(){

            @Override
            public void completed(AioSession session, CompletableFuture<AioSession> future) {
                if (future.isDone() || future.isCancelled()) {
                    session.close();
                } else {
                    future.complete(session);
                }
            }

            @Override
            public void failed(Throwable exc, CompletableFuture<AioSession> future) {
                future.completeExceptionally(exc);
            }
        });
        try {
            return (AioSession)future.get();
        }
        catch (Exception e) {
            future.cancel(false);
            this.shutdownNow();
            throw new IOException(e.getCause() == null ? e : e.getCause());
        }
    }

    public TcpAioSession getSession() {
        return this.session;
    }

    public AioSession start() throws IOException {
        this.asynchronousChannelGroup = new EnhanceAsynchronousChannelProvider(this.lowMemory).openAsynchronousChannelGroup(2, Thread::new);
        return this.start(this.asynchronousChannelGroup);
    }

    public void shutdown() {
        this.shutdown0(false);
    }

    public void shutdownNow() {
        this.shutdown0(true);
    }

    private synchronized void shutdown0(boolean flag) {
        if (this.session != null) {
            this.session.close(flag);
            this.session = null;
        }
        if (this.asynchronousChannelGroup != null) {
            this.asynchronousChannelGroup.shutdown();
            this.asynchronousChannelGroup = null;
        }
    }

    public AioQuickClient setReadBufferSize(int size) {
        this.config.setReadBufferSize(size);
        return this;
    }

    public <V> AioQuickClient setOption(SocketOption<V> socketOption, V value) {
        this.config.setOption(socketOption, value);
        return this;
    }

    public AioQuickClient bindLocal(String local, int port) {
        this.localAddress = local == null ? new InetSocketAddress(port) : new InetSocketAddress(local, port);
        return this;
    }

    public AioQuickClient setBufferPagePool(BufferPagePool bufferPool) {
        return this.setBufferPagePool(bufferPool, bufferPool);
    }

    public AioQuickClient setBufferPagePool(BufferPagePool readBufferPool, BufferPagePool writeBufferPool) {
        this.writeBufferPool = writeBufferPool;
        this.readBufferPool = readBufferPool;
        return this;
    }

    public AioQuickClient setWriteBuffer(int bufferSize, int bufferCapacity) {
        this.config.setWriteBufferSize(bufferSize);
        this.config.setWriteBufferCapacity(bufferCapacity);
        return this;
    }

    public AioQuickClient connectTimeout(int timeout) {
        this.connectTimeout = timeout;
        return this;
    }

    public AioQuickClient disableLowMemory() {
        this.lowMemory = false;
        return this;
    }
}

