/*
 * Decompiled with CFR 0.152.
 */
package com.julienviet.retrofit.vertx;

import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpMethod;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;

public class VertxCallFactory
implements Call.Factory {
    private final HttpClient client;

    public VertxCallFactory(HttpClient client) {
        this.client = client;
    }

    public Call newCall(Request request) {
        return new VertxCall(request);
    }

    private class VertxCall
    implements Call {
        private final Request retroRequest;
        private final AtomicBoolean executed = new AtomicBoolean();

        VertxCall(Request retroRequest) {
            this.retroRequest = retroRequest;
        }

        public Request request() {
            return this.retroRequest;
        }

        public Response execute() throws IOException {
            final CompletableFuture future = new CompletableFuture();
            this.enqueue(new Callback(){

                public void onResponse(Call call, Response response) throws IOException {
                    future.complete(response);
                }

                public void onFailure(Call call, IOException e) {
                    future.completeExceptionally(e);
                }
            });
            try {
                return (Response)future.get(10L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        public void enqueue(Callback callback) {
            if (this.executed.compareAndSet(false, true)) {
                Future fut = Future.future();
                fut.setHandler(ar -> {
                    if (ar.succeeded()) {
                        try {
                            callback.onResponse((Call)this, (Response)ar.result());
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    } else {
                        Throwable cause = ar.cause();
                        IOException ioe = cause instanceof IOException ? (IOException)cause : new IOException(cause);
                        callback.onFailure((Call)this, ioe);
                    }
                });
                HttpMethod method = HttpMethod.valueOf((String)this.retroRequest.method());
                HttpClientRequest request = VertxCallFactory.this.client.requestAbs(method, this.retroRequest.url().toString(), resp -> {
                    resp.exceptionHandler(arg_0 -> ((Future)fut).tryFail(arg_0));
                    resp.bodyHandler(body -> {
                        Response.Builder builder = new Response.Builder();
                        builder.protocol(Protocol.HTTP_1_1);
                        builder.request(this.retroRequest);
                        builder.code(resp.statusCode());
                        builder.message(resp.statusMessage());
                        for (Map.Entry header : resp.headers()) {
                            builder.addHeader((String)header.getKey(), (String)header.getValue());
                        }
                        String mediaTypeHeader = resp.getHeader("Content-Type");
                        MediaType mediaType = mediaTypeHeader != null ? MediaType.parse((String)mediaTypeHeader) : null;
                        builder.body(ResponseBody.create((MediaType)mediaType, (byte[])body.getBytes()));
                        fut.tryComplete((Object)builder.build());
                    });
                });
                request.exceptionHandler(arg_0 -> ((Future)fut).tryFail(arg_0));
                int size = this.retroRequest.headers().size();
                Headers retroHeaders = this.retroRequest.headers();
                MultiMap headers = request.headers();
                for (int i = 0; i < size; ++i) {
                    String header = retroHeaders.name(i);
                    String value = retroHeaders.value(i);
                    headers.add(header, value);
                }
                try {
                    RequestBody body = this.retroRequest.body();
                    if (body != null && body.contentLength() > 0L) {
                        MediaType mediaType = body.contentType();
                        request.putHeader("content-type", mediaType.toString());
                        request.putHeader("content-length", "" + body.contentLength());
                        Buffer buffer = new Buffer();
                        body.writeTo((BufferedSink)buffer);
                        request.write(io.vertx.core.buffer.Buffer.buffer((byte[])buffer.readByteArray()));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                request.end();
            } else {
                callback.onFailure((Call)this, new IOException("Already executed"));
            }
        }

        public void cancel() {
        }

        public boolean isExecuted() {
            return this.executed.get();
        }

        public boolean isCanceled() {
            return false;
        }

        public Call clone() {
            return new VertxCall(this.retroRequest);
        }
    }
}

