/*
 * Decompiled with CFR 0.152.
 */
package org.seimicrawler.xpath.core.function;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.seimicrawler.xpath.core.Function;
import org.seimicrawler.xpath.core.Scope;
import org.seimicrawler.xpath.core.XValue;

public class SubString
implements Function {
    @Override
    public String name() {
        return "substring";
    }

    @Override
    public XValue call(Scope scope, List<XValue> params) {
        String target = params.get(0).asString();
        int start = params.get(1).asLong().intValue();
        start = Math.max(start - 1, 0);
        if (params.get(2) != null) {
            int end = params.get(2).asLong().intValue();
            end = Math.min(start + end, target.length());
            end = Math.max(end, 0);
            return XValue.create(StringUtils.substring((String)target, (int)start, (int)end));
        }
        return XValue.create(StringUtils.substring((String)target, (int)start));
    }
}

