/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.converter;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dromara.autotable.annotation.ColumnType;
import org.dromara.autotable.core.converter.DatabaseTypeAndLength;
import org.dromara.autotable.core.converter.DefaultTypeEnumInterface;
import org.dromara.autotable.core.utils.StringUtils;
import org.dromara.autotable.core.utils.TableBeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface JavaTypeToDatabaseTypeConverter {
    public static final Logger log = LoggerFactory.getLogger(JavaTypeToDatabaseTypeConverter.class);
    public static final Map<String, Map<Class<?>, DefaultTypeEnumInterface>> JAVA_TO_DB_TYPE_MAPPING = new HashMap();

    public static void addTypeMapping(String databaseDialect, Class<?> clazz, DefaultTypeEnumInterface typeEnum) {
        JAVA_TO_DB_TYPE_MAPPING.computeIfAbsent(databaseDialect, k -> new HashMap()).put(clazz, typeEnum);
    }

    public static void addTypeMapping(String databaseDialect, Map<Class<?>, DefaultTypeEnumInterface> typeEnumMap) {
        JAVA_TO_DB_TYPE_MAPPING.computeIfAbsent(databaseDialect, k -> new HashMap()).putAll(typeEnumMap);
    }

    default public DatabaseTypeAndLength convert(String databaseDialect, Class<?> clazz, Field field) {
        ColumnType column = TableBeanUtils.getColumnType(field);
        if (column != null) {
            String type = column.value();
            Integer length = column.length() > -1 ? Integer.valueOf(column.length()) : null;
            Integer decimalLength = column.decimalLength() > -1 ? Integer.valueOf(column.decimalLength()) : null;
            List<String> values = Arrays.asList(column.values());
            if (StringUtils.hasText(type)) {
                return new DatabaseTypeAndLength(type, length, decimalLength, values);
            }
            if (length != null || decimalLength != null) {
                DatabaseTypeAndLength typeAndLength = this.getDatabaseTypeAndLength(databaseDialect, clazz, field);
                typeAndLength.setLength(length);
                typeAndLength.setDecimalLength(decimalLength);
                return typeAndLength;
            }
        }
        return this.getDatabaseTypeAndLength(databaseDialect, clazz, field);
    }

    default public DatabaseTypeAndLength getDatabaseTypeAndLength(String databaseDialect, Class<?> clazz, Field field) {
        DefaultTypeEnumInterface sqlType;
        Class<?> fieldClass;
        Map typeMap = JAVA_TO_DB_TYPE_MAPPING.getOrDefault(databaseDialect, Collections.emptyMap());
        if (typeMap.isEmpty()) {
            log.warn("\u6570\u636e\u5e93\u65b9\u8a00{}\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6570\u636e\u5e93\u7c7b\u578b\u6620\u5c04\u5173\u7cfb", (Object)databaseDialect);
        }
        if ((fieldClass = field.getGenericType() instanceof TypeVariable ? this.getFieldGenericType(clazz, field) : TableBeanUtils.getFieldType(clazz, field)) == null) {
            fieldClass = field.getType();
        }
        if ((sqlType = (DefaultTypeEnumInterface)typeMap.get(fieldClass)) == null) {
            log.warn("{}\u4e0b\u7684\u5b57\u6bb5{}\u5728{}\u4e0b\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6570\u636e\u5e93\u7c7b\u578b\uff0c\u9ed8\u8ba4\u4f7f\u7528\u4e86\u5b57\u7b26\u4e32\u7c7b\u578b\uff0c\u5982\u679c\u60f3\u81ea\u5b9a\u4e49\uff0c\u8bf7\u8c03\u7528JavaTypeToDatabaseTypeConverter.addTypeMap(DatabaseDialect.{}, {}.class, ?)\u6dfb\u52a0\u6620\u5c04\u5173\u7cfb", new Object[]{clazz.getName(), fieldClass.getSimpleName(), databaseDialect, databaseDialect, fieldClass.getSimpleName()});
            sqlType = (DefaultTypeEnumInterface)typeMap.get(String.class);
        }
        DatabaseTypeAndLength typeAndLength = new DatabaseTypeAndLength(sqlType.getTypeName(), sqlType.getDefaultLength(), sqlType.getDefaultDecimalLength(), Collections.emptyList());
        return typeAndLength;
    }

    default public Class<?> getFieldGenericType(Class<?> clazz, Field field) {
        int index;
        ArrayList classList = new ArrayList();
        ArrayList<Type> typeList = new ArrayList<Type>();
        for (Class<?> clas = clazz; clas != field.getDeclaringClass(); clas = clas.getSuperclass()) {
            classList.add(clas);
            typeList.add(clas.getGenericSuperclass());
        }
        String genericTypeName = ((TypeVariable)field.getGenericType()).getName();
        Class<?> declaringClass = field.getDeclaringClass();
        TypeVariable<Class<Object>>[] typeParameters = declaringClass.getTypeParameters();
        for (index = 0; index < typeParameters.length && !typeParameters[index].getName().equals(genericTypeName); ++index) {
        }
        for (int i = typeList.size() - 1; i >= 0; --i) {
            Type genericSuperclass = (Type)typeList.get(i);
            if (!(genericSuperclass instanceof ParameterizedType)) continue;
            Type[] actualTypeArguments = ((ParameterizedType)genericSuperclass).getActualTypeArguments();
            Type actualTypeArgument = actualTypeArguments[index];
            if (actualTypeArgument instanceof Class) {
                return (Class)actualTypeArgument;
            }
            genericTypeName = actualTypeArgument.getTypeName();
            typeParameters = ((Class)classList.get(i)).getTypeParameters();
            for (index = 0; index < typeParameters.length && !typeParameters[index].getName().equals(genericTypeName); ++index) {
            }
        }
        return field.getType();
    }
}

