/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.strategy.pgsql.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.dromara.autotable.annotation.enums.DefaultValueEnum;
import org.dromara.autotable.core.strategy.ColumnMetadata;
import org.dromara.autotable.core.strategy.pgsql.PgsqlStrategy;
import org.dromara.autotable.core.strategy.pgsql.builder.ColumnSqlBuilder;
import org.dromara.autotable.core.strategy.pgsql.builder.CreateTableSqlBuilder;
import org.dromara.autotable.core.strategy.pgsql.data.PgsqlCompareTableInfo;
import org.dromara.autotable.core.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyTableSqlBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModifyTableSqlBuilder.class);

    public static String buildSql(PgsqlCompareTableInfo pgsqlCompareTableInfo) {
        String tableName = pgsqlCompareTableInfo.getName();
        String schema = pgsqlCompareTableInfo.getSchema();
        String tableComment = pgsqlCompareTableInfo.getComment();
        Map<String, String> columnComment = pgsqlCompareTableInfo.getColumnComment();
        Map<String, String> indexComment = pgsqlCompareTableInfo.getIndexComment();
        ArrayList<String> alterTableSqlList = new ArrayList<String>();
        String primaryKeyName = pgsqlCompareTableInfo.getDropPrimaryKeyName();
        if (StringUtils.hasText(primaryKeyName)) {
            alterTableSqlList.add(String.format("  DROP CONSTRAINT %s", primaryKeyName));
        }
        List<String> dropColumnList = pgsqlCompareTableInfo.getDropColumnList();
        dropColumnList.stream().map(columnName -> String.format("  DROP COLUMN %s", columnName)).forEach(alterTableSqlList::add);
        List<ColumnMetadata> newColumnList = pgsqlCompareTableInfo.getNewColumnMetadataList();
        newColumnList.stream().map(column -> String.format("  ADD COLUMN %s", ColumnSqlBuilder.buildSql(column))).forEach(alterTableSqlList::add);
        List<ColumnMetadata> modifyColumnList = pgsqlCompareTableInfo.getModifyColumnMetadataList();
        for (ColumnMetadata columnMetadata : modifyColumnList) {
            String columnName2 = columnMetadata.getName();
            String newFullType = columnMetadata.getType().getDefaultFullType();
            alterTableSqlList.add(String.format("  ALTER COLUMN %s TYPE %s USING %s::%s", columnName2, newFullType, columnName2, newFullType));
            alterTableSqlList.add(String.format("  ALTER COLUMN %s %s NOT NULL", columnName2, columnMetadata.isNotNull() ? "SET" : "DROP"));
            String defaultVal = null;
            DefaultValueEnum defaultValueType = columnMetadata.getDefaultValueType();
            if (DefaultValueEnum.EMPTY_STRING == defaultValueType) {
                defaultVal = "''";
            } else if (DefaultValueEnum.NULL == defaultValueType) {
                defaultVal = "NULL";
            } else {
                String defaultValue = columnMetadata.getDefaultValue();
                if (StringUtils.hasText(defaultValue)) {
                    defaultVal = defaultValue;
                }
            }
            if (StringUtils.hasText(defaultVal)) {
                alterTableSqlList.add(String.format("  ALTER COLUMN %s SET DEFAULT %s", columnName2, defaultVal));
                continue;
            }
            alterTableSqlList.add(String.format("  ALTER COLUMN %s DROP DEFAULT", columnName2));
        }
        List<ColumnMetadata> newPrimaries = pgsqlCompareTableInfo.getNewPrimaries();
        if (!newPrimaries.isEmpty()) {
            String primaryColumns = newPrimaries.stream().map(ColumnMetadata::getName).collect(Collectors.joining(", "));
            if (StringUtils.hasText(primaryKeyName)) {
                alterTableSqlList.add(String.format("  ADD CONSTRAINT %s PRIMARY KEY (%s)", primaryKeyName, primaryColumns));
            } else {
                alterTableSqlList.add(String.format("  ADD PRIMARY KEY (%s)", primaryColumns));
            }
        }
        String alterTableSql = "";
        if (!alterTableSqlList.isEmpty()) {
            alterTableSql = String.format("ALTER TABLE %s \n%s;", PgsqlStrategy.withSchemaName(schema, tableName), String.join((CharSequence)",\n", alterTableSqlList));
        }
        String addColumnCommentSql = CreateTableSqlBuilder.getAddColumnCommentSql(schema, tableName, tableComment, columnComment, indexComment);
        List<String> dropIndexList = pgsqlCompareTableInfo.getDropIndexList();
        String dropIndexSql = dropIndexList.stream().map(indexName -> String.format("DROP INDEX %s;", PgsqlStrategy.withSchemaName(schema, indexName))).collect(Collectors.joining("\n"));
        String createIndexSql = CreateTableSqlBuilder.getCreateIndexSql(schema, tableName, pgsqlCompareTableInfo.getIndexMetadataList());
        return Stream.of(dropIndexSql, alterTableSql, createIndexSql, addColumnCommentSql).filter(StringUtils::hasText).collect(Collectors.joining("\n"));
    }
}

