/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common.codec.h2.codec;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.smartboot.http.common.codec.h2.codec.Http2Frame;
import org.smartboot.socket.transport.WriteBuffer;

public class DataFrame
extends Http2Frame {
    private static final int STATE_PAD_LENGTH = 0;
    private static final int STATE_DATA = 1;
    private static final int STATE_PADDING = 2;
    private int state = 0;
    private int padLength = 0;
    private ByteBuffer dataBuffer = ByteBuffer.allocate(0);
    private byte[] padding = EMPTY_PADDING;

    public DataFrame(int streamId, int flags, int remaining) {
        super(streamId, flags, remaining);
    }

    @Override
    public boolean decode(ByteBuffer buffer) {
        if (this.finishDecode()) {
            return true;
        }
        switch (this.state) {
            case 0: {
                if (this.getFlag(8)) {
                    if (!buffer.hasRemaining()) {
                        return false;
                    }
                    this.padLength = buffer.get();
                    if (this.padLength < 0) {
                        throw new IllegalStateException();
                    }
                    --this.remaining;
                }
                this.dataBuffer = ByteBuffer.allocate(this.remaining - this.padLength);
                this.state = 1;
            }
            case 1: {
                int min = Math.min(buffer.remaining(), this.dataBuffer.remaining());
                int limit = buffer.limit();
                buffer.limit(buffer.position() + min);
                this.dataBuffer.put(buffer);
                buffer.limit(limit);
                this.remaining -= min;
                if (this.dataBuffer.hasRemaining()) {
                    return false;
                }
                this.state = 2;
            }
            case 2: {
                if (buffer.remaining() < this.padLength) {
                    return false;
                }
                if (this.padLength <= 0) break;
                this.padding = new byte[this.padLength];
                buffer.get(this.padding);
                this.remaining -= this.padLength;
            }
        }
        this.checkEndRemaining();
        this.dataBuffer.flip();
        return true;
    }

    public void writeTo(WriteBuffer writeBuffer, byte[] data, int offset, int length) throws IOException {
        boolean padded;
        System.err.println("write data frame");
        int payloadLength = length;
        byte flags = (byte)this.flags;
        boolean bl = padded = this.padding != null && this.padding.length > 0;
        if (padded) {
            payloadLength += 1 + this.padding.length;
            flags = (byte)(flags | 8);
        }
        writeBuffer.writeInt(payloadLength << 8 | 0);
        writeBuffer.writeByte(flags);
        writeBuffer.writeInt(this.streamId);
        if (padded) {
            writeBuffer.writeByte((byte)this.padding.length);
        }
        writeBuffer.write(data, offset, length);
        if (padded) {
            writeBuffer.write(this.padding);
        }
    }

    public byte[] getPadding() {
        return this.padding;
    }

    public byte[] getData() {
        return this.dataBuffer.array();
    }

    @Override
    public int type() {
        return 0;
    }
}

