/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyueyi.quick.transfer;

import com.github.liuyueyi.quick.transfer.constants.TransType;
import com.github.liuyueyi.quick.transfer.dictionary.BasicDictionary;
import com.github.liuyueyi.quick.transfer.dictionary.DictionaryContainer;
import java.util.Collection;
import java.util.Map;

public class ChineseUtils {
    public static void preLoad(boolean async, final TransType ... types) {
        if (async) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    ChineseUtils.preLoad(types);
                }
            });
            thread.setDaemon(true);
            thread.start();
        } else {
            ChineseUtils.preLoad(types);
        }
    }

    public static void preLoad(TransType ... transType) {
        for (TransType type : transType) {
            ChineseUtils.transfer("", type);
        }
    }

    public static void unLoad(TransType ... transTypes) {
        for (TransType type : transTypes) {
            DictionaryContainer.getInstance().unloadDictionary(type);
        }
    }

    public static void loadExcludeDict(TransType type, Collection<String> dict) {
        DictionaryContainer.getInstance().loadExcludeDict(type, dict);
    }

    public static void loadExcludeDict(Collection<String> dict) {
        DictionaryContainer.getInstance().loadExcludeDict(null, dict);
    }

    public static void loadAdditionalDict(TransType type, Map<String, String> dict) {
        BasicDictionary dictionary = DictionaryContainer.getInstance().getDictionary(type);
        dict.forEach(dictionary::add);
    }

    public static String transfer(String content, TransType type) {
        return DictionaryContainer.getInstance().getDictionary(type).convert(content);
    }

    public static String s2t(String content) {
        return DictionaryContainer.getInstance().getDictionary(TransType.SIMPLE_TO_TRADITIONAL).convert(content);
    }

    public static String s2hk(String content) {
        return DictionaryContainer.getInstance().getDictionary(TransType.SIMPLE_TO_HONGKONG).convert(content);
    }

    public static String s2tw(String content) {
        return DictionaryContainer.getInstance().getDictionary(TransType.SIMPLE_TO_TAIWAN).convert(content);
    }

    public static String t2s(String content) {
        return DictionaryContainer.getInstance().getDictionary(TransType.TRADITIONAL_TO_SIMPLE).convert(content);
    }

    public static String hk2s(String content) {
        return DictionaryContainer.getInstance().getDictionary(TransType.HONGKONG_TO_SIMPLE).convert(content);
    }

    public static String tw2s(String content) {
        return DictionaryContainer.getInstance().getDictionary(TransType.TAIWAN_TO_SIMPLE).convert(content);
    }
}

