/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyueyi.quick.transfer;

import java.util.HashMap;
import java.util.Map;

public class TrieNode<T> {
    private int level = 0;
    private char key;
    private Map<Character, TrieNode<T>> children;
    private boolean leaf;
    private T value;

    public TrieNode(char key) {
        this.key = key;
        this.children = new HashMap<Character, TrieNode<T>>();
    }

    public char getKey() {
        return this.key;
    }

    public void setKey(char key) {
        this.key = key;
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    public void setLeaf(boolean leaf) {
        this.leaf = leaf;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public TrieNode<T> addChild(char k) {
        TrieNode<T> node = new TrieNode<T>(k);
        node.level = this.level + 1;
        this.children.put(Character.valueOf(k), node);
        return node;
    }

    public TrieNode<T> child(char k) {
        return this.children.get(Character.valueOf(k));
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.key);
        if (this.value != null) {
            sb.append(":").append(this.value);
        }
        return sb.toString();
    }
}

