/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyueyi.quick.transfer.constants;

import java.util.HashMap;
import java.util.Map;

public enum TransType {
    SIMPLE_TO_TRADITIONAL("s2t"),
    SIMPLE_TO_HONGKONG("s2hk"),
    SIMPLE_TO_TAIWAN("s2tw"),
    TRADITIONAL_TO_SIMPLE("t2s"),
    HONGKONG_TO_SIMPLE("hk2s"),
    TAIWAN_TO_SIMPLE("tw2s");

    private final String type;
    static Map<String, TransType> typeMap;

    private TransType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public static TransType typeOf(String type) {
        return typeMap.get(type);
    }

    static {
        typeMap = new HashMap<String, TransType>(8, 1.0f);
        for (TransType transType : TransType.values()) {
            typeMap.put(transType.getType(), transType);
        }
    }
}

