/*
 * Decompiled with CFR 0.152.
 */
package book.util;

import book.appCtx;
import book.util.ACacheKt;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u001d2\u00020\u0001:\u0003\u001d\u001e\u001fB!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0007J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\u000fJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0015J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0007J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000e\u001a\u00020\u000fJ\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00172\b\b\u0002\u0010\u0011\u001a\u00020\u0007H\u0007J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u001c\u001a\u00020\rR\u0014\u0010\n\u001a\b\u0018\u00010\u000bR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lbook/util/ACache;", "", "cacheDir", "Ljava/io/File;", "max_size", "", "max_count", "", "<init>", "(Ljava/io/File;JI)V", "mCache", "Lbook/util/ACache$ACacheManager;", "put", "", "key", "", "value", "saveTime", "getAsString", "getByHashCode", "hashCode", "", "getAsBinary", "Ljava/io/Serializable;", "getAsObject", "file", "remove", "", "clear", "Companion", "Utils", "ACacheManager", "book"})
public final class ACache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ACacheManager mCache;
    public static final int TIME_HOUR = 3600;
    public static final int TIME_DAY = 86400;
    private static final int MAX_SIZE = 50000000;
    private static final int MAX_COUNT = Integer.MAX_VALUE;
    @NotNull
    private static final HashMap<String, ACache> mInstanceMap = new HashMap();

    private ACache(File cacheDir, long max_size, int max_count) {
        try {
            if (!cacheDir.exists() && !cacheDir.mkdirs()) {
                ACacheKt.access$getLogger$p().info("ACache can't make dirs in %s" + cacheDir.getAbsolutePath());
            }
            this.mCache = new ACacheManager(cacheDir, max_size, max_count);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void put(@NotNull String key, @NotNull String value) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            ACacheManager aCacheManager = this.mCache;
            if (aCacheManager == null) break block2;
            ACacheManager mCache = aCacheManager;
            boolean bl = false;
            try {
                File file = mCache.newFile(key);
                FilesKt.writeText$default((File)file, (String)value, null, (int)2, null);
                mCache.put(file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public final void put(@NotNull String key, @NotNull String value, int saveTime) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.put(key, Utils.INSTANCE.newStringWithDateInfo(saveTime, value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String getAsString(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ACacheManager aCacheManager = this.mCache;
        if (aCacheManager != null) {
            boolean removeFile;
            block7: {
                ACacheManager mCache = aCacheManager;
                boolean bl = false;
                File file = mCache.get(key);
                if (!file.exists()) {
                    return null;
                }
                removeFile = false;
                String text = FilesKt.readText$default((File)file, null, (int)1, null);
                if (Utils.INSTANCE.isDue(text)) break block7;
                String string = Utils.INSTANCE.clearDateInfo(text);
                return string;
            }
            try {
                removeFile = true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.remove(key);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String getByHashCode(@NotNull String hashCode) {
        Intrinsics.checkNotNullParameter((Object)hashCode, (String)"hashCode");
        ACacheManager aCacheManager = this.mCache;
        if (aCacheManager != null) {
            boolean removeFile;
            File file;
            block7: {
                ACacheManager mCache = aCacheManager;
                boolean bl = false;
                file = mCache.newFileFromHashCode(hashCode);
                if (!file.exists()) {
                    return null;
                }
                removeFile = false;
                String text = FilesKt.readText$default((File)file, null, (int)1, null);
                if (Utils.INSTANCE.isDue(text)) break block7;
                String string = Utils.INSTANCE.clearDateInfo(text);
                return string;
            }
            try {
                removeFile = true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            file.delete();
        }
        return null;
    }

    public final void put(@NotNull String key, @NotNull byte[] value) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            ACacheManager aCacheManager = this.mCache;
            if (aCacheManager == null) break block0;
            ACacheManager mCache = aCacheManager;
            boolean bl = false;
            File file = mCache.newFile(key);
            FilesKt.writeBytes((File)file, (byte[])value);
            mCache.put(file);
        }
    }

    public final void put(@NotNull String key, @NotNull byte[] value, int saveTime) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.put(key, Utils.INSTANCE.newByteArrayWithDateInfo(saveTime, value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final byte[] getAsBinary(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ACacheManager aCacheManager = this.mCache;
        if (aCacheManager != null) {
            ACacheManager mCache = aCacheManager;
            boolean bl = false;
            boolean removeFile = false;
            try {
                byte[] byArray;
                File file = mCache.get(key);
                if (!file.exists()) {
                    byte[] byArray2 = null;
                    return byArray2;
                }
                byte[] byteArray = FilesKt.readBytes((File)file);
                if (!Utils.INSTANCE.isDue(byteArray)) {
                    byArray = Utils.INSTANCE.clearDateInfo(byteArray);
                } else {
                    removeFile = true;
                    byArray = null;
                }
                byte[] byArray3 = byArray;
                return byArray3;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (removeFile) {
                    this.remove(key);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public final void put(@NotNull String key, @NotNull Serializable value, int saveTime) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Closeable closeable = new ObjectOutputStream(byteArrayOutputStream);
            Throwable throwable = null;
            try {
                ObjectOutputStream oos = (ObjectOutputStream)closeable;
                boolean bl = false;
                oos.writeObject(value);
                byte[] data = byteArrayOutputStream.toByteArray();
                if (saveTime != -1) {
                    Intrinsics.checkNotNull((Object)data);
                    this.put(key, data, saveTime);
                } else {
                    Intrinsics.checkNotNull((Object)data);
                    this.put(key, data);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static /* synthetic */ void put$default(ACache aCache, String string, Serializable serializable, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = -1;
        }
        aCache.put(string, serializable, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object getAsObject(@NotNull String key) {
        block20: {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            data = this.getAsBinary(key);
            if (data != null) {
                bis = null;
                ois = null;
                bis = new ByteArrayInputStream(data);
                ois = new ObjectInputStream(bis);
                var5_5 = ois.readObject();
                ** try [egrp 1[TRYBLOCK] [0 : 51->59)] { 
lbl-1000:
                // 1 sources

                {
                    bis.close();
                }
lbl15:
                // 1 sources

                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    ois.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return var5_5;
                catch (Exception e) {
                    e.printStackTrace();
                    break block20;
                }
                finally {
                    try {
                        v0 = bis;
                        if (v0 != null) {
                            v0.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    try {
                        v1 = ois;
                        if (v1 != null) {
                            v1.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    @Nullable
    public final File file(@NotNull String key) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            ACacheManager aCacheManager = this.mCache;
            if (aCacheManager == null) break block3;
            ACacheManager mCache = aCacheManager;
            boolean bl = false;
            try {
                File f = mCache.newFile(key);
                if (f.exists()) {
                    return f;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public final boolean remove(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ACacheManager aCacheManager = this.mCache;
        return aCacheManager != null ? aCacheManager.remove(key) : false;
    }

    public final void clear() {
        block0: {
            ACacheManager aCacheManager = this.mCache;
            if (aCacheManager == null) break block0;
            aCacheManager.clear();
        }
    }

    @JvmOverloads
    public final void put(@NotNull String key, @NotNull Serializable value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ACache.put$default(this, key, value, 0, 4, null);
    }

    public /* synthetic */ ACache(File cacheDir, long max_size, int max_count, DefaultConstructorMarker $constructor_marker) {
        this(cacheDir, max_size, max_count);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0096\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0003J\u0011\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0019H\u0086\u0002J\u000e\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0019J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001f\u001a\u00020\u0014J\b\u0010 \u001a\u00020\u0005H\u0002J\u0010\u0010!\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000RP\u0010\u000e\u001aB\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00030\u0003\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00050\u0005 \u0010* \u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00030\u0003\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00110\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012\u00a8\u0006\""}, d2={"Lbook/util/ACache$ACacheManager;", "", "cacheDir", "Ljava/io/File;", "sizeLimit", "", "countLimit", "", "<init>", "(Lbook/util/ACache;Ljava/io/File;JI)V", "cacheSize", "Ljava/util/concurrent/atomic/AtomicLong;", "cacheCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "lastUsageDates", "", "kotlin.jvm.PlatformType", "", "Ljava/util/Map;", "calculateCacheSizeAndCacheCount", "", "put", "file", "get", "key", "", "newFile", "newFileFromHashCode", "hashCode", "remove", "", "clear", "removeNext", "calculateSize", "book"})
    public class ACacheManager {
        @NotNull
        private File cacheDir;
        private final long sizeLimit;
        private final int countLimit;
        @NotNull
        private final AtomicLong cacheSize;
        @NotNull
        private final AtomicInteger cacheCount;
        private final Map<File, Long> lastUsageDates;

        public ACacheManager(File cacheDir, long sizeLimit, int countLimit) {
            Intrinsics.checkNotNullParameter((Object)cacheDir, (String)"cacheDir");
            this.cacheDir = cacheDir;
            this.sizeLimit = sizeLimit;
            this.countLimit = countLimit;
            this.cacheSize = new AtomicLong();
            this.cacheCount = new AtomicInteger();
            this.lastUsageDates = Collections.synchronizedMap(new HashMap());
            this.calculateCacheSizeAndCacheCount();
        }

        private final void calculateCacheSizeAndCacheCount() {
            new Thread(() -> ACacheManager.calculateCacheSizeAndCacheCount$lambda$0(this)).start();
        }

        public final void put(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            try {
                int curCacheCount = this.cacheCount.get();
                while (curCacheCount + 1 > this.countLimit) {
                    long freedSize = this.removeNext();
                    this.cacheSize.addAndGet(-freedSize);
                    curCacheCount = this.cacheCount.addAndGet(-1);
                }
                this.cacheCount.addAndGet(1);
                long valueSize = this.calculateSize(file);
                long curCacheSize = this.cacheSize.get();
                while (curCacheSize + valueSize > this.sizeLimit) {
                    long freedSize = this.removeNext();
                    curCacheSize = this.cacheSize.addAndGet(-freedSize);
                }
                this.cacheSize.addAndGet(valueSize);
                long currentTime = System.currentTimeMillis();
                file.setLastModified(currentTime);
                Map<File, Long> map = this.lastUsageDates;
                Intrinsics.checkNotNullExpressionValue(map, (String)"lastUsageDates");
                Map<File, Long> map2 = map;
                Long l = currentTime;
                map2.put(file, l);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @NotNull
        public final File get(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            File file = this.newFile(key);
            long currentTime = System.currentTimeMillis();
            file.setLastModified(currentTime);
            Map<File, Long> map = this.lastUsageDates;
            Intrinsics.checkNotNullExpressionValue(map, (String)"lastUsageDates");
            Map<File, Long> map2 = map;
            Long l = currentTime;
            map2.put(file, l);
            return file;
        }

        @NotNull
        public final File newFile(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return new File(this.cacheDir, "" + key.hashCode());
        }

        @NotNull
        public final File newFileFromHashCode(@NotNull String hashCode) {
            Intrinsics.checkNotNullParameter((Object)hashCode, (String)"hashCode");
            return new File(this.cacheDir, hashCode);
        }

        public final boolean remove(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            File image = this.get(key);
            return image.delete();
        }

        public final void clear() {
            try {
                this.lastUsageDates.clear();
                this.cacheSize.set(0L);
                Object[] files = this.cacheDir.listFiles();
                if (files != null) {
                    Iterator iterator = ArrayIteratorKt.iterator((Object[])files);
                    while (iterator.hasNext()) {
                        File f = (File)iterator.next();
                        f.delete();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final long removeNext() {
            try {
                if (this.lastUsageDates.isEmpty()) {
                    return 0L;
                }
                Long oldestUsage = null;
                File mostLongUsedFile = null;
                Set<Map.Entry<File, Long>> entries = this.lastUsageDates.entrySet();
                Map<File, Long> map = this.lastUsageDates;
                Intrinsics.checkNotNullExpressionValue(map, (String)"lastUsageDates");
                Map<File, Long> map2 = map;
                synchronized (map2) {
                    boolean bl = false;
                    for (Map.Entry<File, Long> entry : entries) {
                        File key = entry.getKey();
                        Long lastValueUsage = entry.getValue();
                        if (mostLongUsedFile == null) {
                            mostLongUsedFile = key;
                            oldestUsage = lastValueUsage;
                            continue;
                        }
                        long l = lastValueUsage;
                        Long l2 = oldestUsage;
                        Intrinsics.checkNotNull((Object)l2);
                        if (l >= ((Number)l2).longValue()) continue;
                        oldestUsage = lastValueUsage;
                        mostLongUsedFile = key;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                long fileSize = 0L;
                if (mostLongUsedFile != null) {
                    fileSize = this.calculateSize(mostLongUsedFile);
                    if (mostLongUsedFile.delete()) {
                        this.lastUsageDates.remove(mostLongUsedFile);
                    }
                }
                return fileSize;
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0L;
            }
        }

        private final long calculateSize(File file) {
            return file.length();
        }

        private static final void calculateCacheSizeAndCacheCount$lambda$0(ACacheManager this$0) {
            try {
                int size = 0;
                int count = 0;
                Object[] cachedFiles = this$0.cacheDir.listFiles();
                if (cachedFiles != null) {
                    Iterator iterator = ArrayIteratorKt.iterator((Object[])cachedFiles);
                    while (iterator.hasNext()) {
                        Map<File, Long> map;
                        File cachedFile = (File)iterator.next();
                        Intrinsics.checkNotNull((Object)cachedFile);
                        size += (int)this$0.calculateSize(cachedFile);
                        ++count;
                        Intrinsics.checkNotNullExpressionValue(this$0.lastUsageDates, (String)"lastUsageDates");
                        Long l = cachedFile.lastModified();
                        map.put(cachedFile, l);
                    }
                    this$0.cacheSize.set(size);
                    this$0.cacheCount.set(count);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000b2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0005H\u0007J$\u0010\r\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0005H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lbook/util/ACache$Companion;", "", "<init>", "()V", "TIME_HOUR", "", "TIME_DAY", "MAX_SIZE", "MAX_COUNT", "mInstanceMap", "Ljava/util/HashMap;", "", "Lbook/util/ACache;", "get", "cacheName", "maxSize", "", "maxCount", "cacheDir", "Ljava/io/File;", "book"})
    public static final class Companion {
        private Companion() {
        }

        @JvmOverloads
        @NotNull
        public final ACache get(@NotNull String cacheName, long maxSize, int maxCount) {
            Intrinsics.checkNotNullParameter((Object)cacheName, (String)"cacheName");
            File f = new File(appCtx.INSTANCE.getCacheDir(), cacheName);
            return this.get(f, maxSize, maxCount);
        }

        public static /* synthetic */ ACache get$default(Companion companion, String string, long l, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = "ACache";
            }
            if ((n2 & 2) != 0) {
                l = 50000000L;
            }
            if ((n2 & 4) != 0) {
                n = Integer.MAX_VALUE;
            }
            return companion.get(string, l, n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmOverloads
        @NotNull
        public final ACache get(@NotNull File cacheDir, long maxSize, int maxCount) {
            Intrinsics.checkNotNullParameter((Object)cacheDir, (String)"cacheDir");
            Companion companion = this;
            synchronized (companion) {
                boolean bl = false;
                ACache manager = (ACache)mInstanceMap.get(cacheDir.getAbsoluteFile().toString());
                if (manager == null) {
                    manager = new ACache(cacheDir, maxSize, maxCount, null);
                    ((Map)mInstanceMap).put(cacheDir.getAbsolutePath(), manager);
                }
                ACache aCache = manager;
                return aCache;
            }
        }

        public static /* synthetic */ ACache get$default(Companion companion, File file, long l, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                l = 50000000L;
            }
            if ((n2 & 4) != 0) {
                n = Integer.MAX_VALUE;
            }
            return companion.get(file, l, n);
        }

        @JvmOverloads
        @NotNull
        public final ACache get(@NotNull String cacheName, long maxSize) {
            Intrinsics.checkNotNullParameter((Object)cacheName, (String)"cacheName");
            return book.util.ACache$Companion.get$default(this, cacheName, maxSize, 0, 4, null);
        }

        @JvmOverloads
        @NotNull
        public final ACache get(@NotNull String cacheName) {
            Intrinsics.checkNotNullParameter((Object)cacheName, (String)"cacheName");
            return book.util.ACache$Companion.get$default(this, cacheName, 0L, 0, 6, null);
        }

        @JvmOverloads
        @NotNull
        public final ACache get() {
            return book.util.ACache$Companion.get$default(this, null, 0L, 0, 7, null);
        }

        @JvmOverloads
        @NotNull
        public final ACache get(@NotNull File cacheDir, long maxSize) {
            Intrinsics.checkNotNullParameter((Object)cacheDir, (String)"cacheDir");
            return book.util.ACache$Companion.get$default(this, cacheDir, maxSize, 0, 4, null);
        }

        @JvmOverloads
        @NotNull
        public final ACache get(@NotNull File cacheDir) {
            Intrinsics.checkNotNullParameter((Object)cacheDir, (String)"cacheDir");
            return book.util.ACache$Companion.get$default(this, cacheDir, 0L, 0, 6, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\t\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tJ\u0016\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000bJ\u0012\u0010\u0012\u001a\u0004\u0018\u00010\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\tJ\u000e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u0013\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u001b\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u00152\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0016J\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J \u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u000eH\u0002J\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lbook/util/ACache$Utils;", "", "<init>", "()V", "mSeparator", "", "isDue", "", "str", "", "data", "", "newStringWithDateInfo", "second", "", "strInfo", "newByteArrayWithDateInfo", "data2", "clearDateInfo", "hasDateInfo", "getDateInfoFromDate", "", "([B)[Ljava/lang/String;", "indexOf", "c", "copyOfRange", "original", "from", "to", "createDateInfo", "book"})
    @SourceDebugExtension(value={"SMAP\nACache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ACache.kt\nbook/util/ACache$Utils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,798:1\n1#2:799\n*E\n"})
    private static final class Utils {
        @NotNull
        public static final Utils INSTANCE = new Utils();
        private static final char mSeparator = ' ';

        private Utils() {
        }

        public final boolean isDue(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            String string = str;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            return this.isDue(byArray);
        }

        public final boolean isDue(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            try {
                String[] text = this.getDateInfoFromDate(data);
                if (text != null && text.length == 2) {
                    String saveTimeStr = text[0];
                    while (StringsKt.startsWith$default((String)saveTimeStr, (String)"0", (boolean)false, (int)2, null)) {
                        Intrinsics.checkNotNullExpressionValue((Object)saveTimeStr.substring(1), (String)"substring(...)");
                    }
                    Long saveTime = Long.valueOf(saveTimeStr);
                    Long deleteAfter = Long.valueOf(text[1]);
                    if (System.currentTimeMillis() > saveTime + deleteAfter * (long)1000) {
                        return true;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return false;
        }

        @NotNull
        public final String newStringWithDateInfo(int second, @NotNull String strInfo) {
            Intrinsics.checkNotNullParameter((Object)strInfo, (String)"strInfo");
            return this.createDateInfo(second) + strInfo;
        }

        @NotNull
        public final byte[] newByteArrayWithDateInfo(int second, @NotNull byte[] data2) {
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data2");
            String string = this.createDateInfo(second);
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] data1 = byArray;
            byte[] retData = new byte[data1.length + data2.length];
            System.arraycopy(data1, 0, retData, 0, data1.length);
            System.arraycopy(data2, 0, retData, data1.length, data2.length);
            return retData;
        }

        @Nullable
        public final String clearDateInfo(@Nullable String strInfo) {
            String string = strInfo;
            if (string != null) {
                String it = string;
                boolean bl = false;
                byte[] byArray = strInfo.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                if (INSTANCE.hasDateInfo(byArray)) {
                    String string2 = strInfo.substring(StringsKt.indexOf$default((CharSequence)strInfo, (char)' ', (int)0, (boolean)false, (int)6, null) + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    return string2;
                }
            }
            return strInfo;
        }

        @NotNull
        public final byte[] clearDateInfo(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return this.hasDateInfo(data) ? this.copyOfRange(data, this.indexOf(data, ' ') + 1, data.length) : data;
        }

        public final boolean hasDateInfo(@Nullable byte[] data) {
            return data != null && data.length > 15 && data[13] == 45 && this.indexOf(data, ' ') > 14;
        }

        @Nullable
        public final String[] getDateInfoFromDate(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (this.hasDateInfo(data)) {
                String saveDate = new String(this.copyOfRange(data, 0, 13), Charsets.UTF_8);
                String deleteAfter = new String(this.copyOfRange(data, 14, this.indexOf(data, ' ')), Charsets.UTF_8);
                String[] stringArray = new String[]{saveDate, deleteAfter};
                return stringArray;
            }
            return null;
        }

        private final int indexOf(byte[] data, char c) {
            int n = data.length;
            for (int i = 0; i < n; ++i) {
                if (data[i] != (byte)c) continue;
                return i;
            }
            return -1;
        }

        private final byte[] copyOfRange(byte[] original, int from, int to) {
            int newLength = to - from;
            if (!(newLength >= 0)) {
                boolean bl = false;
                String string = from + " > " + to;
                throw new IllegalArgumentException(string.toString());
            }
            byte[] copy = new byte[newLength];
            System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
            return copy;
        }

        private final String createDateInfo(int second) {
            StringBuilder currentTime = new StringBuilder("" + System.currentTimeMillis());
            while (currentTime.length() < 13) {
                currentTime.insert(0, "0");
            }
            return currentTime + "-" + second + " ";
        }
    }
}

