/*
 * Decompiled with CFR 0.152.
 */
package book.util;

import book.util.Base64;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u001a\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\nH\u0007J\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\nH\u0007J\u001a\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\t\u001a\u00020\nH\u0007J\u001a\u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000f"}, d2={"Lbook/util/EncoderUtils;", "", "<init>", "()V", "escape", "", "src", "base64Decode", "str", "flags", "", "base64Encode", "bytes", "", "base64DecodeToByteArray", "book"})
public final class EncoderUtils {
    @NotNull
    public static final EncoderUtils INSTANCE = new EncoderUtils();

    private EncoderUtils() {
    }

    @NotNull
    public final String escape(@NotNull String src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        StringBuilder tmp = new StringBuilder();
        int n = src.length();
        for (int i = 0; i < n; ++i) {
            char charCode;
            block5: {
                char c;
                block4: {
                    c = src.charAt(i);
                    charCode = c;
                    if ('0' <= charCode ? charCode < ':' : false) break block4;
                    if ('A' <= charCode ? charCode < '[' : false) break block4;
                    boolean bl = 'a' <= charCode ? charCode < '{' : false;
                    if (!bl) break block5;
                }
                tmp.append(c);
                continue;
            }
            String prefix = charCode < '\u0010' ? "%0" : (charCode < '\u0100' ? "%" : "%u");
            StringBuilder stringBuilder = tmp.append(prefix);
            String string = Integer.toString(charCode, CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            stringBuilder.append(string);
        }
        String string = tmp.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmOverloads
    @NotNull
    public final String base64Decode(@NotNull String str, int flags) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        byte[] bytes2 = Base64.decode(str, flags);
        return new String(bytes2, Charsets.UTF_8);
    }

    public static /* synthetic */ String base64Decode$default(EncoderUtils encoderUtils, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return encoderUtils.base64Decode(string, n);
    }

    @JvmOverloads
    @Nullable
    public final String base64Encode(@NotNull String str, int flags) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        String string = str;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return Base64.encodeToString(byArray, flags);
    }

    public static /* synthetic */ String base64Encode$default(EncoderUtils encoderUtils, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 2;
        }
        return encoderUtils.base64Encode(string, n);
    }

    @JvmOverloads
    @NotNull
    public final String base64Encode(@NotNull byte[] bytes2, int flags) {
        Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
        return Base64.encodeToString(bytes2, flags);
    }

    public static /* synthetic */ String base64Encode$default(EncoderUtils encoderUtils, byte[] byArray, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 2;
        }
        return encoderUtils.base64Encode(byArray, n);
    }

    @JvmOverloads
    @NotNull
    public final byte[] base64DecodeToByteArray(@NotNull String str, int flags) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return Base64.decode(str, flags);
    }

    public static /* synthetic */ byte[] base64DecodeToByteArray$default(EncoderUtils encoderUtils, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return encoderUtils.base64DecodeToByteArray(string, n);
    }

    @JvmOverloads
    @NotNull
    public final String base64Decode(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return EncoderUtils.base64Decode$default(this, str, 0, 2, null);
    }

    @JvmOverloads
    @Nullable
    public final String base64Encode(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return EncoderUtils.base64Encode$default(this, str, 0, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final String base64Encode(@NotNull byte[] bytes2) {
        Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
        return EncoderUtils.base64Encode$default(this, bytes2, 0, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final byte[] base64DecodeToByteArray(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return EncoderUtils.base64DecodeToByteArray$default(this, str, 0, 2, null);
    }
}

