/*
 * Decompiled with CFR 0.152.
 */
package book.util;

import book.icu4j.CharsetDetector;
import book.icu4j.CharsetMatch;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\f\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u00a8\u0006\r"}, d2={"Lbook/util/EncodingDetect;", "", "<init>", "()V", "getHtmlEncode", "", "bytes", "", "getEncode", "filePath", "file", "Ljava/io/File;", "getFileBytes", "book"})
public final class EncodingDetect {
    @NotNull
    public static final EncodingDetect INSTANCE = new EncodingDetect();

    private EncodingDetect() {
    }

    @Nullable
    public final String getHtmlEncode(@NotNull byte[] bytes2) {
        Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
        try {
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Charset charset2 = charset;
            Document doc = Jsoup.parse((String)new String(bytes2, charset2));
            Elements metaTags = doc.getElementsByTag("meta");
            String charsetStr = null;
            Iterator iterator = metaTags.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                String string;
                Element metaTag = (Element)iterator2.next();
                charsetStr = metaTag.attr("charset");
                if (!(((CharSequence)charsetStr).length() == 0)) {
                    return charsetStr;
                }
                String content = metaTag.attr("content");
                String httpEquiv = metaTag.attr("http-equiv");
                Intrinsics.checkNotNull((Object)httpEquiv);
                String string2 = httpEquiv;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string3 = string2.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                if (!Intrinsics.areEqual((Object)string3, (Object)"content-type")) continue;
                Intrinsics.checkNotNull((Object)content);
                string2 = content;
                Locale locale2 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
                String string4 = string2.toLowerCase(locale2);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                if (StringsKt.contains$default((CharSequence)string4, (CharSequence)"charset", (boolean)false, (int)2, null)) {
                    string2 = content;
                    String string5 = content;
                    Locale locale3 = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"getDefault(...)");
                    String string6 = string5.toLowerCase(locale3);
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toLowerCase(...)");
                    var10_11 = StringsKt.indexOf$default((CharSequence)string6, (String)"charset", (int)0, (boolean)false, (int)6, null) + 8;
                    String string7 = string2.substring(var10_11);
                    string = string7;
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
                } else {
                    string2 = content;
                    String string8 = content;
                    Locale locale4 = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale4, (String)"getDefault(...)");
                    String string9 = string8.toLowerCase(locale4);
                    Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"toLowerCase(...)");
                    var10_11 = StringsKt.indexOf$default((CharSequence)string9, (String)";", (int)0, (boolean)false, (int)6, null) + 1;
                    String string10 = string2.substring(var10_11);
                    string = string10;
                    Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"substring(...)");
                }
                if (((CharSequence)(charsetStr = string)).length() == 0) continue;
                return charsetStr;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getEncode(bytes2);
    }

    @NotNull
    public final String getEncode(@NotNull byte[] bytes2) {
        Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
        CharsetMatch match = new CharsetDetector().setText(bytes2).detect();
        Object object = match;
        if (object == null || (object = ((CharsetMatch)object).getName()) == null) {
            object = "UTF-8";
        }
        return object;
    }

    @NotNull
    public final String getEncode(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return this.getEncode(new File(filePath));
    }

    @NotNull
    public final String getEncode(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        byte[] tempByte = this.getFileBytes(file);
        return this.getEncode(tempByte);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] getFileBytes(File file) {
        byte[] byteArray = new byte[8000];
        try {
            Closeable closeable = new FileInputStream(file);
            Throwable throwable = null;
            try {
                FileInputStream it = (FileInputStream)closeable;
                boolean bl = false;
                int n = it.read(byteArray);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byteArray;
    }
}

