/*
 * Decompiled with CFR 0.152.
 */
package book.util;

import book.appCtx;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.RetentionPolicy;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0016\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0005abcdeB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r\"\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ'\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r\"\u00020\u000e\u00a2\u0006\u0002\u0010\u0011J'\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r\"\u00020\u000e\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000eJ\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000eJ\u000e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000eJ'\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r\"\u00020\u000e\u00a2\u0006\u0002\u0010\u0011J'\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r\"\u00020\u000e\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u000eJ\u000e\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000eJ\u000e\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u000eJ\u000e\u0010'\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\u000eJ\u0010\u0010)\u001a\u00020\u001a2\b\u0010*\u001a\u0004\u0018\u00010+J7\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010-\u001a\u00020\u000e2\u0010\b\u0002\u0010.\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\b\b\u0002\u0010/\u001a\u00020\u001fH\u0007\u00a2\u0006\u0002\u00100J/\u00101\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\r2\u0006\u0010-\u001a\u00020\u000e2\u0010\b\u0002\u00102\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rH\u0007\u00a2\u0006\u0002\u00103J1\u00104\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010-\u001a\u00020\u000e2\n\b\u0002\u00105\u001a\u0004\u0018\u0001062\b\b\u0002\u0010/\u001a\u00020\u001fH\u0007\u00a2\u0006\u0002\u00107J+\u00104\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\r2\u0006\u0010-\u001a\u00020\u000e2\u000e\u00102\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r\u00a2\u0006\u0002\u00103J%\u00104\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\r2\u0006\u0010-\u001a\u00020\u000e2\b\u00108\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u00109J\u000e\u0010:\u001a\u00020\t2\u0006\u0010(\u001a\u00020\u000eJ\u001a\u0010;\u001a\u00020\t2\u0006\u0010<\u001a\u00020\u000b2\b\b\u0002\u0010=\u001a\u00020\tH\u0007J\u0010\u0010>\u001a\u00020\t2\u0006\u0010<\u001a\u00020\u000bH\u0002J\u001a\u0010;\u001a\u00020\t2\u0006\u0010(\u001a\u00020\u000e2\b\b\u0002\u0010=\u001a\u00020\tH\u0007J\u0016\u0010?\u001a\u00020\t2\u0006\u0010@\u001a\u00020\u000e2\u0006\u0010A\u001a\u00020\u000eJ\u0016\u0010?\u001a\u00020\t2\u0006\u0010@\u001a\u00020\u000b2\u0006\u0010A\u001a\u00020\u000bJ\u0016\u0010B\u001a\u00020\t2\u0006\u0010@\u001a\u00020\u000e2\u0006\u0010A\u001a\u00020\u000eJ\u0016\u0010B\u001a\u00020\t2\u0006\u0010@\u001a\u00020\u000b2\u0006\u0010A\u001a\u00020\u000bJ\u0016\u0010C\u001a\u00020\t2\u0006\u0010D\u001a\u00020\u000e2\u0006\u0010E\u001a\u00020\u000eJ\u0016\u0010C\u001a\u00020\t2\u0006\u0010@\u001a\u00020\u000b2\u0006\u0010A\u001a\u00020\u000bJ\u001a\u0010F\u001a\u00020\u000e2\u0006\u0010G\u001a\u00020\u000e2\b\b\u0002\u0010H\u001a\u00020\u000eH\u0007J\u0010\u0010I\u001a\u0004\u0018\u00010J2\u0006\u0010G\u001a\u00020\u000eJ\"\u0010K\u001a\u00020\t2\u0006\u0010G\u001a\u00020\u000e2\u0006\u0010L\u001a\u00020\u000e2\b\b\u0002\u0010H\u001a\u00020\u000eH\u0007J\u0016\u0010M\u001a\u00020\t2\u0006\u0010G\u001a\u00020\u000e2\u0006\u0010N\u001a\u00020JJ\u0016\u0010O\u001a\u00020\t2\u0006\u0010G\u001a\u00020\u000e2\u0006\u0010N\u001a\u00020PJ\u0016\u0010O\u001a\u00020\t2\u0006\u0010<\u001a\u00020\u000b2\u0006\u0010N\u001a\u00020PJ\u0016\u0010Q\u001a\u00020\t2\u0006\u0010(\u001a\u00020\u000e2\u0006\u0010L\u001a\u00020\u000eJ\u000e\u0010R\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u000eJ\u0010\u0010S\u001a\u00020\u000e2\b\u0010T\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010U\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\u000eJ\u000e\u0010V\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\u000eJ\u000e\u0010W\u001a\u00020\u000e2\u0006\u0010X\u001a\u00020\u0005J\u000e\u0010Y\u001a\u00020\u000e2\u0006\u0010T\u001a\u00020\u000eJ\u000e\u0010Z\u001a\u00020\u000e2\u0006\u0010T\u001a\u00020\u000eJ\u001a\u0010[\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\u000e2\b\b\u0002\u0010\\\u001a\u00020\u000eH\u0007J\u0016\u0010[\u001a\u00020\u000e2\u0006\u0010<\u001a\u00020\u000b2\u0006\u0010\\\u001a\u00020\u000eJ\u0016\u0010]\u001a\u00020\u001f2\u0006\u0010^\u001a\u00020\u000e2\u0006\u0010_\u001a\u00020\u000eJ\u000e\u0010`\u001a\u00020\t2\u0006\u0010(\u001a\u00020\u000eJ\u000e\u0010`\u001a\u00020\t2\u0006\u0010<\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u001fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u001fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u001fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u001fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u001fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u001fX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006f"}, d2={"Lbook/util/FileUtils;", "", "<init>", "()V", "GB", "", "MB", "KB", "exists", "", "root", "Ljava/io/File;", "subDirFiles", "", "", "(Ljava/io/File;[Ljava/lang/String;)Z", "createFileIfNotExist", "(Ljava/io/File;[Ljava/lang/String;)Ljava/io/File;", "createFolderIfNotExist", "subDirs", "filePath", "createFileWithReplace", "getFile", "getPath", "(Ljava/io/File;[Ljava/lang/String;)Ljava/lang/String;", "deleteFile", "", "getdownDir", "userid", "getCachePath", "BY_NAME_ASC", "", "BY_NAME_DESC", "BY_TIME_ASC", "BY_TIME_DESC", "BY_SIZE_ASC", "BY_SIZE_DESC", "BY_EXTENSION_ASC", "BY_EXTENSION_DESC", "separator", "path", "closeSilently", "c", "Ljava/io/Closeable;", "listDirs", "startDirPath", "excludeDirs", "sortType", "(Ljava/lang/String;[Ljava/lang/String;I)[Ljava/io/File;", "listDirsAndFiles", "allowExtensions", "(Ljava/lang/String;[Ljava/lang/String;)[Ljava/io/File;", "listFiles", "filterPattern", "Ljava/util/regex/Pattern;", "(Ljava/lang/String;Ljava/util/regex/Pattern;I)[Ljava/io/File;", "allowExtension", "(Ljava/lang/String;Ljava/lang/String;)[Ljava/io/File;", "exist", "delete", "file", "deleteRootDir", "deleteResolveEBUSY", "copy", "src", "tar", "move", "rename", "oldPath", "newPath", "readText", "filepath", "charset", "readBytes", "", "writeText", "content", "writeBytes", "data", "writeInputStream", "Ljava/io/InputStream;", "appendText", "getLength", "getName", "pathOrUrl", "getNameExcludeExtension", "getSize", "toFileSizeString", "fileSize", "getExtension", "getMimeType", "getDateTime", "format", "compareLastModified", "path1", "path2", "makeDirs", "SortType", "SortByExtension", "SortByName", "SortBySize", "SortByTime", "book"})
@SourceDebugExtension(value={"SMAP\nFileUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileUtils.kt\nbook/util/FileUtils\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,814:1\n13402#2,2:815\n13402#2,2:817\n13402#2,2:827\n37#3:819\n36#3,3:820\n37#3:823\n36#3,3:824\n108#4:829\n80#4,22:830\n*S KotlinDebug\n*F\n+ 1 FileUtils.kt\nbook/util/FileUtils\n*L\n80#1:815,2\n96#1:817,2\n392#1:827,2\n203#1:819\n203#1:820,3\n276#1:823\n276#1:824,3\n439#1:829\n439#1:830,22\n*E\n"})
public final class FileUtils {
    @NotNull
    public static final FileUtils INSTANCE = new FileUtils();
    public static final long GB = 0x40000000L;
    public static final long MB = 0x100000L;
    public static final long KB = 1024L;
    public static final int BY_NAME_ASC = 0;
    public static final int BY_NAME_DESC = 1;
    public static final int BY_TIME_ASC = 2;
    public static final int BY_TIME_DESC = 3;
    public static final int BY_SIZE_ASC = 4;
    public static final int BY_SIZE_DESC = 5;
    public static final int BY_EXTENSION_ASC = 6;
    public static final int BY_EXTENSION_DESC = 7;

    private FileUtils() {
    }

    public final boolean exists(@NotNull File root, String ... subDirFiles) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)subDirFiles, (String)"subDirFiles");
        return this.getFile(root, Arrays.copyOf(subDirFiles, subDirFiles.length)).exists();
    }

    @NotNull
    public final File createFileIfNotExist(@NotNull File root, String ... subDirFiles) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)subDirFiles, (String)"subDirFiles");
        String filePath = this.getPath(root, Arrays.copyOf(subDirFiles, subDirFiles.length));
        return this.createFileIfNotExist(filePath);
    }

    @NotNull
    public final File createFolderIfNotExist(@NotNull File root, String ... subDirs) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)subDirs, (String)"subDirs");
        String filePath = this.getPath(root, Arrays.copyOf(subDirs, subDirs.length));
        return this.createFolderIfNotExist(filePath);
    }

    @NotNull
    public final File createFolderIfNotExist(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        File file = new File(filePath);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    @NotNull
    public final synchronized File createFileIfNotExist(@NotNull String filePath) {
        File file;
        block3: {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            file = new File(filePath);
            try {
                if (file.exists()) break block3;
                String string = file.getParent();
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    INSTANCE.createFolderIfNotExist(it);
                }
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    @NotNull
    public final File createFileWithReplace(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        File file = new File(filePath);
        if (!file.exists()) {
            String string = file.getParent();
            if (string != null) {
                String it = string;
                boolean bl = false;
                INSTANCE.createFolderIfNotExist(it);
            }
            v1 = file.createNewFile();
        } else {
            file.delete();
            v1 = file.createNewFile();
        }
        return file;
    }

    @NotNull
    public final File getFile(@NotNull File root, String ... subDirFiles) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)subDirFiles, (String)"subDirFiles");
        String filePath = this.getPath(root, Arrays.copyOf(subDirFiles, subDirFiles.length));
        return new File(filePath);
    }

    @NotNull
    public final String getPath(@NotNull File root, String ... subDirFiles) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)subDirFiles, (String)"subDirFiles");
        StringBuilder path = new StringBuilder(root.getAbsolutePath());
        String[] $this$forEach$iv = subDirFiles;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if (!(((CharSequence)it).length() > 0)) continue;
            path.append(File.separator).append(it);
        }
        String string = path.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final synchronized void deleteFile(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        File file = new File(filePath);
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] files;
            if (files != null) {
                File[] $this$forEach$iv = files = file.listFiles();
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    File element$iv;
                    File subFile = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    String path = subFile.getPath();
                    Intrinsics.checkNotNull((Object)path);
                    INSTANCE.deleteFile(path);
                }
            }
        }
        file.delete();
    }

    @NotNull
    public final File getdownDir(@NotNull String userid) {
        Intrinsics.checkNotNullParameter((Object)userid, (String)"userid");
        String[] stringArray = new String[]{"down", userid};
        File downDir = this.createFolderIfNotExist(appCtx.INSTANCE.getExternalFiles(), stringArray);
        return downDir;
    }

    @NotNull
    public final String getCachePath(@NotNull String userid) {
        Intrinsics.checkNotNullParameter((Object)userid, (String)"userid");
        String[] stringArray = new String[]{"down", userid};
        File downDir = this.createFolderIfNotExist(appCtx.INSTANCE.getExternalFiles(), stringArray);
        String string = downDir.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }

    @NotNull
    public final String separator(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object path1 = path;
        String separator = File.separator;
        Intrinsics.checkNotNull((Object)separator);
        path1 = StringsKt.replace$default((String)path1, (String)"\\", (String)separator, (boolean)false, (int)4, null);
        if (!StringsKt.endsWith$default((String)path1, (String)separator, (boolean)false, (int)2, null)) {
            path1 = (String)path1 + separator;
        }
        return path1;
    }

    public final void closeSilently(@Nullable Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @JvmOverloads
    @NotNull
    public final File[] listDirs(@NotNull String startDirPath, @Nullable String[] excludeDirs, int sortType) {
        Intrinsics.checkNotNullParameter((Object)startDirPath, (String)"startDirPath");
        Object[] excludeDirs1 = excludeDirs;
        ArrayList<File> dirList = new ArrayList<File>();
        File startDir = new File(startDirPath);
        if (!startDir.isDirectory()) {
            return new File[0];
        }
        File[] fileArray = startDir.listFiles(FileUtils::listDirs$lambda$4);
        if (fileArray == null) {
            return new File[0];
        }
        File[] dirs = fileArray;
        if (excludeDirs1 == null) {
            excludeDirs1 = new String[]{};
        }
        for (File dir : dirs) {
            File file = dir.getAbsoluteFile();
            Object[] objectArray = excludeDirs1;
            CharSequence charSequence = ArraysKt.contentDeepToString((Object[])objectArray);
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string, (boolean)false, (int)2, null)) continue;
            dirList.add(file);
        }
        switch (sortType) {
            case 0: {
                Collections.sort((List)dirList, new SortByName());
                break;
            }
            case 1: {
                Collections.sort((List)dirList, new SortByName());
                CollectionsKt.reverse((List)dirList);
                break;
            }
            case 2: {
                Collections.sort((List)dirList, new SortByTime());
                break;
            }
            case 3: {
                Collections.sort((List)dirList, new SortByTime());
                CollectionsKt.reverse((List)dirList);
                break;
            }
            case 4: {
                Collections.sort((List)dirList, new SortBySize());
                break;
            }
            case 5: {
                Collections.sort((List)dirList, new SortBySize());
                CollectionsKt.reverse((List)dirList);
                break;
            }
            case 6: {
                Collections.sort((List)dirList, new SortByExtension());
                break;
            }
            case 7: {
                Collections.sort((List)dirList, new SortByExtension());
                CollectionsKt.reverse((List)dirList);
            }
        }
        Collection $this$toTypedArray$iv = dirList;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new File[0]);
    }

    public static /* synthetic */ File[] listDirs$default(FileUtils fileUtils, String string, String[] stringArray, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            stringArray = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return fileUtils.listDirs(string, stringArray, n);
    }

    @JvmOverloads
    @Nullable
    public final File[] listDirsAndFiles(@NotNull String startDirPath, @Nullable String[] allowExtensions) {
        Intrinsics.checkNotNullParameter((Object)startDirPath, (String)"startDirPath");
        Object[] dirs = null;
        Object[] files = allowExtensions == null ? FileUtils.listFiles$default(this, startDirPath, null, 0, 6, null) : this.listFiles(startDirPath, allowExtensions);
        dirs = FileUtils.listDirs$default(this, startDirPath, null, 0, 6, null);
        if (files == null) {
            return null;
        }
        return (File[])ArraysKt.plus((Object[])dirs, (Object[])files);
    }

    public static /* synthetic */ File[] listDirsAndFiles$default(FileUtils fileUtils, String string, String[] stringArray, int n, Object object) {
        if ((n & 2) != 0) {
            stringArray = null;
        }
        return fileUtils.listDirsAndFiles(string, stringArray);
    }

    @JvmOverloads
    @NotNull
    public final File[] listFiles(@NotNull String startDirPath, @Nullable Pattern filterPattern, int sortType) {
        Intrinsics.checkNotNullParameter((Object)startDirPath, (String)"startDirPath");
        ArrayList<File> fileList = new ArrayList<File>();
        File f = new File(startDirPath);
        if (!f.isDirectory()) {
            return new File[0];
        }
        File[] fileArray = f.listFiles(arg_0 -> FileUtils.listFiles$lambda$5(filterPattern, arg_0));
        if (fileArray == null) {
            return new File[0];
        }
        for (File file : fileArray) {
            fileList.add(file.getAbsoluteFile());
        }
        switch (sortType) {
            case 0: {
                Collections.sort((List)fileList, new SortByName());
                break;
            }
            case 1: {
                Collections.sort((List)fileList, new SortByName());
                CollectionsKt.reverse((List)fileList);
                break;
            }
            case 2: {
                Collections.sort((List)fileList, new SortByTime());
                break;
            }
            case 3: {
                Collections.sort((List)fileList, new SortByTime());
                CollectionsKt.reverse((List)fileList);
                break;
            }
            case 4: {
                Collections.sort((List)fileList, new SortBySize());
                break;
            }
            case 5: {
                Collections.sort((List)fileList, new SortBySize());
                CollectionsKt.reverse((List)fileList);
                break;
            }
            case 6: {
                Collections.sort((List)fileList, new SortByExtension());
                break;
            }
            case 7: {
                Collections.sort((List)fileList, new SortByExtension());
                CollectionsKt.reverse((List)fileList);
            }
        }
        Collection $this$toTypedArray$iv = fileList;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new File[0]);
    }

    public static /* synthetic */ File[] listFiles$default(FileUtils fileUtils, String string, Pattern pattern, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            pattern = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return fileUtils.listFiles(string, pattern, n);
    }

    @Nullable
    public final File[] listFiles(@NotNull String startDirPath, @Nullable String[] allowExtensions) {
        Intrinsics.checkNotNullParameter((Object)startDirPath, (String)"startDirPath");
        File file = new File(startDirPath);
        return file.listFiles((arg_0, arg_1) -> FileUtils.listFiles$lambda$6(allowExtensions, arg_0, arg_1));
    }

    @Nullable
    public final File[] listFiles(@NotNull String startDirPath, @Nullable String allowExtension) {
        File[] fileArray;
        Intrinsics.checkNotNullParameter((Object)startDirPath, (String)"startDirPath");
        if (allowExtension == null) {
            fileArray = this.listFiles(startDirPath, (String)null);
        } else {
            String[] stringArray = new String[]{allowExtension};
            fileArray = this.listFiles(startDirPath, stringArray);
        }
        return fileArray;
    }

    public final boolean exist(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = new File(path);
        return file.exists();
    }

    @JvmOverloads
    public final boolean delete(@NotNull File file, boolean deleteRootDir) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        boolean result = false;
        if (file.isFile()) {
            result = this.deleteResolveEBUSY(file);
        } else {
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return false;
            }
            File[] files = fileArray;
            if (files.length == 0) {
                result = deleteRootDir && this.deleteResolveEBUSY(file);
            } else {
                for (File f : files) {
                    Intrinsics.checkNotNull((Object)f);
                    this.delete(f, deleteRootDir);
                    result = this.deleteResolveEBUSY(f);
                }
            }
            if (deleteRootDir) {
                result = this.deleteResolveEBUSY(file);
            }
        }
        return result;
    }

    public static /* synthetic */ boolean delete$default(FileUtils fileUtils, File file, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return fileUtils.delete(file, bl);
    }

    private final boolean deleteResolveEBUSY(File file) {
        File to = new File(file.getAbsolutePath() + System.currentTimeMillis());
        file.renameTo(to);
        return to.delete();
    }

    @JvmOverloads
    public final boolean delete(@NotNull String path, boolean deleteRootDir) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = new File(path);
        return file.exists() ? this.delete(file, deleteRootDir) : false;
    }

    public static /* synthetic */ boolean delete$default(FileUtils fileUtils, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return fileUtils.delete(string, bl);
    }

    public final boolean copy(@NotNull String src, @NotNull String tar) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)tar, (String)"tar");
        File srcFile = new File(src);
        return srcFile.exists() && this.copy(srcFile, new File(tar));
    }

    public final boolean copy(@NotNull File src, @NotNull File tar) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)tar, (String)"tar");
        try {
            if (src.isFile()) {
                int len;
                FileInputStream is = new FileInputStream(src);
                FileOutputStream op = new FileOutputStream(tar);
                BufferedInputStream bis = new BufferedInputStream(is);
                BufferedOutputStream bos = new BufferedOutputStream(op);
                byte[] bt = new byte[8192];
                while ((len = bis.read(bt)) != -1) {
                    bos.write(bt, 0, len);
                }
                bis.close();
                bos.close();
            } else if (src.isDirectory()) {
                tar.mkdirs();
                File[] fileArray = src.listFiles();
                if (fileArray != null) {
                    File[] $this$forEach$iv = fileArray;
                    boolean $i$f$forEach = false;
                    int n = $this$forEach$iv.length;
                    for (int i = 0; i < n; ++i) {
                        File element$iv;
                        File file = element$iv = $this$forEach$iv[i];
                        boolean bl = false;
                        File file2 = file.getAbsoluteFile();
                        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getAbsoluteFile(...)");
                        INSTANCE.copy(file2, new File(tar.getAbsoluteFile(), file.getName()));
                    }
                }
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public final boolean move(@NotNull String src, @NotNull String tar) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)tar, (String)"tar");
        return this.move(new File(src), new File(tar));
    }

    public final boolean move(@NotNull File src, @NotNull File tar) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)tar, (String)"tar");
        return this.rename(src, tar);
    }

    public final boolean rename(@NotNull String oldPath, @NotNull String newPath) {
        Intrinsics.checkNotNullParameter((Object)oldPath, (String)"oldPath");
        Intrinsics.checkNotNullParameter((Object)newPath, (String)"newPath");
        return this.rename(new File(oldPath), new File(newPath));
    }

    public final boolean rename(@NotNull File src, @NotNull File tar) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)tar, (String)"tar");
        return src.renameTo(tar);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final String readText(@NotNull String filepath, @NotNull String charset) {
        Intrinsics.checkNotNullParameter((Object)filepath, (String)"filepath");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        try {
            byte[] data = this.readBytes(filepath);
            if (data != null) {
                void $this$trim$iv;
                Charset charset2 = Charset.forName(charset);
                Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"forName(...)");
                Object object = charset2;
                object = new String(data, (Charset)object);
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                return ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return "";
    }

    public static /* synthetic */ String readText$default(FileUtils fileUtils, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "utf-8";
        }
        return fileUtils.readText(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final byte[] readBytes(@NotNull String filepath) {
        Intrinsics.checkNotNullParameter((Object)filepath, (String)"filepath");
        FileInputStream fis = null;
        try {
            int len;
            fis = new FileInputStream(filepath);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = fis.read(buffer, 0, buffer.length)) != -1) {
                baos.write(buffer, 0, len);
            }
            byte[] data = baos.toByteArray();
            baos.close();
            byte[] byArray = data;
            return byArray;
        }
        catch (IOException e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.closeSilently(fis);
        }
    }

    @JvmOverloads
    public final boolean writeText(@NotNull String filepath, @NotNull String content, @NotNull String charset) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)filepath, (String)"filepath");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        try {
            Charset charset2 = Charset.forName(charset);
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"forName(...)");
            byte[] byArray = content.getBytes(charset2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            bl = this.writeBytes(filepath, byArray);
        }
        catch (UnsupportedEncodingException e) {
            bl = false;
        }
        return bl;
    }

    public static /* synthetic */ boolean writeText$default(FileUtils fileUtils, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = "utf-8";
        }
        return fileUtils.writeText(string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean writeBytes(@NotNull String filepath, @NotNull byte[] data) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)filepath, (String)"filepath");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        File file = new File(filepath);
        FileOutputStream fos = null;
        try {
            if (!file.exists()) {
                File file2 = file.getParentFile();
                if (file2 != null) {
                    file2.mkdirs();
                }
                file.createNewFile();
            }
            fos = new FileOutputStream(filepath);
            fos.write(data);
            bl = true;
        }
        catch (IOException e) {
            bl = false;
        }
        finally {
            this.closeSilently(fos);
        }
        return bl;
    }

    public final boolean writeInputStream(@NotNull String filepath, @NotNull InputStream data) {
        Intrinsics.checkNotNullParameter((Object)filepath, (String)"filepath");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        File file = new File(filepath);
        return this.writeInputStream(file, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean writeInputStream(@NotNull File file, @NotNull InputStream data) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        FileOutputStream fos = null;
        try {
            int len;
            if (!file.exists()) {
                File file2 = file.getParentFile();
                if (file2 != null) {
                    file2.mkdirs();
                }
                file.createNewFile();
            }
            byte[] buffer = new byte[4096];
            fos = new FileOutputStream(file);
            while ((len = data.read(buffer, 0, buffer.length)) != -1) {
                fos.write(buffer, 0, len);
            }
            data.close();
            fos.flush();
            bl = true;
        }
        catch (IOException e) {
            bl = false;
        }
        finally {
            this.closeSilently(fos);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean appendText(@NotNull String path, @NotNull String content) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        File file = new File(path);
        FileWriter writer = null;
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            writer = new FileWriter(file, true);
            writer.write(content);
            bl = true;
        }
        catch (IOException e) {
            bl = false;
        }
        finally {
            this.closeSilently(writer);
        }
        return bl;
    }

    public final long getLength(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = new File(path);
        return !file.isFile() || !file.exists() ? 0L : file.length();
    }

    @NotNull
    public final String getName(@Nullable String pathOrUrl) {
        Object object;
        if (pathOrUrl == null) {
            return "";
        }
        int pos = StringsKt.lastIndexOf$default((CharSequence)pathOrUrl, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (0 <= pos) {
            String string = pathOrUrl.substring(pos + 1);
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        } else {
            object = System.currentTimeMillis() + "." + this.getExtension(pathOrUrl);
        }
        return object;
    }

    @NotNull
    public final String getNameExcludeExtension(@NotNull String path) {
        String string;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            String fileName;
            String string2 = fileName = new File(path).getName();
            Intrinsics.checkNotNull((Object)string2);
            int lastIndexOf = StringsKt.lastIndexOf$default((CharSequence)string2, (String)".", (int)0, (boolean)false, (int)6, null);
            if (lastIndexOf != -1) {
                string2 = fileName;
                Intrinsics.checkNotNull((Object)string2);
                int n = 0;
                String string3 = string2.substring(n, lastIndexOf);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                fileName = string3;
            }
            string = fileName;
            Intrinsics.checkNotNull((Object)string);
        }
        catch (Exception e) {
            string = "";
        }
        return string;
    }

    @NotNull
    public final String getSize(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        long fileSize = this.getLength(path);
        return this.toFileSizeString(fileSize);
    }

    @NotNull
    public final String toFileSizeString(long fileSize) {
        DecimalFormat df = new DecimalFormat("0.00");
        String fileSizeString = null;
        fileSizeString = fileSize < 1024L ? fileSize + "B" : (fileSize < 0x100000L ? df.format((double)fileSize / (double)1024L) + "K" : (fileSize < 0x40000000L ? df.format((double)fileSize / (double)0x100000L) + "M" : df.format((double)fileSize / (double)0x40000000L) + "G"));
        return fileSizeString;
    }

    @NotNull
    public final String getExtension(@NotNull String pathOrUrl) {
        String string;
        Intrinsics.checkNotNullParameter((Object)pathOrUrl, (String)"pathOrUrl");
        int dotPos = StringsKt.lastIndexOf$default((CharSequence)pathOrUrl, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (0 <= dotPos) {
            String string2 = pathOrUrl.substring(dotPos + 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = "ext";
        }
        return string;
    }

    @NotNull
    public final String getMimeType(@NotNull String pathOrUrl) {
        Intrinsics.checkNotNullParameter((Object)pathOrUrl, (String)"pathOrUrl");
        throw new Exception("Not implemented");
    }

    @JvmOverloads
    @NotNull
    public final String getDateTime(@NotNull String path, @NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        File file = new File(path);
        return this.getDateTime(file, format);
    }

    public static /* synthetic */ String getDateTime$default(FileUtils fileUtils, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "yyyy\u5e74MM\u6708dd\u65e5HH:mm";
        }
        return fileUtils.getDateTime(string, string2);
    }

    @NotNull
    public final String getDateTime(@NotNull File file, @NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(file.lastModified());
        String string = new SimpleDateFormat(format, Locale.PRC).format(cal.getTime());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    public final int compareLastModified(@NotNull String path1, @NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path1, (String)"path1");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path2");
        long stamp1 = new File(path1).lastModified();
        long stamp2 = new File(path2).lastModified();
        return stamp1 > stamp2 ? 1 : (stamp1 < stamp2 ? -1 : 0);
    }

    public final boolean makeDirs(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.makeDirs(new File(path));
    }

    public final boolean makeDirs(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file.mkdirs();
    }

    @JvmOverloads
    @NotNull
    public final File[] listDirs(@NotNull String startDirPath, @Nullable String[] excludeDirs) {
        Intrinsics.checkNotNullParameter((Object)startDirPath, (String)"startDirPath");
        return FileUtils.listDirs$default(this, startDirPath, excludeDirs, 0, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final File[] listDirs(@NotNull String startDirPath) {
        Intrinsics.checkNotNullParameter((Object)startDirPath, (String)"startDirPath");
        return FileUtils.listDirs$default(this, startDirPath, null, 0, 6, null);
    }

    @JvmOverloads
    @Nullable
    public final File[] listDirsAndFiles(@NotNull String startDirPath) {
        Intrinsics.checkNotNullParameter((Object)startDirPath, (String)"startDirPath");
        return FileUtils.listDirsAndFiles$default(this, startDirPath, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final File[] listFiles(@NotNull String startDirPath, @Nullable Pattern filterPattern) {
        Intrinsics.checkNotNullParameter((Object)startDirPath, (String)"startDirPath");
        return FileUtils.listFiles$default(this, startDirPath, filterPattern, 0, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final File[] listFiles(@NotNull String startDirPath) {
        Intrinsics.checkNotNullParameter((Object)startDirPath, (String)"startDirPath");
        return FileUtils.listFiles$default(this, startDirPath, null, 0, 6, null);
    }

    @JvmOverloads
    public final boolean delete(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return FileUtils.delete$default(this, file, false, 2, null);
    }

    @JvmOverloads
    public final boolean delete(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return FileUtils.delete$default(this, path, false, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final String readText(@NotNull String filepath) {
        Intrinsics.checkNotNullParameter((Object)filepath, (String)"filepath");
        return FileUtils.readText$default(this, filepath, null, 2, null);
    }

    @JvmOverloads
    public final boolean writeText(@NotNull String filepath, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)filepath, (String)"filepath");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return FileUtils.writeText$default(this, filepath, content, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final String getDateTime(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return FileUtils.getDateTime$default(this, path, null, 2, null);
    }

    private static final boolean listDirs$lambda$4(File f) {
        if (f == null) {
            return false;
        }
        return f.isDirectory();
    }

    private static final boolean listFiles$lambda$5(Pattern $filterPattern, File file) {
        if (file == null) {
            return false;
        }
        if (file.isDirectory()) {
            return false;
        }
        Object object = $filterPattern;
        return object != null && (object = ((Pattern)object).matcher(file.getName())) != null ? ((Matcher)object).find() : true;
    }

    private static final boolean listFiles$lambda$6(String[] $allowExtensions, File file, String name) {
        Object[] objectArray;
        Intrinsics.checkNotNull((Object)name);
        String extension = INSTANCE.getExtension(name);
        Object object = $allowExtensions;
        return ($allowExtensions != null && (object = ArraysKt.contentDeepToString((Object[])(objectArray = object))) != null ? StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)extension, (boolean)false, (int)2, null) : false) || $allowExtensions == null;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00022\b\u0010\b\u001a\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\t"}, d2={"Lbook/util/FileUtils$SortByExtension;", "Ljava/util/Comparator;", "Ljava/io/File;", "<init>", "()V", "compare", "", "f1", "f2", "book"})
    public static final class SortByExtension
    implements Comparator<File> {
        @Override
        public int compare(@Nullable File f1, @Nullable File f2) {
            int n;
            if (f1 == null || f2 == null) {
                n = f1 == null ? -1 : 1;
            } else if (f1.isDirectory() && f2.isFile()) {
                n = -1;
            } else if (f1.isFile() && f2.isDirectory()) {
                n = 1;
            } else {
                String string = f1.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String string2 = f2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                n = StringsKt.compareTo((String)string, (String)string2, (boolean)true);
            }
            return n;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\t\b\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0007J\u001c\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lbook/util/FileUtils$SortByName;", "Ljava/util/Comparator;", "Ljava/io/File;", "caseSensitive", "", "<init>", "(Z)V", "()V", "compare", "", "f1", "f2", "book"})
    public static final class SortByName
    implements Comparator<File> {
        private boolean caseSensitive;

        public SortByName(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }

        public SortByName() {
            this.caseSensitive = false;
        }

        @Override
        public int compare(@Nullable File f1, @Nullable File f2) {
            int n;
            if (f1 == null || f2 == null) {
                return f1 == null ? -1 : 1;
            }
            if (f1.isDirectory() && f2.isFile()) {
                n = -1;
            } else if (f1.isFile() && f2.isDirectory()) {
                n = 1;
            } else {
                String s1 = f1.getName();
                String s2 = f2.getName();
                if (this.caseSensitive) {
                    Intrinsics.checkNotNull((Object)s1);
                    Intrinsics.checkNotNull((Object)s2);
                    n = StringsKt.compareTo((String)s1, (String)s2, (boolean)false);
                } else {
                    Intrinsics.checkNotNull((Object)s1);
                    Intrinsics.checkNotNull((Object)s2);
                    n = StringsKt.compareTo((String)s1, (String)s2, (boolean)true);
                }
            }
            return n;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00022\b\u0010\b\u001a\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\t"}, d2={"Lbook/util/FileUtils$SortBySize;", "Ljava/util/Comparator;", "Ljava/io/File;", "<init>", "()V", "compare", "", "f1", "f2", "book"})
    public static final class SortBySize
    implements Comparator<File> {
        @Override
        public int compare(@Nullable File f1, @Nullable File f2) {
            return f1 == null || f2 == null ? (f1 == null ? -1 : 1) : (f1.isDirectory() && f2.isFile() ? -1 : (f1.isFile() && f2.isDirectory() ? 1 : (f1.length() < f2.length() ? -1 : 1)));
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00022\b\u0010\b\u001a\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\t"}, d2={"Lbook/util/FileUtils$SortByTime;", "Ljava/util/Comparator;", "Ljava/io/File;", "<init>", "()V", "compare", "", "f1", "f2", "book"})
    public static final class SortByTime
    implements Comparator<File> {
        @Override
        public int compare(@Nullable File f1, @Nullable File f2) {
            return f1 == null || f2 == null ? (f1 == null ? -1 : 1) : (f1.isDirectory() && f2.isFile() ? -1 : (f1.isFile() && f2.isDirectory() ? 1 : (f1.lastModified() > f2.lastModified() ? -1 : 1)));
        }
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lbook/util/FileUtils$SortType;", "", "book"})
    public static @interface SortType {
    }
}

