/*
 * Decompiled with CFR 0.152.
 */
package book.util;

import book.util.StringKt;
import cn.hutool.core.lang.Validator;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.Response;
import okhttp3.internal.publicsuffix.PublicSuffixDatabase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u0005J\u0018\u0010\u0014\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0016\u001a\u00020\u0005J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u0005J\u000e\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005J\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u0010\u0010\u001d\u001a\u00020\u000f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0005J\u0010\u0010#\u001a\u00020\u000f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0005J\u0010\u0010$\u001a\u00020\u000f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0005R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\u001f\u001a\n !*\u0004\u0018\u00010 0 X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\"\u00a8\u0006%"}, d2={"Lbook/util/NetworkUtils;", "", "<init>", "()V", "getUrl", "", "response", "Lretrofit2/Response;", "notNeedEncoding", "Ljava/util/BitSet;", "getNotNeedEncoding", "()Ljava/util/BitSet;", "notNeedEncoding$delegate", "Lkotlin/Lazy;", "hasUrlEncoded", "", "str", "isDigit16Char", "c", "", "getAbsoluteURL", "baseURL", "relativePath", "Ljava/net/URL;", "getBaseUrl", "url", "getSubDomain", "getLocalIPAddress", "Ljava/net/InetAddress;", "isIPv4Address", "input", "IPV4_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "isIPv6Address", "isIPAddress", "book"})
@SourceDebugExtension(value={"SMAP\nNetworkUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkUtils.kt\nbook/util/NetworkUtils\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,197:1\n1104#2,3:198\n*S KotlinDebug\n*F\n+ 1 NetworkUtils.kt\nbook/util/NetworkUtils\n*L\n177#1:198,3\n*E\n"})
public final class NetworkUtils {
    @NotNull
    public static final NetworkUtils INSTANCE = new NetworkUtils();
    @NotNull
    private static final Lazy notNeedEncoding$delegate = LazyKt.lazy(NetworkUtils::notNeedEncoding_delegate$lambda$0);
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$");

    private NetworkUtils() {
    }

    @NotNull
    public final String getUrl(@NotNull retrofit2.Response<?> response) {
        Intrinsics.checkNotNullParameter(response, (String)"response");
        Response networkResponse = response.raw().networkResponse();
        Object object = networkResponse;
        if (object == null || (object = object.request()) == null || (object = object.url()) == null || (object = object.toString()) == null) {
            object = response.raw().request().url().toString();
        }
        return object;
    }

    private final BitSet getNotNeedEncoding() {
        Lazy lazy = notNeedEncoding$delegate;
        return (BitSet)lazy.getValue();
    }

    public final boolean hasUrlEncoded(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        boolean needEncode = false;
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (this.getNotNeedEncoding().get(c)) {
                ++i;
                continue;
            }
            if (c == '%' && i + 2 < str.length()) {
                char c1 = str.charAt(++i);
                char c2 = str.charAt(++i);
                if (this.isDigit16Char(c1) && this.isDigit16Char(c2)) {
                    ++i;
                    continue;
                }
            }
            needEncode = true;
            break;
        }
        return !needEncode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isDigit16Char(char c) {
        boolean bl;
        boolean bl2;
        if ('0' <= c) {
            if (c < ':') {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        if ('A' <= c) {
            if (c < 'G') {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if ('a' > c) return false;
        if (c >= 'g') return false;
        return true;
    }

    @NotNull
    public final String getAbsoluteURL(@Nullable String baseURL, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        CharSequence charSequence = baseURL;
        if (charSequence == null || charSequence.length() == 0) {
            return ((Object)StringsKt.trim((CharSequence)relativePath)).toString();
        }
        URL absoluteUrl = null;
        try {
            absoluteUrl = new URL(StringsKt.substringBefore$default((String)baseURL, (String)",", null, (int)2, null));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getAbsoluteURL(absoluteUrl, relativePath);
    }

    @NotNull
    public final String getAbsoluteURL(@Nullable URL baseURL, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        String relativePathTrim = ((Object)StringsKt.trim((CharSequence)relativePath)).toString();
        if (baseURL == null) {
            return relativePathTrim;
        }
        if (StringKt.isAbsUrl(relativePathTrim)) {
            return relativePathTrim;
        }
        if (StringKt.isDataUrl(relativePathTrim)) {
            return relativePathTrim;
        }
        if (StringsKt.startsWith$default((String)relativePathTrim, (String)"javascript", (boolean)false, (int)2, null)) {
            return "";
        }
        String relativeUrl = relativePath;
        try {
            URL parseUrl = new URL(baseURL, relativePath);
            relativeUrl = parseUrl.toString();
            return relativeUrl;
        }
        catch (Exception e) {
            e.printStackTrace();
            return relativeUrl;
        }
    }

    @Nullable
    public final String getBaseUrl(@Nullable String url) {
        if (url == null) {
            return null;
        }
        if (StringsKt.startsWith((String)url, (String)"http://", (boolean)true) || StringsKt.startsWith((String)url, (String)"https://", (boolean)true)) {
            String string;
            int index = StringsKt.indexOf$default((CharSequence)url, (String)"/", (int)9, (boolean)false, (int)4, null);
            if (index == -1) {
                string = url;
            } else {
                String string2 = url.substring(0, index);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            }
            return string;
        }
        return null;
    }

    @NotNull
    public final String getSubDomain(@NotNull String url) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String string = this.getBaseUrl(url);
        if (string == null) {
            return url;
        }
        String baseUrl = string;
        try {
            boolean bl = false;
            URL mURL = new URL(baseUrl);
            String string2 = mURL.getHost();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getHost(...)");
            String host = string2;
            if (INSTANCE.isIPAddress(host)) {
                return host;
            }
            String string3 = PublicSuffixDatabase.Companion.get().getEffectiveTldPlusOne(host);
            if (string3 == null) {
                string3 = host;
            }
            object = Result.constructor-impl((Object)string3);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (String)(Result.isFailure-impl((Object)object) ? baseUrl : object);
    }

    @Nullable
    public final InetAddress getLocalIPAddress() {
        Enumeration<NetworkInterface> enumeration = null;
        try {
            enumeration = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                NetworkInterface nif = enumeration.nextElement();
                Enumeration<InetAddress> addresses = nif.getInetAddresses();
                if (addresses == null) continue;
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (address.isLoopbackAddress() || !this.isIPv4Address(address.getHostAddress())) continue;
                    return address;
                }
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isIPv4Address(@Nullable String input) {
        if (input == null) return false;
        if (((CharSequence)input).length() <= 0) return false;
        boolean bl = true;
        if (!bl) return false;
        char c = input.charAt(0);
        if ('1' > c) return false;
        if (c >= ':') return false;
        boolean bl2 = true;
        if (!bl2) return false;
        CharSequence $this$count$iv = input;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int i = 0; i < $this$count$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(i);
            boolean bl3 = false;
            if (!(it == '.')) continue;
            ++count$iv;
        }
        if (count$iv != 3) return false;
        if (!Validator.isIpv4((CharSequence)input)) return false;
        return true;
    }

    public final boolean isIPv6Address(@Nullable String input) {
        return input != null && StringsKt.contains$default((CharSequence)input, (CharSequence)":", (boolean)false, (int)2, null) && Validator.isIpv6((CharSequence)input);
    }

    public final boolean isIPAddress(@Nullable String input) {
        String string = input;
        if (string == null) {
            string = "";
        }
        return this.isIPv4Address(string) || this.isIPv6Address(input);
    }

    private static final BitSet notNeedEncoding_delegate$lambda$0() {
        int i;
        BitSet bitSet = new BitSet(256);
        for (i = 97; i < 123; ++i) {
            bitSet.set(i);
        }
        for (i = 65; i < 91; ++i) {
            bitSet.set(i);
        }
        for (i = 48; i < 58; ++i) {
            bitSet.set(i);
        }
        int n = "+-_.$:()!*@&#,[]".length();
        for (int j = 0; j < n; ++j) {
            char c = "+-_.$:()!*@&#,[]".charAt(j);
            bitSet.set(c);
        }
        return bitSet;
    }
}

