/*
 * Decompiled with CFR 0.152.
 */
package book.util;

import book.util.AppPattern;
import book.webBook.analyzeRule.AnalyzeUrl;
import book.webBook.analyzeRule.CustomUrl;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\fJ(\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u00062\u0016\b\u0002\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u000fJ*\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0016\b\u0002\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u000fH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u0012H\u0002J\u001a\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00062\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0006R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lbook/util/UrlUtil;", "", "<init>", "()V", "unExpectFileSuffixs", "", "", "[Ljava/lang/String;", "replaceReservedChar", "text", "getFileName", "analyzeUrl", "Lbook/webBook/analyzeRule/AnalyzeUrl;", "fileUrl", "headerMap", "", "getFileNameFromResponseHeader", "url", "Ljava/net/URL;", "getFileNameFromPath", "fileSuffixRegex", "Lkotlin/text/Regex;", "getSuffix", "str", "default", "book"})
@SourceDebugExtension(value={"SMAP\nUrlUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlUtil.kt\nbook/util/UrlUtil\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,150:1\n216#2,2:151\n774#3:153\n865#3,2:154\n1863#3,2:156\n*S KotlinDebug\n*F\n+ 1 UrlUtil.kt\nbook/util/UrlUtil\n*L\n71#1:151,2\n89#1:153\n89#1:154,2\n91#1:156,2\n*E\n"})
public final class UrlUtil {
    @NotNull
    public static final UrlUtil INSTANCE = new UrlUtil();
    @NotNull
    private static final String[] unExpectFileSuffixs;
    @NotNull
    private static final Regex fileSuffixRegex;

    private UrlUtil() {
    }

    @NotNull
    public final String replaceReservedChar(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)text, (String)"%", (String)"%25", (boolean)false, (int)4, null), (String)" ", (String)"%20", (boolean)false, (int)4, null), (String)"\"", (String)"%22", (boolean)false, (int)4, null), (String)"#", (String)"%23", (boolean)false, (int)4, null), (String)"&", (String)"%26", (boolean)false, (int)4, null), (String)"(", (String)"%28", (boolean)false, (int)4, null), (String)")", (String)"%29", (boolean)false, (int)4, null), (String)"+", (String)"%2B", (boolean)false, (int)4, null), (String)",", (String)"%2C", (boolean)false, (int)4, null), (String)"/", (String)"%2F", (boolean)false, (int)4, null), (String)":", (String)"%3A", (boolean)false, (int)4, null), (String)";", (String)"%3B", (boolean)false, (int)4, null), (String)"<", (String)"%3C", (boolean)false, (int)4, null), (String)"=", (String)"%3D", (boolean)false, (int)4, null), (String)">", (String)"%3E", (boolean)false, (int)4, null), (String)"?", (String)"%3F", (boolean)false, (int)4, null), (String)"@", (String)"%40", (boolean)false, (int)4, null), (String)"\\", (String)"%5C", (boolean)false, (int)4, null), (String)"|", (String)"%7C", (boolean)false, (int)4, null);
    }

    @Nullable
    public final String getFileName(@NotNull AnalyzeUrl analyzeUrl) {
        Intrinsics.checkNotNullParameter((Object)analyzeUrl, (String)"analyzeUrl");
        return this.getFileName(analyzeUrl.getUrl(), (Map<String, String>)analyzeUrl.getHeaderMap());
    }

    @Nullable
    public final String getFileName(@NotNull String fileUrl, @Nullable Map<String, String> headerMap) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        try {
            boolean bl = false;
            URL url = new URL(fileUrl);
            String fileName = INSTANCE.getFileNameFromPath(url);
            if (fileName == null) {
                fileName = INSTANCE.getFileNameFromResponseHeader(url, headerMap);
            }
            object = Result.constructor-impl((Object)fileName);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (String)(Result.isFailure-impl((Object)object) ? null : object);
    }

    public static /* synthetic */ String getFileName$default(UrlUtil urlUtil, String string, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            map = null;
        }
        return urlUtil.getFileName(string, map);
    }

    /*
     * WARNING - void declaration
     */
    private final String getFileNameFromResponseHeader(URL url, Map<String, String> headerMap) {
        String string;
        int $i$a$-forEach-UrlUtil$getFileNameFromResponseHeader$332;
        Regex regex;
        URLConnection uRLConnection = url.openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection conn = (HttpURLConnection)uRLConnection;
        conn.setRequestMethod("HEAD");
        Map<String, String> map = headerMap;
        if (map != null) {
            Map<String, String> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Regex regex2;
                regex = regex2 = iterator.next();
                $i$a$-forEach-UrlUtil$getFileNameFromResponseHeader$332 = 0;
                String key = regex.getKey();
                String value = (String)regex.getValue();
                conn.setRequestProperty(key, value);
            }
        }
        conn.setInstanceFollowRedirects(false);
        conn.connect();
        String raw = conn.getHeaderField("Content-Disposition");
        String redirectUrl = conn.getHeaderField("Location");
        if (raw != null) {
            CharSequence it;
            void $this$filterTo$iv$iv;
            CharSequence charSequence = raw;
            regex = AppPattern.INSTANCE.getSemicolonRegex();
            $i$a$-forEach-UrlUtil$getFileNameFromResponseHeader$332 = 0;
            Iterable iterable = regex.split(charSequence, $i$a$-forEach-UrlUtil$getFileNameFromResponseHeader$332);
            boolean $i$f$filter = false;
            Iterable $i$a$-forEach-UrlUtil$getFileNameFromResponseHeader$332 = iterable;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                if (!StringsKt.contains$default((CharSequence)it, (CharSequence)"filename", (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List fileNames = (List)destination$iv$iv;
            HashSet<String> hashSet = new HashSet<String>();
            Iterable $this$forEach$iv = fileNames;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                boolean bl;
                String it2 = (String)element$iv2;
                boolean bl2 = false;
                it = ((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)it2, (String)"=", null, (int)2, null))).toString();
                String[] stringArray = new Regex("^\"");
                String string2 = "";
                it = stringArray.replace(it, string2);
                stringArray = new Regex("\"$");
                string2 = "";
                String fileName = stringArray.replace(it, string2);
                if (StringsKt.contains$default((CharSequence)it2, (CharSequence)"filename*", (boolean)false, (int)2, null)) {
                    stringArray = new String[]{"''"};
                    List data = StringsKt.split$default((CharSequence)fileName, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    bl = hashSet.add(URLDecoder.decode((String)data.get(1), (String)data.get(0)));
                    continue;
                }
                bl = hashSet.add(fileName);
            }
            string = (String)CollectionsKt.firstOrNull((Iterable)hashSet);
        } else if (redirectUrl != null) {
            URL newUrl = new URL(URLDecoder.decode(redirectUrl, "UTF-8"));
            string = this.getFileNameFromPath(newUrl);
        } else {
            string = null;
        }
        return string;
    }

    static /* synthetic */ String getFileNameFromResponseHeader$default(UrlUtil urlUtil, URL uRL, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            map = null;
        }
        return urlUtil.getFileNameFromResponseHeader(uRL, map);
    }

    private final String getFileNameFromPath(URL fileUrl) {
        String string = fileUrl.getPath();
        if (string == null) {
            return null;
        }
        String path = string;
        String suffix = this.getSuffix(path, "");
        return !Intrinsics.areEqual((Object)suffix, (Object)"") && !ArraysKt.contains((Object[])unExpectFileSuffixs, (Object)suffix) ? StringsKt.substringAfterLast$default((String)path, (String)"/", null, (int)2, null) : null;
    }

    @NotNull
    public final String getSuffix(@NotNull String str, @Nullable String string) {
        String string2;
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        String suffix = StringsKt.substringAfterLast((String)StringsKt.substringBefore$default((String)StringsKt.substringBefore$default((String)StringsKt.substringAfterLast$default((String)new CustomUrl(str).getUrl(), (String)"/", null, (int)2, null), (String)"?", null, (int)2, null), (String)"#", null, (int)2, null), (String)".", (String)"");
        if (suffix.length() > 5 || !fileSuffixRegex.matches(charSequence = (CharSequence)suffix)) {
            string2 = string;
            if (string2 == null) {
                string2 = "ext";
            }
        } else {
            string2 = suffix;
        }
        return string2;
    }

    public static /* synthetic */ String getSuffix$default(UrlUtil urlUtil, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return urlUtil.getSuffix(string, string2);
    }

    static {
        String[] stringArray = new String[]{"php", "html"};
        unExpectFileSuffixs = stringArray;
        fileSuffixRegex = new Regex("^[a-z\\d]+$", RegexOption.IGNORE_CASE);
    }
}

