/*
 * Decompiled with CFR 0.152.
 */
package book.util;

import book.util.ZipUtilsKt;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\bH\u0086@\u00a2\u0006\u0002\u0010\nJ2\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\f\u001a\u0004\u0018\u00010\bH\u0086@\u00a2\u0006\u0002\u0010\rJ.\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\bH\u0007J\u0016\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u001e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bJ(\u0010\u000f\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\bH\u0007J*\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\f\u001a\u0004\u0018\u00010\bH\u0002J\u001e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00162\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bJ\u001e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00162\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000eJ(\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00162\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\bJ,\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00162\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001a\u001a\u0004\u0018\u00010\bJ6\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u000e2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\bH\u0002J\u0016\u0010#\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00162\u0006\u0010\t\u001a\u00020\bJ\u0018\u0010#\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00162\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eJ\u0016\u0010$\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00162\u0006\u0010\t\u001a\u00020\bJ\u0018\u0010$\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00162\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eJ\u0012\u0010%\u001a\u00020\u00052\b\u0010&\u001a\u0004\u0018\u00010\u000eH\u0002J\u0012\u0010'\u001a\u00020\u00052\b\u0010&\u001a\u0004\u0018\u00010\u000eH\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010\u000e2\u0006\u0010)\u001a\u00020\bH\u0002J\u0012\u0010*\u001a\u00020\u00052\b\u0010+\u001a\u0004\u0018\u00010\bH\u0002\u00a8\u0006,"}, d2={"Lbook/util/ZipUtils;", "", "<init>", "()V", "zipFiles", "", "srcFiles", "", "", "zipFilePath", "(Ljava/util/Collection;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "srcFilePaths", "comment", "(Ljava/util/Collection;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Ljava/io/File;", "zipFile", "srcFilePath", "srcFile", "rootPath", "zos", "Ljava/util/zip/ZipOutputStream;", "unzipFile", "", "destDirPath", "destDir", "unzipFileByKeyword", "keyword", "unzipChildFile", "files", "", "zip", "Ljava/util/zip/ZipFile;", "entry", "Ljava/util/zip/ZipEntry;", "name", "getFilesPath", "getComments", "createOrExistsDir", "file", "createOrExistsFile", "getFileByPath", "filePath", "isSpace", "s", "book"})
public final class ZipUtils {
    @NotNull
    public static final ZipUtils INSTANCE = new ZipUtils();

    private ZipUtils() {
    }

    @Nullable
    public final Object zipFiles(@NotNull Collection<String> srcFiles, @NotNull String zipFilePath, @NotNull Continuation<? super Boolean> $completion) {
        return this.zipFiles(srcFiles, zipFilePath, null, $completion);
    }

    @Nullable
    public final Object zipFiles(@Nullable Collection<String> srcFilePaths, @Nullable String zipFilePath, @Nullable String comment, @NotNull Continuation<? super Boolean> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(srcFilePaths, zipFilePath, comment, null){
            int label;
            final /* synthetic */ Collection<String> $srcFilePaths;
            final /* synthetic */ String $zipFilePath;
            final /* synthetic */ String $comment;
            {
                this.$srcFilePaths = $srcFilePaths;
                this.$zipFilePath = $zipFilePath;
                this.$comment = $comment;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        if (this.$srcFilePaths == null || this.$zipFilePath == null) {
                            return Boxing.boxBoolean((boolean)false);
                        }
                        Closeable closeable = new ZipOutputStream(new FileOutputStream(this.$zipFilePath));
                        Collection<String> collection = this.$srcFilePaths;
                        String string = this.$comment;
                        Throwable throwable = null;
                        try {
                            ZipOutputStream it = (ZipOutputStream)closeable;
                            boolean bl = false;
                            for (String srcFile : collection) {
                                File file = ZipUtils.access$getFileByPath(ZipUtils.INSTANCE, srcFile);
                                Intrinsics.checkNotNull((Object)file);
                                if (ZipUtils.access$zipFile(ZipUtils.INSTANCE, file, "", it, string)) continue;
                                Boolean bl2 = Boxing.boxBoolean((boolean)false);
                                return bl2;
                            }
                            Boolean bl3 = Boxing.boxBoolean((boolean)true);
                            return bl3;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public final boolean zipFiles(@Nullable Collection<? extends File> srcFiles, @Nullable File zipFile, @Nullable String comment) throws IOException {
        if (srcFiles == null || zipFile == null) {
            return false;
        }
        Closeable closeable = new ZipOutputStream(new FileOutputStream(zipFile));
        Throwable throwable = null;
        try {
            ZipOutputStream it = (ZipOutputStream)closeable;
            boolean bl = false;
            for (File file : srcFiles) {
                if (INSTANCE.zipFile(file, "", it, comment)) continue;
                boolean bl2 = false;
                return bl2;
            }
            boolean bl3 = true;
            return bl3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ boolean zipFiles$default(ZipUtils zipUtils, Collection collection, File file, String string, int n, Object object) throws IOException {
        if ((n & 4) != 0) {
            string = null;
        }
        return zipUtils.zipFiles(collection, file, string);
    }

    public final boolean zipFile(@NotNull String srcFilePath, @NotNull String zipFilePath) throws IOException {
        Intrinsics.checkNotNullParameter((Object)srcFilePath, (String)"srcFilePath");
        Intrinsics.checkNotNullParameter((Object)zipFilePath, (String)"zipFilePath");
        return this.zipFile(this.getFileByPath(srcFilePath), this.getFileByPath(zipFilePath), null);
    }

    public final boolean zipFile(@NotNull String srcFilePath, @NotNull String zipFilePath, @NotNull String comment) throws IOException {
        Intrinsics.checkNotNullParameter((Object)srcFilePath, (String)"srcFilePath");
        Intrinsics.checkNotNullParameter((Object)zipFilePath, (String)"zipFilePath");
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        return this.zipFile(this.getFileByPath(srcFilePath), this.getFileByPath(zipFilePath), comment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public final boolean zipFile(@Nullable File srcFile, @Nullable File zipFile, @Nullable String comment) throws IOException {
        if (srcFile == null || zipFile == null) {
            return false;
        }
        Closeable closeable = new ZipOutputStream(new FileOutputStream(zipFile));
        Throwable throwable = null;
        try {
            ZipOutputStream zos = (ZipOutputStream)closeable;
            boolean bl = false;
            boolean bl2 = INSTANCE.zipFile(srcFile, "", zos, comment);
            return bl2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ boolean zipFile$default(ZipUtils zipUtils, File file, File file2, String string, int n, Object object) throws IOException {
        if ((n & 4) != 0) {
            string = null;
        }
        return zipUtils.zipFile(file, file2, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zipFile(File srcFile, String rootPath, ZipOutputStream zos, String comment) throws IOException {
        Object rootPath1 = null;
        rootPath1 = rootPath;
        if (!srcFile.exists()) {
            return true;
        }
        rootPath1 = rootPath1 + (this.isSpace((String)rootPath1) ? "" : File.separator) + srcFile.getName();
        if (srcFile.isDirectory()) {
            Object[] fileList = srcFile.listFiles();
            if (fileList == null || fileList.length == 0) {
                ZipEntry entry = new ZipEntry(rootPath1 + "/");
                entry.setComment(comment);
                zos.putNextEntry(entry);
                zos.closeEntry();
            } else {
                Iterator iterator = ArrayIteratorKt.iterator((Object[])fileList);
                while (iterator.hasNext()) {
                    File file = (File)iterator.next();
                    Intrinsics.checkNotNull((Object)file);
                    if (this.zipFile(file, (String)rootPath1, zos, comment)) continue;
                    return false;
                }
            }
        } else {
            Closeable closeable = new BufferedInputStream(new FileInputStream(srcFile));
            Throwable throwable = null;
            try {
                BufferedInputStream is = (BufferedInputStream)closeable;
                boolean bl = false;
                ZipEntry entry = new ZipEntry((String)rootPath1);
                entry.setComment(comment);
                zos.putNextEntry(entry);
                zos.write(ByteStreamsKt.readBytes((InputStream)is));
                zos.closeEntry();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return true;
    }

    @Nullable
    public final List<File> unzipFile(@NotNull String zipFilePath, @NotNull String destDirPath) throws IOException {
        Intrinsics.checkNotNullParameter((Object)zipFilePath, (String)"zipFilePath");
        Intrinsics.checkNotNullParameter((Object)destDirPath, (String)"destDirPath");
        return this.unzipFileByKeyword(zipFilePath, destDirPath, null);
    }

    @Nullable
    public final List<File> unzipFile(@NotNull File zipFile, @NotNull File destDir) throws IOException {
        Intrinsics.checkNotNullParameter((Object)zipFile, (String)"zipFile");
        Intrinsics.checkNotNullParameter((Object)destDir, (String)"destDir");
        return this.unzipFileByKeyword(zipFile, destDir, null);
    }

    @Nullable
    public final List<File> unzipFileByKeyword(@NotNull String zipFilePath, @NotNull String destDirPath, @Nullable String keyword) throws IOException {
        Intrinsics.checkNotNullParameter((Object)zipFilePath, (String)"zipFilePath");
        Intrinsics.checkNotNullParameter((Object)destDirPath, (String)"destDirPath");
        return this.unzipFileByKeyword(this.getFileByPath(zipFilePath), this.getFileByPath(destDirPath), keyword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final List<File> unzipFileByKeyword(@Nullable File zipFile, @Nullable File destDir, @Nullable String keyword) throws IOException {
        if (zipFile == null || destDir == null) {
            return null;
        }
        ArrayList files = new ArrayList();
        ZipFile zip = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> entries = zip.entries();
        Closeable closeable = zip;
        Throwable throwable = null;
        try {
            ZipFile it = (ZipFile)closeable;
            boolean bl = false;
            if (INSTANCE.isSpace(keyword)) {
                while (entries.hasMoreElements()) {
                    ZipEntry entry;
                    Intrinsics.checkNotNull((Object)entries.nextElement(), (String)"null cannot be cast to non-null type java.util.zip.ZipEntry");
                    String entryName = entry.getName();
                    Intrinsics.checkNotNull((Object)entryName);
                    if (StringsKt.contains$default((CharSequence)entryName, (CharSequence)"../", (boolean)false, (int)2, null)) {
                        ZipUtilsKt.access$getLogger$p().error("ZipUtils entryName: " + entryName + " is dangerous!");
                        continue;
                    }
                    if (INSTANCE.unzipChildFile(destDir, files, zip, entry, entryName)) continue;
                    List list = files;
                    return list;
                }
            } else {
                while (entries.hasMoreElements()) {
                    ZipEntry entry;
                    Intrinsics.checkNotNull((Object)entries.nextElement(), (String)"null cannot be cast to non-null type java.util.zip.ZipEntry");
                    String entryName = entry.getName();
                    Intrinsics.checkNotNull((Object)entryName);
                    if (StringsKt.contains$default((CharSequence)entryName, (CharSequence)"../", (boolean)false, (int)2, null)) {
                        ZipUtilsKt.access$getLogger$p().error("ZipUtils entryName: " + entryName + " is dangerous!");
                        continue;
                    }
                    CharSequence charSequence = entryName;
                    String string = keyword;
                    Intrinsics.checkNotNull((Object)string);
                    if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string, (boolean)false, (int)2, null) || INSTANCE.unzipChildFile(destDir, files, zip, entry, entryName)) continue;
                    List list = files;
                    return list;
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean unzipChildFile(File destDir, List<File> files, ZipFile zip, ZipEntry entry, String name) throws IOException {
        File file = new File(destDir, name);
        files.add(file);
        if (entry.isDirectory()) {
            return this.createOrExistsDir(file);
        }
        if (!this.createOrExistsFile(file)) {
            return false;
        }
        Closeable closeable = new BufferedInputStream(zip.getInputStream(entry));
        Throwable throwable = null;
        try {
            BufferedInputStream in = (BufferedInputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new BufferedOutputStream(new FileOutputStream(file));
            Throwable throwable2 = null;
            try {
                BufferedOutputStream out = (BufferedOutputStream)closeable2;
                boolean bl2 = false;
                out.write(ByteStreamsKt.readBytes((InputStream)in));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return true;
    }

    @Nullable
    public final List<String> getFilesPath(@NotNull String zipFilePath) throws IOException {
        Intrinsics.checkNotNullParameter((Object)zipFilePath, (String)"zipFilePath");
        return this.getFilesPath(this.getFileByPath(zipFilePath));
    }

    @Nullable
    public final List<String> getFilesPath(@Nullable File zipFile) throws IOException {
        if (zipFile == null) {
            return null;
        }
        ArrayList<String> paths = new ArrayList<String>();
        ZipFile zip = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            boolean bl;
            ZipEntry zipEntry = entries.nextElement();
            Intrinsics.checkNotNull((Object)zipEntry, (String)"null cannot be cast to non-null type java.util.zip.ZipEntry");
            String entryName = zipEntry.getName();
            Intrinsics.checkNotNull((Object)entryName);
            if (StringsKt.contains$default((CharSequence)entryName, (CharSequence)"../", (boolean)false, (int)2, null)) {
                ZipUtilsKt.access$getLogger$p().error("ZipUtils entryName: " + entryName + " is dangerous!");
                bl = paths.add(entryName);
                continue;
            }
            bl = paths.add(entryName);
        }
        zip.close();
        return paths;
    }

    @Nullable
    public final List<String> getComments(@NotNull String zipFilePath) throws IOException {
        Intrinsics.checkNotNullParameter((Object)zipFilePath, (String)"zipFilePath");
        return this.getComments(this.getFileByPath(zipFilePath));
    }

    @Nullable
    public final List<String> getComments(@Nullable File zipFile) throws IOException {
        if (zipFile == null) {
            return null;
        }
        ArrayList<String> comments = new ArrayList<String>();
        ZipFile zip = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry;
            Intrinsics.checkNotNull((Object)entries.nextElement(), (String)"null cannot be cast to non-null type java.util.zip.ZipEntry");
            comments.add(entry.getComment());
        }
        zip.close();
        return comments;
    }

    private final boolean createOrExistsDir(File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }

    private final boolean createOrExistsFile(File file) {
        boolean bl;
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return file.isFile();
        }
        if (!this.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            bl = file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            bl = false;
        }
        return bl;
    }

    private final File getFileByPath(String filePath) {
        return this.isSpace(filePath) ? null : new File(filePath);
    }

    private final boolean isSpace(String s) {
        if (s == null) {
            return true;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @JvmOverloads
    public final boolean zipFiles(@Nullable Collection<? extends File> srcFiles, @Nullable File zipFile) throws IOException {
        return ZipUtils.zipFiles$default(this, srcFiles, zipFile, null, 4, null);
    }

    @JvmOverloads
    public final boolean zipFile(@Nullable File srcFile, @Nullable File zipFile) throws IOException {
        return ZipUtils.zipFile$default(this, srcFile, zipFile, null, 4, null);
    }

    public static final /* synthetic */ boolean access$zipFile(ZipUtils $this, File srcFile, String rootPath, ZipOutputStream zos, String comment) {
        return $this.zipFile(srcFile, rootPath, zos, comment);
    }

    public static final /* synthetic */ File access$getFileByPath(ZipUtils $this, String filePath) {
        return $this.getFileByPath(filePath);
    }
}

