/*
 * Decompiled with CFR 0.152.
 */
package book.util.crypto;

import book.util.EncoderUtils;
import cn.hutool.crypto.KeyUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0003J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0003J\u0019\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0002\u0010\u000eJ!\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u0007\u00a2\u0006\u0002\u0010\u0012J!\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u0007\u00a2\u0006\u0002\u0010\u0014J!\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u0007\u00a2\u0006\u0002\u0010\u0012J!\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u0007\u00a2\u0006\u0002\u0010\u0014J!\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u0007\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0018"}, d2={"Lbook/util/crypto/AsymmetricCrypto;", "Lcn/hutool/crypto/asymmetric/AsymmetricCrypto;", "algorithm", "", "<init>", "(Ljava/lang/String;)V", "setPrivateKey", "key", "", "setPublicKey", "getKeyType", "Lcn/hutool/crypto/asymmetric/KeyType;", "usePublicKey", "", "(Ljava/lang/Boolean;)Lcn/hutool/crypto/asymmetric/KeyType;", "decrypt", "data", "", "(Ljava/lang/Object;Ljava/lang/Boolean;)[B", "decryptStr", "(Ljava/lang/Object;Ljava/lang/Boolean;)Ljava/lang/String;", "encrypt", "encryptHex", "encryptBase64", "book"})
public final class AsymmetricCrypto
extends cn.hutool.crypto.asymmetric.AsymmetricCrypto {
    public AsymmetricCrypto(@NotNull String algorithm) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        super(algorithm);
    }

    @NotNull
    public final AsymmetricCrypto setPrivateKey(@NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.setPrivateKey(KeyUtil.generatePrivateKey((String)this.algorithm, (byte[])key));
        return this;
    }

    @NotNull
    public final AsymmetricCrypto setPrivateKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.setPrivateKey(StringsKt.encodeToByteArray((String)key));
    }

    @NotNull
    public final AsymmetricCrypto setPublicKey(@NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.setPublicKey(KeyUtil.generatePublicKey((String)this.algorithm, (byte[])key));
        return this;
    }

    @NotNull
    public final AsymmetricCrypto setPublicKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.setPublicKey(StringsKt.encodeToByteArray((String)key));
    }

    private final KeyType getKeyType(Boolean usePublicKey) {
        return Intrinsics.areEqual((Object)usePublicKey, (Object)true) ? KeyType.PublicKey : KeyType.PrivateKey;
    }

    static /* synthetic */ KeyType getKeyType$default(AsymmetricCrypto asymmetricCrypto, Boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return asymmetricCrypto.getKeyType(bl);
    }

    @JvmOverloads
    @NotNull
    public final byte[] decrypt(@NotNull Object data, @Nullable Boolean usePublicKey) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Object object = data;
        if (object instanceof byte[]) {
            byte[] byArray2 = this.decrypt((byte[])data, this.getKeyType(usePublicKey));
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"decrypt(...)");
        } else if (object instanceof String) {
            byte[] byArray3 = this.decrypt((String)data, this.getKeyType(usePublicKey));
            byArray = byArray3;
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"decrypt(...)");
        } else if (object instanceof InputStream) {
            byte[] byArray4 = this.decrypt((InputStream)data, this.getKeyType(usePublicKey));
            byArray = byArray4;
            Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"decrypt(...)");
        } else {
            throw new IllegalArgumentException("Unexpected input type");
        }
        return byArray;
    }

    public static /* synthetic */ byte[] decrypt$default(AsymmetricCrypto asymmetricCrypto, Object object, Boolean bl, int n, Object object2) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return asymmetricCrypto.decrypt(object, bl);
    }

    @JvmOverloads
    @NotNull
    public final String decryptStr(@NotNull Object data, @Nullable Boolean usePublicKey) {
        String string;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Object object = data;
        if (object instanceof byte[]) {
            byte[] byArray = this.decrypt((byte[])data, this.getKeyType(usePublicKey));
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decrypt(...)");
            byte[] byArray2 = byArray;
            string = new String(byArray2, Charsets.UTF_8);
        } else if (object instanceof String) {
            String string2 = this.decryptStr((String)data, this.getKeyType(usePublicKey));
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"decryptStr(...)");
        } else if (object instanceof InputStream) {
            byte[] byArray = this.decrypt((InputStream)data, this.getKeyType(usePublicKey));
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decrypt(...)");
            byte[] byArray3 = byArray;
            string = new String(byArray3, Charsets.UTF_8);
        } else {
            throw new IllegalArgumentException("Unexpected input type");
        }
        return string;
    }

    public static /* synthetic */ String decryptStr$default(AsymmetricCrypto asymmetricCrypto, Object object, Boolean bl, int n, Object object2) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return asymmetricCrypto.decryptStr(object, bl);
    }

    @JvmOverloads
    @NotNull
    public final byte[] encrypt(@NotNull Object data, @Nullable Boolean usePublicKey) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Object object = data;
        if (object instanceof byte[]) {
            byte[] byArray2 = this.encrypt((byte[])data, this.getKeyType(usePublicKey));
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"encrypt(...)");
        } else if (object instanceof String) {
            byte[] byArray3 = this.encrypt((String)data, this.getKeyType(usePublicKey));
            byArray = byArray3;
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"encrypt(...)");
        } else if (object instanceof InputStream) {
            byte[] byArray4 = this.encrypt((InputStream)data, this.getKeyType(usePublicKey));
            byArray = byArray4;
            Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"encrypt(...)");
        } else {
            throw new IllegalArgumentException("Unexpected input type");
        }
        return byArray;
    }

    public static /* synthetic */ byte[] encrypt$default(AsymmetricCrypto asymmetricCrypto, Object object, Boolean bl, int n, Object object2) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return asymmetricCrypto.encrypt(object, bl);
    }

    @JvmOverloads
    @NotNull
    public final String encryptHex(@NotNull Object data, @Nullable Boolean usePublicKey) {
        String string;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Object object = data;
        if (object instanceof byte[]) {
            String string2 = this.encryptHex((byte[])data, this.getKeyType(usePublicKey));
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encryptHex(...)");
        } else if (object instanceof String) {
            String string3 = this.encryptHex((String)data, this.getKeyType(usePublicKey));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"encryptHex(...)");
        } else if (object instanceof InputStream) {
            String string4 = this.encryptHex((InputStream)data, this.getKeyType(usePublicKey));
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"encryptHex(...)");
        } else {
            throw new IllegalArgumentException("Unexpected input type");
        }
        return string;
    }

    public static /* synthetic */ String encryptHex$default(AsymmetricCrypto asymmetricCrypto, Object object, Boolean bl, int n, Object object2) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return asymmetricCrypto.encryptHex(object, bl);
    }

    @JvmOverloads
    @NotNull
    public final String encryptBase64(@NotNull Object data, @Nullable Boolean usePublicKey) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return EncoderUtils.base64Encode$default(EncoderUtils.INSTANCE, this.encrypt(data, usePublicKey), 0, 2, null);
    }

    public static /* synthetic */ String encryptBase64$default(AsymmetricCrypto asymmetricCrypto, Object object, Boolean bl, int n, Object object2) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return asymmetricCrypto.encryptBase64(object, bl);
    }

    @JvmOverloads
    @NotNull
    public final byte[] decrypt(@NotNull Object data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return AsymmetricCrypto.decrypt$default(this, data, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final String decryptStr(@NotNull Object data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return AsymmetricCrypto.decryptStr$default(this, data, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final byte[] encrypt(@NotNull Object data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return AsymmetricCrypto.encrypt$default(this, data, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final String encryptHex(@NotNull Object data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return AsymmetricCrypto.encryptHex$default(this, data, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final String encryptBase64(@NotNull Object data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return AsymmetricCrypto.encryptBase64$default(this, data, null, 2, null);
    }
}

