/*
 * Decompiled with CFR 0.152.
 */
package book.util.help;

import book.appCtx;
import book.model.Cache;
import book.util.FileUtils;
import book.util.help.CacheManagerKt;
import book.util.help.RuleBigDataHelp;
import book.webBook.analyzeRule.QueryTTF;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\"\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00012\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0007J\u0016\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0001J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0018\u001a\u00020\u0003J\u000e\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0003J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0018\u001a\u00020\u0003J\u0015\u0010\u001f\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0018\u001a\u00020\u0003\u00a2\u0006\u0002\u0010 J\u0015\u0010!\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0018\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\"J\u0015\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u0018\u001a\u00020\u0003\u00a2\u0006\u0002\u0010%J\u0015\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u0018\u001a\u00020\u0003\u00a2\u0006\u0002\u0010(J\u0010\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u0018\u001a\u00020\u0003J\u0010\u0010+\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0018\u001a\u00020\u0003J \u0010,\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010-\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0018\u001a\u00020\u0003J\u000e\u0010.\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0003J\b\u0010/\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007RB\u0010\b\u001a6\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\tj\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lbook/util/help/CacheManager;", "", "userid", "", "<init>", "(Ljava/lang/String;)V", "getUserid", "()Ljava/lang/String;", "queryTTFMap", "Ljava/util/HashMap;", "Lkotlin/Pair;", "", "Lbook/webBook/analyzeRule/QueryTTF;", "Lkotlin/collections/HashMap;", "ruleDataDir", "Ljava/io/File;", "cahceData", "clear", "", "setcache", "_key", "value", "getcache", "put", "key", "saveTime", "", "putMemory", "getFromMemory", "deleteMemory", "get", "getInt", "(Ljava/lang/String;)Ljava/lang/Integer;", "getLong", "(Ljava/lang/String;)Ljava/lang/Long;", "getDouble", "", "(Ljava/lang/String;)Ljava/lang/Double;", "getFloat", "", "(Ljava/lang/String;)Ljava/lang/Float;", "getByteArray", "", "getQueryTTF", "putFile", "getFile", "delete", "toString", "book"})
public final class CacheManager {
    @NotNull
    private final String userid;
    @NotNull
    private final HashMap<String, Pair<Long, QueryTTF>> queryTTFMap;
    @NotNull
    private final File ruleDataDir;
    @NotNull
    private final File cahceData;

    public CacheManager(@NotNull String userid) {
        Intrinsics.checkNotNullParameter((Object)userid, (String)"userid");
        this.userid = userid;
        this.queryTTFMap = new HashMap();
        String[] stringArray = new String[]{"cache"};
        this.ruleDataDir = FileUtils.INSTANCE.createFolderIfNotExist(appCtx.INSTANCE.getExternalFiles(), stringArray);
        stringArray = new String[]{"cache", this.userid};
        this.cahceData = FileUtils.INSTANCE.createFolderIfNotExist(this.ruleDataDir, stringArray);
    }

    @NotNull
    public final String getUserid() {
        return this.userid;
    }

    public final void clear() {
        if (this.cahceData.exists()) {
            FilesKt.deleteRecursively((File)this.cahceData);
        }
        this.cahceData.mkdirs();
    }

    private final void setcache(String _key, String value) {
        String key = CacheManagerKt.Md5(_key);
        if (((CharSequence)value).length() == 0) {
            String[] stringArray = new String[]{key + ".txt"};
            File valueFile = FileUtils.INSTANCE.createFileIfNotExist(this.cahceData, stringArray);
            valueFile.delete();
        } else {
            String[] stringArray = new String[]{key + ".txt"};
            File valueFile = FileUtils.INSTANCE.createFileIfNotExist(this.cahceData, stringArray);
            FilesKt.writeText$default((File)valueFile, (String)value, null, (int)2, null);
        }
    }

    private final String getcache(String _key) {
        String key = CacheManagerKt.Md5(_key);
        try {
            String[] stringArray = new String[]{key + ".txt"};
            File valueFile = FileUtils.INSTANCE.createFileIfNotExist(this.cahceData, stringArray);
            String content = FilesKt.readText$default((File)valueFile, null, (int)1, null);
            return content;
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    @JvmOverloads
    public final void put(@NotNull String key, @NotNull Object value, int saveTime) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        long deadline = saveTime == 0 ? 0L : System.currentTimeMillis() + (long)(saveTime * 1000);
        Object object = value;
        if (object instanceof QueryTTF) {
            ((Map)this.queryTTFMap).put(key, new Pair((Object)deadline, value));
        } else if (object instanceof byte[]) {
            Cache cache = new Cache(key, new String((byte[])value, Charsets.UTF_8), deadline);
            String string = new Gson().toJson((Object)cache);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            this.setcache(key, string);
        } else {
            Cache cache = new Cache(key, value.toString(), deadline);
            String string = new Gson().toJson((Object)cache);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            this.setcache(key, string);
        }
    }

    public static /* synthetic */ void put$default(CacheManager cacheManager, String string, Object object, int n, int n2, Object object2) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        cacheManager.put(string, object, n);
    }

    public final void putMemory(@NotNull String key, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        CacheManagerKt.getMemoryLruCache().add-gIAlu-s(this.userid + "_" + key, value);
    }

    @Nullable
    public final Object getFromMemory(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return CacheManagerKt.getMemoryLruCache().get(this.userid + "_" + key);
    }

    public final void deleteMemory(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        CacheManagerKt.getMemoryLruCache().remove(this.userid + "_" + key);
    }

    @Nullable
    public final String get(@NotNull String key) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String v = this.getcache(key);
        String re = null;
        CacheManager cacheManager = this;
        try {
            CacheManager $this$get_u24lambda_u240 = cacheManager;
            boolean bl = false;
            if (v != null && !StringsKt.isBlank((CharSequence)v)) {
                Cache cache = (Cache)new Gson().fromJson(v, Cache.class);
                if (System.currentTimeMillis() < cache.getDeadline() || cache.getDeadline() == 0L) {
                    re = cache.getValue();
                }
            }
            stringArray = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            stringArray = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        if (Intrinsics.areEqual(re, (Object)"undefined")) {
            re = null;
        }
        if (re == null && StringsKt.contains$default((CharSequence)key, (CharSequence)"_", (boolean)false, (int)2, null)) {
            stringArray = new String[]{"_"};
            List s = StringsKt.split$default((CharSequence)key, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (s.size() == 3) {
                return RuleBigDataHelp.INSTANCE.getSourceVariable((String)s.get(1), this.userid, "getv_" + s.get(2));
            }
            if (s.size() == 2) {
                return RuleBigDataHelp.INSTANCE.getSourceVariable((String)s.get(1), this.userid, (String)s.get(0));
            }
        }
        return re;
    }

    @Nullable
    public final Integer getInt(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = this.get(key);
        return string != null ? StringsKt.toIntOrNull((String)string) : null;
    }

    @Nullable
    public final Long getLong(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = this.get(key);
        return string != null ? StringsKt.toLongOrNull((String)string) : null;
    }

    @Nullable
    public final Double getDouble(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = this.get(key);
        return string != null ? StringsKt.toDoubleOrNull((String)string) : null;
    }

    @Nullable
    public final Float getFloat(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = this.get(key);
        return string != null ? StringsKt.toFloatOrNull((String)string) : null;
    }

    @Nullable
    public final byte[] getByteArray(@NotNull String key) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = this.getcache(key);
        if (string != null) {
            String string2 = string;
            byte[] byArray2 = string2.getBytes(Charsets.UTF_8);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        } else {
            byArray = null;
        }
        return byArray;
    }

    @Nullable
    public final QueryTTF getQueryTTF(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Pair<Long, QueryTTF> pair = this.queryTTFMap.get(key);
        if (pair == null) {
            return null;
        }
        Pair<Long, QueryTTF> cache = pair;
        if (((Number)cache.getFirst()).longValue() == 0L || ((Number)cache.getFirst()).longValue() > System.currentTimeMillis()) {
            return (QueryTTF)cache.getSecond();
        }
        return null;
    }

    public final void putFile(@NotNull String key, @NotNull String value, int saveTime) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        long deadline = saveTime == 0 ? 0L : System.currentTimeMillis() + (long)(saveTime * 1000);
        Cache cache = new Cache(key, value, deadline);
        String string = new Gson().toJson((Object)cache);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        this.setcache(key, string);
    }

    public static /* synthetic */ void putFile$default(CacheManager cacheManager, String string, String string2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        cacheManager.putFile(string, string2, n);
    }

    @Nullable
    public final String getFile(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.get(key);
    }

    public final void delete(@NotNull String _key) {
        Intrinsics.checkNotNullParameter((Object)_key, (String)"_key");
        String key = CacheManagerKt.Md5(_key);
        try {
            boolean bl = false;
            String[] stringArray = new String[]{key + ".txt"};
            File it = FileUtils.INSTANCE.createFileIfNotExist(this.cahceData, stringArray);
            boolean bl2 = false;
            if (it.exists()) {
                it.delete();
            }
            this.deleteMemory(key);
            Object object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    @NotNull
    public String toString() {
        int hashCode = this.hashCode();
        String hexHash = Integer.toHexString(hashCode);
        String s = "io.legado.app.help.CacheManager@" + hexHash;
        return s;
    }

    @JvmOverloads
    public final void put(@NotNull String key, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        CacheManager.put$default(this, key, value, 0, 4, null);
    }
}

