/*
 * Decompiled with CFR 0.152.
 */
package book.util.http;

import java.io.InputStream;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpHeaders;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lbook/util/http/DecompressInterceptor;", "Lokhttp3/Interceptor;", "<init>", "()V", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "book"})
public final class DecompressInterceptor
implements Interceptor {
    @NotNull
    public static final DecompressInterceptor INSTANCE = new DecompressInterceptor();

    private DecompressInterceptor() {
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        BufferedSource bufferedSource;
        String encoding;
        String string;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request request = chain.request();
        Request.Builder requestBuilder = request.newBuilder();
        boolean transparentDecompress = false;
        if (request.header("Accept-Encoding") == null && request.header("Range") == null) {
            transparentDecompress = true;
            requestBuilder.header("Accept-Encoding", "gzip, deflate");
        }
        Response response = chain.proceed(requestBuilder.build());
        ResponseBody body = response.body();
        if (!transparentDecompress || !HttpHeaders.promisesBody((Response)response) || body == null) {
            return response;
        }
        String string2 = Response.header$default((Response)response, (String)"Content-Encoding", null, (int)2, null);
        if (string2 != null) {
            String string3 = string2.toLowerCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String string4 = encoding = string;
        if (Intrinsics.areEqual((Object)string4, (Object)"gzip")) {
            bufferedSource = Okio.buffer((Source)Okio.source((InputStream)new GZIPInputStream(body.byteStream())));
        } else if (Intrinsics.areEqual((Object)string4, (Object)"deflate")) {
            bufferedSource = Okio.buffer((Source)Okio.source((InputStream)new InflaterInputStream(body.byteStream(), new Inflater(true))));
        } else {
            return response;
        }
        BufferedSource source = bufferedSource;
        return response.newBuilder().removeHeader("Content-Encoding").removeHeader("Content-Length").body(ResponseBody.Companion.create(source, body.contentType(), -1L)).build();
    }
}

