/*
 * Decompiled with CFR 0.152.
 */
package book.util.http;

import book.util.AppConst;
import book.util.help.CacheManagerKt;
import book.util.help.CookieStore;
import book.util.http.DecompressInterceptor;
import book.util.http.OkHttpExceptionInterceptor;
import book.util.http.OkhttpUncaughtExceptionHandler;
import book.util.http.SSLHelper;
import book.webBook.DebugLog;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.Authenticator;
import okhttp3.ConnectionSpec;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\f\u001a\u00020\u00032\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00022\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\"'\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\u0004\u0010\u0005\"\u001b\u0010\b\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\u0007\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"proxyClientCache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lokhttp3/OkHttpClient;", "getProxyClientCache", "()Ljava/util/concurrent/ConcurrentHashMap;", "proxyClientCache$delegate", "Lkotlin/Lazy;", "okHttpClient", "getOkHttpClient", "()Lokhttp3/OkHttpClient;", "okHttpClient$delegate", "getProxyClient", "proxy", "debugLog", "Lbook/webBook/DebugLog;", "book"})
@SourceDebugExtension(value={"SMAP\nHttpHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpHelper.kt\nbook/util/http/HttpHelperKt\n+ 2 OkHttpClient.kt\nokhttp3/OkHttpClient$Builder\n*L\n1#1,191:1\n578#2:192\n*S KotlinDebug\n*F\n+ 1 HttpHelper.kt\nbook/util/http/HttpHelperKt\n*L\n63#1:192\n*E\n"})
public final class HttpHelperKt {
    @NotNull
    private static final Lazy proxyClientCache$delegate = LazyKt.lazy(HttpHelperKt::proxyClientCache_delegate$lambda$0);
    @NotNull
    private static final Lazy okHttpClient$delegate = LazyKt.lazy(HttpHelperKt::okHttpClient_delegate$lambda$6);

    private static final ConcurrentHashMap<String, OkHttpClient> getProxyClientCache() {
        Lazy lazy = proxyClientCache$delegate;
        return (ConcurrentHashMap)lazy.getValue();
    }

    @NotNull
    public static final OkHttpClient getOkHttpClient() {
        Lazy lazy = okHttpClient$delegate;
        return (OkHttpClient)lazy.getValue();
    }

    @NotNull
    public static final OkHttpClient getProxyClient(@Nullable String proxy, @Nullable DebugLog debugLog) {
        OkHttpClient.Builder builder;
        CharSequence charSequence = proxy;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            if (debugLog == null) {
                return HttpHelperKt.getOkHttpClient();
            }
            builder = HttpHelperKt.getOkHttpClient().newBuilder();
            HttpLoggingInterceptor logInterceptor = new HttpLoggingInterceptor((HttpLoggingInterceptor.Logger)debugLog);
            logInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
            builder.addNetworkInterceptor((Interceptor)logInterceptor);
            return builder.build();
        }
        if (debugLog == null && (builder = HttpHelperKt.getProxyClientCache().get(proxy)) != null) {
            OkHttpClient.Builder it = builder;
            boolean bl = false;
            return it;
        }
        Regex r = new Regex("(http|socks4|socks5)://(.*):(\\d{2,5})(@.*@.*)?");
        Sequence ms = Regex.findAll$default((Regex)r, (CharSequence)proxy, (int)0, (int)2, null);
        MatchResult group = (MatchResult)SequencesKt.first((Sequence)ms);
        Ref.ObjectRef username = new Ref.ObjectRef();
        username.element = "";
        Ref.ObjectRef password = new Ref.ObjectRef();
        password.element = "";
        String type = Intrinsics.areEqual(group.getGroupValues().get(1), (Object)"http") ? "http" : "socks";
        String host = (String)group.getGroupValues().get(2);
        int port = Integer.parseInt((String)group.getGroupValues().get(3));
        if (!Intrinsics.areEqual(group.getGroupValues().get(4), (Object)"")) {
            String[] stringArray = new String[]{"@"};
            username.element = StringsKt.split$default((CharSequence)((CharSequence)group.getGroupValues().get(4)), (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1);
            stringArray = new String[]{"@"};
            password.element = StringsKt.split$default((CharSequence)((CharSequence)group.getGroupValues().get(4)), (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(2);
        }
        if (!Intrinsics.areEqual((Object)type, (Object)"direct") && !Intrinsics.areEqual((Object)host, (Object)"")) {
            OkHttpClient.Builder builder2 = HttpHelperKt.getOkHttpClient().newBuilder();
            OkHttpClient.Builder builder3 = Intrinsics.areEqual((Object)type, (Object)"http") ? builder2.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port))) : builder2.proxy(new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(host, port)));
            if (!Intrinsics.areEqual((Object)username.element, (Object)"") && !Intrinsics.areEqual((Object)password.element, (Object)"")) {
                Authenticator proxyAuthenticator2 = new Authenticator((Ref.ObjectRef<String>)username, (Ref.ObjectRef<String>)password){
                    final /* synthetic */ Ref.ObjectRef<String> $username;
                    final /* synthetic */ Ref.ObjectRef<String> $password;
                    {
                        this.$username = $username;
                        this.$password = $password;
                    }

                    public Request authenticate(Route route, Response response) throws IOException {
                        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                        String credential = Credentials.basic$default((String)((String)this.$username.element), (String)((String)this.$password.element), null, (int)4, null);
                        return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                    }
                };
                builder2.proxyAuthenticator(proxyAuthenticator2);
            }
            if (debugLog != null) {
                HttpLoggingInterceptor logInterceptor = new HttpLoggingInterceptor((HttpLoggingInterceptor.Logger)debugLog);
                logInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
                builder2.addNetworkInterceptor((Interceptor)logInterceptor);
                return builder2.build();
            }
            OkHttpClient proxyClient = builder2.build();
            ((Map)HttpHelperKt.getProxyClientCache()).put(proxy, proxyClient);
            return proxyClient;
        }
        return HttpHelperKt.getOkHttpClient();
    }

    public static /* synthetic */ OkHttpClient getProxyClient$default(String string, DebugLog debugLog, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            debugLog = null;
        }
        return HttpHelperKt.getProxyClient(string, debugLog);
    }

    private static final ConcurrentHashMap proxyClientCache_delegate$lambda$0() {
        return new ConcurrentHashMap();
    }

    private static final Response okHttpClient_delegate$lambda$6$lambda$1(Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request request = chain.request();
        Request.Builder builder = request.newBuilder();
        if (request.header("User-Agent") == null) {
            builder.addHeader("User-Agent", AppConst.INSTANCE.getUserAgent());
        } else if (Intrinsics.areEqual((Object)request.header("User-Agent"), (Object)"null")) {
            builder.removeHeader("User-Agent");
        }
        builder.addHeader("Keep-Alive", "300");
        builder.addHeader("Connection", "Keep-Alive");
        builder.addHeader("Cache-Control", "no-cache");
        return chain.proceed(builder.build());
    }

    private static final Thread okHttpClient_delegate$lambda$6$lambda$5$lambda$4(String $threadName, Runnable runnable) {
        Thread thread;
        Thread $this$okHttpClient_delegate_u24lambda_u246_u24lambda_u245_u24lambda_u244_u24lambda_u243 = thread = new Thread(runnable, $threadName);
        boolean bl = false;
        $this$okHttpClient_delegate_u24lambda_u246_u24lambda_u245_u24lambda_u244_u24lambda_u243.setDaemon(false);
        $this$okHttpClient_delegate_u24lambda_u246_u24lambda_u245_u24lambda_u244_u24lambda_u243.setUncaughtExceptionHandler(OkhttpUncaughtExceptionHandler.INSTANCE);
        return thread;
    }

    private static final OkHttpClient okHttpClient_delegate$lambda$6() {
        OkHttpClient okHttpClient;
        Object[] objectArray = new ConnectionSpec[]{ConnectionSpec.MODERN_TLS, ConnectionSpec.COMPATIBLE_TLS, ConnectionSpec.CLEARTEXT};
        ArrayList specs = CollectionsKt.arrayListOf((Object[])objectArray);
        OkHttpClient.Builder this_$iv = new OkHttpClient.Builder().connectTimeout(15L, TimeUnit.SECONDS).writeTimeout(15L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).callTimeout(60L, TimeUnit.SECONDS).sslSocketFactory(SSLHelper.INSTANCE.getUnsafeSSLSocketFactory(), SSLHelper.INSTANCE.getUnsafeTrustManager()).retryOnConnectionFailure(true).hostnameVerifier(SSLHelper.INSTANCE.getUnsafeHostnameVerifier()).connectionSpecs((List)specs).followRedirects(true).followSslRedirects(true).addInterceptor((Interceptor)OkHttpExceptionInterceptor.INSTANCE).addInterceptor(HttpHelperKt::okHttpClient_delegate$lambda$6$lambda$1);
        boolean bl = false;
        OkHttpClient.Builder builder = this_$iv.addNetworkInterceptor(new Interceptor(){

            @NotNull
            public final Response intercept(@NotNull Interceptor.Chain chain) {
                Response networkResponse;
                block3: {
                    CookieStore store;
                    Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
                    Interceptor.Chain chain2 = chain;
                    boolean bl = false;
                    Request request = chain2.request();
                    String enableCookieJar = request.header(CacheManagerKt.getCookieJarHeader());
                    CharSequence charSequence = enableCookieJar;
                    if (!(charSequence == null || charSequence.length() == 0) && CookieStore.Companion.getStores().containsKey(enableCookieJar)) {
                        CookieStore store2;
                        CookieStore cookieStore = store2 = CookieStore.Companion.getStores().get(enableCookieJar);
                        if (cookieStore != null) {
                            cookieStore.loadRequest(request);
                        }
                    }
                    networkResponse = chain2.proceed(request);
                    CharSequence charSequence2 = enableCookieJar;
                    if (charSequence2 == null || charSequence2.length() == 0 || !CookieStore.Companion.getStores().containsKey(enableCookieJar)) break block3;
                    CookieStore cookieStore = store = CookieStore.Companion.getStores().get(enableCookieJar);
                    if (cookieStore != null) {
                        cookieStore.saveResponse(networkResponse);
                    }
                }
                return networkResponse;
            }
        });
        builder.addInterceptor((Interceptor)DecompressInterceptor.INSTANCE);
        OkHttpClient $this$okHttpClient_delegate_u24lambda_u246_u24lambda_u245 = okHttpClient = builder.build();
        boolean bl2 = false;
        String string = OkHttpClient.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String okHttpName = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)string, (CharSequence)"okhttp3."), (CharSequence)"Client");
        ExecutorService executorService = $this$okHttpClient_delegate_u24lambda_u246_u24lambda_u245.dispatcher().executorService();
        Intrinsics.checkNotNull((Object)executorService, (String)"null cannot be cast to non-null type java.util.concurrent.ThreadPoolExecutor");
        ThreadPoolExecutor executor = (ThreadPoolExecutor)executorService;
        String threadName = okHttpName + " Dispatcher";
        executor.setThreadFactory(arg_0 -> HttpHelperKt.okHttpClient_delegate$lambda$6$lambda$5$lambda$4(threadName, arg_0));
        return okHttpClient;
    }
}

