/*
 * Decompiled with CFR 0.152.
 */
package book.util.http;

import book.util.Base64;
import book.util.http.JsonpResponse;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001BU\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u001a\b\u0002\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010 \u001a\u00020!J\u0018\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0003J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\u001b\u0010(\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u0006H\u00c6\u0003J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\t\u0010*\u001a\u00020\nH\u00c6\u0003J\t\u0010+\u001a\u00020\u0003H\u00c6\u0003JW\u0010,\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u001a\b\u0002\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u00062\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00100\u001a\u00020\nH\u00d6\u0001J\t\u00101\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000f\"\u0004\b\u0013\u0010\u0011R,\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u000f\"\u0004\b\u0019\u0010\u0011R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u000b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u000f\"\u0004\b\u001f\u0010\u0011\u00a8\u00062"}, d2={"Lbook/util/http/MyResponse;", "", "url", "", "method", "headers", "", "", "body", "statusCode", "", "statusMessage", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/lang/String;ILjava/lang/String;)V", "getUrl", "()Ljava/lang/String;", "setUrl", "(Ljava/lang/String;)V", "getMethod", "setMethod", "getHeaders", "()Ljava/util/Map;", "setHeaders", "(Ljava/util/Map;)V", "getBody", "setBody", "getStatusCode", "()I", "setStatusCode", "(I)V", "getStatusMessage", "setStatusMessage", "tojsonresponse", "Lbook/util/http/JsonpResponse;", "text", "responseBytes", "", "charsetName", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "book"})
public final class MyResponse {
    @NotNull
    private String url;
    @NotNull
    private String method;
    @NotNull
    private Map<String, List<String>> headers;
    @NotNull
    private String body;
    private int statusCode;
    @NotNull
    private String statusMessage;

    public MyResponse(@NotNull String url, @NotNull String method, @NotNull Map<String, List<String>> headers, @NotNull String body, int statusCode, @NotNull String statusMessage) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)statusMessage, (String)"statusMessage");
        this.url = url;
        this.method = method;
        this.headers = headers;
        this.body = body;
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
    }

    public /* synthetic */ MyResponse(String string, String string2, Map map, String string3, int n, String string4, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string = "";
        }
        if ((n2 & 2) != 0) {
            string2 = "get";
        }
        if ((n2 & 4) != 0) {
            map = new LinkedHashMap();
        }
        if ((n2 & 8) != 0) {
            string3 = "";
        }
        if ((n2 & 0x10) != 0) {
            n = 200;
        }
        if ((n2 & 0x20) != 0) {
            string4 = "";
        }
        this(string, string2, map, string3, n, string4);
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    public final void setUrl(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.url = string;
    }

    @NotNull
    public final String getMethod() {
        return this.method;
    }

    public final void setMethod(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.method = string;
    }

    @NotNull
    public final Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public final void setHeaders(@NotNull Map<String, List<String>> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.headers = map;
    }

    @NotNull
    public final String getBody() {
        return this.body;
    }

    public final void setBody(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.body = string;
    }

    public final int getStatusCode() {
        return this.statusCode;
    }

    public final void setStatusCode(int n) {
        this.statusCode = n;
    }

    @NotNull
    public final String getStatusMessage() {
        return this.statusMessage;
    }

    public final void setStatusMessage(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.statusMessage = string;
    }

    @NotNull
    public final JsonpResponse tojsonresponse() {
        JsonpResponse response = new JsonpResponse();
        response.setUrl(this.url);
        response.setMethod(this.method);
        response.setHeaders(this.headers);
        byte[] mybody = Base64.decode(this.body, 0);
        String contentType = response.contentType();
        String encoding = null;
        encoding = "utf-8";
        if (contentType != null) {
            String str;
            if (StringsKt.contains$default((CharSequence)contentType, (CharSequence)"charset=", (boolean)false, (int)2, null)) {
                String it = contentType;
                boolean bl = false;
                if (StringsKt.contains$default((CharSequence)it, (CharSequence)"charset=", (boolean)false, (int)2, null)) {
                    String[] stringArray = new String[]{"charset="};
                    String string = ((Object)StringsKt.trim((CharSequence)((String)StringsKt.split$default((CharSequence)it, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1)))).toString().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                    encoding = string;
                }
            } else if (StringsKt.contains$default((CharSequence)contentType, (CharSequence)"html", (boolean)false, (int)2, null) && (StringsKt.contains$default((CharSequence)(str = new String(mybody, Charsets.UTF_8)), (CharSequence)"gb2312", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)str, (CharSequence)"GB2312", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)str, (CharSequence)"GBK", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)str, (CharSequence)"gbk", (boolean)false, (int)2, null))) {
                encoding = "gbk";
            }
        }
        response.setBody(this.text(mybody, encoding));
        response.setStatusCode(this.statusCode);
        response.setStatusMessage(this.statusMessage);
        return response;
    }

    @NotNull
    public final String text(@NotNull byte[] responseBytes, @Nullable String charsetName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)responseBytes, (String)"responseBytes");
        String string2 = charsetName;
        if (string2 != null) {
            String string3 = string2.toLowerCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String string4 = "gb2312".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        if (Intrinsics.areEqual((Object)string, (Object)string4)) {
            Charset charset = Charset.forName("gbk");
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
            Charset charset2 = charset;
            return new String(responseBytes, charset2);
        }
        Charset charset = Charset.forName(charsetName);
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
        Charset charset3 = charset;
        return new String(responseBytes, charset3);
    }

    @NotNull
    public final String component1() {
        return this.url;
    }

    @NotNull
    public final String component2() {
        return this.method;
    }

    @NotNull
    public final Map<String, List<String>> component3() {
        return this.headers;
    }

    @NotNull
    public final String component4() {
        return this.body;
    }

    public final int component5() {
        return this.statusCode;
    }

    @NotNull
    public final String component6() {
        return this.statusMessage;
    }

    @NotNull
    public final MyResponse copy(@NotNull String url, @NotNull String method, @NotNull Map<String, List<String>> headers, @NotNull String body, int statusCode, @NotNull String statusMessage) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)statusMessage, (String)"statusMessage");
        return new MyResponse(url, method, headers, body, statusCode, statusMessage);
    }

    public static /* synthetic */ MyResponse copy$default(MyResponse myResponse, String string, String string2, Map map, String string3, int n, String string4, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = myResponse.url;
        }
        if ((n2 & 2) != 0) {
            string2 = myResponse.method;
        }
        if ((n2 & 4) != 0) {
            map = myResponse.headers;
        }
        if ((n2 & 8) != 0) {
            string3 = myResponse.body;
        }
        if ((n2 & 0x10) != 0) {
            n = myResponse.statusCode;
        }
        if ((n2 & 0x20) != 0) {
            string4 = myResponse.statusMessage;
        }
        return myResponse.copy(string, string2, map, string3, n, string4);
    }

    @NotNull
    public String toString() {
        return "MyResponse(url=" + this.url + ", method=" + this.method + ", headers=" + this.headers + ", body=" + this.body + ", statusCode=" + this.statusCode + ", statusMessage=" + this.statusMessage + ")";
    }

    public int hashCode() {
        int result = this.url.hashCode();
        result = result * 31 + this.method.hashCode();
        result = result * 31 + ((Object)this.headers).hashCode();
        result = result * 31 + this.body.hashCode();
        result = result * 31 + Integer.hashCode(this.statusCode);
        result = result * 31 + this.statusMessage.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MyResponse)) {
            return false;
        }
        MyResponse myResponse = (MyResponse)other;
        if (!Intrinsics.areEqual((Object)this.url, (Object)myResponse.url)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.method, (Object)myResponse.method)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.headers, myResponse.headers)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.body, (Object)myResponse.body)) {
            return false;
        }
        if (this.statusCode != myResponse.statusCode) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.statusMessage, (Object)myResponse.statusMessage);
    }

    public MyResponse() {
        this(null, null, null, null, 0, null, 63, null);
    }
}

