/*
 * Decompiled with CFR 0.152.
 */
package book.webBook;

import android.text.TextUtils;
import book.model.Book;
import book.model.BookSource;
import book.model.rule.BookInfoRule;
import book.util.NetworkUtils;
import book.util.StringKt;
import book.util.StringUtils;
import book.util.help.BookHelp;
import book.webBook.DebugLog;
import book.webBook.analyzeRule.AnalyzeRule;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JD\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011JL\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a8\u0006\u0006"}, d2={"Lbook/webBook/BookInfo;", "", "<init>", "()V", "analyzeBookInfo", "", "book", "Lbook/model/Book;", "body", "", "bookSource", "Lbook/model/BookSource;", "baseUrl", "redirectUrl", "canReName", "", "debugLog", "Lbook/webBook/DebugLog;", "analyzeRule", "Lbook/webBook/analyzeRule/AnalyzeRule;"})
public final class BookInfo {
    @NotNull
    public static final BookInfo INSTANCE = new BookInfo();

    private BookInfo() {
    }

    public final void analyzeBookInfo(@NotNull Book book, @Nullable String body, @NotNull BookSource bookSource, @NotNull String baseUrl, @NotNull String redirectUrl, boolean canReName, @Nullable DebugLog debugLog) throws Exception {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        Intrinsics.checkNotNullParameter((Object)bookSource, (String)"bookSource");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)redirectUrl, (String)"redirectUrl");
        if (body == null) {
            throw new Exception("error_get_web_content: " + baseUrl);
        }
        DebugLog debugLog2 = debugLog;
        if (debugLog2 != null) {
            DebugLog.DefaultImpls.log$default(debugLog2, bookSource.getBookSourceUrl(), "\u2261\u83b7\u53d6\u6210\u529f:" + baseUrl, false, 4, null);
        }
        AnalyzeRule analyzeRule = new AnalyzeRule(book, debugLog, bookSource);
        AnalyzeRule.setContent$default(analyzeRule, body, null, 2, null).setBaseUrl(baseUrl);
        analyzeRule.setRedirectUrl(redirectUrl);
        this.analyzeBookInfo(book, body, analyzeRule, bookSource, baseUrl, redirectUrl, canReName, debugLog);
    }

    public static /* synthetic */ void analyzeBookInfo$default(BookInfo bookInfo, Book book, String string, BookSource bookSource, String string2, String string3, boolean bl, DebugLog debugLog, int n, Object object) throws Exception {
        if ((n & 0x40) != 0) {
            debugLog = null;
        }
        bookInfo.analyzeBookInfo(book, string, bookSource, string2, string3, bl, debugLog);
    }

    public final void analyzeBookInfo(@NotNull Book book, @Nullable String body, @NotNull AnalyzeRule analyzeRule, @NotNull BookSource bookSource, @NotNull String baseUrl, @NotNull String redirectUrl, boolean canReName, @Nullable DebugLog debugLog) throws Exception {
        block46: {
            Object[] objectArray;
            block47: {
                BookInfoRule infoRule;
                block45: {
                    String it;
                    block44: {
                        block43: {
                            block42: {
                                block41: {
                                    Intrinsics.checkNotNullParameter((Object)book, (String)"book");
                                    Intrinsics.checkNotNullParameter((Object)analyzeRule, (String)"analyzeRule");
                                    Intrinsics.checkNotNullParameter((Object)bookSource, (String)"bookSource");
                                    Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
                                    Intrinsics.checkNotNullParameter((Object)redirectUrl, (String)"redirectUrl");
                                    if (body == null) {
                                        throw new Exception("error_get_web_content: " + baseUrl);
                                    }
                                    infoRule = bookSource.getBookInfoRule();
                                    String string = infoRule.getInit();
                                    if (string != null) {
                                        it = string;
                                        boolean bl = false;
                                        if (((CharSequence)it).length() > 0) {
                                            DebugLog debugLog2 = debugLog;
                                            if (debugLog2 != null) {
                                                DebugLog.DefaultImpls.log$default(debugLog2, bookSource.getBookSourceUrl(), "\u2261\u6267\u884c\u8be6\u60c5\u9875\u521d\u59cb\u5316\u89c4\u5219", false, 4, null);
                                            }
                                            AnalyzeRule.setContent$default(analyzeRule, analyzeRule.getElement(it), null, 2, null);
                                        }
                                    }
                                    boolean mCanReName = canReName && !((objectArray = (CharSequence)infoRule.getCanReName()) == null || StringsKt.isBlank((CharSequence)objectArray));
                                    DebugLog debugLog3 = debugLog;
                                    if (debugLog3 != null) {
                                        DebugLog.DefaultImpls.log$default(debugLog3, bookSource.getBookSourceUrl(), "\u250c\u83b7\u53d6\u4e66\u540d", false, 4, null);
                                    }
                                    it = BookHelp.INSTANCE.formatBookName(AnalyzeRule.getString$default(analyzeRule, infoRule.getName(), null, false, 6, null));
                                    boolean bl = false;
                                    if (((CharSequence)it).length() > 0 && (mCanReName || ((CharSequence)book.getName()).length() == 0)) {
                                        book.setName(it);
                                    }
                                    DebugLog debugLog4 = debugLog;
                                    if (debugLog4 != null) {
                                        DebugLog.DefaultImpls.log$default(debugLog4, bookSource.getBookSourceUrl(), "\u2514" + it, false, 4, null);
                                    }
                                    DebugLog debugLog5 = debugLog;
                                    if (debugLog5 != null) {
                                        DebugLog.DefaultImpls.log$default(debugLog5, bookSource.getBookSourceUrl(), "\u250c\u83b7\u53d6\u4f5c\u8005", false, 4, null);
                                    }
                                    it = BookHelp.INSTANCE.formatBookAuthor(AnalyzeRule.getString$default(analyzeRule, infoRule.getAuthor(), null, false, 6, null));
                                    boolean bl2 = false;
                                    if (((CharSequence)it).length() > 0 && (mCanReName || ((CharSequence)book.getAuthor()).length() == 0)) {
                                        book.setAuthor(it);
                                    }
                                    DebugLog debugLog6 = debugLog;
                                    if (debugLog6 != null) {
                                        DebugLog.DefaultImpls.log$default(debugLog6, bookSource.getBookSourceUrl(), "\u2514" + it, false, 4, null);
                                    }
                                    DebugLog debugLog7 = debugLog;
                                    if (debugLog7 != null) {
                                        DebugLog.DefaultImpls.log$default(debugLog7, bookSource.getBookSourceUrl(), "\u250c\u83b7\u53d6\u5206\u7c7b", false, 4, null);
                                    }
                                    try {
                                        objectArray = AnalyzeRule.getStringList$default(analyzeRule, infoRule.getKind(), null, false, 6, null);
                                        if (objectArray != null && (it = CollectionsKt.joinToString$default((Iterable)((Iterable)objectArray), (CharSequence)",", null, null, (int)0, null, null, (int)62, null)) != null) {
                                            String it2 = it;
                                            boolean bl3 = false;
                                            if (((CharSequence)it2).length() > 0) {
                                                book.setKind(it2);
                                            }
                                        }
                                        DebugLog debugLog8 = debugLog;
                                        if (debugLog8 != null) {
                                            DebugLog.DefaultImpls.log$default(debugLog8, bookSource.getBookSourceUrl(), "\u2514" + book.getKind(), false, 4, null);
                                        }
                                    }
                                    catch (Exception e) {
                                        DebugLog debugLog9 = debugLog;
                                        if (debugLog9 == null) break block41;
                                        DebugLog.DefaultImpls.log$default(debugLog9, bookSource.getBookSourceUrl(), "\u2514" + e.getLocalizedMessage(), false, 4, null);
                                    }
                                }
                                DebugLog debugLog10 = debugLog;
                                if (debugLog10 != null) {
                                    DebugLog.DefaultImpls.log$default(debugLog10, bookSource.getBookSourceUrl(), "\u250c\u83b7\u53d6\u5b57\u6570", false, 4, null);
                                }
                                try {
                                    it = StringUtils.INSTANCE.wordCountFormat(AnalyzeRule.getString$default(analyzeRule, infoRule.getWordCount(), null, false, 6, null));
                                    boolean bl = false;
                                    if (((CharSequence)it).length() > 0) {
                                        book.setWordCount(it);
                                    }
                                    DebugLog debugLog11 = debugLog;
                                    if (debugLog11 != null) {
                                        DebugLog.DefaultImpls.log$default(debugLog11, bookSource.getBookSourceUrl(), "\u2514" + book.getWordCount(), false, 4, null);
                                    }
                                }
                                catch (Exception e) {
                                    DebugLog debugLog12 = debugLog;
                                    if (debugLog12 == null) break block42;
                                    DebugLog.DefaultImpls.log$default(debugLog12, bookSource.getBookSourceUrl(), "\u2514" + e.getLocalizedMessage(), false, 4, null);
                                }
                            }
                            DebugLog debugLog13 = debugLog;
                            if (debugLog13 != null) {
                                DebugLog.DefaultImpls.log$default(debugLog13, bookSource.getBookSourceUrl(), "\u250c\u83b7\u53d6\u6700\u65b0\u7ae0\u8282", false, 4, null);
                            }
                            try {
                                it = AnalyzeRule.getString$default(analyzeRule, infoRule.getLastChapter(), null, false, 6, null);
                                boolean bl = false;
                                if (((CharSequence)it).length() > 0) {
                                    book.setLatestChapterTitle(it);
                                }
                                DebugLog debugLog14 = debugLog;
                                if (debugLog14 != null) {
                                    DebugLog.DefaultImpls.log$default(debugLog14, bookSource.getBookSourceUrl(), "\u2514" + book.getLatestChapterTitle(), false, 4, null);
                                }
                            }
                            catch (Exception e) {
                                DebugLog debugLog15 = debugLog;
                                if (debugLog15 == null) break block43;
                                DebugLog.DefaultImpls.log$default(debugLog15, bookSource.getBookSourceUrl(), "\u2514" + e.getLocalizedMessage(), false, 4, null);
                            }
                        }
                        DebugLog debugLog16 = debugLog;
                        if (debugLog16 != null) {
                            DebugLog.DefaultImpls.log$default(debugLog16, bookSource.getBookSourceUrl(), "\u250c\u83b7\u53d6\u7b80\u4ecb", false, 4, null);
                        }
                        try {
                            it = AnalyzeRule.getString$default(analyzeRule, infoRule.getIntro(), null, false, 6, null);
                            boolean bl = false;
                            if (((CharSequence)it).length() > 0) {
                                book.setIntro(StringKt.htmlFormat(it));
                            }
                            DebugLog debugLog17 = debugLog;
                            if (debugLog17 != null) {
                                DebugLog.DefaultImpls.log$default(debugLog17, bookSource.getBookSourceUrl(), "\u2514" + book.getIntro(), false, 4, null);
                            }
                        }
                        catch (Exception e) {
                            DebugLog debugLog18 = debugLog;
                            if (debugLog18 == null) break block44;
                            DebugLog.DefaultImpls.log$default(debugLog18, bookSource.getBookSourceUrl(), "\u2514" + e.getLocalizedMessage(), false, 4, null);
                        }
                    }
                    DebugLog debugLog19 = debugLog;
                    if (debugLog19 != null) {
                        DebugLog.DefaultImpls.log$default(debugLog19, bookSource.getBookSourceUrl(), "\u250c\u83b7\u53d6\u5c01\u9762\u94fe\u63a5", false, 4, null);
                    }
                    try {
                        it = AnalyzeRule.getString$default(analyzeRule, infoRule.getCoverUrl(), null, false, 6, null);
                        boolean bl = false;
                        if (((CharSequence)it).length() > 0) {
                            book.setCoverUrl(NetworkUtils.INSTANCE.getAbsoluteURL(redirectUrl, it));
                        }
                        DebugLog debugLog20 = debugLog;
                        if (debugLog20 != null) {
                            DebugLog.DefaultImpls.log$default(debugLog20, bookSource.getBookSourceUrl(), "\u2514" + book.getCoverUrl(), false, 4, null);
                        }
                    }
                    catch (Exception e) {
                        DebugLog debugLog21 = debugLog;
                        if (debugLog21 == null) break block45;
                        DebugLog.DefaultImpls.log$default(debugLog21, bookSource.getBookSourceUrl(), "\u2514" + e.getLocalizedMessage(), false, 4, null);
                    }
                }
                DebugLog debugLog22 = debugLog;
                if (debugLog22 != null) {
                    DebugLog.DefaultImpls.log$default(debugLog22, bookSource.getBookSourceUrl(), "\u250c\u83b7\u53d6\u76ee\u5f55\u94fe\u63a5", false, 4, null);
                }
                book.setTocUrl(AnalyzeRule.getString$default(analyzeRule, infoRule.getTocUrl(), null, true, 2, null));
                if (((CharSequence)book.getTocUrl()).length() == 0) {
                    book.setTocUrl(baseUrl);
                }
                if (Intrinsics.areEqual((Object)book.getTocUrl(), (Object)baseUrl)) {
                    book.setTocHtml(body);
                }
                DebugLog debugLog23 = debugLog;
                if (debugLog23 != null) {
                    DebugLog.DefaultImpls.log$default(debugLog23, bookSource.getBookSourceUrl(), "\u2514" + book.getTocUrl(), false, 4, null);
                }
                if (book.getType() != 128) break block46;
                DebugLog debugLog24 = debugLog;
                if (debugLog24 != null) {
                    DebugLog.DefaultImpls.log$default(debugLog24, bookSource.getBookSourceUrl(), "\u250c\u83b7\u53d6\u6587\u4ef6\u4e0b\u8f7d\u94fe\u63a5", false, 4, null);
                }
                book.setDownloadUrls(AnalyzeRule.getStringList$default(analyzeRule, infoRule.getDownloadUrls(), null, true, 2, null));
                objectArray = book.getDownloadUrls();
                if (!(objectArray == null || objectArray.isEmpty())) break block47;
                DebugLog debugLog25 = debugLog;
                if (debugLog25 == null) break block46;
                DebugLog.DefaultImpls.log$default(debugLog25, bookSource.getBookSourceUrl(), "\u2514", false, 4, null);
                break block46;
            }
            DebugLog debugLog26 = debugLog;
            if (debugLog26 == null) break block46;
            String string = bookSource.getBookSourceUrl();
            CharSequence charSequence = "\uff0c\n";
            objectArray = new Object[1];
            Intrinsics.checkNotNull(book.getDownloadUrls());
            DebugLog.DefaultImpls.log$default(debugLog26, string, "\u2514" + TextUtils.join(charSequence, objectArray), false, 4, null);
        }
    }

    public static /* synthetic */ void analyzeBookInfo$default(BookInfo bookInfo, Book book, String string, AnalyzeRule analyzeRule, BookSource bookSource, String string2, String string3, boolean bl, DebugLog debugLog, int n, Object object) throws Exception {
        if ((n & 0x80) != 0) {
            debugLog = null;
        }
        bookInfo.analyzeBookInfo(book, string, analyzeRule, bookSource, string2, string3, bl, debugLog);
    }
}

