/*
 * Decompiled with CFR 0.152.
 */
package book.webBook;

import book.model.Book;
import book.model.BookSource;
import book.model.SearchBook;
import book.model.rule.BookListRule;
import book.util.NetworkUtils;
import book.util.StringKt;
import book.util.StringUtils;
import book.util.help.BookHelp;
import book.webBook.BookInfo;
import book.webBook.DebugLog;
import book.webBook.analyzeRule.AnalyzeRule;
import book.webBook.analyzeRule.AnalyzeUrl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JV\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00062\b\b\u0002\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013JH\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u00d8\u0001\u0010\u0018\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001a\u001a\u00020\u00112\u0010\u0010\u001b\u001a\f\u0012\b\u0012\u00060\u001dR\u00020\u00160\u001c2\u0010\u0010\u001e\u001a\f\u0012\b\u0012\u00060\u001dR\u00020\u00160\u001c2\u0010\u0010\u001f\u001a\f\u0012\b\u0012\u00060\u001dR\u00020\u00160\u001c2\u0010\u0010 \u001a\f\u0012\b\u0012\u00060\u001dR\u00020\u00160\u001c2\u0010\u0010!\u001a\f\u0012\b\u0012\u00060\u001dR\u00020\u00160\u001c2\u0010\u0010\"\u001a\f\u0012\b\u0012\u00060\u001dR\u00020\u00160\u001c2\u0010\u0010#\u001a\f\u0012\b\u0012\u00060\u001dR\u00020\u00160\u001c2\u0010\u0010$\u001a\f\u0012\b\u0012\u00060\u001dR\u00020\u00160\u001c2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002\u00a8\u0006%"}, d2={"Lbook/webBook/BookList;", "", "<init>", "()V", "analyzeBookList", "Ljava/util/ArrayList;", "Lbook/model/SearchBook;", "Lkotlin/collections/ArrayList;", "body", "", "bookSource", "Lbook/model/BookSource;", "analyzeUrl", "Lbook/webBook/analyzeRule/AnalyzeUrl;", "baseUrl", "variableBook", "isSearch", "", "debugLog", "Lbook/webBook/DebugLog;", "getInfoItem", "analyzeRule", "Lbook/webBook/analyzeRule/AnalyzeRule;", "variable", "getSearchItem", "item", "log", "ruleName", "", "Lbook/webBook/analyzeRule/AnalyzeRule$SourceRule;", "ruleBookUrl", "ruleAuthor", "ruleKind", "ruleCoverUrl", "ruleWordCount", "ruleIntro", "ruleLastChapter", "book"})
public final class BookList {
    @NotNull
    public static final BookList INSTANCE = new BookList();

    private BookList() {
    }

    @NotNull
    public final ArrayList<SearchBook> analyzeBookList(@Nullable String body, @NotNull BookSource bookSource, @NotNull AnalyzeUrl analyzeUrl, @NotNull String baseUrl, @NotNull SearchBook variableBook, boolean isSearch, @Nullable DebugLog debugLog) throws Exception {
        String ruleList;
        CharSequence charSequence3;
        BookListRule bookListRule;
        CharSequence charSequence2;
        Intrinsics.checkNotNullParameter((Object)bookSource, (String)"bookSource");
        Intrinsics.checkNotNullParameter((Object)analyzeUrl, (String)"analyzeUrl");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)variableBook, (String)"variableBook");
        ArrayList<SearchBook> bookList = new ArrayList<SearchBook>();
        if (body == null) {
            throw new Exception("error_get_web_content");
        }
        DebugLog debugLog2 = debugLog;
        if (debugLog2 != null) {
            DebugLog.DefaultImpls.log$default(debugLog2, bookSource.getBookSourceUrl(), "\u2261\u83b7\u53d6\u6210\u529f:" + analyzeUrl.getRuleUrl(), false, 4, null);
        }
        AnalyzeRule analyzeRule = new AnalyzeRule(variableBook, debugLog, bookSource);
        AnalyzeRule.setContent$default(analyzeRule, body, null, 2, null).setBaseUrl(baseUrl);
        analyzeRule.setRedirectUrl(baseUrl);
        String string = bookSource.getBookUrlPattern();
        if (string != null) {
            String it = string;
            boolean charSequence3 = false;
            charSequence2 = baseUrl;
            if (new Regex(it).matches(charSequence2)) {
                DebugLog debugLog3 = debugLog;
                if (debugLog3 != null) {
                    DebugLog.DefaultImpls.log$default(debugLog3, bookSource.getBookSourceUrl(), "\u2261\u94fe\u63a5\u4e3a\u8be6\u60c5\u9875", false, 4, null);
                }
                SearchBook searchBook2 = INSTANCE.getInfoItem(body, analyzeRule, bookSource, analyzeUrl, baseUrl, variableBook.getVariable(), debugLog);
                if (searchBook2 != null) {
                    SearchBook searchBook3 = searchBook2;
                    boolean bl = false;
                    searchBook3.setInfoHtml(body);
                    bookList.add(searchBook3);
                }
                return bookList;
            }
        }
        List<Object> collections = null;
        boolean reverse = false;
        BookListRule bookListRule2 = bookListRule = isSearch ? (BookListRule)bookSource.getSearchRule() : ((charSequence3 = (CharSequence)bookSource.getExploreRule().getBookList()) == null || StringsKt.isBlank((CharSequence)charSequence3) ? (BookListRule)bookSource.getSearchRule() : (BookListRule)bookSource.getExploreRule());
        String string2 = bookListRule.getBookList();
        if (string2 == null) {
            string2 = "";
        }
        if (StringsKt.startsWith$default((String)(ruleList = string2), (String)"-", (boolean)false, (int)2, null)) {
            reverse = true;
            String string3 = ruleList.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            ruleList = string3;
        }
        if (StringsKt.startsWith$default((String)ruleList, (String)"+", (boolean)false, (int)2, null)) {
            String string4 = ruleList.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            ruleList = string4;
        }
        DebugLog debugLog4 = debugLog;
        if (debugLog4 != null) {
            DebugLog.DefaultImpls.log$default(debugLog4, bookSource.getBookSourceUrl(), "\u250c\u83b7\u53d6\u4e66\u7c4d\u5217\u8868", false, 4, null);
        }
        collections = analyzeRule.getElements(ruleList);
        if (collections.isEmpty() && ((charSequence2 = (CharSequence)bookSource.getBookUrlPattern()) == null || charSequence2.length() == 0)) {
            DebugLog debugLog5 = debugLog;
            if (debugLog5 != null) {
                DebugLog.DefaultImpls.log$default(debugLog5, bookSource.getBookSourceUrl(), "\u2514\u5217\u8868\u4e3a\u7a7a,\u6309\u8be6\u60c5\u9875\u89e3\u6790", false, 4, null);
            }
            SearchBook searchBook4 = this.getInfoItem(body, analyzeRule, bookSource, analyzeUrl, baseUrl, variableBook.getVariable(), debugLog);
            if (searchBook4 != null) {
                SearchBook searchBook5 = searchBook4;
                boolean bl = false;
                searchBook5.setInfoHtml(body);
                bookList.add(searchBook5);
            }
        } else {
            List ruleName = AnalyzeRule.splitSourceRule$default(analyzeRule, bookListRule.getName(), false, 2, null);
            List ruleBookUrl = AnalyzeRule.splitSourceRule$default(analyzeRule, bookListRule.getBookUrl(), false, 2, null);
            List ruleAuthor = AnalyzeRule.splitSourceRule$default(analyzeRule, bookListRule.getAuthor(), false, 2, null);
            List ruleCoverUrl = AnalyzeRule.splitSourceRule$default(analyzeRule, bookListRule.getCoverUrl(), false, 2, null);
            List ruleIntro = AnalyzeRule.splitSourceRule$default(analyzeRule, bookListRule.getIntro(), false, 2, null);
            List ruleKind = AnalyzeRule.splitSourceRule$default(analyzeRule, bookListRule.getKind(), false, 2, null);
            List ruleLastChapter = AnalyzeRule.splitSourceRule$default(analyzeRule, bookListRule.getLastChapter(), false, 2, null);
            List ruleWordCount = AnalyzeRule.splitSourceRule$default(analyzeRule, bookListRule.getWordCount(), false, 2, null);
            DebugLog debugLog6 = debugLog;
            if (debugLog6 != null) {
                DebugLog.DefaultImpls.log$default(debugLog6, bookSource.getBookSourceUrl(), "\u2514\u5217\u8868\u5927\u5c0f:" + collections.size(), false, 4, null);
            }
            Iterator iterator = ((Iterable)collections).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                boolean bl;
                String string5;
                int index = n++;
                Object item = iterator.next();
                SearchBook searchBook6 = this.getSearchItem(item, analyzeRule, bookSource, baseUrl, string5 = variableBook.getVariable(), bl = index == 0, ruleName, ruleBookUrl, ruleAuthor, ruleKind, ruleCoverUrl, ruleWordCount, ruleIntro, ruleLastChapter, debugLog);
                if (searchBook6 == null) continue;
                SearchBook searchBook7 = searchBook6;
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)baseUrl, (Object)searchBook7.getBookUrl())) {
                    searchBook7.setInfoHtml(body);
                }
                bookList.add(searchBook7);
            }
            if (reverse) {
                CollectionsKt.reverse((List)bookList);
            }
        }
        return bookList;
    }

    public static /* synthetic */ ArrayList analyzeBookList$default(BookList bookList, String string, BookSource bookSource, AnalyzeUrl analyzeUrl, String string2, SearchBook searchBook2, boolean bl, DebugLog debugLog, int n, Object object) throws Exception {
        if ((n & 0x20) != 0) {
            bl = true;
        }
        if ((n & 0x40) != 0) {
            debugLog = null;
        }
        return bookList.analyzeBookList(string, bookSource, analyzeUrl, string2, searchBook2, bl, debugLog);
    }

    private final SearchBook getInfoItem(String body, AnalyzeRule analyzeRule, BookSource bookSource, AnalyzeUrl analyzeUrl, String baseUrl, String variable, DebugLog debugLog) {
        Book book = new Book(null, null, null, null, null, null, null, null, null, null, null, null, null, 0, 0, null, 0L, 0L, 0, 0, null, 0, 0.0, 0L, null, false, 0, 0, false, variable, null, null, -536870913, null);
        String string = bookSource.getUserid();
        if (string == null) {
            string = "";
        }
        book.setUserid(string);
        book.setBookUrl(analyzeUrl.getRuleUrl());
        book.setOrigin(bookSource.getBookSourceUrl());
        book.setOriginName(bookSource.getBookSourceName());
        book.setOriginOrder(bookSource.getCustomOrder());
        book.setType(bookSource.getBookSourceType());
        analyzeRule.setRuleData(book);
        BookInfo.INSTANCE.analyzeBookInfo(book, body, analyzeRule, bookSource, baseUrl, baseUrl, false, debugLog);
        if (!StringsKt.isBlank((CharSequence)book.getName())) {
            return book.toSearchBook();
        }
        return null;
    }

    static /* synthetic */ SearchBook getInfoItem$default(BookList bookList, String string, AnalyzeRule analyzeRule, BookSource bookSource, AnalyzeUrl analyzeUrl, String string2, String string3, DebugLog debugLog, int n, Object object) {
        if ((n & 0x40) != 0) {
            debugLog = null;
        }
        return bookList.getInfoItem(string, analyzeRule, bookSource, analyzeUrl, string2, string3, debugLog);
    }

    private final SearchBook getSearchItem(Object item, AnalyzeRule analyzeRule, BookSource bookSource, String baseUrl, String variable, boolean log, List<AnalyzeRule.SourceRule> ruleName, List<AnalyzeRule.SourceRule> ruleBookUrl, List<AnalyzeRule.SourceRule> ruleAuthor, List<AnalyzeRule.SourceRule> ruleKind, List<AnalyzeRule.SourceRule> ruleCoverUrl, List<AnalyzeRule.SourceRule> ruleWordCount, List<AnalyzeRule.SourceRule> ruleIntro, List<AnalyzeRule.SourceRule> ruleLastChapter, DebugLog debugLog) {
        block52: {
            SearchBook searchBook2 = new SearchBook(null, null, null, 0, null, null, null, null, null, null, null, null, 0L, variable, 0, null, 57343, null);
            String string = bookSource.getUserid();
            if (string == null) {
                string = "";
            }
            searchBook2.setUserid(string);
            searchBook2.setOrigin(bookSource.getBookSourceUrl());
            searchBook2.setOriginName(bookSource.getBookSourceName());
            searchBook2.setType(bookSource.getBookSourceType());
            searchBook2.setOriginOrder(bookSource.getCustomOrder());
            analyzeRule.setRuleData(searchBook2);
            AnalyzeRule.setContent$default(analyzeRule, item, null, 2, null);
            if (log) {
                DebugLog debugLog2 = debugLog;
                if (debugLog2 != null) {
                    DebugLog.DefaultImpls.log$default(debugLog2, bookSource.getBookSourceUrl(), "\u250c\u83b7\u53d6\u4e66\u540d", false, 4, null);
                }
            }
            searchBook2.setName(BookHelp.INSTANCE.formatBookName(AnalyzeRule.getString$default(analyzeRule, ruleName, null, false, false, 14, null)));
            if (log) {
                DebugLog debugLog3 = debugLog;
                if (debugLog3 != null) {
                    DebugLog.DefaultImpls.log$default(debugLog3, bookSource.getBookSourceUrl(), "\u2514" + searchBook2.getName(), false, 4, null);
                }
            }
            if (((CharSequence)searchBook2.getName()).length() > 0) {
                block51: {
                    block50: {
                        block49: {
                            block48: {
                                block47: {
                                    if (log) {
                                        DebugLog debugLog4 = debugLog;
                                        if (debugLog4 != null) {
                                            DebugLog.DefaultImpls.log$default(debugLog4, bookSource.getBookSourceUrl(), "\u250c\u83b7\u53d6\u4f5c\u8005", false, 4, null);
                                        }
                                    }
                                    searchBook2.setAuthor(BookHelp.INSTANCE.formatBookAuthor(AnalyzeRule.getString$default(analyzeRule, ruleAuthor, null, false, false, 14, null)));
                                    if (log) {
                                        DebugLog debugLog5 = debugLog;
                                        if (debugLog5 != null) {
                                            DebugLog.DefaultImpls.log$default(debugLog5, bookSource.getBookSourceUrl(), "\u2514" + searchBook2.getAuthor(), false, 4, null);
                                        }
                                    }
                                    if (log) {
                                        DebugLog debugLog6 = debugLog;
                                        if (debugLog6 != null) {
                                            DebugLog.DefaultImpls.log$default(debugLog6, bookSource.getBookSourceUrl(), "\u250c\u83b7\u53d6\u5206\u7c7b", false, 4, null);
                                        }
                                    }
                                    try {
                                        List list = AnalyzeRule.getStringList$default(analyzeRule, ruleKind, null, false, 6, null);
                                        searchBook2.setKind(list != null ? CollectionsKt.joinToString$default((Iterable)list, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) : null);
                                        if (log) {
                                            DebugLog debugLog7 = debugLog;
                                            if (debugLog7 != null) {
                                                DebugLog.DefaultImpls.log$default(debugLog7, bookSource.getBookSourceUrl(), "\u2514" + searchBook2.getKind(), false, 4, null);
                                            }
                                        }
                                    }
                                    catch (Exception e) {
                                        if (!log) break block47;
                                        DebugLog debugLog8 = debugLog;
                                        if (debugLog8 == null) break block47;
                                        DebugLog.DefaultImpls.log$default(debugLog8, bookSource.getBookSourceUrl(), "\u2514" + e.getLocalizedMessage(), false, 4, null);
                                    }
                                }
                                if (log) {
                                    DebugLog debugLog9 = debugLog;
                                    if (debugLog9 != null) {
                                        DebugLog.DefaultImpls.log$default(debugLog9, bookSource.getBookSourceUrl(), "\u250c\u83b7\u53d6\u5b57\u6570", false, 4, null);
                                    }
                                }
                                try {
                                    searchBook2.setWordCount(StringUtils.INSTANCE.wordCountFormat(AnalyzeRule.getString$default(analyzeRule, ruleWordCount, null, false, false, 14, null)));
                                    if (log) {
                                        DebugLog debugLog10 = debugLog;
                                        if (debugLog10 != null) {
                                            DebugLog.DefaultImpls.log$default(debugLog10, bookSource.getBookSourceUrl(), "\u2514" + searchBook2.getWordCount(), false, 4, null);
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    if (!log) break block48;
                                    DebugLog debugLog11 = debugLog;
                                    if (debugLog11 == null) break block48;
                                    DebugLog.DefaultImpls.log$default(debugLog11, bookSource.getBookSourceUrl(), "\u2514" + e.getLocalizedMessage(), false, 4, null);
                                }
                            }
                            if (log) {
                                DebugLog debugLog12 = debugLog;
                                if (debugLog12 != null) {
                                    DebugLog.DefaultImpls.log$default(debugLog12, bookSource.getBookSourceUrl(), "\u250c\u83b7\u53d6\u6700\u65b0\u7ae0\u8282", false, 4, null);
                                }
                            }
                            try {
                                searchBook2.setLatestChapterTitle(AnalyzeRule.getString$default(analyzeRule, ruleLastChapter, null, false, false, 14, null));
                                if (log) {
                                    DebugLog debugLog13 = debugLog;
                                    if (debugLog13 != null) {
                                        DebugLog.DefaultImpls.log$default(debugLog13, bookSource.getBookSourceUrl(), "\u2514" + searchBook2.getLatestChapterTitle(), false, 4, null);
                                    }
                                }
                            }
                            catch (Exception e) {
                                if (!log) break block49;
                                DebugLog debugLog14 = debugLog;
                                if (debugLog14 == null) break block49;
                                DebugLog.DefaultImpls.log$default(debugLog14, bookSource.getBookSourceUrl(), "\u2514" + e.getLocalizedMessage(), false, 4, null);
                            }
                        }
                        if (log) {
                            DebugLog debugLog15 = debugLog;
                            if (debugLog15 != null) {
                                DebugLog.DefaultImpls.log$default(debugLog15, bookSource.getBookSourceUrl(), "\u250c\u83b7\u53d6\u7b80\u4ecb", false, 4, null);
                            }
                        }
                        try {
                            searchBook2.setIntro(StringKt.htmlFormat(AnalyzeRule.getString$default(analyzeRule, ruleIntro, null, false, false, 14, null)));
                            if (log) {
                                DebugLog debugLog16 = debugLog;
                                if (debugLog16 != null) {
                                    DebugLog.DefaultImpls.log$default(debugLog16, bookSource.getBookSourceUrl(), "\u2514" + searchBook2.getIntro(), false, 4, null);
                                }
                            }
                        }
                        catch (Exception e) {
                            if (!log) break block50;
                            DebugLog debugLog17 = debugLog;
                            if (debugLog17 == null) break block50;
                            DebugLog.DefaultImpls.log$default(debugLog17, bookSource.getBookSourceUrl(), "\u2514" + e.getLocalizedMessage(), false, 4, null);
                        }
                    }
                    if (log) {
                        DebugLog debugLog18 = debugLog;
                        if (debugLog18 != null) {
                            DebugLog.DefaultImpls.log$default(debugLog18, bookSource.getBookSourceUrl(), "\u250c\u83b7\u53d6\u5c01\u9762\u94fe\u63a5", false, 4, null);
                        }
                    }
                    try {
                        String it = AnalyzeRule.getString$default(analyzeRule, ruleCoverUrl, null, false, false, 14, null);
                        boolean bl = false;
                        if (((CharSequence)it).length() > 0) {
                            searchBook2.setCoverUrl(NetworkUtils.INSTANCE.getAbsoluteURL(baseUrl, it));
                        }
                        if (log) {
                            DebugLog debugLog19 = debugLog;
                            if (debugLog19 != null) {
                                DebugLog.DefaultImpls.log$default(debugLog19, bookSource.getBookSourceUrl(), "\u2514" + searchBook2.getCoverUrl(), false, 4, null);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!log) break block51;
                        DebugLog debugLog20 = debugLog;
                        if (debugLog20 == null) break block51;
                        DebugLog.DefaultImpls.log$default(debugLog20, bookSource.getBookSourceUrl(), "\u2514" + e.getLocalizedMessage(), false, 4, null);
                    }
                }
                if (log) {
                    DebugLog debugLog21 = debugLog;
                    if (debugLog21 != null) {
                        DebugLog.DefaultImpls.log$default(debugLog21, bookSource.getBookSourceUrl(), "\u250c\u83b7\u53d6\u8be6\u60c5\u9875\u94fe\u63a5", false, 4, null);
                    }
                }
                searchBook2.setBookUrl(AnalyzeRule.getString$default(analyzeRule, ruleBookUrl, null, true, false, 10, null));
                if (((CharSequence)searchBook2.getBookUrl()).length() == 0) {
                    searchBook2.setBookUrl(baseUrl);
                }
                if (log) {
                    DebugLog debugLog22 = debugLog;
                    if (debugLog22 != null) {
                        DebugLog.DefaultImpls.log$default(debugLog22, bookSource.getBookSourceUrl(), "\u2514" + searchBook2.getBookUrl(), false, 4, null);
                    }
                }
                return searchBook2;
            }
            if (!log) break block52;
            DebugLog debugLog23 = debugLog;
            if (debugLog23 != null) {
                DebugLog.DefaultImpls.log$default(debugLog23, bookSource.getBookSourceUrl(), "\u2514\u4e66\u540d\u83b7\u53d6\u4e3a\u7a7a", false, 4, null);
            }
        }
        return null;
    }

    static /* synthetic */ SearchBook getSearchItem$default(BookList bookList, Object object, AnalyzeRule analyzeRule, BookSource bookSource, String string, String string2, boolean bl, List list, List list2, List list3, List list4, List list5, List list6, List list7, List list8, DebugLog debugLog, int n, Object object2) {
        if ((n & 0x4000) != 0) {
            debugLog = null;
        }
        return bookList.getSearchItem(object, analyzeRule, bookSource, string, string2, bl, list, list2, list3, list4, list5, list6, list7, list8, debugLog);
    }
}

