/*
 * Decompiled with CFR 0.152.
 */
package book.webBook.analyzeRule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\u0010\f\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 =2\u00020\u0001:\u0001=B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001cJ\u000e\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0003J\u001f\u0010 \u001a\u00020\u00052\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030!\"\u00020\u0003\u00a2\u0006\u0002\u0010\"J\u0014\u0010#\u001a\u00020\n2\n\u0010\u001f\u001a\u00020$\"\u00020%H\u0002J\u0016\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020%J\u0016\u0010)\u001a\u00020\u00052\u0006\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020%J2\u0010*\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u000ej\b\u0012\u0004\u0012\u00020\u0003`\u000f2\u0012\u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030!\"\u00020\u0003H\u0086\u0010\u00a2\u0006\u0002\u0010,J\u001e\u0010*\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u000ej\b\u0012\u0004\u0012\u00020\u0003`\u000fH\u0083\u0010\u00a2\u0006\u0002\b-J8\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u00032\b\b\u0002\u00100\u001a\u00020\n2\b\b\u0002\u00101\u001a\u00020\n2\u0014\u00102\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u000303J,\u0010.\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u00032\u0014\u00102\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u000303R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u000ej\b\u0012\u0004\u0012\u00020\u0003`\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR!\u00106\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u000ej\b\u0012\u0004\u0012\u00020\u0003`\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R#\u00109\u001a\u0014\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u00050:\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<\u00a8\u0006>"}, d2={"Lbook/webBook/analyzeRule/RuleAnalyzer;", "", "data", "", "code", "", "<init>", "(Ljava/lang/String;Z)V", "queue", "pos", "", "start", "startX", "rule", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "step", "elementsType", "getElementsType", "()Ljava/lang/String;", "setElementsType", "(Ljava/lang/String;)V", "innerType", "getInnerType", "()Z", "setInnerType", "(Z)V", "trim", "", "reSetPos", "consumeTo", "seq", "consumeToAny", "", "([Ljava/lang/String;)Z", "findToAny", "", "", "chompCodeBalanced", "open", "close", "chompRuleBalanced", "splitRule", "split", "([Ljava/lang/String;)Ljava/util/ArrayList;", "splitRuleNext", "innerRule", "inner", "startStep", "endStep", "fr", "Lkotlin/Function1;", "startStr", "endStr", "ruleTypeList", "getRuleTypeList", "()Ljava/util/ArrayList;", "chompBalanced", "Lkotlin/reflect/KFunction2;", "getChompBalanced", "()Lkotlin/reflect/KFunction;", "Companion", "book"})
public final class RuleAnalyzer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String queue;
    private int pos;
    private int start;
    private int startX;
    @NotNull
    private ArrayList<String> rule;
    private int step;
    @NotNull
    private String elementsType;
    private boolean innerType;
    @NotNull
    private final ArrayList<String> ruleTypeList;
    @NotNull
    private final KFunction<Boolean> chompBalanced;
    private static final char ESC = '\\';

    public RuleAnalyzer(@NotNull String data, boolean code) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.queue = data;
        this.rule = new ArrayList();
        this.elementsType = "";
        this.innerType = true;
        this.ruleTypeList = new ArrayList();
        this.chompBalanced = code ? (KFunction)new Function2<Character, Character, Boolean>((Object)this){

            public final Boolean invoke(char p0, char p1) {
                return ((RuleAnalyzer)this.receiver).chompCodeBalanced(p0, p1);
            }
        } : (KFunction)new Function2<Character, Character, Boolean>((Object)this){

            public final Boolean invoke(char p0, char p1) {
                return ((RuleAnalyzer)this.receiver).chompRuleBalanced(p0, p1);
            }
        };
    }

    public /* synthetic */ RuleAnalyzer(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(string, bl);
    }

    @NotNull
    public final String getElementsType() {
        return this.elementsType;
    }

    public final void setElementsType(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.elementsType = string;
    }

    public final boolean getInnerType() {
        return this.innerType;
    }

    public final void setInnerType(boolean bl) {
        this.innerType = bl;
    }

    public final void trim() {
        if (this.queue.charAt(this.pos) == '@' || Intrinsics.compare((int)this.queue.charAt(this.pos), (int)33) < 0) {
            int n = this.pos;
            this.pos = n + 1;
            while (this.queue.charAt(this.pos) == '@' || Intrinsics.compare((int)this.queue.charAt(this.pos), (int)33) < 0) {
                n = this.pos;
                this.pos = n + 1;
            }
            this.start = this.pos;
            this.startX = this.pos;
        }
    }

    public final void reSetPos() {
        this.pos = 0;
        this.startX = 0;
    }

    public final boolean consumeTo(@NotNull String seq) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
        this.start = this.pos;
        int offset = StringsKt.indexOf$default((CharSequence)this.queue, (String)seq, (int)this.pos, (boolean)false, (int)4, null);
        if (offset != -1) {
            this.pos = offset;
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean consumeToAny(String ... seq) {
        Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
        for (int pos = this.pos; pos != this.queue.length(); ++pos) {
            for (String s : seq) {
                if (!StringsKt.regionMatches$default((String)this.queue, (int)pos, (String)s, (int)0, (int)s.length(), (boolean)false, (int)16, null)) continue;
                this.step = s.length();
                this.pos = pos;
                return true;
            }
        }
        return false;
    }

    private final int findToAny(char ... seq) {
        for (int pos = this.pos; pos != this.queue.length(); ++pos) {
            for (char s : seq) {
                if (this.queue.charAt(pos) != s) continue;
                return pos;
            }
        }
        return -1;
    }

    public final boolean chompCodeBalanced(char open, char close) {
        boolean bl;
        int pos = this.pos;
        int depth = 0;
        int otherDepth = 0;
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        while (pos != this.queue.length()) {
            char c;
            if ((c = this.queue.charAt(pos++)) != '\\') {
                if (c == '\'' && !inDoubleQuote) {
                    inSingleQuote = !inSingleQuote;
                } else if (c == '\"' && !inSingleQuote) {
                    boolean bl2 = inDoubleQuote = !inDoubleQuote;
                }
                if (!inSingleQuote && !inDoubleQuote) {
                    if (c == '[') {
                        ++depth;
                    } else if (c == ']') {
                        --depth;
                    } else if (depth == 0) {
                        if (c == open) {
                            ++otherDepth;
                        } else if (c == close) {
                            --otherDepth;
                        }
                    }
                }
            } else {
                ++pos;
            }
            if (depth > 0 || otherDepth > 0) continue;
        }
        if (depth > 0 || otherDepth > 0) {
            bl = false;
        } else {
            this.pos = pos;
            bl = true;
        }
        return bl;
    }

    public final boolean chompRuleBalanced(char open, char close) {
        boolean bl;
        int pos = this.pos;
        int depth = 0;
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        while (pos != this.queue.length()) {
            char c;
            if ((c = this.queue.charAt(pos++)) == '\'' && !inDoubleQuote) {
                inSingleQuote = !inSingleQuote;
            } else if (c == '\"' && !inSingleQuote) {
                boolean bl2 = inDoubleQuote = !inDoubleQuote;
            }
            if (!inSingleQuote && !inDoubleQuote) {
                if (c == '\\') {
                    ++pos;
                } else if (c == open) {
                    ++depth;
                } else if (c == close) {
                    --depth;
                }
            }
            if (depth > 0) continue;
        }
        if (depth > 0) {
            bl = false;
        } else {
            this.pos = pos;
            bl = true;
        }
        return bl;
    }

    @NotNull
    public final ArrayList<String> splitRule(String ... split) {
        Intrinsics.checkNotNullParameter((Object)split, (String)"split");
        RuleAnalyzer ruleAnalyzer = this;
        while (true) {
            if (split.length == 1) {
                ArrayList<String> arrayList;
                ruleAnalyzer.elementsType = split[0];
                if (!ruleAnalyzer.consumeTo(ruleAnalyzer.elementsType)) {
                    Collection collection = ruleAnalyzer.rule;
                    String string = ruleAnalyzer.queue.substring(ruleAnalyzer.startX);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    collection.add(string);
                    arrayList = ruleAnalyzer.rule;
                } else {
                    ruleAnalyzer.step = ruleAnalyzer.elementsType.length();
                    arrayList = ruleAnalyzer.splitRuleNext();
                }
                return arrayList;
            }
            if (!ruleAnalyzer.consumeToAny(Arrays.copyOf(split, split.length))) {
                Collection collection = ruleAnalyzer.rule;
                String string = ruleAnalyzer.queue.substring(ruleAnalyzer.startX);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                collection.add(string);
                return ruleAnalyzer.rule;
            }
            int end = ruleAnalyzer.pos;
            ruleAnalyzer.pos = ruleAnalyzer.start;
            do {
                char next;
                Object[] objectArray;
                int st;
                if ((st = ruleAnalyzer.findToAny((char[])(objectArray = new char[]{'[', '('}))) == -1) {
                    objectArray = new String[1];
                    String string = ruleAnalyzer.queue.substring(ruleAnalyzer.startX, end);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    objectArray[0] = (char)string;
                    ruleAnalyzer.rule = CollectionsKt.arrayListOf((Object[])objectArray);
                    String string2 = ruleAnalyzer.queue.substring(end, end + ruleAnalyzer.step);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    ruleAnalyzer.elementsType = string2;
                    ruleAnalyzer.pos = end + ruleAnalyzer.step;
                    while (ruleAnalyzer.consumeTo(ruleAnalyzer.elementsType)) {
                        Collection collection = ruleAnalyzer.rule;
                        String string3 = ruleAnalyzer.queue.substring(ruleAnalyzer.start, ruleAnalyzer.pos);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                        collection.add(string3);
                        ruleAnalyzer.pos += ruleAnalyzer.step;
                    }
                    Collection collection = ruleAnalyzer.rule;
                    String string4 = ruleAnalyzer.queue.substring(ruleAnalyzer.pos);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                    collection.add(string4);
                    return ruleAnalyzer.rule;
                }
                if (st > end) {
                    ArrayList<String> arrayList;
                    objectArray = new String[1];
                    String string = ruleAnalyzer.queue.substring(ruleAnalyzer.startX, end);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    objectArray[0] = (char)string;
                    ruleAnalyzer.rule = CollectionsKt.arrayListOf((Object[])objectArray);
                    String string5 = ruleAnalyzer.queue.substring(end, end + ruleAnalyzer.step);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                    ruleAnalyzer.elementsType = string5;
                    ruleAnalyzer.pos = end + ruleAnalyzer.step;
                    while (ruleAnalyzer.consumeTo(ruleAnalyzer.elementsType) && ruleAnalyzer.pos < st) {
                        Collection collection = ruleAnalyzer.rule;
                        String string6 = ruleAnalyzer.queue.substring(ruleAnalyzer.start, ruleAnalyzer.pos);
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                        collection.add(string6);
                        ruleAnalyzer.pos += ruleAnalyzer.step;
                    }
                    if (ruleAnalyzer.pos > st) {
                        ruleAnalyzer.startX = ruleAnalyzer.start;
                        arrayList = ruleAnalyzer.splitRuleNext();
                    } else {
                        Collection collection = ruleAnalyzer.rule;
                        String string7 = ruleAnalyzer.queue.substring(ruleAnalyzer.pos);
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
                        collection.add(string7);
                        arrayList = ruleAnalyzer.rule;
                    }
                    return arrayList;
                }
                ruleAnalyzer.pos = st;
                char c = next = ruleAnalyzer.queue.charAt(ruleAnalyzer.pos) == '[' ? (char)']' : ')';
                if (((Boolean)((Function2)ruleAnalyzer.chompBalanced).invoke((Object)Character.valueOf(ruleAnalyzer.queue.charAt(ruleAnalyzer.pos)), (Object)Character.valueOf(next))).booleanValue()) continue;
                String string = ruleAnalyzer.queue.substring(0, ruleAnalyzer.start);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                throw new Error(string + "\u540e\u672a\u5e73\u8861");
            } while (end > ruleAnalyzer.pos);
            ruleAnalyzer.start = ruleAnalyzer.pos;
            RuleAnalyzer ruleAnalyzer2 = ruleAnalyzer;
            String[] stringArray = Arrays.copyOf(split, split.length);
            ruleAnalyzer = ruleAnalyzer2;
            split = stringArray;
        }
    }

    @JvmName(name="splitRuleNext")
    private final ArrayList<String> splitRuleNext() {
        RuleAnalyzer ruleAnalyzer = this;
        block0: while (true) {
            int end = ruleAnalyzer.pos;
            ruleAnalyzer.pos = ruleAnalyzer.start;
            do {
                char next;
                Object[] objectArray;
                Object object;
                int st;
                if ((st = ruleAnalyzer.findToAny((char)(object = new char[]{'[', '('}))) == -1) {
                    object = ruleAnalyzer.rule;
                    objectArray = new String[1];
                    Intrinsics.checkNotNullExpressionValue((Object)ruleAnalyzer.queue.substring(ruleAnalyzer.startX, end), (String)"substring(...)");
                    CollectionsKt.addAll((Collection)object, (Object[])objectArray);
                    ruleAnalyzer.pos = end + ruleAnalyzer.step;
                    while (ruleAnalyzer.consumeTo(ruleAnalyzer.elementsType)) {
                        Collection collection = ruleAnalyzer.rule;
                        String string = ruleAnalyzer.queue.substring(ruleAnalyzer.start, ruleAnalyzer.pos);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        collection.add(string);
                        ruleAnalyzer.pos += ruleAnalyzer.step;
                    }
                    Collection collection = ruleAnalyzer.rule;
                    String string = ruleAnalyzer.queue.substring(ruleAnalyzer.pos);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    collection.add(string);
                    return ruleAnalyzer.rule;
                }
                if (st > end) {
                    object = ruleAnalyzer.rule;
                    objectArray = new String[1];
                    Intrinsics.checkNotNullExpressionValue((Object)ruleAnalyzer.queue.substring(ruleAnalyzer.startX, end), (String)"substring(...)");
                    CollectionsKt.addAll((Collection)object, (Iterable)CollectionsKt.arrayListOf((Object[])objectArray));
                    ruleAnalyzer.pos = end + ruleAnalyzer.step;
                    while (ruleAnalyzer.consumeTo(ruleAnalyzer.elementsType) && ruleAnalyzer.pos < st) {
                        Collection collection = ruleAnalyzer.rule;
                        String string = ruleAnalyzer.queue.substring(ruleAnalyzer.start, ruleAnalyzer.pos);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        collection.add(string);
                        ruleAnalyzer.pos += ruleAnalyzer.step;
                    }
                    if (ruleAnalyzer.pos > st) {
                        ruleAnalyzer.startX = ruleAnalyzer.start;
                        continue block0;
                    }
                    Collection collection = ruleAnalyzer.rule;
                    String string = ruleAnalyzer.queue.substring(ruleAnalyzer.pos);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    collection.add(string);
                    return ruleAnalyzer.rule;
                }
                ruleAnalyzer.pos = st;
                char c = next = ruleAnalyzer.queue.charAt(ruleAnalyzer.pos) == '[' ? (char)']' : ')';
                if (((Boolean)((Function2)ruleAnalyzer.chompBalanced).invoke((Object)Character.valueOf(ruleAnalyzer.queue.charAt(ruleAnalyzer.pos)), (Object)Character.valueOf(next))).booleanValue()) continue;
                String string = ruleAnalyzer.queue.substring(0, ruleAnalyzer.start);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                throw new Error(string + "\u540e\u672a\u5e73\u8861");
            } while (end > ruleAnalyzer.pos);
            ruleAnalyzer.start = ruleAnalyzer.pos;
            if (!ruleAnalyzer.consumeTo(ruleAnalyzer.elementsType)) break;
        }
        Collection collection = ruleAnalyzer.rule;
        String string = ruleAnalyzer.queue.substring(ruleAnalyzer.startX);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        collection.add(string);
        return ruleAnalyzer.rule;
    }

    @NotNull
    public final String innerRule(@NotNull String inner, int startStep, int endStep, @NotNull Function1<? super String, String> fr) {
        String string;
        Intrinsics.checkNotNullParameter((Object)inner, (String)"inner");
        Intrinsics.checkNotNullParameter(fr, (String)"fr");
        StringBuilder st = new StringBuilder();
        while (this.consumeTo(inner)) {
            int posPre = this.pos;
            if (this.chompCodeBalanced('{', '}')) {
                String string2 = this.queue.substring(posPre + startStep, this.pos - endStep);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                String frv = (String)fr.invoke((Object)string2);
                CharSequence charSequence = frv;
                if (!(charSequence == null || charSequence.length() == 0)) {
                    String string3 = this.queue.substring(this.startX, posPre);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    st.append(string3 + frv);
                    this.startX = this.pos;
                    continue;
                }
            }
            this.pos += inner.length();
        }
        if (this.startX == 0) {
            string = "";
        } else {
            StringBuilder stringBuilder;
            StringBuilder $this$innerRule_u24lambda_u240 = stringBuilder = st;
            boolean bl = false;
            String string4 = this.queue.substring(this.startX);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            $this$innerRule_u24lambda_u240.append(string4);
            String string5 = stringBuilder.toString();
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
        }
        return string;
    }

    public static /* synthetic */ String innerRule$default(RuleAnalyzer ruleAnalyzer, String string, int n, int n2, Function1 function1, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 1;
        }
        if ((n3 & 4) != 0) {
            n2 = 1;
        }
        return ruleAnalyzer.innerRule(string, n, n2, (Function1<? super String, String>)function1);
    }

    @NotNull
    public final String innerRule(@NotNull String startStr, @NotNull String endStr, @NotNull Function1<? super String, String> fr) {
        String string;
        Intrinsics.checkNotNullParameter((Object)startStr, (String)"startStr");
        Intrinsics.checkNotNullParameter((Object)endStr, (String)"endStr");
        Intrinsics.checkNotNullParameter(fr, (String)"fr");
        StringBuilder st = new StringBuilder();
        while (this.consumeTo(startStr)) {
            this.pos += startStr.length();
            int posPre = this.pos;
            if (!this.consumeTo(endStr)) continue;
            String string2 = this.queue.substring(posPre, this.pos);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String frv = (String)fr.invoke((Object)string2);
            String string3 = this.queue.substring(this.startX, posPre - startStr.length());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            st.append(string3 + frv);
            this.pos += endStr.length();
            this.startX = this.pos;
        }
        if (this.startX == 0) {
            string = this.queue;
        } else {
            StringBuilder stringBuilder;
            StringBuilder $this$innerRule_u24lambda_u241 = stringBuilder = st;
            boolean bl = false;
            String string4 = this.queue.substring(this.startX);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            $this$innerRule_u24lambda_u241.append(string4);
            String string5 = stringBuilder.toString();
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
        }
        return string;
    }

    @NotNull
    public final ArrayList<String> getRuleTypeList() {
        return this.ruleTypeList;
    }

    @NotNull
    public final KFunction<Boolean> getChompBalanced() {
        return this.chompBalanced;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lbook/webBook/analyzeRule/RuleAnalyzer$Companion;", "", "<init>", "()V", "ESC", "", "book"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

