/*
 * Decompiled with CFR 0.152.
 */
package book.webBook.localBook;

import book.model.Book;
import book.model.BookChapter;
import book.util.ExtKt;
import book.util.FileUtils;
import book.util.MD5Utils;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000  2\u00020\u0001:\u0001 B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u0016\u001a\u001e\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0001\u0018\u00010\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0019H\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001fH\u0002R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R(\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0001\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0002"}, d2={"Lbook/webBook/localBook/CbzFile;", "", "book", "Lbook/model/Book;", "<init>", "(Lbook/model/Book;)V", "getBook", "()Lbook/model/Book;", "setBook", "info", "", "", "getInfo", "()Ljava/util/Map;", "setInfo", "(Ljava/util/Map;)V", "cover", "Ljava/io/InputStream;", "getCover", "()Ljava/io/InputStream;", "setCover", "(Ljava/io/InputStream;)V", "parseBookInfo", "Lkotlin/Pair;", "upBookInfo", "", "updateCover", "getContent", "chapter", "Lbook/model/BookChapter;", "getChapterList", "Ljava/util/ArrayList;", "Companion"})
public final class CbzFile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Book book;
    @Nullable
    private Map<String, Object> info;
    @Nullable
    private InputStream cover;
    @Nullable
    private static CbzFile cFile;

    public CbzFile(@NotNull Book book) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        this.book = book;
    }

    @NotNull
    public final Book getBook() {
        return this.book;
    }

    public final void setBook(@NotNull Book book) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"<set-?>");
        this.book = book;
    }

    @Nullable
    public final Map<String, Object> getInfo() {
        return this.info;
    }

    public final void setInfo(@Nullable Map<String, Object> map) {
        this.info = map;
    }

    @Nullable
    public final InputStream getCover() {
        return this.cover;
    }

    public final void setCover(@Nullable InputStream inputStream) {
        this.cover = inputStream;
    }

    private final Pair<Map<String, Object>, InputStream> parseBookInfo() {
        if (this.cover != null || this.info != null) {
            return new Pair(this.info, (Object)this.cover);
        }
        ZipFile zf = new ZipFile(this.book.getLocalFile());
        Enumeration<? extends ZipEntry> entries = zf.entries();
        Object[] objectArray = new String[]{"jpg", "jpeg", "gif", "png", "bmp", "webp", "svg"};
        List imageExt = CollectionsKt.listOf((Object[])objectArray);
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry;
            Intrinsics.checkNotNull((Object)entries.nextElement(), (String)"null cannot be cast to non-null type java.util.zip.ZipEntry");
            if (!zipEntry.isDirectory()) {
                String name = zipEntry.getName();
                if (name.equals("ComicInfo.xml")) {
                    InputStream inputStream;
                    InputStream inputStream2 = inputStream = zf.getInputStream(zipEntry);
                    Intrinsics.checkNotNull((Object)inputStream2);
                    this.info = ExtKt.xml2map(inputStream2);
                } else if (this.cover == null) {
                    String ext;
                    Intrinsics.checkNotNull((Object)name);
                    Intrinsics.checkNotNullExpressionValue((Object)ExtKt.getFileExtetion$default(name, null, 2, null).toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
                    if (imageExt.contains(ext)) {
                        this.cover = zf.getInputStream(zipEntry);
                    }
                }
            }
            if (this.cover == null || this.info == null) continue;
        }
        return new Pair(this.info, (Object)this.cover);
    }

    private final void upBookInfo() {
        Pair<Map<String, Object>, InputStream> result = this.parseBookInfo();
        if (result.getFirst() != null) {
            Map info;
            Object object;
            Object object2 = result.getFirst();
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
            Map bookInfo = (Map)object2;
            Map map = (Map)bookInfo.get("ComicInfo");
            if (map == null) {
                map = null;
            }
            if ((object = (info = map)) == null || (object = object.get("Title")) == null) {
                object = this.book.getName();
            }
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            this.book.setName((String)object);
            Object object3 = info;
            if (object3 == null || (object3 = object3.get("Writer")) == null) {
                object3 = this.book.getAuthor();
            }
            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.String");
            this.book.setAuthor((String)object3);
        }
        this.updateCover();
    }

    private final void updateCover() {
        Pair<Map<String, Object>, InputStream> result;
        String coverFile = MD5Utils.INSTANCE.md5Encode16(this.book.getBookUrl()) + ".jpg";
        String[] stringArray = new String[]{this.book.getUserNameSpace(), "covers", coverFile};
        String relativeCoverUrl = ((Object)Paths.get("assets", stringArray)).toString();
        this.book.setCoverUrl("/" + relativeCoverUrl);
        String[] stringArray2 = new String[]{"storage", relativeCoverUrl};
        String coverUrl = ((Object)Paths.get(this.book.workRoot(), stringArray2)).toString();
        if (!new File(coverUrl).exists() && (result = this.parseBookInfo()).getSecond() != null) {
            Object object = result.getSecond();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.io.InputStream");
            InputStream coverStream = (InputStream)object;
            FileUtils.INSTANCE.writeInputStream(coverUrl, coverStream);
        }
    }

    private final String getContent(BookChapter chapter) {
        return "";
    }

    private final ArrayList<BookChapter> getChapterList() {
        ArrayList<BookChapter> chapterList = new ArrayList<BookChapter>();
        ZipFile zf = new ZipFile(this.book.getLocalFile());
        Enumeration<? extends ZipEntry> entries = zf.entries();
        ArrayList<String> imageFileList = new ArrayList<String>();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry;
            Intrinsics.checkNotNull((Object)entries.nextElement(), (String)"null cannot be cast to non-null type java.util.zip.ZipEntry");
            if (zipEntry.isDirectory()) continue;
            String name = zipEntry.getName();
            Intrinsics.checkNotNull((Object)name);
            if (StringsKt.endsWith$default((String)name, (String)".xml", (boolean)false, (int)2, null)) continue;
            imageFileList.add(name);
        }
        CollectionsKt.sort((List)imageFileList);
        int n = imageFileList.size();
        for (int i = 0; i < n; ++i) {
            Object e = imageFileList.get(i);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            String name = (String)e;
            BookChapter chapter = new BookChapter(null, null, false, null, null, 0, null, null, false, false, null, null, null, null, null, null, null, null, 262143, null);
            chapter.setTitle(name);
            chapter.setIndex(i);
            chapter.setBookUrl(this.book.getBookUrl());
            chapter.setUrl(name);
            chapterList.add(chapter);
        }
        BookChapter bookChapter = (BookChapter)CollectionsKt.lastOrNull((List)chapterList);
        this.book.setLatestChapterTitle(bookChapter != null ? bookChapter.getTitle() : null);
        this.book.setTotalChapterNum(chapterList.size());
        return chapterList;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000bJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\u0011\u001a\u00020\u0012R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lbook/webBook/localBook/CbzFile$Companion;", "", "<init>", "()V", "cFile", "Lbook/webBook/localBook/CbzFile;", "getCbzFile", "book", "Lbook/model/Book;", "getChapterList", "Ljava/util/ArrayList;", "Lbook/model/BookChapter;", "getContent", "", "chapter", "upBookInfo", "", "onlyCover", ""})
    public static final class Companion {
        private Companion() {
        }

        private final synchronized CbzFile getCbzFile(Book book) {
            Object object;
            if (cFile == null || !Intrinsics.areEqual((Object)((object = cFile) != null && (object = ((CbzFile)object).getBook()) != null ? ((Book)object).getBookUrl() : null), (Object)book.getBookUrl())) {
                cFile = new CbzFile(book);
                CbzFile cbzFile = cFile;
                Intrinsics.checkNotNull((Object)cbzFile);
                return cbzFile;
            }
            CbzFile cbzFile = cFile;
            if (cbzFile != null) {
                cbzFile.setBook(book);
            }
            CbzFile cbzFile2 = cFile;
            Intrinsics.checkNotNull((Object)cbzFile2);
            return cbzFile2;
        }

        @NotNull
        public final synchronized ArrayList<BookChapter> getChapterList(@NotNull Book book) {
            Intrinsics.checkNotNullParameter((Object)book, (String)"book");
            return this.getCbzFile(book).getChapterList();
        }

        @Nullable
        public final synchronized String getContent(@NotNull Book book, @NotNull BookChapter chapter) {
            Intrinsics.checkNotNullParameter((Object)book, (String)"book");
            Intrinsics.checkNotNullParameter((Object)chapter, (String)"chapter");
            return this.getCbzFile(book).getContent(chapter);
        }

        public final synchronized void upBookInfo(@NotNull Book book, boolean onlyCover) {
            Intrinsics.checkNotNullParameter((Object)book, (String)"book");
            if (onlyCover) {
                this.getCbzFile(book).updateCover();
                return;
            }
            this.getCbzFile(book).upBookInfo();
        }

        public static /* synthetic */ void upBookInfo$default(Companion companion, Book book, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            companion.upBookInfo(book, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

