/*
 * Decompiled with CFR 0.152.
 */
package book.webBook.localBook;

import book.model.Book;
import book.model.BookChapter;
import book.util.FileUtils;
import book.util.HtmlFormatter;
import book.util.MD5Utils;
import book.webBook.localBook.EpubFileKt;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import me.ag2s.epublib.domain.EpubBook;
import me.ag2s.epublib.domain.Resource;
import me.ag2s.epublib.domain.Resources;
import me.ag2s.epublib.domain.SpineReference;
import me.ag2s.epublib.epub.EpubReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 )2\u00020\u0001:\u0001)B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u000f\u001a\u0004\u0018\u00010\fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J$\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00112\b\u0010\u001a\u001a\u0004\u0018\u00010\u0011H\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u0011H\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0006\u0010 \u001a\u00020\u001fJ\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00130\"J\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00130\"J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00130\"2\b\b\u0002\u0010%\u001a\u00020&J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130\"2\b\b\u0002\u0010(\u001a\u00020&R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\u0004\u0018\u00010\f8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0002"}, d2={"Lbook/webBook/localBook/EpubFile;", "", "book", "Lbook/model/Book;", "<init>", "(Lbook/model/Book;)V", "getBook", "()Lbook/model/Book;", "setBook", "mCharset", "Ljava/nio/charset/Charset;", "epubBook", "Lme/ag2s/epublib/domain/EpubBook;", "getEpubBook", "()Lme/ag2s/epublib/domain/EpubBook;", "readEpub", "getContent", "", "chapter", "Lbook/model/BookChapter;", "getContent2", "getBody", "Lorg/jsoup/nodes/Element;", "res", "Lme/ag2s/epublib/domain/Resource;", "startFragmentId", "endFragmentId", "getImage", "Ljava/io/InputStream;", "href", "upBookInfo", "", "updateCover", "getChapterListBySpine", "Ljava/util/ArrayList;", "getChapterList", "getChapterListBySpinAndToc", "useTocTitle", "", "getChapterListByTocAndSpin", "useSpinTitle", "Companion"})
@SourceDebugExtension(value={"SMAP\nEpubFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EpubFile.kt\nbook/webBook/localBook/EpubFile\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,499:1\n1863#2,2:500\n1872#2,3:502\n1863#2,2:505\n1863#2,2:507\n1872#2,3:509\n1872#2,3:512\n*S KotlinDebug\n*F\n+ 1 EpubFile.kt\nbook/webBook/localBook/EpubFile\n*L\n190#1:500,2\n197#1:502,3\n200#1:505,2\n225#1:507,2\n368#1:509,3\n402#1:512,3\n*E\n"})
public final class EpubFile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Book book;
    @NotNull
    private Charset mCharset;
    @Nullable
    private EpubBook epubBook;
    @Nullable
    private static EpubFile eFile;

    public EpubFile(@NotNull Book book) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        this.book = book;
        this.updateCover();
        Charset charset = Charset.defaultCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset(...)");
        this.mCharset = charset;
        try {
            Unit unit;
            EpubBook epubBook = this.getEpubBook();
            if (epubBook != null) {
                EpubBook it = epubBook;
                boolean bl = false;
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
        catch (Exception e) {
            e.printStackTrace();
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public final Book getBook() {
        return this.book;
    }

    public final void setBook(@NotNull Book book) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"<set-?>");
        this.book = book;
    }

    private final EpubBook getEpubBook() {
        if (this.epubBook != null) {
            return this.epubBook;
        }
        this.epubBook = this.readEpub();
        return this.epubBook;
    }

    private final EpubBook readEpub() {
        try {
            File file = this.book.getLocalFile();
            return new EpubReader().readEpubLazy(new ZipFile(file), "utf-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String getContent(BookChapter chapter) {
        Element it;
        Object object = this.getEpubBook();
        if (object == null || (object = ((EpubBook)object).getContents()) == null) {
            return null;
        }
        Object contents = object;
        String nextChapterFirstResourceHref = StringsKt.substringBeforeLast$default((String)chapter.getUrl(), (String)"#", null, (int)2, null);
        String currentChapterFirstResourceHref = StringsKt.substringBeforeLast$default((String)chapter.getUrl(), (String)"#", null, (int)2, null);
        boolean isLastChapter = StringsKt.isBlank((CharSequence)nextChapterFirstResourceHref);
        String startFragmentId = chapter.getStartFragmentId();
        String endFragmentId = chapter.getEndFragmentId();
        Elements elements = new Elements();
        boolean findChapterFirstSource = false;
        Object object2 = endFragmentId;
        boolean includeNextChapterResource = !(object2 == null || StringsKt.isBlank((CharSequence)object2));
        object2 = contents.iterator();
        while (object2.hasNext()) {
            Resource res = (Resource)object2.next();
            if (!findChapterFirstSource) {
                if (!Intrinsics.areEqual((Object)currentChapterFirstResourceHref, (Object)res.getHref())) continue;
                findChapterFirstSource = true;
                Intrinsics.checkNotNull((Object)res);
                elements.add((Object)this.getBody(res, startFragmentId, endFragmentId));
                if (!isLastChapter && Intrinsics.areEqual((Object)res.getHref(), (Object)nextChapterFirstResourceHref)) break;
                continue;
            }
            if (!Intrinsics.areEqual((Object)nextChapterFirstResourceHref, (Object)res.getHref())) {
                Intrinsics.checkNotNull((Object)res);
                elements.add((Object)this.getBody(res, null, null));
                continue;
            }
            if (!includeNextChapterResource) break;
            Intrinsics.checkNotNull((Object)res);
            elements.add((Object)this.getBody(res, null, endFragmentId));
            break;
        }
        for (int i = 1; i < 7; ++i) {
            Elements elements2 = elements.select("h" + i);
            Intrinsics.checkNotNullExpressionValue((Object)elements2, (String)"select(...)");
            Iterable $this$forEach$iv = (Iterable)elements2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Element it2 = (Element)element$iv;
                boolean bl = false;
                it2.remove();
            }
        }
        elements.select("title").remove();
        elements.select("[style*=display:none]").remove();
        Elements elements3 = elements.select("img[src=\"cover.jpeg\"]");
        Intrinsics.checkNotNullExpressionValue((Object)elements3, (String)"select(...)");
        Iterable $this$forEachIndexed$iv = (Iterable)elements3;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void it3;
            int it2;
            if ((it2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Element bl = (Element)item$iv;
            int i = it2;
            boolean bl2 = false;
            if (i <= 0) continue;
            it3.remove();
        }
        Elements elements4 = elements.select("img");
        Intrinsics.checkNotNullExpressionValue((Object)elements4, (String)"select(...)");
        Iterable $this$forEach$iv = (Iterable)elements4;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Element)element$iv;
            boolean bl = false;
            String string = it.attr("src");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attr(...)");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"cover", (boolean)false, (int)2, null)) {
                Object url;
                String string2 = this.book.getCoverUrl();
                if (string2 == null) {
                    string2 = "";
                }
                if (!StringsKt.startsWith$default((String)(url = string2), (String)"http", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)url, (String)"https", (boolean)false, (int)2, null)) {
                    url = "http/" + (String)url;
                }
                it.attr("src", (String)url);
                continue;
            }
            EpubBook epubBook = this.getEpubBook();
            Intrinsics.checkNotNull((Object)epubBook);
            Resource resource = epubBook.getResources().getResourceMap().get(it.attr("src"));
            byte[] data = (byte[])(resource != null ? resource.getData() : null);
            if (data == null) continue;
            String coverFile = MD5Utils.INSTANCE.md5Encode16(this.book.getBookUrl() + it.attr("src")) + ".jpg";
            String[] bl2 = new String[]{this.book.getUserNameSpace(), "covers", coverFile};
            String relativeCoverUrl = ((Object)Paths.get("assets", bl2)).toString();
            String url = "/" + relativeCoverUrl;
            String[] stringArray = new String[]{"storage", relativeCoverUrl};
            String coverUrl = ((Object)Paths.get(this.book.workRoot(), stringArray)).toString();
            if (!new File(coverUrl).exists()) {
                FileUtils.INSTANCE.writeBytes(coverUrl, data);
            }
            if (!StringsKt.startsWith$default((String)url, (String)"http", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)url, (String)"https", (boolean)false, (int)2, null)) {
                url = "http/" + url;
            }
            it.attr("src", url);
        }
        Elements elements5 = elements.select("img");
        Intrinsics.checkNotNullExpressionValue((Object)elements5, (String)"select(...)");
        $this$forEach$iv = (Iterable)elements5;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Element)element$iv;
            boolean bl = false;
            if (it.attributesSize() <= 1) continue;
            String src = it.attr("src");
            it.clearAttributes();
            it.attr("src", src);
        }
        long tag = 4L;
        if (this.book.getDelTag(tag)) {
            elements.select("rp, rt").remove();
        }
        String html = elements.outerHtml();
        return HtmlFormatter.formatKeepImg$default(HtmlFormatter.INSTANCE, html, null, 2, null);
    }

    private final String getContent2(BookChapter chapter) {
        if (StringsKt.contains$default((CharSequence)chapter.getUrl(), (CharSequence)"titlepage.xhtml", (boolean)false, (int)2, null)) {
            return "<img src=\"cover.jpeg\" />";
        }
        EpubBook epubBook = this.getEpubBook();
        if (epubBook != null) {
            EpubBook epubBook2 = epubBook;
            boolean bl = false;
            String nextUrl = chapter.getVariable("nextUrl");
            String startFragmentId = chapter.getStartFragmentId();
            String endFragmentId = chapter.getEndFragmentId();
            Elements elements = new Elements();
            boolean isChapter = false;
            for (Resource res : epubBook2.getContents()) {
                if (Intrinsics.areEqual((Object)StringsKt.substringBeforeLast$default((String)chapter.getUrl(), (String)"#", null, (int)2, null), (Object)res.getHref())) {
                    Intrinsics.checkNotNull((Object)res);
                    elements.add((Object)this.getBody(res, startFragmentId, endFragmentId));
                    isChapter = true;
                    String string = nextUrl;
                    if (!Intrinsics.areEqual((Object)res.getHref(), string != null ? StringsKt.substringBeforeLast$default((String)string, (String)"#", null, (int)2, null) : null)) continue;
                    break;
                }
                if (!isChapter) continue;
                String string = nextUrl;
                if (Intrinsics.areEqual((Object)res.getHref(), string != null ? StringsKt.substringBeforeLast$default((String)string, (String)"#", null, (int)2, null) : null)) break;
                Intrinsics.checkNotNull((Object)res);
                elements.add((Object)this.getBody(res, startFragmentId, endFragmentId));
            }
            String html = elements.outerHtml();
            long tag = 4L;
            if (this.book.getDelTag(tag)) {
                CharSequence charSequence = html;
                Intrinsics.checkNotNull((Object)charSequence);
                charSequence = charSequence;
                Regex regex = new Regex("<ruby>\\s?([\\u4e00-\\u9fa5])\\s?.*?</ruby>");
                String string = "$1";
                html = regex.replace(charSequence, string);
            }
            return HtmlFormatter.formatKeepImg$default(HtmlFormatter.INSTANCE, html, null, 2, null);
        }
        return null;
    }

    private final Element getBody(Resource res, String startFragmentId, String endFragmentId) {
        long tag;
        Element element;
        byte[] byArray = res.getData();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getData(...)");
        Object object = byArray;
        Charset charset = this.mCharset;
        Element body = Jsoup.parse((String)new String((byte[])object, charset)).body();
        object = startFragmentId;
        if (!(object == null || StringsKt.isBlank((CharSequence)object)) && (element = body.getElementById(startFragmentId)) != null && (element = element.previousElementSiblings()) != null) {
            element.remove();
        }
        if (!((object = (Object)endFragmentId) == null || StringsKt.isBlank((CharSequence)object)) && !Intrinsics.areEqual((Object)endFragmentId, (Object)startFragmentId)) {
            Element element2 = body.getElementById(endFragmentId);
            if (element2 != null) {
                Element $this$getBody_u24lambda_u246 = element2;
                boolean bl = false;
                $this$getBody_u24lambda_u246.nextElementSiblings().remove();
                $this$getBody_u24lambda_u246.remove();
            }
        }
        if (this.book.getDelTag(tag = 2L)) {
            body.getElementsByTag("h1").remove();
            body.getElementsByTag("h2").remove();
            body.getElementsByTag("h3").remove();
            body.getElementsByTag("h4").remove();
            body.getElementsByTag("h5").remove();
            body.getElementsByTag("h6").remove();
        }
        Elements children = body.children();
        children.select("script").remove();
        children.select("style").remove();
        Intrinsics.checkNotNull((Object)body);
        return body;
    }

    private final InputStream getImage(String href) {
        String abHref = StringsKt.replace$default((String)href, (String)"../", (String)"", (boolean)false, (int)4, null);
        Serializable serializable = this.getEpubBook();
        return serializable != null && (serializable = ((EpubBook)serializable).getResources()) != null && (serializable = ((Resources)serializable).getByHref(abHref)) != null ? ((Resource)serializable).getInputStream() : null;
    }

    private final void upBookInfo() {
        if (this.getEpubBook() == null) {
            eFile = null;
            this.book.setIntro("\u4e66\u7c4d\u5bfc\u5165\u5f02\u5e38");
        } else {
            EpubBook epubBook = this.getEpubBook();
            Intrinsics.checkNotNull((Object)epubBook);
            me.ag2s.epublib.domain.Metadata metadata = epubBook.getMetadata();
            this.book.setName(metadata.getFirstTitle());
            if (((CharSequence)this.book.getName()).length() == 0) {
                this.book.setName(StringsKt.replace$default((String)this.book.getOriginName(), (String)".epub", (String)"", (boolean)false, (int)4, null));
            }
            if (metadata.getAuthors().size() > 0) {
                String string = metadata.getAuthors().get(0).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                CharSequence charSequence = string;
                Regex regex = new Regex("^, |, $");
                String string2 = "";
                String author = regex.replace(charSequence, string2);
                this.book.setAuthor(author);
            }
            if (metadata.getDescriptions().size() > 0) {
                this.book.setIntro(Jsoup.parse((String)metadata.getDescriptions().get(0)).text());
            }
            this.updateCover();
        }
    }

    public final void updateCover() {
        String coverFile = MD5Utils.INSTANCE.md5Encode16(this.book.getBookUrl()) + ".jpg";
        String[] stringArray = new String[]{this.book.getUserNameSpace(), "covers", coverFile};
        String relativeCoverUrl = ((Object)Paths.get("assets", stringArray)).toString();
        this.book.setCoverUrl("/" + relativeCoverUrl);
        String[] stringArray2 = new String[]{"storage", relativeCoverUrl};
        String coverUrl = ((Object)Paths.get(this.book.workRoot(), stringArray2)).toString();
        if (!new File(coverUrl).exists()) {
            EpubBook epubBook = this.getEpubBook();
            Intrinsics.checkNotNull((Object)epubBook);
            byte[] byArray = epubBook.getCoverImage().getData();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getData(...)");
            FileUtils.INSTANCE.writeBytes(coverUrl, byArray);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public final ArrayList<BookChapter> getChapterListBySpine() {
        block8: {
            chapterList = new ArrayList<BookChapter>();
            v0 = this.getEpubBook();
            if (v0 == null || (v0 = v0.getSpine()) == null || (v0 = v0.getSpineReferences()) == null) break block8;
            $this$forEachIndexed$iv = (Iterable)v0;
            $i$f$forEachIndexed = false;
            index$iv = 0;
            for (T item$iv : $this$forEachIndexed$iv) {
                if ((var7_7 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                var8_8 = (SpineReference)item$iv;
                index = var7_7;
                $i$a$-forEachIndexed-EpubFile$getChapterListBySpine$1 = false;
                resource = spinResource.getResource();
                title = resource.getTitle();
                var13_13 = title;
                if (var13_13 == null || var13_13.length() == 0) {
                    try {
                        Intrinsics.checkNotNullExpressionValue((Object)resource.getData(), (String)"getData(...)");
                        var15_16 = this.mCharset;
                        doc = Jsoup.parse((String)new String(var14_15 /* !! */ , var15_16));
                        elements = doc.getElementsByTag("title");
                        if (elements.size() > 0) {
                            title = ((Element)elements.get(0)).text();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                chapter = new BookChapter(null, null, false, null, null, 0, null, null, false, false, null, null, null, null, null, null, null, null, 262143, null);
                chapter.setIndex(index);
                chapter.setBookUrl(this.book.getBookUrl());
                chapter.setUrl(resource.getHref());
                if (index != 0) ** GOTO lbl-1000
                var14_15 /* !! */  = (byte[])title;
                Intrinsics.checkNotNull((Object)var14_15 /* !! */ );
                if (((CharSequence)var14_15 /* !! */ ).length() == 0) {
                    chapter.setTitle("\u5c01\u9762");
                } else lbl-1000:
                // 2 sources

                {
                    chapter.setTitle(title);
                }
                chapterList.add(chapter);
            }
        }
        v1 = (BookChapter)CollectionsKt.lastOrNull((List)chapterList);
        this.book.setLatestChapterTitle(v1 != null ? v1.getTitle() : null);
        this.book.setTotalChapterNum(chapterList.size());
        return chapterList;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public final ArrayList<BookChapter> getChapterList() {
        block8: {
            chapterList = new ArrayList<BookChapter>();
            v0 = this.getEpubBook();
            if (v0 == null || (v0 = v0.getTableOfContents()) == null || (v0 = v0.getAllUniqueResources()) == null) break block8;
            $this$forEachIndexed$iv = (Iterable)v0;
            $i$f$forEachIndexed = false;
            index$iv = 0;
            for (T item$iv : $this$forEachIndexed$iv) {
                if ((var7_7 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                var8_8 = (Resource)item$iv;
                index = var7_7;
                $i$a$-forEachIndexed-EpubFile$getChapterList$1 = false;
                title = resource.getTitle();
                var12_12 = title;
                if (var12_12 == null || var12_12.length() == 0) {
                    try {
                        Intrinsics.checkNotNullExpressionValue((Object)resource.getData(), (String)"getData(...)");
                        var14_15 = this.mCharset;
                        doc = Jsoup.parse((String)new String(var13_14 /* !! */ , var14_15));
                        elements = doc.getElementsByTag("title");
                        if (elements.size() > 0) {
                            title = ((Element)elements.get(0)).text();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                chapter = new BookChapter(null, null, false, null, null, 0, null, null, false, false, null, null, null, null, null, null, null, null, 262143, null);
                chapter.setIndex(index);
                chapter.setBookUrl(this.book.getBookUrl());
                chapter.setUrl(resource.getHref());
                if (index != 0) ** GOTO lbl-1000
                var13_14 /* !! */  = (byte[])title;
                Intrinsics.checkNotNull((Object)var13_14 /* !! */ );
                if (((CharSequence)var13_14 /* !! */ ).length() == 0) {
                    chapter.setTitle("\u5c01\u9762");
                } else lbl-1000:
                // 2 sources

                {
                    chapter.setTitle(title);
                }
                chapterList.add(chapter);
            }
        }
        v1 = (BookChapter)CollectionsKt.lastOrNull((List)chapterList);
        this.book.setLatestChapterTitle(v1 != null ? v1.getTitle() : null);
        this.book.setTotalChapterNum(chapterList.size());
        return chapterList;
    }

    @NotNull
    public final ArrayList<BookChapter> getChapterListBySpinAndToc(boolean useTocTitle) {
        int i;
        ArrayList<BookChapter> tocChapterList = this.getChapterList();
        ArrayList<BookChapter> spinChapterList = this.getChapterListBySpine();
        if (spinChapterList.size() == 0) {
            return tocChapterList;
        }
        if (tocChapterList.size() == 0) {
            return spinChapterList;
        }
        Map titleMap = new LinkedHashMap();
        int n = tocChapterList.size();
        for (i = 0; i < n; ++i) {
            String string = tocChapterList.get(i).getUrl();
            BookChapter bookChapter = tocChapterList.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)bookChapter, (String)"get(...)");
            titleMap.put(string, bookChapter);
        }
        n = spinChapterList.size();
        for (i = 0; i < n; ++i) {
            BookChapter chapter;
            Intrinsics.checkNotNullExpressionValue((Object)spinChapterList.get(i), (String)"get(...)");
            BookChapter tocChapter = (BookChapter)titleMap.get(chapter.getUrl());
            if (tocChapter == null || !(((CharSequence)tocChapter.getTitle()).length() > 0) || !useTocTitle && !(((CharSequence)chapter.getTitle()).length() == 0)) continue;
            chapter.setTitle(tocChapter.getTitle());
        }
        BookChapter bookChapter = (BookChapter)CollectionsKt.lastOrNull((List)spinChapterList);
        this.book.setLatestChapterTitle(bookChapter != null ? bookChapter.getTitle() : null);
        this.book.setTotalChapterNum(spinChapterList.size());
        return spinChapterList;
    }

    public static /* synthetic */ ArrayList getChapterListBySpinAndToc$default(EpubFile epubFile, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return epubFile.getChapterListBySpinAndToc(bl);
    }

    @NotNull
    public final ArrayList<BookChapter> getChapterListByTocAndSpin(boolean useSpinTitle) {
        int i;
        ArrayList<BookChapter> tocChapterList = this.getChapterList();
        ArrayList<BookChapter> spinChapterList = this.getChapterListBySpine();
        if (tocChapterList.size() == 0) {
            return spinChapterList;
        }
        if (spinChapterList.size() == 0) {
            return tocChapterList;
        }
        Map titleMap = new LinkedHashMap();
        int n = spinChapterList.size();
        for (i = 0; i < n; ++i) {
            String string = spinChapterList.get(i).getUrl();
            BookChapter bookChapter = spinChapterList.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)bookChapter, (String)"get(...)");
            titleMap.put(string, bookChapter);
        }
        n = tocChapterList.size();
        for (i = 0; i < n; ++i) {
            BookChapter chapter;
            Intrinsics.checkNotNullExpressionValue((Object)tocChapterList.get(i), (String)"get(...)");
            BookChapter tocChapter = (BookChapter)titleMap.get(chapter.getUrl());
            if (tocChapter == null || !(((CharSequence)tocChapter.getTitle()).length() > 0) || !useSpinTitle && !(((CharSequence)chapter.getTitle()).length() == 0)) continue;
            chapter.setTitle(tocChapter.getTitle());
        }
        BookChapter bookChapter = (BookChapter)CollectionsKt.lastOrNull((List)tocChapterList);
        this.book.setLatestChapterTitle(bookChapter != null ? bookChapter.getTitle() : null);
        this.book.setTotalChapterNum(tocChapterList.size());
        return tocChapterList;
    }

    public static /* synthetic */ ArrayList getChapterListByTocAndSpin$default(EpubFile epubFile, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return epubFile.getChapterListByTocAndSpin(bl);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000bJ\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\rJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\u0014\u001a\u00020\u0015R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lbook/webBook/localBook/EpubFile$Companion;", "", "<init>", "()V", "eFile", "Lbook/webBook/localBook/EpubFile;", "getEFile", "book", "Lbook/model/Book;", "getChapterList", "Ljava/util/ArrayList;", "Lbook/model/BookChapter;", "getContent", "", "chapter", "getImage", "Ljava/io/InputStream;", "href", "upBookInfo", "", "onlyCover", ""})
    public static final class Companion {
        private Companion() {
        }

        private final synchronized EpubFile getEFile(Book book) {
            Object object;
            if (eFile == null || !Intrinsics.areEqual((Object)((object = eFile) != null && (object = ((EpubFile)object).getBook()) != null ? ((Book)object).getBookUrl() : null), (Object)book.getBookUrl())) {
                eFile = new EpubFile(book);
                EpubFile epubFile = eFile;
                Intrinsics.checkNotNull((Object)epubFile);
                return epubFile;
            }
            EpubFile epubFile = eFile;
            if (epubFile != null) {
                epubFile.setBook(book);
            }
            EpubFile epubFile2 = eFile;
            Intrinsics.checkNotNull((Object)epubFile2);
            return epubFile2;
        }

        @NotNull
        public final synchronized ArrayList<BookChapter> getChapterList(@NotNull Book book) {
            Intrinsics.checkNotNullParameter((Object)book, (String)"book");
            if (((CharSequence)book.getTocUrl()).length() == 0) {
                book.setTocUrl("spin+toc");
            }
            EpubFile epubFile = this.getEFile(book);
            return switch (book.getTocUrl()) {
                case "toc" -> {
                    EpubFileKt.access$getLogger$p().info("epubFile.getChapterList");
                    yield epubFile.getChapterList();
                }
                case "spin" -> {
                    EpubFileKt.access$getLogger$p().info("epubFile.getChapterListBySpine");
                    yield epubFile.getChapterListBySpine();
                }
                case "spin<toc" -> {
                    EpubFileKt.access$getLogger$p().info("epubFile.getChapterListBySpinAndToc true");
                    yield epubFile.getChapterListBySpinAndToc(true);
                }
                case "spin+toc" -> {
                    EpubFileKt.access$getLogger$p().info("epubFile.getChapterListBySpinAndToc");
                    yield EpubFile.getChapterListBySpinAndToc$default(epubFile, false, 1, null);
                }
                case "toc+spin" -> {
                    EpubFileKt.access$getLogger$p().info("epubFile.getChapterListByTocAndSpin");
                    yield EpubFile.getChapterListByTocAndSpin$default(epubFile, false, 1, null);
                }
                case "toc<spin" -> {
                    EpubFileKt.access$getLogger$p().info("epubFile.getChapterListByTocAndSpin true");
                    yield epubFile.getChapterListByTocAndSpin(true);
                }
                default -> {
                    EpubFileKt.access$getLogger$p().info("epubFile.getChapterListBySpinAndToc");
                    yield EpubFile.getChapterListBySpinAndToc$default(epubFile, false, 1, null);
                }
            };
        }

        @Nullable
        public final synchronized String getContent(@NotNull Book book, @NotNull BookChapter chapter) {
            Intrinsics.checkNotNullParameter((Object)book, (String)"book");
            Intrinsics.checkNotNullParameter((Object)chapter, (String)"chapter");
            return this.getEFile(book).getContent(chapter);
        }

        @Nullable
        public final synchronized InputStream getImage(@NotNull Book book, @NotNull String href) {
            Intrinsics.checkNotNullParameter((Object)book, (String)"book");
            Intrinsics.checkNotNullParameter((Object)href, (String)"href");
            return this.getEFile(book).getImage(href);
        }

        public final synchronized void upBookInfo(@NotNull Book book, boolean onlyCover) {
            Intrinsics.checkNotNullParameter((Object)book, (String)"book");
            if (onlyCover) {
                this.getEFile(book).updateCover();
                return;
            }
            this.getEFile(book).upBookInfo();
        }

        public static /* synthetic */ void upBookInfo$default(Companion companion, Book book, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            companion.upBookInfo(book, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

