/*
 * Decompiled with CFR 0.152.
 */
package book.webBook.localBook;

import book.model.Book;
import book.model.BookChapter;
import book.model.TxtTocRule;
import book.util.EncodingDetect;
import book.util.MD5Utils;
import book.util.StringUtils;
import book.util.Utf8BomUtils;
import book.util.help.DefaultData;
import book.webBook.localBook.LocalBook;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u0011J\"\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J,\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u00112\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0016H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0002"}, d2={"Lbook/webBook/localBook/TextFile;", "", "book", "Lbook/model/Book;", "<init>", "(Lbook/model/Book;)V", "blank", "", "bufferSize", "", "maxLengthWithNoToc", "maxLengthWithToc", "charset", "Ljava/nio/charset/Charset;", "getChapterList", "Ljava/util/ArrayList;", "Lbook/model/BookChapter;", "Lkotlin/collections/ArrayList;", "analyze", "pattern", "Ljava/util/regex/Pattern;", "fileStart", "", "fileEnd", "getTocRule", "content", "", "getTocRules", "", "Lbook/model/TxtTocRule;", "Companion"})
@SourceDebugExtension(value={"SMAP\nTextFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextFile.kt\nbook/webBook/localBook/TextFile\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,364:1\n1872#2,3:365\n1872#2,3:369\n774#2:372\n865#2,2:373\n1#3:368\n*S KotlinDebug\n*F\n+ 1 TextFile.kt\nbook/webBook/localBook/TextFile\n*L\n80#1:365,3\n159#1:369,3\n359#1:372\n359#1:373,2\n*E\n"})
public final class TextFile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Book book;
    private final byte blank;
    private final int bufferSize;
    private final int maxLengthWithNoToc;
    private final int maxLengthWithToc;
    @NotNull
    private Charset charset;

    public TextFile(@NotNull Book book) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        this.book = book;
        this.blank = (byte)10;
        this.bufferSize = 512000;
        this.maxLengthWithNoToc = 10240;
        this.maxLengthWithToc = 102400;
        this.charset = this.book.fileCharset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final ArrayList<BookChapter> getChapterList() throws FileNotFoundException {
        if (this.book.getCharset() == null || StringsKt.isBlank((CharSequence)this.book.getTocUrl())) {
            Closeable closeable = LocalBook.INSTANCE.getBookInputStream(this.book);
            Throwable throwable = null;
            try {
                InputStream bis = (InputStream)closeable;
                boolean bl = false;
                byte[] buffer = new byte[this.bufferSize];
                int length = bis.read(buffer);
                CharSequence charSequence = this.book.getCharset();
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                    byte[] byArray = Arrays.copyOf(buffer, length);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
                    this.book.setCharset(EncodingDetect.INSTANCE.getEncode(byArray));
                }
                this.charset = this.book.fileCharset();
                if (StringsKt.isBlank((CharSequence)this.book.getTocUrl())) {
                    String blockContent = new String(buffer, 0, length, this.charset);
                    Object object = this.getTocRule(blockContent);
                    if (object == null || (object = ((Pattern)object).pattern()) == null) {
                        object = "";
                    }
                    this.book.setTocUrl((String)object);
                }
                bis = Unit.INSTANCE;
            }
            catch (Throwable bl) {
                throwable = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        Pattern pattern = Pattern.compile(this.book.getTocUrl(), 8);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        ArrayList<BookChapter> toc = this.analyze(pattern);
        Iterable $this$forEachIndexed$iv = toc;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void bookChapter;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            BookChapter bookChapter2 = (BookChapter)item$iv;
            int index = n;
            boolean bl = false;
            bookChapter.setIndex(index);
            bookChapter.setBookUrl(this.book.getBookUrl());
            bookChapter.setUrl(MD5Utils.INSTANCE.md5Encode16(this.book.getOriginName() + index + bookChapter.getTitle()));
        }
        this.book.setLatestChapterTitle(((BookChapter)CollectionsKt.last((List)toc)).getTitle());
        this.book.setTotalChapterNum(toc.size());
        return toc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final ArrayList<BookChapter> analyze(Pattern pattern) {
        v0 = pattern;
        var2_2 = v0 != null ? v0.pattern() : null;
        if (var2_2 == null || var2_2.length() == 0) {
            return TextFile.analyze$default(this, 0L, 0L, 3, null);
        }
        if (pattern == null) {
            return TextFile.analyze$default(this, 0L, 0L, 3, null);
        }
        toc = new ArrayList<BookChapter>();
        var3_3 = LocalBook.INSTANCE.getBookInputStream(this.book);
        var4_4 = null;
        try {
            bis = (InputStream)var3_3;
            $i$a$-use-TextFile$analyze$1 = false;
            blockContent = null;
            curOffset = 0L;
            length = 0;
            buffer = new byte[this.bufferSize];
            bufferStart = 3;
            bis.read(buffer, 0, 3);
            if (Utf8BomUtils.INSTANCE.hasBom(buffer)) {
                bufferStart = 0;
                curOffset = 3L;
            }
            while (true) {
                it = var13_14 = bis.read(buffer, bufferStart, this.bufferSize - bufferStart);
                $i$a$-also-TextFile$analyze$1$1 = false;
                length = it;
                if (var13_14 <= 0) break;
                end = bufferStart + length;
                if (end == this.bufferSize) {
                    for (i = bufferStart + length - 1; -1 < i; --i) {
                        if (buffer[i] != this.blank) continue;
                        end = i;
                        break;
                    }
                }
                blockContent = new String(buffer, 0, end, this.charset);
                ArraysKt.copyInto((byte[])buffer, (byte[])buffer, (int)0, (int)end, (int)(bufferStart + length));
                bufferStart = bufferStart + length - end;
                length = end;
                seekPos = 0;
                Intrinsics.checkNotNullExpressionValue((Object)pattern.matcher(blockContent), (String)"matcher(...)");
                while (matcher.find()) {
                    block27: {
                        block26: {
                            chapterStart = matcher.start();
                            Intrinsics.checkNotNullExpressionValue((Object)blockContent.substring(seekPos, chapterStart), (String)"substring(...)");
                            v1 = chapterContent.getBytes(this.charset);
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getBytes(...)");
                            chapterLength = v1.length;
                            v2 = (BookChapter)CollectionsKt.lastOrNull((List)toc);
                            v3 = v2 != null && (v2 = v2.getStart()) != null ? v2.longValue() : (lastStart = curOffset);
                            if (!this.book.getSplitLongChapter() || curOffset + (long)chapterLength - lastStart <= (long)this.maxLengthWithToc) break block26;
                            if ((BookChapter)CollectionsKt.lastOrNull((List)toc) != null) {
                                $i$a$-let-TextFile$analyze$1$2 = false;
                                it.setEnd(it.getStart());
                            }
                            v4 = (BookChapter)CollectionsKt.lastOrNull((List)toc);
                            lastTitle = v4 != null ? v4.getTitle() : null;
                            v5 = lastTitle;
                            if (v5 == null) ** GOTO lbl-1000
                            v6 = v5.getBytes(this.charset);
                            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getBytes(...)");
                            v5 = v6;
                            if (v6 != null) {
                                v7 = ((Object)v5).length;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v7 = 0;
                            }
                            lastTitleLength = v7;
                            chapters = this.analyze(lastStart + (long)lastTitleLength, curOffset + (long)chapterLength);
                            if (lastTitle != null) {
                                $i$a$-let-TextFile$analyze$1$3 = false;
                                $this$forEachIndexed$iv = chapters;
                                $i$f$forEachIndexed = false;
                                index$iv = 0;
                                for (T item$iv : $this$forEachIndexed$iv) {
                                    if ((var32_36 = index$iv++) < 0) {
                                        CollectionsKt.throwIndexOverflow();
                                    }
                                    var33_37 = (BookChapter)item$iv;
                                    index = var32_36;
                                    $i$a$-forEachIndexed-TextFile$analyze$1$3$1 = false;
                                    bookChapter.setTitle(lastTitle + "(" + (index + 1) + ")");
                                }
                            }
                            toc.addAll((Collection<BookChapter>)chapters);
                            curChapter = new BookChapter(null, null, false, null, null, 0, null, null, false, false, null, null, null, null, null, null, null, null, 262143, null);
                            curChapter.setTitle(matcher.group());
                            curChapter.setStart(curOffset + (long)chapterLength);
                            v8 = toc.add(curChapter);
                            break block27;
                        }
                        if (seekPos == 0 && chapterStart != 0) {
                            if (toc.isEmpty()) {
                                if (((CharSequence)StringUtils.INSTANCE.trim(chapterContent)).length() > 0) {
                                    qyChapter = new BookChapter(null, null, false, null, null, 0, null, null, false, false, null, null, null, null, null, null, null, null, 262143, null);
                                    qyChapter.setTitle("\u524d\u8a00");
                                    qyChapter.setStart(curOffset);
                                    qyChapter.setEnd(Long.valueOf(chapterLength));
                                    toc.add(qyChapter);
                                }
                                curChapter = new BookChapter(null, null, false, null, null, 0, null, null, false, false, null, null, null, null, null, null, null, null, 262143, null);
                                curChapter.setTitle(matcher.group());
                                curChapter.setStart(Long.valueOf(chapterLength));
                                v8 = toc.add(curChapter);
                            } else {
                                lastChapter = (BookChapter)CollectionsKt.last((List)toc);
                                lastChapter.setVolume(StringsKt.isBlank((CharSequence)StringsKt.substringAfter$default((String)chapterContent, (String)lastChapter.getTitle(), null, (int)2, null)));
                                v9 = lastChapter.getEnd();
                                Intrinsics.checkNotNull((Object)v9);
                                lastChapter.setEnd(v9 + (long)chapterLength);
                                curChapter = new BookChapter(null, null, false, null, null, 0, null, null, false, false, null, null, null, null, null, null, null, null, 262143, null);
                                curChapter.setTitle(matcher.group());
                                curChapter.setStart(lastChapter.getEnd());
                                v8 = toc.add(curChapter);
                            }
                        } else if (((Collection)toc).isEmpty() == false) {
                            lastChapter = (BookChapter)CollectionsKt.last((List)toc);
                            lastChapter.setVolume(StringsKt.isBlank((CharSequence)StringsKt.substringAfter$default((String)chapterContent, (String)lastChapter.getTitle(), null, (int)2, null)));
                            v10 = lastChapter.getStart();
                            Intrinsics.checkNotNull((Object)v10);
                            v11 = v10;
                            v12 = chapterContent.getBytes(this.charset);
                            Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"getBytes(...)");
                            lastChapter.setEnd(v11 + (long)v12.length);
                            curChapter = new BookChapter(null, null, false, null, null, 0, null, null, false, false, null, null, null, null, null, null, null, null, 262143, null);
                            curChapter.setTitle(matcher.group());
                            curChapter.setStart(lastChapter.getEnd());
                            v8 = toc.add(curChapter);
                        } else {
                            curChapter = new BookChapter(null, null, false, null, null, 0, null, null, false, false, null, null, null, null, null, null, null, null, 262143, null);
                            curChapter.setTitle(matcher.group());
                            curChapter.setStart(curOffset);
                            curChapter.setEnd(curOffset);
                            v8 = toc.add(curChapter);
                        }
                    }
                    seekPos += chapterContent.length();
                }
                curOffset += (long)length;
                v13 = (BookChapter)CollectionsKt.lastOrNull((List)toc);
                if (v13 == null) continue;
                v13.setEnd(curOffset);
            }
            var5_5 = Unit.INSTANCE;
        }
        catch (Throwable var6_7) {
            var4_4 = var6_7;
            throw var6_7;
        }
        finally {
            CloseableKt.closeFinally((Closeable)var3_3, (Throwable)var4_4);
        }
        System.gc();
        return toc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ArrayList<BookChapter> analyze(long fileStart, long fileEnd) {
        ArrayList<BookChapter> toc = new ArrayList<BookChapter>();
        Closeable closeable = LocalBook.INSTANCE.getBookInputStream(this.book);
        Throwable throwable = null;
        try {
            Object object;
            InputStream bis = (InputStream)closeable;
            boolean bl = false;
            int blockPos = 0;
            long curOffset = 0L;
            int chapterPos = 0;
            int length = 0;
            byte[] buffer = new byte[this.bufferSize];
            int bufferStart = 0;
            bufferStart = 3;
            if (fileStart == 0L) {
                bis.read(buffer, 0, 3);
                if (Utf8BomUtils.INSTANCE.hasBom(buffer)) {
                    bufferStart = 0;
                    curOffset = 3L;
                }
            } else {
                bis.skip(fileStart);
                curOffset = fileStart;
                bufferStart = 0;
            }
            while (fileEnd - curOffset - (long)bufferStart > 0L) {
                int n;
                int it = n = bis.read(buffer, bufferStart, (int)Math.min((long)(this.bufferSize - bufferStart), fileEnd - curOffset - (long)bufferStart));
                boolean bl2 = false;
                length = it;
                if (n <= 0) break;
                ++blockPos;
                int chapterOffset = 0;
                int strLength = length += bufferStart;
                chapterPos = 0;
                while (strLength > 0) {
                    ++chapterPos;
                    if (strLength > this.maxLengthWithNoToc) {
                        int end = length;
                        int n2 = length;
                        for (int i = chapterOffset + this.maxLengthWithNoToc; i < n2; ++i) {
                            if (buffer[i] != this.blank) continue;
                            end = i;
                            break;
                        }
                        BookChapter chapter = new BookChapter(null, null, false, null, null, 0, null, null, false, false, null, null, null, null, null, null, null, null, 262143, null);
                        chapter.setTitle("\u7b2c" + blockPos + "\u7ae0(" + chapterPos + ")");
                        Object object2 = (BookChapter)CollectionsKt.lastOrNull((List)toc);
                        if (object2 == null || (object2 = ((BookChapter)object2).getEnd()) == null) {
                            object2 = curOffset;
                        }
                        chapter.setStart((Long)object2);
                        Long l = chapter.getStart();
                        Intrinsics.checkNotNull((Object)l);
                        chapter.setEnd(l + (long)end - (long)chapterOffset);
                        toc.add(chapter);
                        strLength -= end - chapterOffset;
                        chapterOffset = end;
                        continue;
                    }
                    ArraysKt.copyInto((byte[])buffer, (byte[])buffer, (int)0, (int)(length - strLength), (int)length);
                    length -= strLength;
                    bufferStart = strLength;
                    strLength = 0;
                }
                curOffset += (long)length;
            }
            if (bufferStart > 100 || toc.isEmpty()) {
                BookChapter chapter = new BookChapter(null, null, false, null, null, 0, null, null, false, false, null, null, null, null, null, null, null, null, 262143, null);
                chapter.setTitle("\u7b2c" + blockPos + "\u7ae0(" + chapterPos + ")");
                Object object3 = (BookChapter)CollectionsKt.lastOrNull((List)toc);
                if (object3 == null || (object3 = ((BookChapter)object3).getEnd()) == null) {
                    object3 = curOffset;
                }
                chapter.setStart((Long)object3);
                Long l = chapter.getStart();
                Intrinsics.checkNotNull((Object)l);
                chapter.setEnd(l + (long)bufferStart);
                object = toc.add(chapter);
            } else {
                BookChapter bookChapter = (BookChapter)CollectionsKt.lastOrNull((List)toc);
                if (bookChapter != null) {
                    BookChapter it = bookChapter;
                    boolean bl3 = false;
                    Long l = it.getEnd();
                    Intrinsics.checkNotNull((Object)l);
                    it.setEnd(l + (long)bufferStart);
                    object = Unit.INSTANCE;
                } else {
                    object = null;
                }
            }
            Unit unit = object;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return toc;
    }

    static /* synthetic */ ArrayList analyze$default(TextFile textFile, long l, long l2, int n, Object object) {
        if ((n & 1) != 0) {
            l = 0L;
        }
        if ((n & 2) != 0) {
            l2 = Long.MAX_VALUE;
        }
        return textFile.analyze(l, l2);
    }

    private final Pattern getTocRule(String content) {
        List rules = CollectionsKt.reversed((Iterable)this.getTocRules());
        int maxCs = 1;
        Pattern tocPattern = null;
        for (TxtTocRule tocRule : rules) {
            Pattern pattern;
            Intrinsics.checkNotNullExpressionValue((Object)Pattern.compile(tocRule.getRule(), 8), (String)"compile(...)");
            Matcher matcher = pattern.matcher(content);
            int cs = 0;
            while (matcher.find()) {
                ++cs;
            }
            if (cs < maxCs) continue;
            maxCs = cs;
            tocPattern = pattern;
        }
        return tocPattern;
    }

    /*
     * WARNING - void declaration
     */
    private final List<TxtTocRule> getTocRules() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = DefaultData.INSTANCE.getTxtTocRules();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TxtTocRule it = (TxtTocRule)element$iv$iv;
            boolean bl = false;
            if (!it.getEnable()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lbook/webBook/localBook/TextFile$Companion;", "", "<init>", "()V", "getChapterList", "Ljava/util/ArrayList;", "Lbook/model/BookChapter;", "Lkotlin/collections/ArrayList;", "book", "Lbook/model/Book;", "getContent", "", "bookChapter"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ArrayList<BookChapter> getChapterList(@NotNull Book book) throws FileNotFoundException {
            Intrinsics.checkNotNullParameter((Object)book, (String)"book");
            return new TextFile(book).getChapterList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final String getContent(@NotNull Book book, @NotNull BookChapter bookChapter) throws FileNotFoundException {
            Intrinsics.checkNotNullParameter((Object)book, (String)"book");
            Intrinsics.checkNotNullParameter((Object)bookChapter, (String)"bookChapter");
            Long l = bookChapter.getEnd();
            Intrinsics.checkNotNull((Object)l);
            long l2 = l;
            Long l3 = bookChapter.getStart();
            Intrinsics.checkNotNull((Object)l3);
            int count = (int)(l2 - l3);
            byte[] buffer = new byte[count];
            Object object = LocalBook.INSTANCE.getBookInputStream(book);
            Throwable throwable = null;
            try {
                InputStream bis = (InputStream)object;
                boolean bl = false;
                Long l4 = bookChapter.getStart();
                Intrinsics.checkNotNull((Object)l4);
                bis.skip(l4);
                int n = bis.read(buffer);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            if (book.getCharset() == null) {
                book.setCharset(EncodingDetect.INSTANCE.getEncode(book.getLocalFile()));
            }
            object = StringsKt.substringAfter$default((String)new String(buffer, book.fileCharset()), (String)bookChapter.getTitle(), null, (int)2, null);
            throwable = new Regex("^[\\n\\s]+");
            String string = "\u3000\u3000";
            return throwable.replace((CharSequence)object, string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

