/*
 * Decompiled with CFR 0.152.
 */
package book.webBook.localBook;

import book.model.Book;
import book.model.BookChapter;
import book.util.FileUtils;
import book.util.MD5Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ag2s.umdlib.domain.UmdBook;
import me.ag2s.umdlib.domain.UmdChapters;
import me.ag2s.umdlib.domain.UmdHeader;
import me.ag2s.umdlib.umd.UmdReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\r\u001a\u0004\u0018\u00010\nH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u000fH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0016H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0012H\u0002R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u0018\u0010\t\u001a\u0004\u0018\u00010\n8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0002"}, d2={"Lbook/webBook/localBook/UmdFile;", "", "book", "Lbook/model/Book;", "<init>", "(Lbook/model/Book;)V", "getBook", "()Lbook/model/Book;", "setBook", "umdBook", "Lme/ag2s/umdlib/domain/UmdBook;", "getUmdBook", "()Lme/ag2s/umdlib/domain/UmdBook;", "readUmd", "upBookInfo", "", "updateCover", "getContent", "", "chapter", "Lbook/model/BookChapter;", "getChapterList", "Ljava/util/ArrayList;", "getImage", "Ljava/io/InputStream;", "href", "Companion"})
@SourceDebugExtension(value={"SMAP\nUmdFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UmdFile.kt\nbook/webBook/localBook/UmdFile\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,146:1\n1872#2,3:147\n*S KotlinDebug\n*F\n+ 1 UmdFile.kt\nbook/webBook/localBook/UmdFile\n*L\n127#1:147,3\n*E\n"})
public final class UmdFile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Book book;
    @Nullable
    private UmdBook umdBook;
    @Nullable
    private static UmdFile uFile;

    public UmdFile(@NotNull Book book) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        this.book = book;
        try {
            Unit unit;
            UmdBook umdBook = this.getUmdBook();
            if (umdBook != null) {
                UmdBook it = umdBook;
                boolean bl = false;
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
        catch (Exception e) {
            e.printStackTrace();
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public final Book getBook() {
        return this.book;
    }

    public final void setBook(@NotNull Book book) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"<set-?>");
        this.book = book;
    }

    private final UmdBook getUmdBook() {
        if (this.umdBook != null) {
            return this.umdBook;
        }
        this.umdBook = this.readUmd();
        return this.umdBook;
    }

    private final UmdBook readUmd() {
        FileInputStream input = new FileInputStream(new File(this.book.getBookUrl()));
        return new UmdReader().read(input);
    }

    private final void upBookInfo() {
        if (this.getUmdBook() == null) {
            uFile = null;
            this.book.setIntro("\u4e66\u7c4d\u5bfc\u5165\u5f02\u5e38");
        } else {
            UmdBook umdBook = this.getUmdBook();
            Intrinsics.checkNotNull((Object)umdBook);
            UmdHeader hd = umdBook.getHeader();
            this.book.setName(hd.getTitle());
            this.book.setAuthor(hd.getAuthor());
            this.book.setKind(hd.getBookType());
            this.updateCover();
        }
    }

    private final void updateCover() {
        if (this.getUmdBook() == null) {
            uFile = null;
            return;
        }
        String coverFile = MD5Utils.INSTANCE.md5Encode16(this.book.getBookUrl()) + ".jpg";
        String[] stringArray = new String[]{this.book.getUserNameSpace(), "covers", coverFile};
        String relativeCoverUrl = ((Object)Paths.get("assets", stringArray)).toString();
        this.book.setCoverUrl("/" + relativeCoverUrl);
        String[] stringArray2 = new String[]{"storage", relativeCoverUrl};
        String coverUrl = ((Object)Paths.get(this.book.workRoot(), stringArray2)).toString();
        if (!new File(coverUrl).exists()) {
            UmdBook umdBook = this.getUmdBook();
            Intrinsics.checkNotNull((Object)umdBook);
            byte[] byArray = umdBook.getCover().getCoverData();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getCoverData(...)");
            FileUtils.INSTANCE.writeBytes(coverUrl, byArray);
        }
    }

    private final String getContent(BookChapter chapter) {
        Object object = this.getUmdBook();
        return object != null && (object = ((UmdBook)object).getChapters()) != null ? ((UmdChapters)object).getContentString(chapter.getIndex()) : null;
    }

    private final ArrayList<BookChapter> getChapterList() {
        ArrayList<BookChapter> chapterList = new ArrayList<BookChapter>();
        Object object = this.getUmdBook();
        if (object != null && (object = ((UmdBook)object).getChapters()) != null && (object = ((UmdChapters)object).getTitles()) != null) {
            Iterable $this$forEachIndexed$iv = (Iterable)object;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                byte[] cfr_ignored_0 = (byte[])item$iv;
                int index = n;
                boolean bl = false;
                UmdBook umdBook = this.getUmdBook();
                Intrinsics.checkNotNull((Object)umdBook);
                String title = umdBook.getChapters().getTitle(index);
                BookChapter chapter = new BookChapter(null, null, false, null, null, 0, null, null, false, false, null, null, null, null, null, null, null, null, 262143, null);
                chapter.setTitle(title);
                chapter.setIndex(index);
                chapter.setBookUrl(this.book.getBookUrl());
                chapter.setUrl(String.valueOf(index));
                System.out.println("UMD" + chapter.getUrl());
                chapterList.add(chapter);
            }
        }
        BookChapter bookChapter = (BookChapter)CollectionsKt.lastOrNull((List)chapterList);
        this.book.setLatestChapterTitle(bookChapter != null ? bookChapter.getTitle() : null);
        this.book.setTotalChapterNum(chapterList.size());
        return chapterList;
    }

    private final InputStream getImage(String href) {
        return null;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000bJ\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\rJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\u0014\u001a\u00020\u0015R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lbook/webBook/localBook/UmdFile$Companion;", "", "<init>", "()V", "uFile", "Lbook/webBook/localBook/UmdFile;", "getUFile", "book", "Lbook/model/Book;", "getChapterList", "Ljava/util/ArrayList;", "Lbook/model/BookChapter;", "getContent", "", "chapter", "getImage", "Ljava/io/InputStream;", "href", "upBookInfo", "", "onlyCover", ""})
    public static final class Companion {
        private Companion() {
        }

        private final synchronized UmdFile getUFile(Book book) {
            Object object;
            if (uFile == null || !Intrinsics.areEqual((Object)((object = uFile) != null && (object = ((UmdFile)object).getBook()) != null ? ((Book)object).getBookUrl() : null), (Object)book.getBookUrl())) {
                uFile = new UmdFile(book);
                UmdFile umdFile = uFile;
                Intrinsics.checkNotNull((Object)umdFile);
                return umdFile;
            }
            UmdFile umdFile = uFile;
            if (umdFile != null) {
                umdFile.setBook(book);
            }
            UmdFile umdFile2 = uFile;
            Intrinsics.checkNotNull((Object)umdFile2);
            return umdFile2;
        }

        @NotNull
        public final synchronized ArrayList<BookChapter> getChapterList(@NotNull Book book) {
            Intrinsics.checkNotNullParameter((Object)book, (String)"book");
            return this.getUFile(book).getChapterList();
        }

        @Nullable
        public final synchronized String getContent(@NotNull Book book, @NotNull BookChapter chapter) {
            Intrinsics.checkNotNullParameter((Object)book, (String)"book");
            Intrinsics.checkNotNullParameter((Object)chapter, (String)"chapter");
            return this.getUFile(book).getContent(chapter);
        }

        @Nullable
        public final synchronized InputStream getImage(@NotNull Book book, @NotNull String href) {
            Intrinsics.checkNotNullParameter((Object)book, (String)"book");
            Intrinsics.checkNotNullParameter((Object)href, (String)"href");
            return this.getUFile(book).getImage(href);
        }

        public final synchronized void upBookInfo(@NotNull Book book, boolean onlyCover) {
            Intrinsics.checkNotNullParameter((Object)book, (String)"book");
            if (onlyCover) {
                this.getUFile(book).updateCover();
                return;
            }
            this.getUFile(book).upBookInfo();
        }

        public static /* synthetic */ void upBookInfo$default(Companion companion, Book book, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            companion.upBookInfo(book, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

