/*
 * Decompiled with CFR 0.152.
 */
package book.webBook.rss;

import book.model.RssArticle;
import book.model.RssSource;
import book.util.NetworkUtils;
import book.webBook.DebugLog;
import book.webBook.analyzeRule.AnalyzeRule;
import book.webBook.analyzeRule.RuleData;
import book.webBook.exception.NoStackTraceException;
import book.webBook.rss.RssParserDefault;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J`\u0010\u0004\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00052\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0086@\u00a2\u0006\u0002\u0010\u0013J\u00a2\u0001\u0010\u0014\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0010\u0010\u001d\u001a\f\u0012\b\u0012\u00060\u001fR\u00020\u00190\u001e2\u0010\u0010 \u001a\f\u0012\b\u0012\u00060\u001fR\u00020\u00190\u001e2\u0010\u0010!\u001a\f\u0012\b\u0012\u00060\u001fR\u00020\u00190\u001e2\u0010\u0010\"\u001a\f\u0012\b\u0012\u00060\u001fR\u00020\u00190\u001e2\u0010\u0010#\u001a\f\u0012\b\u0012\u00060\u001fR\u00020\u00190\u001e2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002\u00a8\u0006$"}, d2={"Lbook/webBook/rss/RssParserByRule;", "", "<init>", "()V", "parseXML", "Lkotlin/Pair;", "", "Lbook/model/RssArticle;", "", "sortName", "sortUrl", "redirectUrl", "body", "rssSource", "Lbook/model/RssSource;", "ruleData", "Lbook/webBook/analyzeRule/RuleData;", "debugLogger", "Lbook/webBook/DebugLog;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lbook/model/RssSource;Lbook/webBook/analyzeRule/RuleData;Lbook/webBook/DebugLog;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getItem", "sourceUrl", "userid", "item", "analyzeRule", "Lbook/webBook/analyzeRule/AnalyzeRule;", "variable", "log", "", "ruleTitle", "", "Lbook/webBook/analyzeRule/AnalyzeRule$SourceRule;", "rulePubDate", "ruleDescription", "ruleImage", "ruleLink", "book"})
public final class RssParserByRule {
    @NotNull
    public static final RssParserByRule INSTANCE = new RssParserByRule();

    private RssParserByRule() {
    }

    @Nullable
    public final Object parseXML(@NotNull String sortName, @NotNull String sortUrl, @NotNull String redirectUrl, @Nullable String body, @NotNull RssSource rssSource, @NotNull RuleData ruleData, @Nullable DebugLog debugLogger, @NotNull Continuation<? super Pair<? extends List<RssArticle>, String>> $completion) throws Exception {
        String ruleArticles;
        CharSequence charSequence;
        String sourceUrl = rssSource.getSourceUrl();
        String nextUrl = null;
        CharSequence charSequence2 = body;
        if (charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) {
            throw new NoStackTraceException("\u8bbf\u95ee\u7f51\u7ad9\u5931\u8d25:" + rssSource + ".sourceUrl");
        }
        DebugLog debugLog = debugLogger;
        if (debugLog != null) {
            DebugLog.DefaultImpls.log$default(debugLog, sourceUrl, "\u2261\u83b7\u53d6\u6210\u529f:" + sourceUrl, false, 4, null);
        }
        if (debugLogger != null) {
            debugLogger.log("\u5217\u8868\u6e90\u7801Qwq" + body);
        }
        if ((charSequence = (CharSequence)(ruleArticles = rssSource.getRuleArticles())) == null || StringsKt.isBlank((CharSequence)charSequence)) {
            String string;
            DebugLog debugLog2 = debugLogger;
            if (debugLog2 != null) {
                DebugLog.DefaultImpls.log$default(debugLog2, sourceUrl, "\u21d2\u5217\u8868\u89c4\u5219\u4e3a\u7a7a, \u4f7f\u7528\u9ed8\u8ba4\u89c4\u5219\u89e3\u6790", false, 4, null);
            }
            if ((string = rssSource.getUserid()) == null) {
                string = "";
            }
            return RssParserDefault.INSTANCE.parseXML(sortName, body, sourceUrl, string, debugLogger);
        }
        List articleList = new ArrayList();
        AnalyzeRule analyzeRule = new AnalyzeRule(ruleData, debugLogger, rssSource);
        AnalyzeRule.setContent$default(analyzeRule, body, null, 2, null).setBaseUrl(sortUrl);
        analyzeRule.setRedirectUrl(redirectUrl);
        boolean reverse = false;
        if (StringsKt.startsWith$default((String)ruleArticles, (String)"-", (boolean)false, (int)2, null)) {
            reverse = true;
            String string = ruleArticles.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            ruleArticles = string;
        }
        DebugLog debugLog3 = debugLogger;
        if (debugLog3 != null) {
            DebugLog.DefaultImpls.log$default(debugLog3, sourceUrl, "\u250c\u83b7\u53d6\u5217\u8868", false, 4, null);
        }
        List<Object> collections = analyzeRule.getElements(ruleArticles);
        DebugLog debugLog4 = debugLogger;
        if (debugLog4 != null) {
            DebugLog.DefaultImpls.log$default(debugLog4, sourceUrl, "\u2514\u5217\u8868\u5927\u5c0f:" + collections.size(), false, 4, null);
        }
        CharSequence charSequence3 = rssSource.getRuleNextPage();
        if (!(charSequence3 == null || charSequence3.length() == 0)) {
            DebugLog debugLog5 = debugLogger;
            if (debugLog5 != null) {
                DebugLog.DefaultImpls.log$default(debugLog5, sourceUrl, "\u250c\u83b7\u53d6\u4e0b\u4e00\u9875\u94fe\u63a5", false, 4, null);
            }
            String string = rssSource.getRuleNextPage();
            Intrinsics.checkNotNull((Object)string);
            charSequence3 = string;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string2 = ((String)charSequence3).toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            if (Intrinsics.areEqual((Object)string2, (Object)"PAGE")) {
                nextUrl = sortUrl;
            } else {
                nextUrl = AnalyzeRule.getString$default(analyzeRule, rssSource.getRuleNextPage(), null, false, 6, null);
                if (((CharSequence)nextUrl).length() > 0) {
                    nextUrl = NetworkUtils.INSTANCE.getAbsoluteURL(sortUrl, nextUrl);
                }
            }
            DebugLog debugLog6 = debugLogger;
            if (debugLog6 != null) {
                DebugLog.DefaultImpls.log$default(debugLog6, sourceUrl, "\u2514" + nextUrl, false, 4, null);
            }
        }
        List ruleTitle = AnalyzeRule.splitSourceRule$default(analyzeRule, rssSource.getRuleTitle(), false, 2, null);
        List rulePubDate = AnalyzeRule.splitSourceRule$default(analyzeRule, rssSource.getRulePubDate(), false, 2, null);
        List ruleDescription = AnalyzeRule.splitSourceRule$default(analyzeRule, rssSource.getRuleDescription(), false, 2, null);
        List ruleImage = AnalyzeRule.splitSourceRule$default(analyzeRule, rssSource.getRuleImage(), false, 2, null);
        List ruleLink = AnalyzeRule.splitSourceRule$default(analyzeRule, rssSource.getRuleLink(), false, 2, null);
        String variable = ruleData.getVariable();
        Iterator iterator = ((Iterable)collections).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            RssArticle rssArticle;
            int index = n++;
            Object item = iterator.next();
            String string = rssSource.getUserid();
            if (string == null) {
                string = "";
            }
            if ((rssArticle = this.getItem(sourceUrl, string, item, analyzeRule, variable, index == 0, ruleTitle, rulePubDate, ruleDescription, ruleImage, ruleLink, debugLogger)) == null) continue;
            RssArticle it = rssArticle;
            boolean bl = false;
            it.setSort(sortName);
            it.setOrigin(sourceUrl);
            String string3 = rssSource.getUserid();
            if (string3 == null) {
                string3 = "";
            }
            it.setUserid(string3);
            Boxing.boxBoolean((boolean)articleList.add(it));
        }
        if (reverse) {
            CollectionsKt.reverse((List)articleList);
        }
        return new Pair((Object)articleList, (Object)nextUrl);
    }

    public static /* synthetic */ Object parseXML$default(RssParserByRule rssParserByRule, String string, String string2, String string3, String string4, RssSource rssSource, RuleData ruleData, DebugLog debugLog, Continuation continuation, int n, Object object) throws Exception {
        if ((n & 0x40) != 0) {
            debugLog = null;
        }
        return rssParserByRule.parseXML(string, string2, string3, string4, rssSource, ruleData, debugLog, (Continuation<? super Pair<? extends List<RssArticle>, String>>)continuation);
    }

    private final RssArticle getItem(String sourceUrl, String userid, Object item, AnalyzeRule analyzeRule, String variable, boolean log, List<AnalyzeRule.SourceRule> ruleTitle, List<AnalyzeRule.SourceRule> rulePubDate, List<AnalyzeRule.SourceRule> ruleDescription, List<AnalyzeRule.SourceRule> ruleImage, List<AnalyzeRule.SourceRule> ruleLink, DebugLog debugLogger) {
        RssArticle rssArticle = new RssArticle(null, null, null, 0L, null, null, null, null, null, null, false, variable, userid, 2047, null);
        analyzeRule.setRuleData(rssArticle);
        AnalyzeRule.setContent$default(analyzeRule, item, null, 2, null);
        DebugLog debugLog = debugLogger;
        if (debugLog != null) {
            debugLog.log(sourceUrl, "\u250c\u83b7\u53d6\u6807\u9898", log);
        }
        rssArticle.setTitle(AnalyzeRule.getString$default(analyzeRule, ruleTitle, null, false, false, 14, null));
        DebugLog debugLog2 = debugLogger;
        if (debugLog2 != null) {
            debugLog2.log(sourceUrl, "\u2514" + rssArticle.getTitle(), log);
        }
        DebugLog debugLog3 = debugLogger;
        if (debugLog3 != null) {
            debugLog3.log(sourceUrl, "\u250c\u83b7\u53d6\u65f6\u95f4", log);
        }
        rssArticle.setPubDate(AnalyzeRule.getString$default(analyzeRule, rulePubDate, null, false, false, 14, null));
        DebugLog debugLog4 = debugLogger;
        if (debugLog4 != null) {
            debugLog4.log(sourceUrl, "\u2514" + rssArticle.getPubDate(), log);
        }
        DebugLog debugLog5 = debugLogger;
        if (debugLog5 != null) {
            debugLog5.log(sourceUrl, "\u250c\u83b7\u53d6\u63cf\u8ff0", log);
        }
        if (ruleDescription.isEmpty()) {
            rssArticle.setDescription(null);
            DebugLog debugLog6 = debugLogger;
            if (debugLog6 != null) {
                debugLog6.log(sourceUrl, "\u2514\u63cf\u8ff0\u89c4\u5219\u4e3a\u7a7a\uff0c\u5c06\u4f1a\u89e3\u6790\u5185\u5bb9\u9875", log);
            }
        } else {
            rssArticle.setDescription(AnalyzeRule.getString$default(analyzeRule, ruleDescription, null, false, false, 14, null));
            DebugLog debugLog7 = debugLogger;
            if (debugLog7 != null) {
                debugLog7.log(sourceUrl, "\u2514" + rssArticle.getDescription(), log);
            }
        }
        DebugLog debugLog8 = debugLogger;
        if (debugLog8 != null) {
            debugLog8.log(sourceUrl, "\u250c\u83b7\u53d6\u56fe\u7247url", log);
        }
        rssArticle.setImage(AnalyzeRule.getString$default(analyzeRule, ruleImage, null, true, false, 10, null));
        DebugLog debugLog9 = debugLogger;
        if (debugLog9 != null) {
            debugLog9.log(sourceUrl, "\u2514" + rssArticle.getImage(), log);
        }
        DebugLog debugLog10 = debugLogger;
        if (debugLog10 != null) {
            debugLog10.log(sourceUrl, "\u250c\u83b7\u53d6\u6587\u7ae0\u94fe\u63a5", log);
        }
        rssArticle.setLink(NetworkUtils.INSTANCE.getAbsoluteURL(sourceUrl, AnalyzeRule.getString$default(analyzeRule, ruleLink, null, false, false, 14, null)));
        DebugLog debugLog11 = debugLogger;
        if (debugLog11 != null) {
            debugLog11.log(sourceUrl, "\u2514" + rssArticle.getLink(), log);
        }
        if (StringsKt.isBlank((CharSequence)rssArticle.getTitle())) {
            return null;
        }
        return rssArticle;
    }

    static /* synthetic */ RssArticle getItem$default(RssParserByRule rssParserByRule, String string, String string2, Object object, AnalyzeRule analyzeRule, String string3, boolean bl, List list, List list2, List list3, List list4, List list5, DebugLog debugLog, int n, Object object2) {
        if ((n & 0x800) != 0) {
            debugLog = null;
        }
        return rssParserByRule.getItem(string, string2, object, analyzeRule, string3, bl, list, list2, list3, list4, list5, debugLog);
    }
}

