# Ada Chen Rekhi - 双语对照

This is the complete bilingual transcript for **Lenny’s Podcast** featuring **Ada Chen Rekhi**.

---

### [00:00:00] Ada Chen Rekhi

**English:**
It's a terrible outcome to wake up one day and be late career and feel trapped because you have a certain lifestyle or a certain expectations of the people around you that you have to go work this job, but then you look at yourself in the mirror and you're not happy going in there. I think that's a terrible trap that we should all try to avoid as we navigate our career paths and find the thing that's most optimal for us. Which is usually a mix of career success, but also meaningfulness and alignment in the work that we're doing with our values.

**中文翻译:**
如果有一天你醒来，发现自己处于职业生涯后期，却感到被困住了，那是一个非常糟糕的结果。你可能因为某种生活方式或周围人的期待而不得不去做这份工作，但当你照镜子时，你发现自己并不开心。我认为这是我们在职业道路上都应该努力避免的陷阱。我们应该寻找最适合自己的状态，这通常是职业成功、工作意义以及工作内容与个人价值观契合的结合体。

---

### [00:00:36] Lenny

**English:**
Welcome to Lenny's Podcast, where I interview world-class product leaders and growth experts to learn from their hard-won experiences building and growing today's most successful products. Today my guest is Ada Chen Rekhi. Ada is an executive coach and also the co-founder of a product called Notejoy. In her coaching practice, she focuses on helping founders scale themselves. Before starting her company, she was senior vice president of marketing at SurveyMonkey. Before that, she started a contact management startup that was acquired by LinkedIn where she ended up leading LinkedIn's marketing efforts for their growth team. Two fun facts about Ada. One, she started her current company with her husband, which we chat about whether that's a good idea or not. Also, her brother is Andrew Chen of a16z fame. In our conversation, it explains how to make better decisions with a framework she calls Curiosity Loops.

**中文翻译:**
欢迎来到 Lenny 的播客。在这里，我会采访世界级的跨国产品负责人和增长专家，从他们构建和增长当今最成功产品的宝贵经验中学习。今天的嘉宾是 Ada Chen Rekhi。Ada 是一位高管教练，也是 Notejoy 的联合创始人。在她的教练实践中，她专注于帮助创始人实现自我规模化（scale themselves）。在创业之前，她是 SurveyMonkey 的营销高级副总裁。在此之前，她创办了一家联系人管理初创公司，后被 LinkedIn 收购，她随后负责 LinkedIn 增长团队的营销工作。关于 Ada 有两个趣事：第一，她是和丈夫一起创办了现在的公司，我们会聊聊这到底是不是个好主意；第二，她的哥哥是 a16z 著名的 Andrew Chen。在我们的对话中，她解释了如何通过一个她称之为“好奇心循环”（Curiosity Loops）的框架来做出更好的决策。

---

### [00:01:21] Lenny (Continued)

**English:**
We do a live exercise around my own personal values. She shares a bunch of advice on how to intentionally and practically build your early career path. How to thrive as a woman in Silicon Valley, when to get a coach and what you can do on your own without one and a ton more. Enjoy this episode with Ada Chen Rekhi after a short word from our sponsors.

**中文翻译:**
我们还围绕我个人的价值观进行了一次现场练习。她分享了许多关于如何有意识且务实地规划早期职业道路的建议。包括如何在硅谷作为女性脱颖而出、什么时候该找教练、没有教练时你可以自己做些什么，以及更多内容。在听完赞助商的简短介绍后，请欣赏本期与 Ada Chen Rekhi 的对话。

---

### [00:01:40] Lenny (Sponsor Break)

**English:**
This episode is brought to you by Sprig. Next generation product teams like, Robinhood, Notion and Loom rely on Sprig to uncover blind spots in their product development process. Sprig lets product teams collect user insights fast, allowing you to better understand why users take certain actions and how they feel about the experience. One of the things I love most about Sprig is that they're all about getting product teams the specific insights they need in the timeframe that they need it.

**中文翻译:**
本期节目由 Sprig 赞助。Robinhood、Notion 和 Loom 等新一代产品团队都依赖 Sprig 来发现产品开发过程中的盲点。Sprig 让产品团队能够快速收集用户洞察，让你更好地理解用户为什么采取某些行动，以及他们对体验的感受。我最喜欢 Sprig 的一点是，他们致力于在产品团队需要的时间范围内，为他们提供所需的具体洞察。

---

### [00:02:07] Lenny (Sponsor Break Continued)

**English:**
As of today, Sprig is making that even easier with the new and improved templates library. On this podcast, you've heard a lot about how useful templates are for companies as they grow. Sprig partnered with some of the top product teams and product thinkers to build proven playbooks, specifically to solve the biggest challenges facing product teams today from how to optimize an existing feature to improving a conversion flow to troubleshooting drop off. Sprig helps you build better products. Sprig now has a library of more than 85 templates that you can use to get started collecting user insights quickly right in your app. I especially love that Sprig builds templates specifically for product teams, and I was really excited when they ask me to create a template around product sense.

**中文翻译:**
从今天起，Sprig 通过全新改进的模板库让这一切变得更加简单。在这个播客中，你听过很多关于模板对公司成长有多么有用的内容。Sprig 与一些顶尖的产品团队和产品思想家合作，构建了经过验证的实战手册（playbooks），专门用于解决当今产品团队面临的最大挑战——从如何优化现有功能，到改善转化流，再到排查用户流失原因。Sprig 帮助你构建更好的产品。Sprig 现在拥有超过 85 个模板的库，你可以直接在你的 App 中快速开始收集用户洞察。我特别喜欢 Sprig 为产品团队量身定制模板这一点，当他们邀请我创建一个关于“产品感”（product sense）的模板时，我非常兴奋。

---

### [00:02:47] Lenny (Sponsor Break Continued)

**English:**
One of the questions they get most is how to develop your product sense. So I decided to build a playbook along with Sprig on how to do that based on my experience at Airbnb and from what I've learned interviewing top product folks like, Jules Walter who wrote a whole guest post on how to build your product sense. Explore my product sense playbook and the entire Sprig templates library and build better products faster. Check it out today at sprig.com/templates. That's S-P-R-I-G.com/templates. Ada, welcome to the podcast.

**中文翻译:**
他们收到的最多的问题之一就是如何培养产品感。因此，我决定根据我在 Airbnb 的经验，以及从采访 Jules Walter（他曾写过一篇关于如何建立产品感的客座文章）等顶尖产品人那里学到的知识，与 Sprig 共同构建一个实战手册。探索我的产品感手册和整个 Sprig 模板库，更快地构建更好的产品。今天就去 sprig.com/templates 查看吧。Ada，欢迎来到播客。

---

### [00:03:20] Ada Chen Rekhi

**English:**
Thanks. I'm excited to be here.

**中文翻译:**
谢谢。很高兴来到这里。

---

### [00:03:22] Lenny

**English:**
So I've heard such great things about you from a lot of people, including a bunch of guests that have been on the podcast. And you also have this really great Venn diagram of maybe an ideal guest for the podcast. You've done growth. You've done products. You've started a company. You're also an executive coach to founders. So there's a variety of topics I'm excited to begin too. So thanks again for being here.

**中文翻译:**
我从很多人那里听到了关于你的赞誉，包括很多上过这个播客的嘉宾。你拥有一个非常完美的“理想嘉宾”韦恩图：你做过增长，做过产品，创办过公司，还是创始人的高管教练。所以有很多话题我都迫不及待想聊。再次感谢你的到来。

---

### [00:03:22] Ada Chen Rekhi

**English:**
Yeah, I'm excited to be here.

**中文翻译:**
是的，我也很兴奋。

---

### [00:03:45] Lenny

**English:**
An interesting thing that I'll start with is that when we were chatting about what to focus on in our conversation, where you're emailing about this, and you did something that I thought was really interesting. You ran something called a Curiosity Loop where you pinged a bunch of your friends and asked them for input in this really structured way. So I thought I'd start there. Could you just share what this process is, so that we can learn how to maybe do it ourselves, this idea of a curiosity loop?

**中文翻译:**
我想从一件有趣的事开始。当我们通过邮件讨论这次谈话的重点时，你做了一件我觉得非常有意思的事。你运行了一个叫做“好奇心循环”（Curiosity Loop）的东西，你联系了一群朋友，用一种非常有结构的方式征求他们的意见。所以我想从这里开始，你能分享一下这个过程是什么吗？这样我们也可以学习如何自己操作这个“好奇心循环”。

---

### [00:04:08] Ada Chen Rekhi

**English:**
A curiosity loop is essentially going to a whole bunch of people. In this case, I sent out an email very quickly to about 10 or 11 people and asking them, "Hey, here are nine topics for Lenny's Podcast. What are two or three of the topics that resonate with you and why?" And I got back such an incredible amount of information for about 20 minutes of work. I don't normally do this, but I actually showed you some of the anonymized feedback from people really just talking about what resonated and what didn't. So I came out of it just so much smarter, and curiosity loops are my method of doing so.

**中文翻译:**
好奇心循环本质上是向一群人征求意见。在这个案例中，我很快给大约 10 到 11 个人发了邮件，问他们：“嘿，这里有九个关于 Lenny 播客的话题。哪两三个话题让你产生共鸣，为什么？”大约花了 20 分钟的工作，我就收到了惊人的信息量。我平时不常这么做，但我实际上给你看了一些匿名反馈，大家在里面讨论哪些有共鸣，哪些没有。所以做完这件事后，我感觉自己变聪明了很多，而好奇心循环就是我达成这一目标的方法。

---

### [00:04:42] Lenny

**English:**
Often, people ask friends for advice on just like, "Hey, what should I do here? What can I maybe talk about on this podcast?" Your approach had a lot of structure to it. So maybe two questions just like, what is the actual structure to this concept? And then two, just people... You can often ask friends for advice, but you also don't want to over bug them with questions. How do you think about just not over asking everyone questions all the time, but all decisions you want to make? So I guess the question is, when do you use this versus just not?

**中文翻译:**
通常人们问朋友建议只是说：“嘿，我该怎么办？在这个播客上我能聊点什么？”但你的方法非常有结构。所以我有两个问题：第一，这个概念的具体结构是什么？第二，关于人际关系……你经常可以向朋友寻求建议，但你也不想用问题过度打扰他们。你如何考虑不总是向每个人问问题，但又能涵盖你想做的所有决定？所以问题是，你什么时候会使用这个方法，什么时候不会？

---

### [00:05:12] Ada Chen Rekhi

**English:**
I think that there are heavyweight and lightweight ways to use this. So the heavyweight way was what I just exemplified by saying, I sent an email and I made a doc. And on the other side, I had all of this really interesting and rich data. The lightweight way to do this is really just make it your ongoing theme of what you're curious about as you interact with people. So maybe it's this thing where every single day as you talk to people, if you have a social topic, you might just bring up the same question over and over again and start looking for are there any differences or surprises in what people are telling you? One of the big reasons why I think curiosity loops are really useful is that it really fights the fact that there's a lot of bad advice out there.

**中文翻译:**
我认为使用这个方法有“重量级”和“轻量级”之分。重量级的方法就像我刚才举的例子：发邮件、做文档，然后收获大量有趣且丰富的数据。轻量级的方法则是把它变成你与人互动时的一个持续主题。比如，每天当你与人交谈时，如果你有一个社交话题，你可以反复提出同一个问题，并开始观察人们的回答中是否有差异或惊喜。我认为好奇心循环非常有用的一个重要原因是，它能有效对抗现实中存在的许多“糟糕建议”。

---

### [00:05:54] Ada Chen Rekhi (Continued)

**English:**
And it's not bad because it's not well-intentioned, but it's bad because it's not contextual. So when someone tells you to quit your job and chase your dreams, or they tell you to sit tight and grind through and build some experience before you go off and go start the company that you've always been thinking about starting, which piece of advice do you actually take? Right? A lot of it depends on your situation, what you're considering, what skills and experience you actually have, and curiosity loops actually are this way of really thinking about how do you make your advice contextual. So I'll break it down a bit in terms of how I think about structuring it. So the first piece of a curiosity loop is really just thinking about asking a good question. In the time when I was working at SurveyMonkey in the past, I had this opportunity to spend a lot of time with the survey researchers, and we really talked a lot about what makes a question good.

**中文翻译:**
这些建议之所以糟糕，不是因为出发点不好，而是因为它们脱离了语境（not contextual）。比如有人告诉你辞职去追逐梦想，或者有人告诉你按兵不动、埋头苦干，先积累经验再去开创你一直想开的公司。你到底该听哪一个？这很大程度上取决于你的处境、你的顾虑以及你实际拥有的技能和经验。好奇心循环实际上就是一种思考如何让建议“语境化”的方法。我来拆解一下我如何构建它。好奇心循环的第一步是思考如何提出一个好问题。以前在 SurveyMonkey 工作时，我有机会和调查研究员待在一起，我们深入讨论过什么样的问题才算好问题。

---

### [00:06:44] Ada Chen Rekhi (Continued)

**English:**
So in this case, a question's good if it's specific, if it solicits rationale, and it's not biased. You don't want to start a question with, here's what I think because people have this tendency to want to please you or to agree with you. So a good example... Well, let me start with a bad example of a question. A bad example of a question is, what should I do with my career next? It's just such a poorly formed question because it's really vague, it's not specific. It puts a lot of cognitive load on other people, and the output that you're going to get from it is probably going to be similarly bad. Garbage in, garbage out. A better example of a question might be something like, "Hey, you know me. I'm a marketer. I've been thinking about doing this webdev thing. So my plan is to quit my job, do a webdev bootcamp and then go find a job elsewhere. Do you think that's a good idea?"

**中文翻译:**
在这种情况下，一个好问题应该是具体的、能引导出理由的，并且是不带偏见的。你不想在提问开头就说“我是这么想的”，因为人们倾向于讨好你或认同你。举个例子……先说个坏榜样。一个坏问题是：“我接下来的职业生涯该怎么办？”这是一个非常糟糕的问题，因为它太模糊、不具体，给别人带来了巨大的认知负荷（cognitive load），而你得到的结果可能同样糟糕。垃圾进，垃圾出。一个更好的提问方式可能是：“嘿，你了解我。我是个营销人员，但我一直在考虑转行做 Web 开发。我的计划是辞职，参加一个 Web 开发训练营，然后找一份相关工作。你觉得这是个好主意吗？”

---

### [00:07:45] Ada Chen Rekhi (Continued)

**English:**
There's just so much rich data to actually explore with that. First, are you suited to being a developer? Are webdev boot camps effective? What's the state of the economy in the hiring market right now for junior web developers? And that's an example of maybe a question that's a little bit more specific and gives people something to anchor on. So that's the first piece. The next piece is really around how do you curate who you ask? I think there are two dimensions of this. The first one is the obvious one, which is a subject matter expert who really knows something about the topic at hand. So maybe a webdev themselves, for my example question. Another one, and this dimension I think is really important, is someone who knows you really well and can provide insight on how well does that work for you. And then after that, you really want to ask the question. And this touches on what you said about how do you make it really lightweight?

**中文翻译:**
这样的问题有很多丰富的数据可以挖掘。首先，你适合当开发人员吗？Web 开发训练营有效吗？目前初级 Web 开发者的招聘市场行情如何？这就是一个更具体、能让对方有据可依的问题。这是第一部分。接下来是关于如何筛选（curate）提问对象。我认为有两个维度：第一是显而易见的，即真正了解该话题的领域专家（subject matter expert），比如我例子中的 Web 开发人员。另一个维度我认为非常重要，那就是非常了解你的人，他们能提供关于“这件事对你来说是否合适”的见解。之后，你就要正式提问了。这涉及到了你提到的“如何让它变得轻量级”。

---

### [00:08:41] Ada Chen Rekhi (Continued)

**English:**
Ask the question in a way that really gets you a useful constructive answer, but doesn't put too much weight on people. So what I usually like to do is just make it very lightweight. So in your case, I said, "Here are nine topics. Can you pick your top two and tell me why you like them?" Some people went above and beyond and scrolled through and gave me feedback on every single topic. Some of them just said, "Here are my top two, and here's one I think you should avoid." I wanted to design it in a way where if you're a busy founder, you're a busy product person, which is the list that I chose for this curiosity loop, you would be able to sit down on your couch at the end of the night, read this interesting email and tap out a quick reply and give me that answer. Because the risk that you're running is either you're getting poor answers or you're getting a really low response rate because you've given them way too much cognitive load in terms of answering it.

**中文翻译:**
提问的方式要能引导出有用的建设性答案，但又不会给对方增加太多负担。我通常喜欢把它做得非常轻量。比如在你的案例中，我说：“这里有九个话题。你能选出你最喜欢的两个并告诉我原因吗？”有些人做得更多，浏览了所有话题并给出了反馈。有些人只是说：“这是我最喜欢的两个，还有一个我觉得你应该避开。”我设计的初衷是，如果你是一个忙碌的创始人或产品经理（这也是我这次循环选择的人群），你能在忙完一天后坐在沙发上，读到这封有趣的邮件，然后快速敲出回复。因为如果你给对方太大的认知负荷，风险要么是得到敷衍的答案，要么是回复率极低。

---

### [00:09:35] Ada Chen Rekhi (Continued)

**English:**
And then finally, to close the loop, I think a big piece of it is processing that information and then thanking them for it. So a big misconception that people have when they're really getting into this work of asking for advice or input from other people in the community is often that it's really one-sided. I'm asking you for help and you're getting nothing out of it. The reminder that I would have for all of you is that it feels really good to help someone. It feels really good to be heard and give input. And a big piece of that is, if someone comes to you and they said, "You gave me this advice, it changed my life. Maybe it's not at that level, but it really affected my decision and here's how it turned out. Thank you so much." That feels so good, especially if you only spent a few minutes giving them the input that enabled them to make a better decision.

**中文翻译:**
最后，为了完成闭环，很重要的一步是处理这些信息并向他们致谢。人们在向社区寻求建议时常有一个误区，认为这是单方面的：我在求你帮忙，而你一无所获。我想提醒大家的是，帮助别人感觉非常好。被倾听并给出建议的感觉也很好。其中很大一部分在于，如果有人回来告诉你：“你给我的建议改变了我的生活（也许没到那个程度，但确实影响了我的决定），结果是这样的，非常感谢。”这种感觉棒极了，尤其是当你只花了三五分钟给出的建议却能帮他们做出更好的决定时。

---

### [00:10:21] Lenny

**English:**
So to summarize, I wrote these pieces down. The concept broadly is if you want advice on a decision you're trying to make, pick some friends and this is... I guess I'll go through the four things you just mentioned. And part two is actually pick the right friends. But one is just, come up with a question that's specific. As in just like, what should I do with my life? But more, should I take the specific role at the specific company? Figure out the people that know you well and maybe have some context on this decision. How many people do you usually email for this sort of thing? What's a number?

**中文翻译:**
总结一下，我记下了这些要点。大体概念是，如果你想针对某个决定寻求建议，选一些朋友……我来复述一下你提到的四点。第二部分是选对朋友。第一，提出一个具体的问题。不要问“我的人生该怎么办”，而要问“我该不该去这家公司的这个具体职位”。第二，找那些了解你且对这个决定有背景知识的人。你通常会给多少人发邮件？大概是多少个？

---

### [00:10:55] Ada Chen Rekhi

**English:**
I would try to optimize for getting at least three or four responses. It just depends on the nature of the loop. And then you think about what is your response rate. So if you're emailing really busy people that you don't know very well, maybe you would assume that you only get half of people to respond. If you're emailing people really well and it's really lightweight like, yes or no, and here's why, then you might just send out a handful.

**中文翻译:**
我会尽量争取至少得到三四个回复。这取决于循环的性质。然后你要考虑回复率。如果你给那些不太熟的忙人发邮件，可能假设只有一半人会回。如果你给很熟的人发，而且问题很轻量（比如“是或否，为什么”），那你可能只需要发给几个人。

---

### [00:11:22] Lenny

**English:**
Okay, awesome. So it's five to 10 people, broadly sounds like. Oh yeah, you want to make it really quick and easy. So it's like, here's 10 things, which of these two do you think I should focus on? So it's a quick ask as something you recommend, and then just thank them for it after you finish. Is that broadly the approach?

**中文翻译:**
好的，太棒了。听起来大概是 5 到 10 个人。而且要让过程变得快速简单，比如“这里有 10 件事，你觉得我应该关注哪两件？”所以你推荐的是一种快速的请求，完成后再向他们致谢。大体上是这个方法吗？

---

### [00:11:39] Ada Chen Rekhi

**English:**
Yep, that's the approach. One thing I want to note is that it's actually really useful for personal things as well. So we framed it in this professional context of, I'm trying to change a job. But one example that I have is when we had our daughter who's now three years old, one of the debates that my partner and I were having was how do we actually set up our estate planning in terms of if, God forbids, something happened to both of us. How should she inherit the state? And my partner was basically saying, "18 years old, she gets everything fully unlocked." I was saying, "Oh, well maybe 25." And we're at this impasse. And we actually just started to tell each other, why don't we, in our day-to-day conversations with folks that we trust in our family, people that we think are smart, that have kids ask people what their perspective is on it.

**中文翻译:**
没错，就是这个方法。我想补充一点，它在个人事务上也非常有用。我们刚才是在职业背景下讨论的，比如换工作。但我有一个例子：当我们女儿出生时（她现在三岁了），我和伴侣曾争论过如何设置遗产规划（estate planning），万一——上帝保佑不要发生——我们两个都出事了，她该如何继承遗产？我伴侣的意思是：“18 岁，她就可以解锁全部遗产。”我说：“哦，也许该到 25 岁。”我们陷入了僵局。于是我们对彼此说，不如在日常生活中问问我们信任的家人、那些我们觉得聪明且有孩子的人，看看他们的看法。

---

### [00:12:28] Ada Chen Rekhi (Continued)

**English:**
One thing was really telling, no one out of everyone we asked said 18. So that really dragged my partner up. And then the other thing that was really interesting was that we learned a little bit about executive function and the research around it. So executive function, which is your ability to make decisions and plans and be thoughtful peaks at the age of 30, and it's all downhill from there. So bad news for people like me that are older.

**中文翻译:**
结果非常说明问题：我们问的所有人中，没有一个说是 18 岁。这让我伴侣的立场发生了动摇。另一件有趣的事是，我们了解了一些关于“执行功能”（executive function）的研究。执行功能是指你做决定、制定计划和深思熟虑的能力，它在 30 岁达到顶峰，之后就开始走下坡路了。所以对于像我这样年纪稍大的人来说，这可不是个好消息。

---

### [00:12:54] Lenny

**English:**
And then I'm getting [inaudible 00:12:54] or game over.

**中文翻译:**
那我岂不是快要“游戏结束”了。

---

### [00:12:55] Ada Chen Rekhi

**English:**
Yeah, exactly.

**中文翻译:**
是的，没错。

---

### [00:12:55] Lenny

**English:**
Just like I'm-

**中文翻译:**
就像我——

---

### [00:12:57] Ada Chen Rekhi

**English:**
But if you're thinking about 18, you are so far from your peak. So it dragged us both up in terms of what our set point was to make a decision like that. But we wouldn't have figured that out without a curiosity loop because it's too much work to dig through papers or research or whatever else to try to come to a good decision on it.

**中文翻译:**
但如果你考虑 18 岁，那离巅峰还远着呢。所以这提高了我们做此类决定的基准点。如果没有好奇心循环，我们不会发现这一点，因为去翻阅论文或研究报告来做一个决定实在太费劲了。

---

### [00:13:14] Lenny

**English:**
So the core lesson here is just, versus just emailing a bunch of people, asking for advice, which I imagine people often do, just what should I do here? Creating a little bit of the structure and even calling it a curiosity loop, I bet, helps people feel like they want to be a part of this and participate and help.

**中文翻译:**
所以核心教训是，与其只是给一群人发邮件问“我该怎么办”（我猜人们经常这么干），不如建立一点结构，甚至给它起个名字叫“好奇心循环”。我敢打赌，这能让人们觉得他们是这件事的一部分，从而更愿意参与和提供帮助。

---

### [00:13:31] Ada Chen Rekhi

**English:**
Yeah, definitely. One of the things that I always try to do is I try to explain to people in my ask, here's why I picked you. So for example, I picked you because I really trust you to be a sound source of truthful advice and give me some feedback. So I really value that. Do you mind spending a couple of minutes and just giving me some thoughts on this?

**中文翻译:**
是的，绝对如此。我总是尝试在请求中向对方解释：我为什么选择了你。例如，“我选择你是因为我非常信任你，认为你能提供可靠、真实的建议和反馈。我非常看重这一点。你介意花几分钟谈谈你的想法吗？”

---

### [00:13:53] Lenny

**English:**
And how often are you pinging people? If you're a friend of Ada, are you getting curiosity looped every week, or how often? What's your rate limit?

**中文翻译:**
你多久联系一次别人？如果你是 Ada 的朋友，是每周都会收到“好奇心循环”吗，还是多久一次？你的频率限制是多少？

---

### [00:14:02] Ada Chen Rekhi

**English:**
I usually reserve it for bigger things. So probably quarterly or anything where I'm having a big debate, and I'm feeling really indecisive.

**中文翻译:**
我通常把它留给大事。大概每季度一次，或者当我面临重大争议、感到非常犹豫不决的时候。

---

### [00:14:12] Lenny

**English:**
Awesome. It also makes me think about this idea of a personal board of directors, and this feels like an asynchronous approach to that concept where instead of a call every, I don't know, quarter month with small group, it's asynchronous. Here's an ask I have-

**中文翻译:**
太棒了。这也让我想到了“个人董事会”的概念，这感觉像是该概念的一种异步实现方式。不是每季度或每月和一小群人开会，而是异步的：“我有一个请求——”

---

### [00:14:24] Ada Chen Rekhi

**English:**
Totally. Yep. I think this is really based off of the marketing concept of customer advisory councils. So when I was working in marketing and product at a startup, one of the things we would always have is a group of our top customers on DM, basically. And if we had really interesting product conflicts, we would actually just go ping a couple of them and ask them, "Hey, we're debating this. Do you mind just giving us your quick thoughts and telling us why?" And then being able to as a marketer come back to the product conversation and say, here is the literal voice of the customer and four or five different verbatims on what people think about this really enabled me as a marketer to have a seat at the table. And the insight and the helpfulness of that was really something I wanted to bring to my personal life as well.

**中文翻译:**
完全正确。我认为这实际上是基于营销中的“客户顾问委员会”（customer advisory councils）概念。当我在一家初创公司做营销和产品时，我们总会有一群顶级客户的私信联系方式。如果我们遇到有趣的产品冲突，我们会联系其中几个人问：“嘿，我们在争论这个。你介意快速谈谈你的想法并告诉我们原因吗？”然后作为营销人员，我可以回到产品讨论中说：“这是客户的原话，这里有四五个关于大家看法的逐字记录。”这真的让我作为营销人员在决策桌上有了话语权。这种洞察力和帮助性是我非常想带入个人生活的。

---

### [00:15:07] Lenny

**English:**
That's really interesting. It's basically user research for your life. User research, you're told don't do what people tell you to do. I guess it's the same thing here, where it's just like, here's advice and then you end up making the decision for your own own life.

**中文翻译:**
这很有趣。这基本上就是为你的人生做“用户研究”。在用户研究中，人们常说不要照搬用户告诉你的话。我想这里也一样：这是建议，但最终还是由你为自己的人生做决定。

---

### [00:15:19] Ada Chen Rekhi

**English:**
Right. Right. Yes. That is the big caveat. Don't do what people tell you to do. Take it as an input and look for the hard feedback. Look for things that you strongly disagree with or are surprises to you. Because to me, I think these loops are more about looking around the corner and seeing if there's anything you missed in terms of the integrity of your decision making process.

**中文翻译:**
没错，是的。这是一个重要的注意事项：不要照搬别人的话。把它当作一种输入，寻找那些“逆耳”的反馈。寻找那些你强烈反对或让你感到意外的东西。因为对我来说，这些循环更多是为了“未雨绸缪”，看看在决策过程的完整性方面是否遗漏了什么。

---

### [00:15:43] Lenny

**English:**
Sweet. You said that people told you what we should not talk about. They're like, "Don't cover this." What was in that list?

**中文翻译:**
太好了。你提到有人告诉你我们“不该”聊什么。他们说：“别碰这个。”那个清单上有什么？

---

### [00:15:50] Ada Chen Rekhi

**English:**
So I think there were two topics on the list. The first one, it was just how do you onboard and hire and bring people onto the team? And the feedback I got there was like, "There's just so many people who have done this. I'm sure you have some interesting concepts, but I personally wouldn't be that interested in hearing it. And that was really useful to me. And then the other one was actually just about being a woman in Silicon Valley and the experience of that. I actually had someone write, and you probably read this, Lenny, "No. Stay far away from this. There's no winning on this topic."

**中文翻译:**
清单上有两个话题。第一个是“如何入职、招聘和组建团队”。我得到的反馈是：“已经有太多人聊过这个了。我确信你有一些有趣的见解，但我个人对此不太感兴趣。”这对我很有用。另一个话题是关于“作为女性在硅谷的经历”。实际上有人写道（Lenny 你可能也读到了）：“不。离这个话题远点。在这个话题上没有赢家。”

---

### [00:16:23] Lenny

**English:**
Oh, my God. Okay, let's touch on that topic rather than, it's going to be great.

**中文翻译:**
天哪。好吧，那我们就聊聊这个话题，肯定会很棒。

---

### [00:16:28] Ada Chen Rekhi

**English:**
Yeah. So let's ignore the advice?

**中文翻译:**
所以我们要无视那个建议吗？

---

### [00:16:29] Lenny

**English:**
Yeah, let's ignore it. Before we get to that, I wanted to first talk about you. You gave me some homework also ahead of this chat. And the homework was around helping me figure out values and personal values for myself. I did the exercise. So first of all, can you just maybe talk about what this exercise was, and what the goal of it is? And then I'll share what I come up with.

**中文翻译:**
是的，无视它。在聊那个之前，我想先聊聊你。在这次谈话前你也给我留了作业。作业是关于帮我理清自己的价值观和个人价值观。我做了那个练习。所以首先，你能谈谈这个练习是什么，目标是什么吗？然后我会分享我的结果。

---

### [00:16:51] Ada Chen Rekhi

**English:**
So the homework that I gave you is similar homework that I give to everyone that I work with in coaching, and it's this values exercise. It's this 10 to 15 minute exercise where you're presented with a list of words that might encompass potential values. It's pretty lightweight. You just go down the list, and you pick out all the words that resonate with you, and then we filter them down into groups of values, and then we filter them down into a stack rank and a list. And the output on the end is basically three to five sentences that cover what are the values stack rank that are important to you right now in your personal and professional life? And what I really like is, it's this internal scorecard of what really matters to you in your decision making process as opposed to the external scorecard of status, money, wealth, how other people perceive you, that often we feel really pressured by. So it's this great way to look back and see how well do decisions, or how well do my situations in life align with my values?

**中文翻译:**
我给你的作业和我给所有辅导对象的一样，就是一个价值观练习。这是一个 10 到 15 分钟的练习，你会看到一堆代表潜在价值观的词汇。它很轻量：你只需浏览清单，挑出让你产生共鸣的词，然后我们将它们归类，最后进行优先级排序（stack rank）。最终产出大约是三到五句话，涵盖了目前对你的个人和职业生活最重要的价值观排序。我非常喜欢它的一点是，它是一个“内部计分卡”，反映了在决策过程中对你真正重要的东西，而不是地位、金钱、财富或他人评价等让我们感到压力的“外部计分卡”。这是一种回顾过去、审视决策或生活现状是否与价值观契合的绝佳方式。

---

### [00:17:53] Lenny

**English:**
Sweet. And what I liked about it is, if someone were to be like, "Hey, come up with your values." I'd be like, "Oh, my God. I'm just sitting here thinking about words and concepts." And it was really helpful because it was basically multiple choice. Here's all the options across tons of categories, just keep picking and then helps you whittle them down. I ended up with six. I feel like that's one too many. Actually, I added a bonus one because it's just one that I really like. But should I read through what I came up with?

**中文翻译:**
太棒了。我喜欢它的地方在于，如果有人直接说“嘿，想出你的价值观”，我会觉得“天哪，我只能坐在这儿苦思冥想词汇和概念”。而这个练习很有帮助，因为它基本上是多选题。这里有跨越多个类别的所有选项，你只需不断挑选，然后它会帮你精简。我最后选了六个。我觉得有点多。实际上，我还加了一个额外的，因为那是我非常喜欢的。我该读一下我的结果吗？

---

### [00:18:18] Ada Chen Rekhi

**English:**
Yeah, that sounds great.

**中文翻译:**
好啊，听起来不错。

---

### [00:18:19] Lenny

**English:**
So here's what my values, I guess. Choose adventure, stay optimistic, treat others you want to be treated. Classic. Keep getting better, act generously. And added one that my grandma taught me back in the day that has stuck with me, that had nothing to do with this exercise, but I just wanted to have on this list, which is, first do what you need to do, and then do what you want.

**中文翻译:**
这是我的价值观：选择冒险（Choose adventure）、保持乐观（stay optimistic）、像你希望被对待那样对待他人（treat others you want to be treated）——经典款。不断进步（Keep getting better）、慷慨行事（act generously）。我还加了一个我祖母以前教我的、一直铭记在心的一条，虽然和这个练习无关，但我很想把它列进去：先做你必须做的，再做你想做的。

---

### [00:18:44] Ada Chen Rekhi

**English:**
I love it. What a great list of values and what stands out to me from that list too, Lenny, is this idea of achievement or status or success. A lot of the things that we talk about publicly, what your LinkedIn feed might look like don't actually show up in your values. And it must reflect in some of the choices that you've made in your life.

**中文翻译:**
我太喜欢了。Lenny，这份清单非常棒。让我印象深刻的是，成就、地位或成功这些概念并没有出现在你的价值观里。很多我们公开讨论的东西，或者你 LinkedIn 动态里展示的东西，其实并不在你的核心价值观中。这一定反映在你人生中的一些选择上。

---

### [00:19:04] Lenny

**English:**
Yes, I hope so.

**中文翻译:**
是的，我希望如此。

---

### [00:19:08] Ada Chen Rekhi

**English:**
Let me ask you this. Let's try to apply some of the values in real time as an experiment.

**中文翻译:**
让我问你这个。让我们尝试实时应用这些价值观做一个实验。

---

### [00:19:14] Lenny

**English:**
Oh, boy.

**中文翻译:**
噢，天哪。

---

### [00:19:15] Ada Chen Rekhi

**English:**
If you think about a recent decision that you've had to make or a decision that you're facing coming up, can you share what that decision might be? And then let's try to apply the values to it to think about if you were living up to these values, what choice would you make and maybe some of the pressures you might feel to choose otherwise.

**中文翻译:**
如果你想到一个最近必须做的决定，或者即将面临的决定，你能分享一下吗？然后我们试着把价值观应用上去，思考一下如果你遵循这些价值观，你会做出什么选择，以及你可能会感受到哪些让你做出相反选择的压力。

---

### [00:19:37] Lenny

**English:**
So an ongoing decision I have is I have all these opportunities of things I can be doing. Additional things I can be doing. The podcast, this actually was a good example of I never wanted to do a podcast because I really wanted to... Life is good. I was writing this newsletters, doing great, making a living, doing one great email a week. And I was like, "Why would I do anything more? This is good." So I've constantly resisted, I resisted the podcast for two to three years, and then eventually succumbed. And it was a great decision in the end. But now, I have other things that I'm trying to not do, but they're always pushing into my mind space like, a book for example. Of course at one point, and I paused that just so I could have more time for the podcast. So I guess the decision is just like, what should I say yes to versus say no to?

**中文翻译:**
我一直面临的一个决定是，我有太多的机会可以去做。额外的机会。播客其实就是一个很好的例子，我以前从未想过做播客，因为我真的觉得……生活很美好。我写着新闻通讯（newsletter），做得很好，能维持生计，每周发一封高质量邮件。我想：“为什么还要做更多？这样就很好了。”所以我一直抵制，抵制了播客两三年，最后还是屈服了。结果证明这是一个伟大的决定。但现在，我有其他想拒绝但总是在脑海里盘旋的事，比如写书。当然，我一度暂停了写书，为了给播客留出更多时间。所以决定就是：我该对什么说“好”，对什么说“不”？

---

### [00:20:26] Lenny (Continued)

**English:**
I'm looking at my values a little bit, and one of them is choose adventure, which you would think would be just do stuff, just try stuff out. But I feel like maybe it's just a missing bullet point here of, I just want to do less. I'm trying to take on less and do less and cut out and-

**中文翻译:**
我审视了一下我的价值观，其中一个是“选择冒险”，你可能会觉得这意味着“去做事，去尝试”。但我感觉这里可能漏掉了一点：我只想少做点事。我正努力减少负担，少做点，砍掉一些——

---

### [00:20:44] Ada Chen Rekhi

**English:**
That's really interesting.

**中文翻译:**
这很有趣。

---

### [00:20:44] Lenny

**English:**
... simplify. Yeah. Because there's just endless things I could be doing, and I want to spend time with my wife. And now, my new child is coming in a couple of months, if all goes well. So that's where my mind goes when you ask that.

**中文翻译:**
……简化。是的。因为总有没完没了的事情可以做，而我想花时间陪妻子。而且如果一切顺利，我的孩子几个月后就要出生了。所以当你问这个问题时，我脑子里想的就是这些。

---

### [00:20:57] Ada Chen Rekhi

**English:**
Yeah. Yeah. And then maybe if you were to decompose adventure, what adventure actually means to you and you go into that word list, you might actually just find that some of these opportunities like writing a book, at some point, it doesn't feel like an adventure.

**中文翻译:**
是的。也许如果你去分解“冒险”这个词，看看它对你到底意味着什么，再回到那个词汇表，你可能会发现，像写书这样的机会，在某种程度上感觉并不像是一场冒险。

---

### [00:21:13] Lenny

**English:**
Right. That's so true. The beginning of it is an adventure. And then that's such a good point because yeah, once you start a thing... Something I always say about this content creation life is like, it's easy to start. It's hard to keep it going, and it becomes just this treadmill of just, you have to keep creating awesome stuff basically for the rest of your life. I don't know how you get off the treadmill. Not that I'm complaining, but that's just a reality of this path. So that is such a good point that it becomes not adventurous very quickly. So that's really interesting.

**中文翻译:**
没错，太对了。开始的时候是冒险。这是一个很好的观点，因为一旦你开始了一件事……关于内容创作生活，我常说：开始很容易，坚持很难。它会变成一个跑步机，你基本上余生都得不断创作出色的东西。我不知道该怎么从跑步机上下来。我不是在抱怨，但这确实是这条路的现实。所以你说得很对，它很快就会变得不再具有冒险感。这很有趣。

---

### [00:21:13] Ada Chen Rekhi

**English:**
I love it.

**中文翻译:**
我喜欢这个观点。

---

### [00:21:42] Lenny

**English:**
I guess the other thing is just, what's a cutoff? What am I... I do a bunch of angel investing and so I'm thinking about just stopping that for a while just so I get up more time with my new child and just carve out things that maybe aren't as essential.

**中文翻译:**
我想另一件事就是，界限在哪里？我……我做了一些天使投资，所以我正考虑暂停一段时间，这样我就能有更多时间陪刚出生的孩子，砍掉那些可能没那么重要的事情。

---

### [00:21:55] Ada Chen Rekhi

**English:**
So on the values exercise, I think what you've done a really good job of is just really delineating, here are some examples of choices that you have to make. I think that there are some points in our lives where writing a book, it just seems really obvious. It's good for your career. It's the next level in terms of where you go from the community, the newsletter, the podcast and getting to that next level. But where I think there is value is these lists of values can help ground us from those obvious decisions. So in my life, to share a mini example of this, there have been a lot of cases where the next obvious step for me might be to go an executive at a big company and to go chase the dream and continue on the latter climb of my career.

**中文翻译:**
在价值观练习中，我认为你做得很好的一点是清晰地勾勒出了你必须做出的选择。我认为在人生的某些阶段，写书似乎是显而易见的：它对职业生涯有好处，是你在社区、通讯、播客之后更上一层楼的标志。但我认为价值观清单的价值在于，它能帮我们从那些“显而易见”的决定中抽离出来，让我们脚踏实地。在我的人生中，举个小例子，很多时候我下一步“显而易见”的选择是去大公司当高管，去追逐梦想，继续攀登职业阶梯。

---

### [00:22:40] Ada Chen Rekhi (Continued)

**English:**
As I've examined my own personal values, a big piece of it has really been around prioritizing relationships and really pursuing knowledge and growth on my own terms. And things like independence and autonomy have started to creep up over time, especially once I started a family. It became very clear to me that sometimes the external scorecard of what people think you should go do is very much an opposition of what I actually want to do. Even though it might be objectively better, depending on what scorecard you actually use, I would actually be less happy with some of those outcomes. So I think values are this really nice useful tool to think about how do you make better decisions again to maximize for your own alignment with life.

**中文翻译:**
但当我审视自己的个人价值观时，很大一部分其实是优先考虑人际关系，并按照自己的方式追求知识和成长。随着时间的推移，独立和自主等因素开始凸显，尤其是在我组建家庭之后。我非常清楚地意识到，有时别人认为你“应该”去做什么的外部计分卡，与我真正想做的事情是截然相反的。尽管从某种计分卡来看，那些选择可能客观上更好，但我对那些结果其实并不会感到开心。所以我认为价值观是一个非常实用的工具，能帮你做出更好的决定，从而最大限度地实现自我与生活的契合。

---

### [00:23:23] Lenny

**English:**
That's such an important point. It connects back to the course that I taught and then this potential book of, it just feels like an obvious thing I should do. It was great, but it just didn't bring me joy. And other things bring me more joy. So it was a really good reminder of just like, do I really want to be doing this, or is this just a thing that feels like a smart thing to do but maybe isn't for me psychologically? So I love just the reminder of coming back to values as a lens to decide if you want to do a thing versus just, what are people telling you? Smart or... Which just feels like the natural thing to do.

**中文翻译:**
这确实是非常重要的一点。这让我想起了我教过的课程，以及那本潜在的书——它们感觉像是我“应该”做的显而易见的事。虽然过程不错，但它们并没有带给我快乐。而其他事情带给我更多快乐。所以这是一个很好的提醒：我真的想做这件事吗？还是这只是件看起来很聪明、但心理上并不适合我的事？我非常喜欢这种回归价值观的视角，以此来决定是否要做某事，而不是仅仅听从别人的建议，或者去做那些看起来“聪明”或“自然而然”的事。

---

### [00:24:00] Ada Chen Rekhi

**English:**
Yeah, and it's really self-aware of you too. I think too. Cut it off because you start realizing that you're doing this course, and it's not giving you energy or it's not quite the right thing. It's really hard to say no to things.

**中文翻译:**
是的，而且你非常有自知之明。当你意识到做这门课并不能给你带来能量，或者它不太对劲时，果断停止。学会说“不”真的很难。

---

### [00:24:12] Lenny

**English:**
It is. It is.

**中文翻译:**
确实，确实很难。

---

### [00:24:12] Ada Chen Rekhi

**English:**
And I don't think we focus on that enough.

**中文翻译:**
我认为我们对此关注得还不够。

---

### [00:24:14] Lenny

**English:**
Yeah, I've learned how to do that better. I have all these auto templates of ways to say no in different ways. Actually, ChatGPT, somebody's tweeted this that it has all kinds of good suggestions. If you could ask it, how do I say no to my manager who wants me to prioritize a feature? And has all kinds of clever words to [inaudible 00:24:30].

**中文翻译:**
是的，我已经学会了如何做得更好。我有各种自动模板，用不同的方式说“不”。实际上，有人在推特上说 ChatGPT 有各种好的建议。你可以问它：“我该如何拒绝想要我优先处理某个功能的经理？”它会给出各种巧妙的措辞。

---

### [00:24:30] Ada Chen Rekhi

**English:**
Oh. Yeah, that's a great use for it.

**中文翻译:**
噢，那确实是个很棒的用途。

---

### [00:24:32] Lenny

**English:**
The other thing that I realized as we were going through this exercise that I imagine you find also is when you come up with an initial set of values, I was realizing I maybe another value of just keeping things simple, simplifying. And I imagine that's part of the process of narrowing in on what's important to you is you take this first pass and then you try to use it in making a decision and then you realize, oh, there's this other thing that's really important to me and that updates your values.

**中文翻译:**
在做这个练习的过程中我意识到的另一件事（我想你可能也发现了），就是当你列出最初的一组价值观时，我意识到我可能还有另一个价值观，那就是保持简单、简化。我想这就是明确什么对你重要的过程的一部分：你先做第一轮筛选，然后尝试用它来做决定，接着你会发现，“噢，还有另一件事对我非常重要”，从而更新你的价值观。

---

### [00:24:57] Ada Chen Rekhi

**English:**
Yeah, I think you could definitely use that process to force yourself to make a stack ring and to be really clear, and also change it. Change it. It's yours. So change it over time as it suits you.

**中文翻译:**
是的，我认为你完全可以利用这个过程强迫自己进行优先级排序，变得非常清晰，并且也可以改变它。改变它吧，它是属于你的。随着时间的推移，根据你的需要去调整它。

---

### [00:25:08] Lenny

**English:**
All right. It feels like there should be a curiosity loop AI bot with your values that you email, what should I do with this decision? And then it's like, oh, you think simplicity is great? You should not do this.

**中文翻译:**
好吧。感觉应该有一个带有你价值观的“好奇心循环 AI 机器人”，你发邮件问它：“关于这个决定我该怎么办？”然后它会说：“噢，你觉得简单很重要？那你就不该做这件事。”

---

### [00:25:20] Ada Chen Rekhi

**English:**
The next big idea.

**中文翻译:**
下一个伟大的创业点子。

---

### [00:25:22] Lenny

**English:**
There we go. Somebody build that. Okay, so it's funny we went into reverse interview, and then I have to asking questions again. So let's do this. You talked about your career and how you resisted these shiny object opportunities to focus on the thing that you were excited about and wanted to do. So maybe a couple questions there. One is just early career advice. You coach a lot of founders. You had a really in incredible career doing all kinds of interesting things. What have you learned about what works best for optimizing in your early career?

**中文翻译:**
没错，谁来开发一下。好，很有趣，我们刚才进入了反向采访模式，现在我得重新开始提问了。我们聊聊这个：你谈到了你的职业生涯，以及你如何抵制那些“闪闪发光”的机会，转而专注于让你兴奋和想做的事情。这里有两个问题。第一是关于早期职业建议。你辅导过很多创始人，你自己也有过非常精彩的职业生涯，做过各种有趣的事。关于在职业生涯早期如何进行最优选择，你学到了什么？

---

### [00:25:55] Ada Chen Rekhi

**English:**
My early career was pretty wild. So I had a really fast run. Over the course of seven years, I went from my first job, which was basically this entry level sales job at Microsoft, working on Microsoft adCenter to SVP of marketing at SurveyMonkey, leading a global team. And when I reflect back on what works across my early career, it really comes down in a nutshell to this career concept of explore and exploit, which actually sounds dark now that I'm saying it out loud, but-

**中文翻译:**
我的早期职业生涯相当疯狂。晋升非常快。在七年的时间里，我从第一份工作（基本上是微软 adCenter 的入门级销售）做到了 SurveyMonkey 的营销高级副总裁，领导一个全球团队。当我回想早期职业生涯中什么最有效时，简而言之，可以归结为一个职业概念：“探索与利用”（explore and exploit）。虽然大声说出来听着有点阴暗，但是——

---

### [00:26:27] Lenny

**English:**
Yeah, sounds great. I love it.

**中文翻译:**
不，听起来很棒。我喜欢。

---

### [00:26:29] Ada Chen Rekhi

**English:**
Explore and exploit, if you're familiar with it from growth background, is really just around what mode you're in. You're either in a mode of explorer where you have a bunch of unknowns and you're testing to see whether or not you like it, how well it works, whether or not it fits for you. Or you're exploiting, where you actually have found something that's really rich and really deep and then you're just trying to get more. And when I think about explore and exploit for early career, it's all about exploration. You really haven't experienced that much, but you're doing it with a thesis. You're doing it with that growth mindset where you have a hypothesis. So coming out of school, my first job was at Microsoft. I was at adCenter. The big thing I learned from the 367 days that I was there was that corporate life at that point in my career was just a little bit too slow-paced for me, and I was really hungry to go do something else.

**中文翻译:**
如果你熟悉增长背景，就知道“探索与利用”其实是指你所处的状态。要么处于“探索”模式，面对一堆未知，测试自己是否喜欢、效果如何、是否适合；要么处于“利用”模式，你已经发现了一些非常有价值、非常深厚的东西，然后努力获取更多。当我想到早期职业生涯的“探索与利用”时，重点全在探索。你其实还没经历过那么多，但你是带着“论题”去做的。你是带着增长心态和假设去做的。毕业后我的第一份工作在微软 adCenter。在那里的 367 天里，我学到的最重要的事是：在那个阶段，大公司的生活对我来说节奏太慢了，我非常渴望去做点别的。

---

### [00:27:19] Ada Chen Rekhi (Continued)

**English:**
But I also learned quite a lot about marketing and advertising. And I had the suspicion that not only did I want to try something smaller, but I also wanted to try marketing. So I moved to this series a startup where I had to sample my desk on the first day called Mochi Media. And I was in a marketing role at a startup and had this great run there over three years, where I learned all kinds of things and even tried product at some point. What I learned from that experience was then I love marketing, games was pretty fun and being in a smaller team was really dynamic. It was this choice on, do I exploit and go deeper into the industry or do I explore more? I was 23 at the time, so I decided I have so little to lose, let me continue exploring. My big thesis was, let me try being a founder. So then I founded Connected, and Connected was this personal CRM that's a little bit like Clay.

**中文翻译:**
但我也学到了很多关于营销和广告的知识。我隐约觉得，我不仅想尝试规模小一点的公司，还想尝试营销。于是我跳槽到了一家名为 Mochi Media 的 A 轮初创公司，第一天我还得自己组装办公桌。我在那家初创公司做营销，待了三年，学到了各种东西，甚至一度尝试了产品工作。那次经历让我明白我热爱营销，游戏行业挺有趣，小团队非常有活力。当时面临的选择是：我是该“利用”并深耕这个行业，还是继续“探索”？那时我 23 岁，我觉得自己没什么可失去的，那就继续探索吧。我的大论题是：让我试试当创始人。于是我创办了 Connected，那是一个个人 CRM（客户关系管理）工具，有点像现在的 Clay。

---

### [00:28:14] Lenny

**English:**
Yeah. It's a beautiful product.

**中文翻译:**
是的，那是个很漂亮的产品。

---

### [00:28:20] Ada Chen Rekhi

**English:**
Yeah, it's a beautiful product, much more beautiful than what we built at the time. It was such a great learning experience to discover what it was like to be a founder of a company and an entrepreneur. My personal learning out of all of those things was really just that I was continuously optimizing that I loved marketing. I loved being a founder. I really like small teams. There are pros and cons to this corporate life, where maybe things are really slow paced, but the scale is really important. So that was really what carried me through a lot of my early career. After Connected was acquired by LinkedIn, I moved into this exploit mode.

**中文翻译:**
是的，它很漂亮，比我们当时做的漂亮多了。发现如何成为一名公司创始人和企业家是一次非常棒的学习经历。从这些事情中我个人的收获是，我一直在不断优化：我发现我热爱营销，热爱当创始人，非常喜欢小团队。大公司生活有优有劣，虽然节奏慢，但规模效应非常重要。这就是支撑我走过早期职业生涯的核心。在 Connected 被 LinkedIn 收购后，我进入了“利用”模式。

---

### [00:28:59] Ada Chen Rekhi (Continued)

**English:**
So I was at LinkedIn for a period of time while I was investing, and I really wanted to be intentional about the time that I spent there in terms of how I wanted to exploit it. So unlike a traditional path where you're really focused on trying to get the biggest title, a big team, set yourself up to run a big org, my role at LinkedIn was really explicit. I even told my manager this when I first came in, "I'm here to learn to be a better founder." So there were a lot of things when I started connected, which I didn't know how to do very well, I didn't understand growth. I was fair to middling at pricing. I really didn't understand how to build a subscriptions business and how to price it. So if I can make my LinkedIn experiences match to that, that would be a huge win for me independent of promotion, or compensation or a whole bunch of those things because the plan afterward is actually to go off and start another company.

**中文翻译:**
我在 LinkedIn 待了一段时间，期间也做投资。我非常想有意识地利用在那里的时间。与传统的职业路径（专注于获得最高的头衔、带大团队、管理大部门）不同，我在 LinkedIn 的角色非常明确。我刚进去时甚至告诉我的经理：“我来这里是为了学习如何成为一名更好的创始人。”创办 Connected 时有很多事我做得不够好：我不懂增长，定价水平一般，完全不知道如何构建订阅业务以及如何定价。所以，如果我能让我在 LinkedIn 的经历与这些需求匹配，那对我来说就是巨大的胜利，这与晋升、薪酬等无关，因为我之后的计划是再去创办另一家公司。

---

### [00:29:53] Ada Chen Rekhi (Continued)

**English:**
So I managed to get into this great role leading gross marketing for LinkedIn, working with their growth team from a hundred million to 200 million members, read every experiment brief that I could, spent a lot of time with the team, really understanding their process, and then shifted into the subscription side where I worked on LinkedIn subscriptions and ran their sales subscriptions business at scale through the online channel. And saw how all of those pieces and worked together from a financial planning and analysis stage to all of the optimizations that they did. It was just such a rare opportunity, but I wouldn't have gotten those opportunities if I just let them promote me or I followed a strategy where I was just focused on trying to get the biggest title.

**中文翻译:**
所以我成功争取到了负责 LinkedIn 增长营销的职位，与增长团队一起见证了会员从 1 亿增长到 2 亿的过程。我阅读了每一份能读到的实验简报，花大量时间与团队在一起，深入了解他们的流程。然后我转到了订阅部门，负责 LinkedIn 的订阅业务，并通过线上渠道大规模运营他们的销售订阅业务。我看到了所有这些环节是如何从财务规划分析阶段到各种优化措施协同工作的。这是一个非常难得的机会，但如果我只是顺着公司的晋升路径走，或者只盯着最高头衔，我是得不到这些机会的。

---

### [00:30:35] Ada Chen Rekhi (Continued)

**English:**
Instead, I was focused on those learnings and those experiences. Ultimately, the fact that I was a startup founder. I had big company experience. I had growth experience, and I had subs experience. And I was a product marketer. That was actually the winning combination that caused SurveyMonkey to send me a LinkedIn InMail, start a conversation and ultimately bring me in as their head of marketing at the age of, I think I was 27 or 28 at the time. Because their rationale was, you have all these experiences that we really need and you don't have the management experience, but we have plenty of that. We're happy to teach that to you.

**中文翻译:**
相反，我专注于那些学习和经历。最终，我曾是初创公司创始人、有大公司经验、有增长经验、有订阅经验，还是产品营销人员——这些背景的结合成了致胜关键。这促使 SurveyMonkey 给我发了一封 LinkedIn 私信，开始了对话，并最终在我 27 或 28 岁时聘请我担任营销主管。因为他们的逻辑是：你拥有我们急需的所有这些经验，虽然你缺乏管理经验，但我们这里有很多管理人才，我们很乐意教你。

---

### [00:31:10] Lenny

**English:**
I really like this framework. I've never heard it described this way. Explore and exploit connects a lot with what I always recommend which, early on, is to optimize for a variety of experience so that you can figure out where you actually have a good time and what you're interested in versus getting stuck on the first thing something. I don't know if you'll have an immediate answer to this, but I'm curious. Many people don't know how long to stick with something that maybe doesn't feel good but may lead to something. Like, someone may be in a job right now, or just like, "I really don't like this job, but I feel like it'll lead to something great. And I don't want to give up too quickly." So I guess the question is, what are heuristics that tell you to stick it out and stick with something that you think will lead to something great versus hold the recording and get out?

**中文翻译:**
我非常喜欢这个框架。我从未听过有人这样描述它。“探索与利用”与我一直推荐的观点非常契合：早期要优化经验的多样性，这样你才能发现自己真正享受什么、对什么感兴趣，而不是被困在第一份工作上。我不知道你是否能立即回答这个问题，但我很好奇：很多人不知道该在那些感觉不太好、但可能带来好结果的事情上坚持多久。比如有人现在的工作很不顺心，但觉得它会通向伟大的前程，不想太快放弃。所以问题是：有哪些启发式方法（heuristics）能告诉你该坚持下去，还是该果断抽身？

---

### [00:32:01] Ada Chen Rekhi

**English:**
That's a great question, and it's a really tough one that is contextual on the person that you are. So one of the things that I like to share is this idea of, it's a little gory, don't be the frog. So if you are familiar with the story of the frog, it's this idea of boiling the frog. So if you take a frog, and you throw in a pot of boiling water, it'll jump out. But if you take a frog and you put in a pot and you increase the temperature degree by degree by degree, the frog doesn't notice and before it knows, it's boiled alive. And how I apply this to your question to come back and circle back to it is that, it's really easy to be a victim of inertia. It's really easy for all of us to be the frog where there are little things that make us uncomfortable, and we sit with them or we think, "Gosh, it'll get better. The next manager will get better. I'm always one conversation or one promotion away from getting to that next step."

**中文翻译:**
这是一个好问题，也是一个非常难回答的问题，因为它取决于你是什么样的人。我喜欢分享的一个观点是——虽然有点血腥——“别当那只青蛙”。如果你熟悉青蛙的故事，就是“温水煮青蛙”。如果你把青蛙扔进沸水里，它会跳出来。但如果你把它放进冷水里，一度一度地升温，青蛙察觉不到，等它意识到时已经被煮熟了。我把这应用到你的问题上：我们很容易成为“惯性”的受害者。我们都很容易成为那只青蛙，面对一些让我们不舒服的小事，我们忍着，或者想：“天哪，情况会好转的。下一个经理会更好。我离下一步只差一次谈话或一次晋升。”

---

### [00:33:02] Ada Chen Rekhi (Continued)

**English:**
But you really have to be aware of your surroundings. You have to be aware of which way is the direction of the temperature of the water trending. That's what makes the advice really contextual. I really look at it from the lens of learning. What can I learn here, and how am I growing and developing? So there might be an argument for you to stay at a job for two decades. If it turns out that every single day you're being really challenged, you're learning new things, you're deriving a lot of meaningful enjoyment out of your work and you're this happy frog that's hanging out, realizing that things are good and the temperature is not rising. But there are also situations where you might encounter just some really hard walls, where you don't get along with the thesis of the company. You don't agree with the direction of the company that you're in.

**中文翻译:**
但你必须意识到周围的环境。你必须意识到水温的趋势。这就是为什么建议必须结合语境。我通常从“学习”的角度来看待它：我在这里能学到什么？我如何成长和发展？如果你在一家公司待了 20 年，每天都面临挑战，学习新东西，从工作中获得意义和快乐，那你就是一只幸福的青蛙，水温并没有升高。但也有一些情况，你会遇到无法逾越的障碍，比如你不认同公司的核心理念，或者不同意公司的发展方向。

---

### [00:33:53] Ada Chen Rekhi (Continued)

**English:**
There are fundamental aspects of the role which are limiting to you or you're not learning a lot, frankly. I think that happens a lot, where you providing a lot of value and doing a good job at a company, but you might not be learning things that stretch you and grow you to achieve your ultimate goal. When you are aware of that learning, I think that's the point at which you have to say, "How do I change that? How do I be an agent in my own career and make a difference in that?" And it doesn't necessarily mean that the strategy is to quit your job and do something catastrophic, and then go do something else, take a course or sign up for something new. It might actually mean a proactive conversation with your manager or the leadership to say, "I love what I'm doing here, and I would also like to learn a little bit more. And here's what I'm interested in."

**中文翻译:**
坦率地说，有些职位的基本属性限制了你，或者你学不到太多东西。这种情况经常发生：你在公司提供了很多价值，工作也做得很好，但你学不到那些能让你突破、成长并实现最终目标的东西。当你意识到学习停滞时，你就得问：“我该如何改变？我该如何成为自己职业生涯的主导者并做出改变？”这并不一定意味着要辞职去做一些翻天覆地的大事，或者去上课、报名新项目。它可能意味着与你的经理或领导层进行一次积极的谈话，说：“我喜欢我现在的工作，但我也想多学一点。这是我感兴趣的方向。”

---

### [00:34:44] Ada Chen Rekhi (Continued)

**English:**
And then try to find a way to either land the right projects. So in my case, it was really growth and subscriptions, that experience that I really wanted. Let's say, you hit a blank wall there, even take it as a gift of time, which is great. I'm not going to be able to get this from my company, but now that I have this extra time because I'm so optimized at this job, how am I going to choose to use that time? And it might be around building relationships with some of the key people at the company or learning something new on your own time that you can leverage in another way.

**中文翻译:**
然后尝试争取到合适的项目。在我的案例中，我真正想要的是增长和订阅方面的经验。假设你在公司碰壁了，那也可以把它当作“时间的馈赠”。既然我无法从公司获得这些，而我又因为对这份工作驾轻就熟而有了额外的时间，我该如何利用这段时间？可能是与公司的一些关键人物建立关系，或者在业余时间学习一些可以以其他方式利用的新技能。

---

### [00:35:17] Lenny

**English:**
I like that. Make the most of the time, even if it's not the best opportunity for you. Also love the frog boiling metaphor.

**中文翻译:**
我喜欢这个。即使这不是最好的机会，也要充分利用时间。我也很喜欢温水煮青蛙的比喻。

---

### [00:35:23] Ada Chen Rekhi

**English:**
Little gory.

**中文翻译:**
有点血腥。

---

### [00:35:24] Lenny

**English:**
No, it's great. So I guess the lesson there is think about are you that frog being boiled right now and think ahead, is this going to be the end of the-

**中文翻译:**
不，很棒。所以教训是：思考一下你现在是不是那只正在被煮的青蛙，并预想一下，这是否会是——

---

### [00:35:24] Ada Chen Rekhi

**English:**
Right. Keep an eye on your environment and which way is it trending?

**中文翻译:**
没错。留意你的环境，看它正朝着哪个方向发展。

---

### [00:35:35] Lenny

**English:**
Yeah, the temperature on the thermostat in your office. The other thing this makes me think about is, it's so easy to get caught up in making your resume look amazing and continuing to just like, "Oh, if I get this next role, my resume's going to look so great." And this other logo and this cool title and role. I find that just like, you do that long enough in your life, you end up... You retire, and then you die. Life is that resume. Right? That is your life, you're living, and there's not going to be a point at which you have to realize, okay, I've done all the things to make my resume. Also, I'm like, "What do I actually want to do? Am I enjoying this?" Because it'll never end. You're never going to end trying to make a better resume and a more awesome background for yourself. Do you experience that with yourself or other people you work with of just over optimizing to make an awesome series of roles and logos and then forgetting, do I actually enjoy any of this? What am I doing?

**中文翻译:**
是的，就像办公室温控器上的温度。这让我想到的另一件事是：人们太容易陷入“让简历看起来很棒”的怪圈，总想着“如果我拿到下一个职位，我的简历会更好看”，还有那些大厂 Logo、酷炫的头衔。我发现如果你一辈子都这么干，最后……你退休，然后去世。人生就是那份简历，对吧？那是你正在度过的生活，不会有那么一个时刻让你突然意识到：“好了，我已经做完了所有美化简历的事。”我也会想：“我到底想做什么？我享受这个过程吗？”因为这永远没有尽头。你永远不会停止追求更好的简历和更牛的背景。你或你合作的人是否经历过这种“过度优化”——追求一系列光鲜的角色和 Logo，却忘了问：“我真的喜欢这些吗？我到底在干什么？”

---

### [00:36:31] Ada Chen Rekhi

**English:**
I have experienced that personally a lot. I think that it may be a generational thing or it just may be my background, but having grown up with the Asian tiger parenting, it's very focused on logos or certain accomplishments or certain achievements like, going to an Ivy League school, working in a company that someone's heard of, being able to have a certain title. At a certain point, I bailed out a bit and I really started to think about who am I trying to please and optimize for? That values exercise that I had you do, Lenny, is actually a big piece of that. So I probably took it for the first time over a decade ago, at this point. I looked at those values and I said, "Well, if I draw a straight line from where I am right now and just extend it forward and play the rest of the movie as it plays out, given the current plot line, how well does that optimize for those values?"

**中文翻译:**
我个人深有体会。我认为这可能是代际问题，也可能与我的背景有关。在亚洲“虎妈”式教育下长大，非常看重 Logo、某些成就或功绩，比如上常春藤盟校、在知名公司工作、拥有某种头衔。在某个时刻，我选择了退出这种竞争，开始思考：我到底在讨好谁？在为谁优化？Lenny，我让你做的那个价值观练习其实就是其中的重要部分。我第一次做这个练习大概是在十多年前。我看着那些价值观说：“如果我从现在的位置画一条直线向前延伸，按照目前的剧情把人生的电影放完，它在多大程度上优化了这些价值观？”

---

### [00:37:27] Ada Chen Rekhi (Continued)

**English:**
That's great. My parents might be happy about my resume or other people might look upon me in a certain way because I've managed these achievements, but in my day-to-day life, what really matters to me, what's really meaningful to me, only some of this stuff really matters. So getting very intentional about that and being clear about who your audience is as you navigate our career. I think it's a terrible outcome to wake up one day and be late career and feel trapped because you have a certain lifestyle or a certain expectations of the people around you that you have to go work this job, but then you look at yourself in the mirror and you're not happy going in there. I think that's a terrible trap that we should all try to avoid as we navigate our career paths and find the thing that's most optimal for us, which is usually a mix of career success, but also meaningfulness and alignment in the work that we're doing with our values.

**中文翻译:**
那很好，我的父母可能会为我的简历感到高兴，或者其他人会因为我的这些成就而对我另眼相看，但在我的日常生活中，真正对我重要、真正有意义的东西，其实只有一部分。所以在规划职业生涯时，要非常有意识，并明确你的“观众”是谁。我认为最糟糕的结果是，有一天醒来发现自己处于职业生涯后期，却感到被困住了——因为某种生活方式或周围人的期待，你不得不去做这份工作，但当你照镜子时，你发现自己并不开心。这是我们在职业道路上都应该努力避免的陷阱。我们应该寻找最适合自己的状态，这通常是职业成功、工作意义以及工作内容与个人价值观契合的结合体。

---

### [00:38:25] Lenny (Sponsor Break)

**English:**
I love this topic. Thank you for sharing that. This episode is brought to you by Sprig. You already heard me talk about how Sprig helps you uncover blind spots in your product development process, allowing you to better understand why users take certain actions and how they feel about the experience. Just this week, they launched their brand new templates library, which you can find at sprig.com/templates. Which helps you plug and play proven playbooks for helping you identify and solve the biggest challenges facing product teams today. From how to optimize an existing feature to improving a conversion flow, to troubleshooting drop off. One of the questions I get most on this podcast and in my newsletter is how to develop your product sense. So I decided to work with Sprig to build a playbook for how to do just that, based on my experience at Airbnb and what I learned from interviewing top product people like, Jules Walter who wrote a whole guest post on how to develop your product sense, which informed this template that you'll find. Just go to sprig.com/templates to find this playbook and 85 more that is sprig.com/templates. S-P-R-I-G.com/plates.

**中文翻译:**
我喜欢这个话题。谢谢你的分享。本期节目由 Sprig 赞助。你已经听我谈过 Sprig 如何帮助你发现产品开发过程中的盲点，让你更好地理解用户为什么采取某些行动，以及他们对体验的感受。就在本周，他们推出了全新的模板库，你可以在 sprig.com/templates 找到。它能帮你即插即用地使用经过验证的实战手册，识别并解决当今产品团队面临的最大挑战：从优化现有功能到改善转化流，再到排查用户流失。在这个播客和我的通讯中，我收到的最多的问题之一就是如何培养产品感。因此，我决定与 Sprig 合作，根据我在 Airbnb 的经验以及从采访 Jules Walter 等顶尖产品人那里学到的知识，构建一个实战手册。只需访问 sprig.com/templates 即可找到这个手册以及其他 85 个模板。

---

### [00:39:31] Lenny

**English:**
What triggered your reevaluation of that path? Was there just like a, "Oh, man. I need to really rethink where I'm going." And then I have a follow-up question.

**中文翻译:**
是什么触发了你对那条道路的重新评估？是突然觉得“噢，天哪，我真的需要重新思考我的方向”吗？我还有一个后续问题。

---

### [00:39:40] Ada Chen Rekhi

**English:**
Really just a career opportunity. And it was this step where I could do something that was, at the time, really high profile and really exciting and felt great, but also involved demanding travel and grueling hours. And wasn't in a space that I was excited about, but it looked amazing on my resume. And I was talking to a friend about it, and they actually introduced me to this values exercise to say like, "Ada, go through and fill out this values exercise, and apply it to this job." What I realized at the time, after I did it, was that my top three values, the things that I cared about this job would categorically just fail at because I would be gone all the time, in pursuit of glory that I didn't really care about. Instead, my current path at the time was something that if I persisted in, it would actually be able to potentially fulfill all of those values.

**中文翻译:**
其实就是一个职业机会。那是一个当时看起来非常高端、非常令人兴奋、感觉很棒的职位，但也涉及频繁的出差和超长的工作时间。而且它所在的领域并不是我感兴趣的，只是简历上看起来会很漂亮。我当时和一个朋友聊起这件事，他向我介绍了这个价值观练习，说：“Ada，去做一下这个练习，然后把它应用到这份工作上。”做完之后我意识到，我最看重的三个价值观，这份工作完全无法满足，因为我会一直出差，去追求那些我并不真正关心的荣耀。相反，如果我坚持当时的道路，它反而有可能实现我所有的价值观。

---

### [00:40:36] Lenny

**English:**
It reminds me of a friend who has this metaphor of this ego monster sitting in the corner of the room that's always yelling at them, when they're... To do the thing that's impressive and take on the really cool role, and just get an awesome title, and do something really impressive, that's just like yelling at them from the corner. And my friend's just learned to just like, "Okay, that's the ego monster pulling at me. I don't have to listen to that. Doesn't mean I'm going to be happy if I listen to this guy." And that's been really helpful to my friend just to disassociate that part of the brain.

**中文翻译:**
这让我想起一个朋友，他有一个比喻：房间角落里坐着一个“自我怪兽”（ego monster），总是在对他大喊大叫，让他去做那些令人印象深刻的事，去接那些酷炫的角色，去拿牛逼的头衔。我的朋友学会了这样想：“好吧，那是自我怪兽在拉扯我。我不必听它的。听它的并不意味着我会快乐。”这对他将大脑的那部分功能剥离出来非常有帮助。

---

### [00:41:10] Ada Chen Rekhi

**English:**
Yeah. The ego monster is a great way to put it. I use something that Warren Buffet has talked about, which is inner scorecard versus outer scorecard.

**中文翻译:**
是的，“自我怪兽”这个说法很棒。我用的是沃伦·巴菲特谈过的一个概念：内部计分卡 vs. 外部计分卡。

---

### [00:41:19] Lenny

**English:**
Tell me more.

**中文翻译:**
多讲讲。

---

### [00:41:20] Ada Chen Rekhi

**English:**
So he talks about how there's an outer scorecard, which is how the rest of the world evaluates you, how you keep score in terms of external factors. So top 10 lists, wealth status, title, maybe things that people really care about. And then your inner scorecard is things that actually matter to you, how you spent your day, how good of a person you are. Did you have an adventure today, Lenny? Were you kind? And there are a lot of things that maybe are in opposition to each other. So really thinking about did you win at the cost of kindness? Did you succeed at the cost of losing access to the adventure that you really wanted? I think really thinking about it in that lens helps you trade off against some of that external pressure and the ego monster.

**中文翻译:**
他谈到外部计分卡是世界如何评价你，你如何根据外部因素给自己打分，比如前十名榜单、财富地位、头衔，这些人们非常看重的东西。而内部计分卡是那些对你真正重要的东西：你这一天是怎么过的，你是一个多么好的人。Lenny，你今天冒险了吗？你善良吗？很多时候这两者是相互对立的。所以要思考：你是否以牺牲善良为代价赢得了胜利？你是否以失去你真正想要的冒险为代价获得了成功？我认为从这个角度思考，能帮你抵御外部压力和那个“自我怪兽”。

---

### [00:42:11] Lenny

**English:**
This might be a good segue to chat about coaching. I imagine a lot of people listening to this like, "Yes, I want to do that. I want to measure myself according to my values and check in on this. And am I doing the wrong path?" It's hard to do just on your own, I find. And I think that's one of the benefits of an executive coach. So maybe we just chat about what should people know about coaching and getting a coach, and does everyone need a coach and how to think about the idea of getting a coach at some point in their career.

**中文翻译:**
这可能是聊聊“教练服务”（coaching）的一个很好的切入点。我猜很多听众会想：“是的，我也想这么做。我想根据我的价值观来衡量自己，审视自己是否走错了路。”但我发现，仅靠自己很难做到。我认为这就是高管教练的优势之一。所以我们聊聊关于教练服务人们应该了解什么，如何找教练，是否每个人都需要教练，以及如何考虑在职业生涯的某个阶段找个教练。

---

### [00:42:42] Ada Chen Rekhi

**English:**
I'll have a hot take on this, and it's something that I share to people when I talk to them about coaching. But my hot take is that for the vast majority of people, they probably do not need a coach.

**中文翻译:**
关于这一点我有一个“非主流观点”（hot take），这也是我与人谈论教练服务时常分享的。我的观点是：对于绝大多数人来说，他们可能并不需要教练。

---

### [00:42:52] Lenny

**English:**
Great.

**中文翻译:**
太好了。

---

### [00:42:54] Ada Chen Rekhi

**English:**
And what I often push people on is if you're thinking about getting a coach, which is usually an indication that they have a feeling of being stuck or they have a problem that they're trying to solve, I ask them, "What are your goals when it comes to coaching? Roll it forward six months, what have you gotten done in your coaching experience. What have you accomplished, and you're just... It's like, a home run. And then look at all of the potential alternatives in terms of how you could have spent your valuable time and often pricey fees to achieve the same goal, but maybe in a better way." The thing that people don't really think about is if you're looking for a mentor, a coach is actually a terrible mentor in some ways because it's this one person's opinion. It's actually way better to run a curiosity loop, for example, and get the benefit a couple different minds on a specific topic and hit their wheelhouse of things that they know about. Than to go ask one person, what do you think I should do in this situation?

**中文翻译:**
我经常追问那些想找教练的人（这通常意味着他们感到被困住了或有想解决的问题）：“你找教练的目标是什么？快进到六个月后，你在教练体验中完成了什么？你取得了什么成就，让你觉得像打出了全垒打？然后看看所有潜在的替代方案，看看你如何利用宝贵的时间和通常昂贵的费用来达到同样的目标，甚至是以更好的方式。”人们没意识到的是，如果你在找导师（mentor），教练在某些方面其实是个糟糕的导师，因为那只是一个人的意见。实际上，运行一个“好奇心循环”要好得多，比如针对特定话题获取几个不同大脑的见解，触及他们的擅长领域，而不是只问一个人：“你觉得在这种情况下我该怎么办？”

---

### [00:43:58] Ada Chen Rekhi (Continued)

**English:**
If you're trying to learn about a topic in a really robust way, let's say you want to learn about growth, maybe you should take are Reforge course and get access to all of the resources and the insights of the EIRs and the growth advisors that Reforge and get an overview and survey of the landscape instead of one person's experience and the handful of companies that they might have worked with. Likewise, if you're just feeling like you're a little emotionally overcome, I think coaches are this great resource around that, but it's actually better to pay it forward and build a tribe and a community of people around you that you can rely on for support because that's the thing that lasts you for years and years.

**中文翻译:**
如果你想系统地学习某个主题，比如增长，也许你应该去上 Reforge 的课程，获取所有资源以及 Reforge 的驻场企业家（EIR）和增长顾问的见解，获得整个领域的全景概览，而不是仅仅依赖一个人的经验和他合作过的几家公司。同样，如果你只是感到情绪上有些难以承受，教练确实是很好的资源，但更好的做法是“回馈社会”，在你周围建立一个你可以依靠的部落和社区，因为那才是能陪伴你多年的东西。

---

### [00:44:38] Ada Chen Rekhi (Continued)

**English:**
So one of the first things that I do when people talk to me about coaching is I challenge them and say, "Have you explored all of these other opportunities first, and do you really need a coach? And is a coach actually the best option for you?" Like an anti sell, just so that they know what they're getting themselves into because I don't necessarily think that it's useful for all things, even though it can be helpful.

**中文翻译:**
所以当人们和我谈起教练服务时，我做的第一件事就是挑战他们：“你是否先探索了所有这些其他机会？你真的需要教练吗？教练真的是你的最佳选择吗？”这就像是一种“反向推销”（anti-sell），只是为了让他们知道自己在做什么，因为我不认为教练对所有事情都有用，尽管它确实有帮助。

---

### [00:44:59] Lenny

**English:**
And then when do you find that it's actually important and valuable and something someone should try to get?

**中文翻译:**
那么，你什么时候觉得它实际上是重要且有价值的，是某人应该尝试去获得的？

---

### [00:45:06] Ada Chen Rekhi

**English:**
I wouldn't be a coach if I didn't think that it wasn't important and valuable. I think that in certain contexts it can be super helpful. So when you have situations where you're in a state of hyper growth, and you need very accelerated learning, and you need someone who can point you in the right direction, I think coaches can be really helpful. So I work with founders for example, and founders are just in this unique state where everything is chaos. They have no structure. They don't know what their jobs are. They have fully justified imposter syndrome where no one in their right mind would objectively have hired them for the position that they're in. There's really intense highs and lows. So for a founder, it might make a lot of sense to get a coach because they have to learn a lot of stuff really quickly, and time is of the essence.

**中文翻译:**
如果我不认为它重要且有价值，我就不会当教练了。我认为在某些语境下它超级有用。比如当你处于“超速增长”（hyper growth）状态，需要极速学习，需要有人指点迷津时，教练会非常有帮助。例如我合作的创始人，他们处于一种独特的混沌状态：没有结构，不知道自己的职责是什么，有着完全合理的“冒充者综合征”（imposter syndrome）——因为客观来说，任何理智的人都不会雇佣他们担任现在的职位。情绪起伏非常剧烈。所以对于创始人来说，找个教练非常有意义，因为他们必须快速学习大量东西，而且时间紧迫。

---

### [00:45:54] Ada Chen Rekhi (Continued)

**English:**
So a coach might be a really helpful shortcut for them to get there. Related to that, I think it's also really helpful on sensitive topics. So there are a lot of things that we want to be coached on where either it takes a lot of time for us to work through and progress because it's a long-term project, for example, or it's something very sensitive. People issues and interpersonal conflicts. Coaches can be especially helpful in those cases because it's this really safe space for you to work through things, but also have someone who's really rational to help guide you through them with potentially some frameworks and extra advice.

**中文翻译:**
所以教练可能是他们达成目标的捷径。除此之外，我认为在处理敏感话题时也很有帮助。有很多事情我们希望得到指导，要么是因为它需要很长时间去消化和推进（比如长期项目），要么是因为它非常敏感，比如人事问题和人际冲突。在这些情况下，教练特别有用，因为他为你提供了一个非常安全的空间去处理问题，同时还有一个非常理性的人用一些框架和额外建议来引导你。

---

### [00:46:30] Lenny

**English:**
So I had a couple coaches in my career and what made me feel like I should pursue that is when you think about a sports athlete or, I don't know, athlete. No one does not have a coach, the best athletes have coaches and they get great because they have somebody helping them get better. It's not just like an accident. They don't just learn on their own. It just makes you realize that other people in their profession that have a coach helping them out are just going to be more successful because innately, they have someone helping them learn how to do the job better. So that made me realize, man, I should probably get a coach to help me out with stuff. Even though there wasn't anything super specific, I'm like, "Oh, I need to fix this problem." It was just like, wow, this just intellectually make sense. So it was actually really important and transformative for me.

**中文翻译:**
在我的职业生涯中请过几个教练。让我觉得应该这么做的是，当你想到运动员时，没有哪个顶尖运动员是没有教练的。他们之所以伟大，是因为有人在帮他们变得更好。这不只是偶然，他们不只是靠自学。这让你意识到，在其他行业，有教练辅助的人往往会更成功，因为天生就有人在帮他们学习如何把工作做得更好。所以这让我意识到，我也该找个教练帮帮我。虽然当时没有什么超级具体的问题要解决，但我只是觉得，哇，这在逻辑上是说得通的。所以这对我来说确实非常重要，且具有变革意义。

---

### [00:47:21] Ada Chen Rekhi

**English:**
If you go to my site, I actually have this guide that I've written over time on both my take on how do you find a coach, and the TLDR there is actually that I strongly recommend to everyone. If you're thinking about getting a coach, talk to two or three different coaches. And really get a sense of their vibe and how well you get to know them. It's surprising because I did this piece of research, which I also wrote about, and we could link to, but I talked to over 80 people about their experiences with a coach. I talked including coaches, including founders, including executives and there's this shocking data point in there where half of people that founder their coach literally went with the first coach that they talked to. It's that your buddy said, "I work with this great coach." And then you go and you hire your buddy's coach.

**中文翻译:**
如果你访问我的网站，你会看到我写的一份关于如何找教练的指南。核心观点（TLDR）是我强烈建议每个人：如果你考虑找教练，先和两三个不同的教练聊聊。真正感受一下他们的气场（vibe），以及你们之间的契合度。这很令人惊讶，因为我做过一项研究（我也写成了文章，我们可以放个链接），我采访了 80 多位有教练体验的人，包括教练、创始人和高管。其中有一个惊人的数据点：一半的人在找教练时，直接选择了他们谈过的第一个教练。通常是你的哥们说“我这个教练很棒”，然后你就直接雇了你哥们的教练。

---

### [00:48:08] Ada Chen Rekhi (Continued)

**English:**
I think that's a totally fine way to go find a coach, but I would actually really just urge people to talk to a couple because what works for your friend may not work for you. And just being able to see some of the variance in terms of the style and how people get along, I think that can make a huge difference in terms of this reflection of how do you learn best? When you think about acquiring a new skill, do you love structure? Do you not like structure? Do you like it when someone really teaches you and walks you through specific examples, or do you frameworks? Coaches come in all of those different flavors. So I think it's really worth it to explore before you get into such a deep relationship with someone, just so that both people can feel really sure about it.

**中文翻译:**
我认为这是一种完全可以的找教练方式，但我真的敦促大家多聊几个，因为适合你朋友的不一定适合你。能够看到风格上的差异以及相处方式的不同，对于反思“你如何学习效果最好”会有巨大帮助。当你考虑习得新技能时，你喜欢有结构的吗？还是不喜欢？你喜欢有人手把手教你具体案例，还是喜欢框架？教练有各种各样的风格。所以在进入一段如此深厚的关系之前，多探索一下是非常值得的，这样双方都能感到非常笃定。

---

### [00:48:51] Lenny

**English:**
What's one thing that people may not think about or just something that you find really important that maybe is unexpected when you're looking for a coach?

**中文翻译:**
在找教练时，有什么是人们可能没考虑到，或者你觉得非常重要但可能出人意料的事？

---

### [00:49:00] Ada Chen Rekhi

**English:**
I thought that credentials and the relevant experience of the coach was a huge factor in terms of how you should go about your coach selection. But part of the interviews that I did was talking to founders that had had experiences with coaches and asking them to reflect back, and these founders and executives when they thought about it, they actually said so much more about, it was actually this amorphous sense of vibe with the person, how safe you felt with them, how deeply you would explore with them, and how well they got you, and remembered the pieces of the conversation and help you put it together. Way more than potentially some experiences that they'd had, where this person had the perfect background, but they just never really connected on that level. So it was unintuitive to me that there was such a big piece of it that was around personal connection, which is why I've now pushed people to try to talk to a couple different people.

**中文翻译:**
我原以为资历和相关经验是选择教练的关键因素。但在我采访那些有过教练体验的创始人时，让他们回想，这些创始人和高管谈论最多的其实是那种难以言喻的“气场感”：你和他们在一起感觉有多安全，你能和他们探讨多深，他们有多懂你，以及他们如何记住谈话的碎片并帮你拼凑起来。这比某些拥有完美背景但从未在灵魂层面产生连接的经历要重要得多。对我来说，个人连接占据如此大的比重是很反直觉的，这也是为什么我现在推崇大家多和几个人聊聊。

---

### [00:49:55] Ada Chen Rekhi (Continued)

**English:**
And then the other thing which comes back to the sports coaching analogy is that there are different coaches that are really good at different things. So just like how, if you're a star tennis player, you might actually have multiple coaches working with you, maybe an offensive coach or a defensive coach or working on a particular swing. It actually makes sense when you're really performing at a high level to consider having coaches that work with you on shorter term basis to really just work on your speaking or help you with getting into your groove on writing or help you achieve a specific goal. You shouldn't think about it as this long-term commitment to stay with one person, but instead more choosing off of a menu and thinking about what goal are you trying to achieve right now?

**中文翻译:**
另一件事回到了体育教练的类比：不同的教练擅长不同的事。就像如果你是网球明星，你可能有多个教练：进攻教练、防守教练，或者专门纠正某个挥拍动作的教练。当你处于高水平竞争时，考虑请一些短期教练来专门训练你的演讲、帮你进入写作状态或达成某个特定目标，是非常合理的。你不应该把它看作是对一个人的长期承诺，而应该像从菜单里点菜一样，思考你现在想达成什么目标。

---

### [00:50:39] Lenny

**English:**
Does anyone ever get multiple executive coaches that... I like how we went from, you don't need a coach to maybe need a month [inaudible 00:50:46] hamstrings.

**中文翻译:**
真的有人会请多个高管教练吗？我喜欢我们话题的转变：从“你不需要教练”变成了“你可能每个月都需要一个”。

---

### [00:50:48] Ada Chen Rekhi

**English:**
Yes. I know of multiple people that I've talked to, usually CEOs, that either have had a series of coaches or have multiple coaches. It makes a lot more sense, Lenny, when you think about someone who's getting a pitch coach because they're about to get into fundraising.

**中文翻译:**
是的。我认识好几个我聊过的人，通常是 CEO，他们要么先后请过一系列教练，要么同时有多个教练。Lenny，当你想到有人因为要融资而请一个专门的“路演教练”（pitch coach）时，这就非常合理了。

---

### [00:51:04] Lenny

**English:**
Got it. Right. Niche skills.

**中文翻译:**
明白了。没错，针对特定技能。

---

### [00:51:05] Ada Chen Rekhi

**English:**
Right. For niche things because they're about to enter a process or someone who's trying to get into a writing coach-

**中文翻译:**
没错。针对特定领域，因为他们即将进入某个流程，或者有人想找写作教练——

---

### [00:51:11] Lenny

**English:**
Got it. Yeah.

**中文翻译:**
明白，是的。

---

### [00:51:13] Ada Chen Rekhi

**English:**
... in addition to some of their executive and leadership work that they might be doing.

**中文翻译:**
……作为他们正在进行的高管和领导力训练的补充。

---

### [00:51:17] Lenny

**English:**
Okay. That makes sense. I love it. I'm going to get four coaches. One for everything I do.

**中文翻译:**
好，这有道理。我喜欢。我要请四个教练，我做的每件事都配一个。

---

### [00:51:23] Ada Chen Rekhi

**English:**
A podcast coach.

**中文翻译:**
一个播客教练。

---

### [00:51:23] Lenny

**English:**
Podcast coach.

**中文翻译:**
播客教练。

---

### [00:51:25] Ada Chen Rekhi

**English:**
A newsletter coach.

**中文翻译:**
一个通讯教练。

---

### [00:51:26] Lenny

**English:**
A writing coach, and a-

**中文翻译:**
一个写作教练，还有一个——

---

### [00:51:30] Ada Chen Rekhi

**English:**
Yes. And then a parent coach. Don't forget that.

**中文翻译:**
是的，还有育儿教练。别忘了那个。

---

### [00:51:30] Lenny

**English:**
Parent coach. A job board coach, and then just a life coach. Okay. I'm on it. Okay. So let's touch on the thing that your friends said we shouldn't touch on, which is being a woman in leadership in Silicon Valley. I guess I'll just frame it simply. Imagine there's many young women listening to this podcast, and many may dream of a career like yours, all the things you've shared. What advice do you have for young women just starting out in their career hoping to find a similar path?

**中文翻译:**
育儿教练。一个招聘板教练，然后就是一个人生教练。好，我记下了。好，那我们来聊聊你朋友说不该碰的话题：作为女性在硅谷担任领导者。我简单描述一下：想象有很多年轻女性在听这个播客，她们可能梦想拥有像你一样的职业生涯。对于那些刚开始职业生涯、希望走上类似道路的年轻女性，你有什么建议？

---

### [00:52:03] Ada Chen Rekhi

**English:**
This is a really delicate subject, and it's interesting because when I try to decompose why people gave me the feedback they gave me on this topic, I think a big piece of it is just that you want to have respect for the inherent challenges of being a non stereotypically great fit for leadership roles or certain career success roles in Silicon Valley and acknowledge that. And also try to push for some of the agency of the things that you can do. So I'm going to start with just this quick story about someone that I worked with who's given me permission to share this, in a coaching context and then back out. So I was working with a seed stage founder, and she's so smart. She is really dynamic, very, very focused, really, really great at taking feedback and actioning it. She's one of those people that is just stellar, and I have no doubt that she's going to make a huge dent in the universe.

**中文翻译:**
这是一个非常微妙的话题。有趣的是，当我试图分析为什么人们给我那样的反馈时，我认为很大一部分原因是：你既要尊重那些非典型领导者在硅谷面临的固有挑战，承认它们的存在，同时又要努力发挥自己的主观能动性。我想先分享一个我辅导过的创始人的故事（她允许我分享）。我曾与一位种子轮创始人合作，她非常聪明、充满活力、非常专注，而且非常擅长接受反馈并付诸行动。她是那种出类拔萃的人，我毫不怀疑她会改变世界。

---

### [00:52:58] Ada Chen Rekhi (Continued)

**English:**
We've been working together on Zoom for a couple of months, and I'd built this great respect for her competence as an operator, and the way that she thought and took apart problems and then acted on them. And then we met together for the first time in person at lunch. I feel almost nervous talking about this here. The disparity between my sense of who she was as an operator and how she came across to me initially at this lunch was really striking in that it was a weekday lunch and she was dressed as if she was hanging out on the weekend. So old T-shirt, hair back and in a claw, bra straps were showing. She was just incredibly casual in terms of her physical appearance. It took me almost like a little bit of a step back to reevaluate and think, "Oh, this is the same person, but she actually just presents so differently.

**中文翻译:**
我们在 Zoom 上合作了几个月，我对她作为运营者的能力、她思考和拆解问题的方式以及执行力充满了敬意。然后我们第一次在线下共进午餐。在这里谈论这个我甚至感到有点紧张。我认知中那个干练的运营者，与她在午餐时给我的第一印象之间的差距非常惊人：那是工作日的午餐，但她的打扮就像是在过周末。旧 T 恤，头发用抓夹随便一夹，内衣肩带都露出来了。她的外表极其随意。这让我不得不退后一步重新评估：“噢，这是同一个人，但她的呈现方式完全不同。”

---

### [00:53:54] Ada Chen Rekhi (Continued)

**English:**
So then I took the step after we met and I gave her that feedback in one of our next coaching sessions where we invited each other to give each other feedback. I shared a lot of my impressions with her and I told her, "I respect you so much as an operator. I want to tell you that in the physical meeting that we had together, there was this disparity on how I would've potentially perceived you when I first met you in person versus what I've come to know about you from the months that we spent together."

**中文翻译:**
见面后，在下一次教练环节中，我们互相邀请对方给出反馈，于是我迈出了那一步。我向她分享了我的印象，我说：“我非常尊重你作为运营者的能力。我想告诉你，在我们线下的见面中，如果我是第一次见到你，我可能会产生的认知，与我们相处数月后我对你的了解之间存在巨大的差异。”

---

### [00:54:27] Ada Chen Rekhi (Continued)

**English:**
Her reaction was like, "Oh my God, Ada. No one has ever connected the dots for me. Thank you so much. It has never explicitly been told to me that some of these elements which you describe, and they're very easy for me to fix and I'm motivated to fix them, are things that might actually trigger certain impressions or biases. No one's actually said it to me before, and I'm about to go into fundraising. It's actually super helpful for me to hear this, that these are controllable elements of my physical attire or my appearance that might actually just affect the way that people perceive me. And then it gives me this extra hump to get over, in terms of getting to this point of credibility for them to see me as a seasoned operator that I am." She took it so well. But what was interesting about it was actually that she'd made it all this way in her career. She'd even raised funding, and no one had ever given her this feedback.

**中文翻译:**
她的反应是：“噢天哪，Ada。从来没有人帮我把这些点串联起来。太感谢了。从来没有人明确告诉我，你描述的这些元素（它们很容易修复，我也很有动力去修复）实际上可能会触发某些印象或偏见。以前真的没人跟我说过，而我马上就要去融资了。听到这些对我非常有帮助，这些是我外表或着装中可控的元素，却可能影响别人对我的看法。这会让我为了建立可信度、让他们看到我真实的老练运营能力而不得不付出额外的努力。”她接受得非常好。但有趣的是，她在职业生涯中走了这么远，甚至已经融过资了，却从未有人给她过这样的反馈。

---

### [00:55:21] Ada Chen Rekhi (Continued)

**English:**
So this is, I think one of the big challenges of being a woman in Silicon Valley because getting to an executive role or getting to a funded founder role, it's like an Olympic level sport. You have to get all the way through the funnel and become one of the few that are really chosen to do that. But the difficulty of this game is that no one tells you the rules of the game. You actually don't really know what are the rules on how to get intros or give intros. What's the right way to follow up? What are the impressions that people have about you? It turns out that in a career context, it's so unsafe for your manager to turn to a young woman on the team and say, "Here, let me give you feedback on your physical appearance, and how it affects your competence and how you're perceived in the workforce." That the vast majority of them will just never do it because there's no winning, which is similar to the feedback that I got.

**中文翻译:**
我认为这就是作为女性在硅谷面临的巨大挑战之一。因为要成为高管或获得融资的创始人，就像参加奥运会级别的运动。你必须通过层层筛选，成为极少数被选中的人。但这场游戏的难点在于，没人告诉你游戏规则。你其实并不知道如何获得引荐或提供引荐的规则。正确的跟进方式是什么？人们对你的印象是什么？事实证明，在职业背景下，经理很难对团队里的年轻女性说：“来，我给你一些关于外表的反馈，以及它如何影响你的能力评估和职场形象。”绝大多数人永远不会这么做，因为吃力不讨好，这和我收到的那个反馈是一样的。

---

### [00:56:16] Ada Chen Rekhi (Continued)

**English:**
SO where I lean in is to say, we're not powerless and there's something that all of us can do if we're in a position where we feel like not even about being female, it's about being perceived as too young or too old, too tall, too short, not the right race. Whatever reason that you feel people may be disqualifying you or not seeing you. We're not powerless, even though this game is rigged. We can study the game, we can help each other, and we can actually start to call out some of those rules and then find ways around them. In this case, for the founder in this example, she really turned to her friends and did a mini makeover and amped up her appearance.

**中文翻译:**
所以我坚持认为，我们并非无能为力。如果我们处于某种劣势——不只是性别，还包括被认为太年轻或太老、太高或太矮、种族不对——无论出于什么原因让你觉得别人在否定你或忽视你，我们都有应对之策。虽然这场游戏可能存在不公，但我们并非无能为力。我们可以研究游戏规则，互相帮助，指出那些潜规则并找到应对方法。在这个例子中，那位创始人向朋友求助，进行了一次形象改造，提升了自己的外表。

---

### [00:57:03] Ada Chen Rekhi (Continued)

**English:**
And she came back and she reported, "A lot of people have been giving me really positive feedback, that something about me feels more confident and more energetic, and they can't figure out why." But actually, she was getting a ton of people noticing that something was really different about her in a positive way simply because I was in this great position as her coach to give her some of these pieces of hard feedback that she had never heard before. So it's really on us to try to find those and then try to adapt ourselves to play that game if you want to play at that level.

**中文翻译:**
她后来告诉我：“很多人都给了我非常积极的反馈，说我看起来更自信、更有活力了，但他们不知道为什么。”实际上，很多人都注意到了她身上发生的积极变化，仅仅是因为我作为她的教练，处在一个绝佳的位置，给了她一些她从未听过的逆耳忠言。所以，如果我们想在那个水平上竞争，就必须主动寻找这些反馈，并调整自己去适应游戏规则。

---

### [00:57:33] Lenny

**English:**
How nervous were you giving her that feedback?

**中文翻译:**
你给她那个反馈时有多紧张？

---

### [00:57:37] Ada Chen Rekhi

**English:**
I was so nervous. I actually almost didn't do it, and then took a deep breath and then decided, what the heck? I think she's great. I think she would really benefit from doing it and I gave it. Even in a position where I'm in a relationship with her where I can have that trust, it was super, super difficult. So I can only imagine how hard it is for people to give feedback like that in another context, but how else are people going to hear it?

**中文翻译:**
我非常紧张。我差点就没说，然后深吸一口气，心想：“管它呢，我觉得她很棒，我觉得这会对她大有裨益。”于是我说了。即使我和她之间有这种信任关系，这依然超级、超级难。所以我完全可以想象在其他语境下给这种反馈有多难，但如果不说，人们又该从哪里听到真相呢？

---

### [00:58:03] Lenny

**English:**
I think there was a company culture where they talk about how you're being selfish, not giving someone hard feedback because you don't want to be stressed or risk causing damage to your own reputation. But you're not helping them. So it's a really interesting insight of just like, don't be selfish. Do something that's hard when you think it's going to help someone else.

**中文翻译:**
我记得有一种公司文化提到，不给别人逆耳的反馈其实是自私的表现，因为你只是不想让自己感到压力，或者不想冒险损害自己的名声。但你并没有帮到他们。所以这是一个非常有趣的见解：不要自私。当你认为这能帮到别人时，去做那些困难的事。

---

### [00:58:26] Ada Chen Rekhi

**English:**
Right. But I think on the topic of being female or on the topic of physical appearance or maybe even some of the topics around being an immigrant, if you're in a position where you can give that feedback, I think the struggle is often will it be well received? And that's where the feedback comes from me from the curiosity loop for this piece, which was there's almost no winning in doing it because the upside is something great happens for them. But there's just so many downsides to giving advice or giving someone input like that the default course is just to avoid. But then that person never learns the rules of the game.

**中文翻译:**
没错。但在涉及女性、外表甚至移民等话题时，如果你处于可以给反馈的位置，纠结的点往往在于：对方会接受吗？这就是我从好奇心循环中得到的反馈：做这件事几乎没有赢面，因为好处是对方的，而给这种建议的坏处却很多，所以默认的做法就是回避。但这样一来，那个人就永远学不会游戏规则。

---

### [00:59:05] Lenny

**English:**
Yeah, absolutely. It makes me think also a little bit about Radical Candor, basically. I don't know if you read that book, but

**中文翻译:**
是的，绝对如此。这让我想到了《彻底坦诚》（Radical Candor）。不知道你读过那本书没？

---

### [00:59:14] Ada Chen Rekhi

**English:**
Yeah, Kim Malone Scott, I think.

**中文翻译:**
读过，我想是 Kim Malone Scott 写的。

---

### [00:59:16] Lenny

**English:**
Yeah. And Sheryl Sandberg had a similar story where she... I think Sheryl Sandberg gave her a really hard feedback and she didn't take it that well, actually. I think you did a better job, or your friend actually took the feedback and did something with it. I think the whole book was just like, "Hey, I actually do this where people actually listen." I think the framework is, you got to communicate that you care deeply about that person, but you want to challenge them directly also at the same time.

**中文翻译:**
是的。谢丽尔·桑德伯格（Sheryl Sandberg）也有类似的故事，她给过 Kim 极其严厉的反馈，Kim 当时其实接受得并不好。我觉得你做得更好，或者说你的朋友真的听进去了并付诸行动。整本书的核心就是：“嘿，我这样做是为了让人们真正听进去。”我认为那个框架是：你必须传达出你深切关心那个人，但同时也要直接挑战他们。

---

### [00:59:40] Ada Chen Rekhi

**English:**
Yeah, it's a great story. I think Sheryl Sandberg took her aside after one of her meetings and basically told her that, "If you say um, it makes me sound stupid." And she didn't take that well, but at the same time, later on in retrospect, she reflected that it was so brave and so helpful of someone like Sheryl to go give that feedback because there's a real cost to it. There's real risk to it.

**中文翻译:**
是的，那是个很棒的故事。谢丽尔·桑德伯格在一次会议后把她拉到一边，基本上是告诉她：“如果你总说‘嗯’，会让你听起来很蠢。”她当时没接受，但后来回想起来，她觉得谢丽尔能给出那样的反馈是多么勇敢和有帮助，因为那是需要付出代价和承担风险的。

---

### [01:00:09] Lenny

**English:**
Any other thoughts or advice along these lines that you want to leave people with?

**中文翻译:**
关于这方面，你还有什么想留给大家的想法或建议吗？

---

### [01:00:13] Ada Chen Rekhi

**English:**
The biggest piece of advice that I have that comes to mind is really around trying to be really thoughtful on something I call eating your vegetables. So I have all these branded terms for things, but-

**中文翻译:**
我能想到的最大的建议是关于我称之为“吃蔬菜”的思考。我给很多事情都起了品牌化的名字，但是——

---

### [01:00:13] Lenny

**English:**
That's great.

**中文翻译:**
那很棒。

---

### [01:00:30] Ada Chen Rekhi

**English:**
... eating your vegetables is really this idea around how little kids don't really develop an appreciation for vegetables until they're 10 or 12 exposures in. So the researchers say, "Expose kids to vegetables 10 or 12 times, even if they don't like it, because that's what it takes to get someone to like something." So when I think about career strategy and when I think about improving yourself and I think about how do we look for some of the hard feedback, eating your vegetables is this really important component of it because it's about how do you identify dislike for something because you're bad at it or you're new to it or you've never done it before, compared to genuine dislike where you've done it and you really don't like it. So to make it a little bit real, if we think about the world of podcasts, Lenny, I think it's something like 75 or 80% of podcasts never make it past the first podcast.

**中文翻译:**
……“吃蔬菜”这个概念源于：小孩子通常要接触 10 到 12 次才会开始喜欢蔬菜。研究人员说：“让孩子接触蔬菜 10 到 12 次，即使他们不喜欢，因为这是让人喜欢上某样东西所需的次数。”当我思考职业策略、自我提升以及如何寻找逆耳反馈时，“吃蔬菜”是一个非常重要的组成部分。因为它关乎你如何区分：你是因为不擅长、刚接触或从未做过而讨厌某事，还是因为你做过了且真的不喜欢它。举个现实的例子，Lenny，在播客界，我想大约 75% 到 80% 的播客在录完第一集后就夭折了。

---

### [01:01:25] Ada Chen Rekhi (Continued)

**English:**
You have to do things a number of times before you really develop an affinity for it. Because the first time you do it, you're just not going to be good. So my mini example of that was early on in my career, I was really awkward and not very good at networking. I moved to Silicon Valley and one of the things that people told me about Silicon Valley was that it's really important to grow your network. It's all about the people. Totally agree about that. However, I didn't know anyone, and I didn't really understand this networking thing. So I gave myself this rule where I had to go out once a week for a couple of months, go to an external event, and I would count out 10 business cards. And the rule was, I had to hand out all 10 of those business cards by introducing myself to people that were new, and touch the back wall of the venue of that event and then I could leave.

**中文翻译:**
你必须多次尝试某件事，才能真正培养出对它的喜爱。因为第一次做时，你肯定做得不好。我自己的一个小例子是：在职业生涯早期，我不擅长社交，感觉很尴尬。我搬到硅谷，人们告诉我硅谷最重要的是扩展人脉，一切都关乎人。我完全同意。然而，我不认识任何人，也不懂社交。于是我给自己定了个规矩：连续几个月每周出去一次，参加一个外部活动，我会数出 10 张名片。规则是：我必须通过向陌生人介绍自己把这 10 张名片全部发出去，并且必须摸到活动场地的后墙，然后才能离开。

---

### [01:02:15] Ada Chen Rekhi (Continued)

**English:**
I did that a couple of weeks in a row, and it was horrible. It was really awful, but it got a lot better. What I realized about that was actually two things. One that, as I started going and I saw familiar faces, it became a lot easier for me to just break in and meet people, just by seeing who people I knew already were talking to. And then second, I got a lot better at just breaking in and introducing myself and understanding how this intro and networking thing worked in terms of meeting people and moving through a crowd. Some of those relationships now from that first job and those first couple months are pretty much foundational to the network and the people that I know today. So it really paid off for me because I really focused on eating my vegetables and powering through that initial discomfort.

**中文翻译:**
我连续几周都这么做，起初感觉糟透了。真的很痛苦，但后来好多了。我意识到两件事：第一，随着我参加次数增多，我开始看到熟面孔，通过观察熟人在和谁聊天，我更容易切入并结识新朋友。第二，我变得更擅长主动介绍自己，理解了在人群中结识新朋友的社交规则。我在第一份工作和最初几个月建立的一些关系，基本上构成了我今天人脉网的基础。所以这对我来说非常有回报，因为我专注于“吃蔬菜”，熬过了最初的不适。

---

### [01:03:00] Ada Chen Rekhi (Continued)

**English:**
So to title back when it comes to thinking about how do you progress in your career, think about the obvious things that maybe you're not very good at, and then think about what are some of the actions that you can do to be very deliberate and intentional about practicing it to get to the point where you have some faculty at it because it's just really important in some cases to be good at certain skills.

**中文翻译:**
所以回到职业发展的话题：想想那些你可能不擅长的显而易见的事，然后思考你可以采取哪些行动，有意识、有目的地去练习，直到你掌握这些技能。因为在某些情况下，掌握某些技能真的非常重要。

---

### [01:03:24] Lenny

**English:**
I really like that. I also really like the physicality of that rule of touching the back wall. It just forces you to go through a room, and I just escape really quickly. Is there any other examples of things you've seen or recommend for doing things like, eating vegetables? That was a really good example of just forcing yourself to go to a networking event, touch the back wall. Is there anything else, any other examples that come to mind that you've recommended or found useful, doing something really hard that was really impactful?

**中文翻译:**
我非常喜欢这个。我也很喜欢“摸后墙”这个规则的身体参与感。它强迫你穿过整个房间，而不是很快溜掉。关于“吃蔬菜”，你还有什么见过或推荐的例子吗？强迫自己参加社交活动并摸后墙是个很好的例子。还有别的吗？有没有其他你推荐过或觉得有用的、虽然很难但影响深远的例子？

---

### [01:03:53] Ada Chen Rekhi

**English:**
Yeah. So there are actually a few of them. A lot of them around content creation because it's just so hard. So one of them that comes to mind is, I know a lot of people have talked about doing a LinkedIn 30. So 30 days of posting something on LinkedIn in terms of content every day for 30 days straight, and just getting past that barrier of sharing. And then looking at it over time and seeing out of the things that you posted, what really resonated. I also think it's helpful to start thinking about things like getting into DMs. Right. It takes a lot of work to think about, "Oh, this person's really smart, let me DM them. Let me try to strike up a conversation because we're well out of the world of physical business cards. I don't think anyone has those anymore.

**中文翻译:**
有的，其实有好几个。很多是关于内容创作的，因为那真的很难。我想到的是很多人谈论过的“LinkedIn 30”：连续 30 天每天在 LinkedIn 上发布内容，以此突破分享的心理障碍。然后随着时间的推移，观察你发布的内容中哪些真正引起了共鸣。我也认为开始尝试私信（DM）很有帮助。去想“噢，这个人很聪明，我给他发个私信，试着开始对话”是需要勇气的，因为我们已经远离了纸质名片的时代，我想现在没人用那个了。

---

### [01:04:34] Lenny

**English:**
No.

**中文翻译:**
确实没有了。

---

### [01:04:35] Ada Chen Rekhi

**English:**
But modern networking is finding people that are really interesting on the internet and then finding some way to connect with them. It takes a certain amount of extroversion in that case to start meeting up with people and having conversations with them. So forcing yourself in some way to really think about, "Well, instead of having one outreach and then failing at it and saying, 'I'm never doing that again.' How do I actually create a pattern where I can learn or a sequence of trying to do this 10 or 12 times, and see what I get out of it?" Because that's really how you learn and how you grow.

**中文翻译:**
现代社交是在互联网上找到有趣的人，然后想办法与他们建立联系。这需要一定的外向性去约人见面并交谈。所以要强迫自己去想：“与其只尝试一次失败后就说‘我再也不干了’，我该如何建立一个学习模式，或者连续尝试 10 到 12 次，看看能收获什么？”因为这才是你学习和成长的方式。

---

### [01:05:07] Lenny

**English:**
The LinkedIn 30 idea, I like a lot. Something that I'll share as a tip is when you hear that, I bet a lot of people are just like, "Oh, my God. Going to link post on LinkedIn. So cringey. I don't want to be this self-promotiony LinkedIn person." But what I find is if you reframe it to, "I just want to crystallize a thought that I have and just share something that is useful to me or an insight I've had, and not think of it from, I'm trying to get as many likes. I'm trying to go viral with this post, or I'm trying to just build some following." Just don't think of it that way. Think of it as just want to communicate a thought I have and use this opportunity to crystallize it in a really simple way. That helps motivate. That, at least, works for me. It also ends up being useful for me. It's not like I'm trying to grow some following as a result of that.

**中文翻译:**
我非常喜欢 LinkedIn 30 这个点子。我想分享一个小贴士：当人们听到这个时，我敢打赌很多人会想：“噢天哪，在 LinkedIn 上发帖，太尴尬了（cringey）。我不想成为那种自我推销的 LinkedIn 红人。”但我发现，如果你把它重新定义为：“我只是想把我的一个想法具体化，分享一些对我也有用的东西或我的见解”，而不是想着“我要获得多少赞、我要让这篇帖子疯传、我要涨粉”。别那样想。把它看作是沟通你的想法，并利用这个机会用简单的方式把它理清楚。这有助于产生动力，至少对我有效。而且这对我自己也很有用，不仅仅是为了涨粉。

---

### [01:05:59] Ada Chen Rekhi

**English:**
I find that really helpful as well. One piece of advice that's similar to that that I've heard is, write for an audience of one. Imagine you're just talking to a friend or you're trying to talk to someone that's a trusted colleague, and just write for them. I think that's really helpful, and it helps us with the problem of getting in over your skis, really over fixating on the outcome of, I did a post and I didn't get my 5,000 followers. And instead, just thinking about I did a post because I wanted to share an interesting idea, and then how cool, some people resonated with it.

**中文翻译:**
我也觉得这很有帮助。我听过一个类似的建议：为“一个人的观众”而写。想象你只是在和一位朋友或一位信任的同事聊天，只为他们而写。我认为这非常有用，它能帮我们解决“操之过急”的问题，避免过度关注结果（比如“我发了帖但没涨 5000 粉”）。相反，只需想：“我发帖是因为我想分享一个有趣的想法，如果有人产生共鸣，那太酷了。”

---

### [01:06:31] Lenny

**English:**
Yeah, I love that. You could just even say, something I found useful day one and just approach it that way. That's the stuff that end up being most interesting to people. The less it feels like you're trying to be thirsty for followers and likes and all that stuff. And the more it's just like, here's the thing I've found useful. Enjoy it, if you can.

**中文翻译:**
是的，我喜欢。你甚至可以开头说：“第一天，我发现了一些有用的东西”，就这样开始。这种内容往往最吸引人。越不让人觉得你渴望粉丝和赞，越让人觉得“这是我觉得有用的东西，希望你也喜欢”，效果就越好。

---

### [01:06:49] Ada Chen Rekhi

**English:**
Yeah. Yeah. People can really tell when you're being genuine and authentic online.

**中文翻译:**
没错。人们真的能分辨出你在网上是否真诚和真实。

---

### [01:06:53] Lenny

**English:**
Absolutely. More and more. Maybe a last question. You started a company with your partner. You're both co-founders, you and your husband. I'm curious, what's your take on that approach to starting company? Would you recommend for other folks or not?

**中文翻译:**
绝对如此，越来越明显。最后一个问题：你是和你的伴侣一起创业的，你和你丈夫都是联合创始人。我很好奇，你对这种创业方式怎么看？你会推荐给别人吗？

---

### [01:07:10] Ada Chen Rekhi

**English:**
If you had asked me when I first started the company, it would've been an enthusiastic hell yes. I totally recommend. Now, I have a couple asterisks on top of it, and-

**中文翻译:**
如果你在我刚创业时问我，我会热情地说：“当然，绝对推荐！”现在，我得加几个星号（备注）了，而且——

---

### [01:07:10] Lenny

**English:**
Go on.

**中文翻译:**
请继续。

---

### [01:07:23] Ada Chen Rekhi

**English:**
... I think it really just goes back to what I was talking about earlier where being a founder is such a traumatic and crazy experience with all these intense highs and lows and lack of structure that when you throw romance into the mix, it's just this really volatile combination. So what I've found is that it seems like it either goes really well or it goes really badly, and there's no in between. And asterisks are there because we've actually had a couple of friends try it, and it's been such a mixed bag of results. So my personal experience is I love it. My partner Sachin, and I work really well together. And the main benefit that we have is that the active founding is such an active obsession that you spend so much of your time thinking about your business and the concepts of your business and whatever problem you happen to be facing.

**中文翻译:**
……我认为这回到了我之前说的：当创始人是一次充满创伤和疯狂的经历，有着剧烈的情绪起伏且缺乏结构。当你把浪漫关系掺和进来时，这会变成一个非常不稳定的组合。我发现，这要么结果非常好，要么结果非常糟，没有中间地带。加星号是因为我们有几个朋友尝试过，结果褒贬不一。我个人的经验是：我热爱这种方式。我的伴侣 Sachin 和我配合得非常好。我们获得的主要好处是：创业是一种极度的痴迷，你会花大量时间思考业务、理念和面临的问题。

---

### [01:08:11] Ada Chen Rekhi (Continued)

**English:**
That when I had this thesis of I want to be a founder too, we played it out and said, "Well, okay, now we're going to walk around being obsessed about two completely different things. We may never see each other, and so why not try the same thing?" So our first experiment was actually trying it together, and we were nuts. I actually had a 30, 60 and 90 day plan where we would have check-ins. And some of the explicit questions in the check-in, is this affecting our relationship? Because I just wanted to make sure we were putting our relationship first. It worked well for us to the extent that we've done two companies together. And then when we were at LinkedIn, we actually moved across multiple teams in the company and continued to be counterparts and product and marketing together. So it's been phenomenal. The thing that I would say really helps us in terms of making it a successful relationship was things that I think apply to anyone that's thinking about, should you work with a person and should you be a co-founder with this person?

**中文翻译:**
当我也有了当创始人的想法时，我们推演了一下：“好吧，如果我们各自创业，我们会对两个完全不同的东西痴迷，可能永远见不到面，那为什么不尝试同一件事呢？”所以我们的第一次实验就是一起创业，我们当时很疯狂。我甚至制定了一个 30、60、90 天的计划，定期进行检查。检查中的一个明确问题是：“这影响我们的关系了吗？”因为我想确保我们把关系放在第一位。这对我们非常有效，以至于我们一起创办了两家公司。在 LinkedIn 时，我们甚至在多个团队中调动，继续作为产品和营销的搭档。这太棒了。我认为让这种关系成功的因素，也适用于任何考虑“是否该和某人一起工作”或“是否该和某人成为联合创始人”的人。

---

### [01:09:08] Ada Chen Rekhi (Continued)

**English:**
We had a very, very good set of complimentary domains and skillsets, so we had really clear decision making rights. Sachin does product design and engineering. I focus on marketing, operations, finance, everything else on the business side. And because of that, it's really clear that we take input from each other, but ultimately who makes the call and who's driving and owning that project. So that was really helpful for us. And then the big part that I think is the murky Meyer for couples and maybe even for close friends working together is how do you engage in constructive conflict? How do you get to the point where you're attacking the problem and not each other? So if your partner comes to you and says that work was not good, that marketing plan or that product roadmap that you put together, not good, do you take it as the plan is not good and let's talk about what we can actually do to fix it?

**中文翻译:**
我们拥有一套非常互补的领域知识和技能，所以决策权非常清晰。Sachin 负责产品设计和工程，我专注于营销、运营、财务以及业务方面的其他所有事情。正因如此，我们很清楚虽然会听取对方的意见，但最终由谁拍板、由谁负责推进项目。这对我们很有帮助。我认为对于夫妻甚至好朋友一起工作来说，最难处理的部分是：如何进行“建设性冲突”？你如何做到只针对问题而不针对人？如果你的伴侣对你说“这项工作做得不好，你做的营销计划或产品路线图不行”，你是把它看作“计划不好，让我们谈谈怎么修复”，还是看作“他觉得我不行”？

---

### [01:10:06] Ada Chen Rekhi (Continued)

**English:**
Or do you take it as, "Oh, gosh, they think I'm not good. They think I'm too lazy. I saw that look that they were giving me." And take it as this personal offense. So the ability to be really truth seeking and take the most respectful interpretation when you're giving feedback to focus on trying to get to a smart good outcome that benefits the business, I think that's actually one of the most crucial things that you have to think about. If you're going to work with anyone. Much less your partner or a close friend on starting a company and what's really worked for us,

**中文翻译:**
或者你会想：“噢天哪，他觉得我不够好，他觉得我太懒了，我看到了他看我的那个眼神”，并把它当作人身攻击。所以，在给出反馈时，能够真正追求真理并采取最尊重的解释方式，专注于为业务争取一个聪明、良好的结果，我认为这是你必须考虑的最关键的事情之一。无论你和谁一起工作都是如此，更不用说和你的伴侣或好朋友一起创业了。这就是对我们真正有效的方法。

---

### [01:10:37] Lenny

**English:**
I am very impressed with how you're able to execute on this. I don't think I could do this with my wife. That would not go well, I think. You should probably write-

**中文翻译:**
我对你们的执行力印象非常深刻。我觉得我没法和妻子一起工作，那肯定会出问题。你应该写一篇——

---

### [01:10:37] Ada Chen Rekhi

**English:**
That's self awareness.

**中文翻译:**
这就是自知之明。

---

### [01:10:48] Lenny

**English:**
Yeah. No, we're aware. You should write a post on how to successfully build a company with your partner. That seems like you have a lot of really interesting frameworks and insights on how it's worked. The fact that-

**中文翻译:**
是的，我们很有自知之明。你应该写一篇关于“如何成功地与伴侣共同创业”的文章。看起来你有很多关于这方面如何运作的有趣框架和见解。

---

### [01:10:57] Ada Chen Rekhi

**English:**
That's a good idea.

**中文翻译:**
这是个好主意。

---

### [01:10:58] Lenny

**English:**
... [inaudible 01:10:58] for so long. Yeah, it could be its own little book. Is there anything else you wanted to share or touch on before we get to our very exciting lightning round?

**中文翻译:**
……坚持了这么久。是的，这甚至可以写成一本小书。在我们进入非常令人兴奋的闪电轮提问之前，你还有什么想分享或提到的吗？

---

### [01:11:06] Ada Chen Rekhi

**English:**
I think you covered most of it, Lenny.

**中文翻译:**
我想你已经涵盖了大部分内容，Lenny。

---

### [01:11:08] Lenny

**English:**
With that then, we have reached our very exciting lightning round. I've got five questions for you. Are you ready?

**中文翻译:**
那么，我们进入了非常令人兴奋的闪电轮。我有五个问题要问你。准备好了吗？

---

### [01:11:15] Ada Chen Rekhi

**English:**
I am ready.

**中文翻译:**
准备好了。

---

### [01:11:17] Lenny

**English:**
What are two or three books that you've recommended most to other people?

**中文翻译:**
你向别人推荐最多的两三本书是什么？

---

### [01:11:20] Ada Chen Rekhi

**English:**
Persuasion by Robert Cialdini. I think it's a great book, if you're a marketer. It's a great book, if you're a founder or product person. But it really is a breakdown of what are the different strategies to get people to say yes and help persuade them toward things. I think it really helps in terms of thinking through that and designing a product or a business around it.

**中文翻译:**
罗伯特·西奥迪尼（Robert Cialdini）的《影响力》（Persuasion）。如果你是营销人员，这是一本伟大的书；如果你是创始人或产品人，它同样出色。它详细拆解了让人们说“是”并说服他们采取行动的不同策略。我认为它在思考和设计产品或业务方面非常有帮助。

---

### [01:11:40] Lenny

**English:**
I've got that in my bookshelf behind me.

**中文翻译:**
我身后的书架上就有那本书。

---

### [01:11:43] Ada Chen Rekhi

**English:**
Oh, yeah. It's a great book. Yeah. The next book that I also recommend is a book called Designing Your Life, and it's out of the Stanford Design School. And it's by, let me look, Bill Burnett and Dave Evans. They're two Stanford D School professors, and what they're doing is they're applying design principles to life design. So how do you actually map that next level career that's both meaningful and fulfilling and also achieves maybe some of the success factors that you really care about, and brainstorm and be really creative about it. So when people are stuck or thinking about career strategy, that's actually one of the books that I always point out for them.

**中文翻译:**
噢是的，那是本好书。我推荐的下一本书叫《斯坦福大学人生设计课》（Designing Your Life），出自斯坦福设计学院。作者是 Bill Burnett 和 Dave Evans。他们是两位斯坦福教授，他们将设计原则应用于人生设计。比如你如何规划下一个阶段的职业生涯，使其既有意义又充实，同时还能实现你关心的成功因素，并对此进行富有创造力的头脑风暴。当人们感到迷茫或思考职业策略时，这是我总是向他们推荐的书之一。

---

### [01:12:23] Lenny

**English:**
What's a favorite recent movie or TV show?

**中文翻译:**
最近最喜欢的电影或电视剧是什么？

---

### [01:12:25] Ada Chen Rekhi

**English:**
So Ted Lasso is back, so I'm watching that, the newest season. I am also a Star Trek nerd, so I'm watching Star Trek: Strange New Worlds.

**中文翻译:**
《足球教练》（Ted Lasso）回归了，所以我正在看最新一季。我还是个《星际迷航》迷，所以我正在看《星际迷航：奇异新世界》。

---

### [01:12:25] Lenny

**English:**
I didn't know there's a new Star Trek. That's good to know.

**中文翻译:**
我不知道有新的《星际迷航》，这消息不错。

---

### [01:12:41] Ada Chen Rekhi

**English:**
Oh, It's so good. I think the thing I love about Star Trek is just that, unlike some of the classic storylines that you see right now on TV coming out now, sometimes the episodes are just happy. They explore a planet. Nothing bad happens. They see something really wondrous. They all leave happy, and they pat themselves on the back for having explored something. It's something that's missing in the genre of TV that they still have, this happiness factor where sometimes life is good and sometimes life is bad.

**中文翻译:**
噢，它非常棒。我喜欢《星际迷航》的一点是，不像现在电视上的一些经典剧情，有时剧集就是很单纯的快乐。他们探索一颗星球，没发生什么坏事，他们看到了奇观，最后大家都开心地离开，为探索了新事物而感到自豪。这是现在的电视剧中缺失的一种特质——那种纯粹的幸福感，即生活有时就是美好的。

---

### [01:13:09] Lenny

**English:**
I like the sound of that. Although, I've learned about storytelling for a story to be interesting. There needs to be some conflict or problem. So I imagine there's something going wrong somewhere in the middle.

**中文翻译:**
听起来不错。虽然我学到的讲故事技巧是，一个故事要有趣必须有冲突或问题。所以我猜中间肯定还是出了点什么状况。

---

### [01:13:20] Ada Chen Rekhi

**English:**
But it's not wrong. It's something interesting happens.

**中文翻译:**
但那不是“错误”，而是发生了一些有趣的事。

---

### [01:13:23] Lenny

**English:**
Oh.

**中文翻译:**
噢。

---

### [01:13:23] Ada Chen Rekhi

**English:**
And then it's resolved, and it's happy. Right. But it just doesn't always need to be, something tries to kill you.

**中文翻译:**
然后问题解决了，大家都很开心。没错。但并不总是需要那种“有什么东西想要杀了你”的桥段。

---

### [01:13:28] Lenny

**English:**
I got to watch that. That sounds great. I was a huge Star Trek fan back in the day. Didn't know they were still making new ones. What's a favorite interview question you like to ask when you're interviewing people?

**中文翻译:**
我得去看看。听起来很棒。我以前也是个超级《星际迷航》迷，不知道他们还在拍新的。面试别人时，你最喜欢问的问题是什么？

---

### [01:13:37] Ada Chen Rekhi

**English:**
What's a common misconception people have about you? I usually like to throw that in toward the end of the interview, and the reason why I think it's really useful is it's a way for me to reset my bias. I may have had a certain impression about them, and this is their opportunity to speak up and say, "Hey, a lot of people think this about me, but it's not true." It's also this reflection of their self-awareness.

**中文翻译:**
“人们对你最常见的误解是什么？”我通常喜欢在面试快结束时抛出这个问题。我认为它非常有用的原因是，它能帮我重置偏见。我可能对他们已经有了某种印象，而这是他们发声的机会：“嘿，很多人这么看我，但事实并非如此。”这也能反映出他们的自我意识。

---

### [01:14:01] Lenny

**English:**
Great. What are some products that you've recently discovered or use regularly, SaaS products or even consumer fun random products that you want to share?

**中文翻译:**
太棒了。最近有没有发现或经常使用的产品？SaaS 产品，或者有趣的消费类产品都可以分享。

---

### [01:14:14] Ada Chen Rekhi

**English:**
Yeah. I can't go through this podcast without giving a shout-out to Notejoy. So Notejoy is a fast and focused notes app for individuals and teams. So that's the company that I work on. So I use it for everything from Noora product roadmaps to my coaching notes, to even prepping for something like this podcast. I use Notejoy all the time. Another one that I really use a lot is Captio. It's been around for a while, but it's a little iOS app. I don't know if it's on Android, but basically it's a blank notepad. You can dump your brain into it, and there's one button, and it emails it to you. So when I find that I'm really distracted, or I just want to remember something, I use Captio all the time just to quickly capture my ideas. And then I process it later in my inbox.

**中文翻译:**
当然。如果不提一下 Notejoy，我就没法录完这个播客。Notejoy 是一款面向个人和团队的快速、专注的笔记应用，也是我正在经营的公司。我用它来做任何事，从产品路线图到教练笔记，甚至是准备这次播客。我一直在用 Notejoy。另一个我经常用的是 Captio。它已经存在一段时间了，是一个 iOS 小应用（不知道有没有安卓版）。基本上它就是一个空白记事本，你可以把脑子里的东西倒进去，按一个键，它就会发邮件给你。当我感到分心或只想记住某件事时，我会用 Captio 快速捕捉想法，稍后再在收件箱里处理。

---

### [01:14:53] Ada Chen Rekhi (Continued)

**English:**
And then something that I just downloaded this week is Arc, the new browser. I'm actually really excited about its vision. I'm not sure if I'm going to work it into my workflow yet or how it fits in, but it's really beautiful and it's really cool to see someone iterating on the cluster that is browser tabs.

**中文翻译:**
还有我这周刚下载的 Arc，那个新浏览器。我对它的愿景感到非常兴奋。我不确定是否会把它纳入我的工作流，或者它如何适配，但它真的很漂亮，看到有人在改进浏览器标签页这一团乱麻，真的很酷。

---

### [01:15:11] Lenny

**English:**
Yep. Love Arc. Went deep on Arc in the previous episode and I used Captio, however you call it. And I found another app, actually, the similar thing that I found even more simple. It's called Note to Self, just sits on my doc. Anytime I want to email myself a thought, I open it up and this type of thing. Somehow, it ends up being even easier. So that's another one to check out, Note to Self. Final question. You're really big on productivity. What's one tip that you found that has been really helpful for you in your day-to-day life, being more productive?

**中文翻译:**
是的，我也喜欢 Arc。在上一集里我们深入探讨过 Arc。我也用过 Captio。实际上我发现了另一个类似的、甚至更简单的应用，叫 Note to Self，就放在我的 Dock 栏上。任何时候我想给自己发个想法，打开它输入就行。不知为何，它用起来更简单。所以那是另一个值得尝试的：Note to Self。最后一个问题：你非常看重生产力，在日常生活中，有什么能让你变得更高产的秘诀吗？

---

### [01:15:43] Ada Chen Rekhi

**English:**
Figure out, maybe the night before, the one thing that you want to get done in your day, and then at the earliest opportunity, just try to give yourself five minutes on it. Just five minutes. And the reason why I say five minutes is that there is this challenge that I experience and maybe other people experience as well, which is really just productive procrastination. Even though I know something is really important that needs to get done, I will often do other things that are useful and need to get done simply because I'm avoiding that one thing. And then before you know it's the end of the day and I'm like, "I still have to go do that thing." By really focusing on what's the number one thing and then just getting started on it a little bit. It just makes it really lightweight. And usually, what I find is that five minutes turns into a solid hour just knocking that thing out early in my day, and I feel really accomplished. But it's a mental hurdle that I really struggle with.

**中文翻译:**
在前一天晚上想好你第二天最想完成的一件事。然后在最早的机会，试着只花五分钟在上面。就五分钟。之所以说五分钟，是因为我（可能其他人也是）面临一个挑战，叫“生产性拖延”。即使我知道某件事非常重要，我也会去做其他有用且需要做的事，仅仅是因为我在逃避那件最重要的事。等回过神来已经到傍晚了，我心想：“我还是得去做那件事。”通过专注于头号大事并只开始做一点点，这会让心理负担变得很轻。通常我发现，那五分钟会变成一个小时，让我一大早就搞定它，感觉非常有成就感。但这确实是我一直在努力克服的一个心理障碍。

---

### [01:16:37] Lenny

**English:**
I really like the approach of the five minutes because that's such a trick to get you to like, "All right, I'll just do five minutes. I got to get this done."

**中文翻译:**
我非常喜欢“五分钟法”，因为这是一种心理暗示：“好吧，我就做五分钟，我得把这个搞定。”

---

### [01:16:44] Ada Chen Rekhi

**English:**
Right. It's quick.

**中文翻译:**
没错，很快。

---

### [01:16:44] Lenny

**English:**
I need to bring it. Yeah. There's a book that many people on this podcast have recommended called Make Time, and there's a framework within that called The Highlight, where you pick the highlight of your day, and that's the thing you got to do first and make... That's like, if you do nothing else, do your highlight and-

**中文翻译:**
我得试试。是的，这个播客里很多人推荐过一本书叫《设计时间》（Make Time），里面有一个框架叫“每日高光”（The Highlight），你选出一天中的高光任务，那是你必须首先完成的事……如果你什么都不做，至少完成你的高光任务——

---

### [01:16:59] Ada Chen Rekhi

**English:**
Yeah, really similar then.

**中文翻译:**
是的，那非常相似。

---

### [01:17:01] Lenny

**English:**
Yeah, and they don't do the five-minute thing, so I think that's a clever element of it. Ada, this was amazing. This chat was full of feelings, and frogs, and vegetables, and frameworks and insights. Thank you again so much for being here. Two final questions. Where can folks find you online if they want to learn more, reach out and how can listeners be useful to you?

**中文翻译:**
是的，但他们没提到“五分钟法”，所以我觉得那是你这个方法的巧妙之处。Ada，这太棒了。这次谈话充满了情感、青蛙、蔬菜、框架和洞察。再次感谢你的到来。最后两个问题：如果大家想了解更多或联系你，可以在哪里找到你？听众们能为你做些什么？

---

### [01:17:21] Ada Chen Rekhi

**English:**
You can find me online. On Twitter and LinkedIn, I'm Ada Chen, A-D-A-C-H-E-N. I have a website, adachen.com, and you can always just shoot me an email, adachen@gmail.com. In terms of how listeners can be useful to me, any feedback and riffs on some of the ideas and topics that we've shared. I'm always eager to learn from other people. So feel free to drop a note and say hello. And if you're a founder and you're interested in learning more about coaching, I'm always happy to talk.

**中文翻译:**
你可以在网上找到我。在 Twitter 和 LinkedIn 上，我是 Ada Chen (A-D-A-C-H-E-N)。我的网站是 adachen.com，你也可以直接给我发邮件：adachen@gmail.com。至于听众能帮我什么，欢迎对我们分享的想法和话题提供任何反馈或延伸讨论。我总是渴望向他人学习。所以请随时给我留言打个招呼。如果你是创始人，想了解更多关于教练服务的信息，我也很乐意交流。

---

### [01:17:51] Lenny

**English:**
Awesome. And then Notejoy, how do they check that out?

**中文翻译:**
太棒了。那 Notejoy 呢，大家怎么查看？

---

### [01:17:54] Ada Chen Rekhi

**English:**
Notejoy.com.

**中文翻译:**
Notejoy.com。

---

### [01:17:56] Lenny

**English:**
So easy. Great domain. Ada, thank you again.

**中文翻译:**
真简单，好域名。Ada，再次感谢。

---

### [01:18:00] Ada Chen Rekhi

**English:**
Thank you.

**中文翻译:**
谢谢。

---

### [01:18:01] Lenny

**English:**
Bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
大家再见。非常感谢收听。如果你觉得本期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众找到这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目再见。