# Adam Fishman - 双语对照

这是一份为您准备的《Lenny's Podcast》访谈 Adam Fishman 的完整双语文档。

---

### 00:00:00 Adam Fishman

**English:**
Onboarding is the only part of your product experience that a hundred percent of people are ever going to touch. Good luck getting a hundred percent feature adoption of anything else in your product, right? But onboarding is the thing that you have to go through in order to use the product. It's also the first opportunity that you have as a company to deliver on the promise that you made out in the marketplace. So I like to think of your brand is the promise that you're making and your product experience is your delivery of that promise. And those two things have to be in lockstep with each other, or you're going to have mismatched expectations and some really disappointed customers. So this is the first chance that a customer has to be really excited or really disappointed in what they thought they were getting. So don't mess that up.

**中文翻译:**
新手引导（Onboarding）是你的产品体验中，唯一一个 100% 的用户都会接触到的部分。想要让产品里的其他任何功能达到 100% 的采用率，那简直是天方夜谭，对吧？但新手引导是你为了使用产品而必须经历的过程。这也是公司第一次有机会兑现你在市场上许下的承诺。所以我喜欢把品牌看作是你许下的承诺，而产品体验则是你对该承诺的交付。这两者必须保持步调一致，否则就会出现预期不符，导致客户大失所望。所以，这是客户第一次有机会对他们认为会得到的东西感到兴奋，或者是感到失望。所以，千万别搞砸了。

---

### 00:00:55 Lenny

**English:**
Adam Fishman was the first growth and marketing hire at Lyft where he spent two and a half years leading their growth efforts. Then he went on to lead product and growth at Patreon, where he spent over four years building one of the most successful and lasting created platforms out there. And most recently, he was CPO at Imperfect Foods. Today he spends his time advising companies on product and growth, and he's also doing a lot more writing.

**中文翻译:**
Adam Fishman 是 Lyft 招聘的第一位增长和营销人员，他在那里花了两年半的时间领导增长工作。随后，他加入 Patreon 领导产品和增长，在那里的四年多时间里，他打造了目前最成功且最持久的创作者平台之一。最近，他担任了 Imperfect Foods 的首席产品官（CPO）。现在，他主要负责为各家公司提供产品和增长方面的咨询，同时也投入了更多精力在写作上。

---

### 00:01:19 Lenny

**English:**
And in this episode we cover three things, his growth competency model, which helps you hire and evaluate growth talent and also get a job as a growth person. We go deep into why onboarding is such an underappreciated growth lever and all of the impact that you can have optimizing your onboarding flow. Adam also shares a super cool framework for choosing which company to work at. Adam is hilarious and he's so full of wisdom and I can't wait for you to hear this episode. With that, I bring you Adam Fishman.

**中文翻译:**
在本期节目中，我们将涵盖三个方面：首先是他的“增长胜任力模型”（Growth Competency Model），它可以帮助你招聘和评估增长人才，也能助你找到增长岗位的工作。接着，我们将深入探讨为什么新手引导是一个被低估的增长杠杆，以及优化新手引导流程能带来的巨大影响。Adam 还会分享一个非常酷的框架，教你如何选择入职的公司。Adam 幽默风趣且充满智慧，我迫不及待想让大家听到这一集。下面，让我们欢迎 Adam Fishman。

---

### 00:01:50 Lenny

**English:**
This episode is brought to you by Coda. Coda's an all-in one doc that combines the best of documents, spreadsheets, and apps in one place. I actually use Coda every single day. It's my home base for organizing my newsletter writing, it's where I plan my content calendar, capture my research, and write the first drafts of each and every post. It's also where I curate my private knowledge repository for paid newsletter subscribers, and it's also how I manage the workflow for this very podcast.

**中文翻译:**
本期节目由 Coda 赞助播出。Coda 是一款多合一文档工具，它将文档、电子表格和应用程序的优点集于一身。实际上，我每天都在使用 Coda。它是我撰写时事通讯的大本营，我在这里规划内容日历、记录研究资料，并撰写每一篇文章的初稿。它也是我为付费订阅者整理私人知识库的地方，我甚至用它来管理这个播客的工作流。

---

### 00:02:17 Lenny

**English:**
Over the years, I've seen Coda evolve from being a tool that makes teams more productive to one that also helps bring the best practices across the tech industry to life with an incredibly rich collection of templates and guides in the Coda Doc Gallery, including resources from many guests on this podcast, including Shreyas, GoCool, and Shishir, the CEO of Coda.

**中文翻译:**
这些年来，我见证了 Coda 的演变，它不仅是一个提高团队生产力的工具，还通过 Coda 文档库中极其丰富的模板和指南，帮助科技行业的最佳实践落地。这些资源包括本播客许多嘉宾的分享，比如 Shreyas、GoCool，以及 Coda 的 CEO Shishir。

---

### 00:02:38 Lenny

**English:**
Some of the best teams out there like Pinterest, Spotify, Square and Uber, use Coda to run effectively and have published their templates for anyone to use. If you're ping ponging between lots of documents and spreadsheets, make your life better and start using Coda, You can take advantage of a special limited time offer just for startups. Head over to coda.io/lenny to sign up and get a thousand dollar credit on your first statement. That's C-O-D-A.I-O/lenny to sign up and get a thousand dollars in credit on your account.

**中文翻译:**
像 Pinterest、Spotify、Square 和 Uber 这样的一流团队都在使用 Coda 来高效运作，并发布了供任何人使用的模板。如果你总是在大量的文档和电子表格之间来回切换，那就用 Coda 让生活更轻松吧。现在你可以享受专门针对初创公司的限时优惠。访问 coda.io/lenny 注册，即可在首张账单中获得 1000 美元的抵扣额度。记住是 C-O-D-A.I-O/lenny。

---

### 00:03:16 Lenny

**English:**
This episode is brought to you by Linear. Let's be honest, the issue tracker that you're using today isn't very helpful. Why is it that it always seems to be working against you instead of working for you? Why does it feel like such a chore to use? Well, Linear is different. It's incredibly fast, beautifully designed, and it comes with powerful workflows that streamline your entire product development process from issue tracking all the way to managing product roadmaps. Linear is designed for the way modern software teams work. What users love about Linear are the powerful keyboard shortcuts, efficient GitHub integrations, cycles that actually create progress, and built in project updates that keep everyone in sync. In short, it just works. Linear is the default tool of choice among startups, and it powers a wide range of large established companies such as Versal, Retool, and Cash App. See for yourself by product teams describe using Linear as magical. Visit linear.app/lenny to try Linear for free with your team and get 25% off when you upgrade. That's linear.app/lenny.

**中文翻译:**
本期节目由 Linear 赞助。说实话，你现在用的问题追踪工具（Issue Tracker）可能并不好用。为什么它总是感觉在和你作对，而不是在帮你？为什么用起来像是在干苦力活？Linear 则完全不同。它速度极快，设计精美，并配有强大的工作流，可以简化从问题追踪到产品路线图管理的整个开发过程。Linear 是为现代软件团队的工作方式而设计的。用户最喜欢 Linear 的地方在于其强大的快捷键、高效的 GitHub 集成、能真正推动进度的“周期”（Cycles）功能，以及让所有人保持同步的内置项目更新。简而言之，它就是好用。Linear 是初创公司的首选工具，也为 Versal、Retool 和 Cash App 等大型成熟公司提供支持。亲自去看看为什么产品团队会用“神奇”来形容 Linear。访问 linear.app/lenny 免费试用，升级时还可享受 25% 的折扣。

---

### 00:04:26 Lenny

**English:**
Adam Fishman, welcome to the podcast.

**中文翻译:**
Adam Fishman，欢迎来到本播客。

---

### 00:04:30 Adam Fishman

**English:**
Thanks for having me, Lenny. Super excited to be here. It's a pleasure to be on chatting with you today.

**中文翻译:**
谢谢邀请我，Lenny。非常兴奋能来到这里，今天能和你聊天是我的荣幸。

---

### 00:04:36 Lenny

**English:**
It's even more my pleasure. Thank you for being here. To set a little context for listeners that don't know too much about you yet, can you spend 45 seconds giving us a little overview of all of the wonderful things that you've done in your career?

**中文翻译:**
这是我的荣幸，感谢你的到来。为了给那些还不了解你的听众提供一些背景，你能花 45 秒时间简单介绍一下你职业生涯中做过的那些精彩事情吗？

---

### 00:04:50 Adam Fishman

**English:**
Sure. I'm setting my timer for 45 seconds.

**中文翻译:**
没问题，我设定一个 45 秒的计时器。

---

### 00:04:53 Lenny

**English:**
And, start.

**中文翻译:**
好，开始。

---

### 00:04:55 Adam Fishman

**English:**
So I've been the Chief Product Officer and VP of Growth and Product at a bunch of different companies Imperfect Foods, Patreon, Lyft, the precursor to Lyft which was Zimride to name a few. Now, I do three things primarily, I'm an EIR at Reforge and a program partner, which means I create courses. I run an advisory practice on growth and product strategy, which keeps me pretty busy, and then I recently started a newsletter which was pretty much inspired by your work in this area over the last several years. Those are the three pillars of my life these days, my professional life at least.

**中文翻译:**
我曾在多家公司担任首席产品官（CPO）以及增长与产品副总裁，包括 Imperfect Foods、Patreon、Lyft，以及 Lyft 的前身 Zimride 等等。现在，我主要做三件事：我是 Reforge 的驻企企业家（EIR）和项目合伙人，负责开发课程；我经营着一家关于增长和产品策略的咨询公司，这让我非常忙碌；最近我还创办了一份时事通讯（Newsletter），这很大程度上是受你过去几年在该领域工作的启发。这就是我目前生活的三个支柱，至少在职业生活方面是这样。

---

### 00:05:31 Lenny

**English:**
Nailed it. Wow, that was very contained and clear. Let's plug the newsletter real quick. What's the URL? Is it fishmanafnewsletter.com?

**中文翻译:**
完美。哇，非常简练清晰。快来宣传一下你的时事通讯吧。网址是什么？是 fishmanafnewsletter.com 吗？

---

### 00:05:39 Adam Fishman

**English:**
It is fishmanafnewsletter.com. I am blessed with great initials that allow me to have that name for a newsletter.

**中文翻译:**
没错，就是 fishmanafnewsletter.com。我很幸运，我的名字缩写（AF，在英文俚语中常作为加强语气的后缀）刚好能让这个名字很有记忆点。

---

### 00:05:47 Lenny

**English:**
It's not obvious. Adam Fishman AF. There you go. That's the acronym. And then in terms of the advising, just to set this expectation, are you looking for more clients or are you capped out? How should people think about that as they listen?

**中文翻译:**
确实很有意思，Adam Fishman AF。这就是缩写。关于咨询业务，为了让听众有个预期，你现在还在寻找新客户吗，还是已经满员了？大家听的时候应该怎么考虑？

---

### 00:05:58 Adam Fishman

**English:**
Well, I'm pretty busy, but it is a bit of a revolving door, so there's always some pipeline. So even if I can't work with folks right now, sometimes it makes sense for me to work with them a few months down the road. So always open to new interest and learning about new companies.

**中文翻译:**
嗯，我确实挺忙的，但这就像个旋转门，总会有一些项目进进出出。所以即使我现在没法和大家合作，几个月后可能就有机会了。所以我始终对新的兴趣和了解新公司持开放态度。

---

### 00:06:12 Lenny

**English:**
All right, great. We'll share how to contact you at the end of this and it will be in the show notes.

**中文翻译:**
太好了。我们会在节目最后分享你的联系方式，也会放在节目简介里。

---

### 00:06:15 Adam Fishman

**English:**
Awesome.

**中文翻译:**
太棒了。

---

### 00:06:17 Lenny

**English:**
One question I wanted to ask off the bat is, Lyft, you were there super early. I imagine it was an incredibly wild ride. I'm curious, what's the most tangible memory you have of your time at Lyft?

**中文翻译:**
我马上想问的一个问题是，你在 Lyft 成立非常早期就在那里了。我猜那一定是一段疯狂的旅程。我很好奇，你在 Lyft 期间最深刻、最具体的记忆是什么？

---

### 00:06:29 Adam Fishman

**English:**
I have a ton of memories from the almost three years that I was there, but I think the biggest one, and probably the most tactile or memorable thing was when we launched Lyft, when we were bringing it out of private beta, we had this press event at the office, which is in Soma, and it had these doors, these big huge garage style doors. And so we opened them up and we actually drove a car into the office with a pink mustache on the front of it, and then a bunch of drivers piled out of it and met the press members and were high fiving people and stuff like that. And then we also served a giant pink mustache cake at this event. So of all of the things there, that one sticks in my head the most.

**中文翻译:**
在那里的近三年时间里，我有无数的回忆。但我认为最重大、最具体、最难忘的一件事是 Lyft 正式发布的时候。当时我们要结束内测，在位于 Soma 的办公室举办了一场媒体活动。办公室有那种巨大的车库式大门，我们把门打开，真的把一辆车开进了办公室，车头挂着那个标志性的粉色胡子。然后一群司机从车里钻出来，和媒体成员见面、击掌之类的。活动现场我们还提供了一个巨大的粉色胡子蛋糕。在所有事情中，这一幕在我脑海里印象最深。

---

### 00:07:14 Lenny

**English:**
I love that. I hope there was no hair in this mustache cake.

**中文翻译:**
太赞了。我希望那个胡子蛋糕里没有真的胡须。

---

### 00:07:18 Adam Fishman

**English:**
No, no, there was not. It was delicious.

**中文翻译:**
不，不，没有。味道好极了。

---

### 00:07:21 Lenny

**English:**
Okay, awesome. Another question I always have for folks that worked at Lyft or at Uber is how they feel about Super Pumped and what it is like watching that, if you've seen it, what it's like watching the story of Uber and especially working for Lyft.

**中文翻译:**
好，太棒了。我一直想问那些在 Lyft 或 Uber 工作过的人一个问题：他们对美剧《超泵》（Super Pumped，讲述 Uber 创业史）怎么看？如果你看过的话，作为一个在 Lyft 工作过的人，看着 Uber 的故事被搬上荧幕是什么感觉？

---

### 00:07:35 Adam Fishman

**English:**
Yeah, I have seen it. I actually read the book first. I've been a pretty big fan of Mike Isaac, who's the New York Times reporter who wrote it. So I've been a big fan of his reporting for a long time. I connected with him a bit while he was writing the book, and I would say, there were parts of it that were painful. It was like renavigating, relitigating a history that I had lived through already. And so much of that story was stuff that I had experienced pretty regularly while I was at Lyft battling against Uber.

**中文翻译:**
是的，我看过。其实我是先读了那本书。我是《纽约时报》记者 Mike Isaac 的忠实粉丝，书就是他写的。我关注他的报道很久了，他在写书的时候我们也交流过。我想说，看这部剧有些部分是痛苦的。这就像是重新经历、重新审视一段我已经亲身走过的历史。故事中的很多情节，都是我在 Lyft 与 Uber 竞争期间经常经历的事情。

---

### 00:08:04 Adam Fishman

**English:**
So one part of me was like, "I remember that. God, that was hard." Another part of me was happy to see that all of the things were out in the open finally, things that were hard to talk about about competitive practices and stuff like that and just shady things. And some part of me was happy that it was out there. And then one other thing separately, so I actually was interviewing with Joseph Gordon-Levitt to be an advisor with his company HitRecord while he was filming Super Bumped.

**中文翻译:**
所以我的一部分感觉是：“我记得那件事，天哪，当时真难。”另一部分感觉则是很高兴看到所有这些事情终于公开了，包括那些难以启齿的竞争手段和一些阴暗面。我心里挺欣慰这些事能被揭露出来。另外还有件趣事：当 Joseph Gordon-Levitt（JGL）在拍摄《超泵》期间，我正好在面试他公司 HitRecord 的顾问职位。

---

### 00:08:35 Adam Fishman

**English:**
And we had this conversation over Zoom when he was on break in between scenes of filming the show. And for those who don't know, he's the guy that plays Travis Kalanick, the CEO and founder of Uber. So he did this interview with me and he was in his trailer on set, fully decked out as TK in his look with his hair slicked back. And it was really funny and also cool to see him in this context. And he is probably the polar opposite from Travis Kalanick. Obviously they're both super successful, but JGL is a really down to earth, nice, very family-oriented calm guy. So anyways, this is a funny story of my time meeting and interviewing with him.

**中文翻译:**
我们在 Zoom 上聊的时候，他正处于两场戏之间的休息时间。对于那些不知道的人，他就是扮演 Uber 创始人兼 CEO Travis Kalanick（TK）的演员。所以他面试我的时候，正坐在片场的房车里，全身都是 TK 的装扮，头发梳得油光锃亮。在那种情境下见到他真的很有趣也很酷。而且他本人可能和 Travis Kalanick 完全相反。显然他们都很成功，但 JGL 是一个非常接地气、友善、顾家且冷静的人。总之，这是我面试时的一段趣事。

---

### 00:09:19 Lenny

**English:**
That is amazing. Did you slip in a couple Lyft facts to help Lyft look a little happier and better?

**中文翻译:**
太神奇了。你有没有顺便塞给他一些关于 Lyft 的事实，好让 Lyft 在剧里看起来更正面一点？

---

### 00:09:26 Adam Fishman

**English:**
I did. We talked a bit about that journey and I asked him some questions about how he prepared for the role and stuff like that. And so yeah, it was pretty fun. We swapped some stories and stuff. So yeah, it was neat.

**中文翻译:**
我确实说了。我们聊了聊那段旅程，我也问了他一些关于他如何准备这个角色之类的问题。所以是的，挺有意思的。我们交换了一些故事，感觉很棒。

---

### 00:09:37 Lenny

**English:**
Fun fact, my mom wanted me to dress like Joseph Gordon-Levitt and I was like, "I should look like this guy. Wear some vests. This guy's looking good. Looks like you a little bit."

**中文翻译:**
趣闻一件：我妈以前想让我穿得像 Joseph Gordon-Levitt 那样，我也觉得：“我应该学学这家伙，穿点背心什么的。他看起来很帅，而且长得和你还有点像。”

---

### 00:09:48 Adam Fishman

**English:**
I see that. I do see that. That's awesome. Way to go, mom.

**中文翻译:**
我感觉到了，确实有点像。太棒了，妈妈真有眼光。

---

### 00:09:51 Lenny

**English:**
Yeah. Then I'll follow her advice. Maybe I should have.

**中文翻译:**
是啊，那我得听她的建议。也许我早该这么做了。

---

### 00:09:54 Lenny

**English:**
Yeah. Okay. So transitioning to the meat of our chat, there's three things I wanted to spend our time chatting about. One is your growth competency model, which essentially is this post you wrote recently that tells founders how to hire and how to evaluate growth people. Two, I want to chat about onboarding flows. You have a lot of really interesting experience optimizing onboarding flows and the impact that's had. And then three is how to choose a company to work out. You've chosen a lot of really interesting companies and you have some cool insights around how to think about that. Does that sound good?

**中文翻译:**
好。现在转入我们聊天的核心内容，我想花时间聊三件事。第一是你的“增长胜任力模型”，这基本上是你最近写的一篇文章，告诉创始人如何招聘和评估增长人才。第二，我想聊聊新手引导流程（Onboarding flows）。你在优化新手引导流程及其产生的影响方面有很多非常有趣的经验。第三是如何选择入职的公司。你选择过很多非常有趣的公司，对于如何思考这个问题，你有一些很酷的见解。听起来可以吗？

---

### 00:10:27 Adam Fishman

**English:**
Yeah, it sounds great. I've also chosen some bad companies in my time too, so we can talk about the good, the bad and the ugly.

**中文翻译:**
是的，听起来很棒。我也曾选过一些糟糕的公司，所以我们可以聊聊好的、坏的和丑陋的一面。

---

### 00:10:32 Lenny

**English:**
Okay, excited to hear about that. So first we talked about this briefly. You've started to do a lot more writing. You have this newsletter at fishmanafnewsletter.com, and you recently wrote this really epic piece called the Growth Competency Model, which essentially lays out what to look for in a growth leader, how to hire, how to evaluate, what to concentrate skills on? Things like that. First question, just what made you feel like you had to write this? What mistakes have you found founders make when hiring and evaluating growth leaders?

**中文翻译:**
好的，很期待听听这些。首先，我们简短地聊过这个。你开始写更多的东西了，你在 fishmanafnewsletter.com 有自己的时事通讯。你最近写了一篇非常宏大的文章，叫作《增长胜任力模型》，它基本上阐述了在寻找增长负责人时应该看重什么、如何招聘、如何评估、技能应该集中在哪些方面等等。第一个问题：是什么让你觉得必须写这篇文章？你发现创始人在招聘和评估增长负责人时常犯哪些错误？

---

### 00:10:59 Adam Fishman

**English:**
Yeah, so first I'm going to put up my new background here, which is my growth competency model background. For those watching on YouTube, I have a funny graphic in the background for this. So I guess the reason that I wrote this, there were a few reasons that I wrote it. One is it really felt necessary to write it. And at first it's, I don't think I've ever come across this type of canonical reference before around how to hire and plan for growth. So that's number one. I didn't think it existed. It needed to exist.

**中文翻译:**
好的，首先我要换上我的新背景，也就是我的增长胜任力模型背景。对于在 YouTube 上观看的朋友，我为此准备了一个有趣的背景图。至于我写这篇文章的原因，有这么几点。第一，我真的觉得有必要写。起初，我觉得自己从未见过关于如何招聘和规划增长的这种权威参考资料。所以这是第一点：我认为它不存在，但它需要存在。

---

### 00:11:32 Adam Fishman

**English:**
Two, as an advisor and someone who has held the head of growth role many times, I get asked this question a lot. I get asked all the time about how do you hire growth people? And it's usually something like, "Hey, how do we find you but 10 years earlier in your career?" And it feels like that question is missing the first principles approach to hiring a growth person. And if you're doing that, you're just pattern matching to me. And I may not be the best person, right, or somebody who looks like me may not be the best person. So I think we're missing that.

**中文翻译:**
第二，作为一名顾问，以及多次担任增长负责人的人，我经常被问到这个问题。总有人问我：如何招聘增长人才？通常问法是：“嘿，我们怎么能找到像你一样，但处于职业生涯早 10 年阶段的人？”我觉得这种问法忽略了招聘增长人才的“第一性原理”。如果你只是在找我的影子，那你只是在进行模式匹配。但我可能并不是最合适的人选，或者长得像我的人也不一定是最合适的。所以我觉得我们缺失了这部分思考。

---

### 00:12:09 Adam Fishman

**English:**
And then third, one of the programs that I'm currently creating is around growth leadership. And so I've been thinking a lot about what it takes to be an exceptional growth leader, how you hire other people onto your team and create balanced teams. And this is going to be a really important component of that program. So it was just really top of mind. So yeah, that's why I wrote it.

**中文翻译:**
第三，我目前正在开发的一个项目是关于增长领导力的。所以我一直在思考如何成为一名卓越的增长领导者，如何为团队招聘其他成员并创建平衡的团队。这将是该项目的一个非常重要的组成部分。所以这正是我最近一直在思考的事情。这就是我写它的原因。

---

### 00:12:30 Lenny

**English:**
Let me ask one quick question and I think you were about to start answering one mistakes founders make, but I guess it's less of a question. I know this was built on another model for product management, which is really awesome. And I love that there's this growing fountain of career ladders, competencies per function. And so I don't know if there's been one that's really great for design and engineering, but I love that this is happening. And so first of all, I just want to say I appreciate that you put in the time to think this through.

**中文翻译:**
让我快速问一个问题，我想你正准备回答创始人常犯的错误，但我想这更像是一个感慨。我知道这个模型是基于另一个产品管理模型建立的，这真的很棒。我很高兴看到这种关于职业阶梯、各职能胜任力的资源越来越多。我不知道设计和工程领域是否也有这么棒的模型，但我很喜欢这种趋势。所以首先，我想说我很感谢你花时间深入思考这些。

---

### 00:12:54 Adam Fishman

**English:**
Cool. Thank you. Yeah, and I do think we need more of these. I think we need one for marketers, I think we need one for engineers, designers, research probably, there's probably a bunch of functions that could benefit from some canonicalized resource around this stuff. So yeah, some myths and mistakes that I think founders made and that I've made. I've definitely lived through some mistakes. A few experiences where I was hired into a company where the founder had really messed up expectations of what a growth person should be doing, what I should be doing. And I wanted to set the record straight for founders because they are the folks who hire for this and other leaders.

**中文翻译:**
太好了，谢谢。是的，我也认为我们需要更多这样的模型。营销人员、工程师、设计师、可能还有研究人员，都需要一个。可能有很多职能都能从这种规范化的资源中受益。关于创始人常犯的错误，以及我自己犯过的错，我确实经历过一些。有几次我被公司聘用，但创始人对增长人员应该做什么、我应该做什么有着完全错误的预期。我想为创始人正名，因为他们是招聘这些岗位的人，其他领导者也是如此。

---

### 00:13:34 Adam Fishman

**English:**
So one example that comes to mind is, I did a very brief stint at a company called Wyzant, in between Lyft and Patreon. And the founders of that company, so Wyzant was a tutoring marketplace. It was acquired by a company not too long ago, so it's now part of a bigger learning company. And the founders of that company we're looking for what I would call a silver bullet strategy to their growth challenges. And what they really needed, and I was naive and didn't think about asking these questions or about evaluating this properly, what they really needed was to create a strategy to add on new growth loops and a system for how to execute against that strategy.

**中文翻译:**
我想到一个例子，在 Lyft 和 Patreon 之间，我曾在一家名为 Wyzant 的公司短暂工作过。Wyzant 是一个家教市场平台，不久前被收购了，现在是一家大型学习公司的一部分。那家公司的创始人当时正在寻找我所谓的解决增长挑战的“银弹策略”（Silver bullet strategy，指万能灵药）。而他们真正需要的——当时我很天真，没想过问这些问题或进行适当的评估——是制定一套增加新增长环（Growth loops）的策略，以及一套执行该策略的系统。

---

### 00:14:13 Adam Fishman

**English:**
If we had talked about that as part of evaluating each other, as part of them evaluating me, it would've given me a lot of confidence that it was the right hire to make. But the problem was they didn't approach it that way. They didn't ask me those questions and I was too naive to recognize that, "Hey, they're not actually evaluating this with the competencies that you would expect for a growth leader." Executing a growth strategy takes time and patience, and they didn't really have it. And overall it ended rather unsuccessfully. I helped them build this office in San Francisco, hired a bunch of folks, we actually closed down the office. I had to lay off a bunch of the people that I'd hired, including myself, which wasn't particularly fun. And I think all of it comes back to that they didn't have a really strong set of criteria on what it meant to hire a great growth person. And so if I can help even just a little bit with founders making that decision better, it'll lead to fewer mismatches I think in the hiring process.

**中文翻译:**
如果我们当时在互相评估时谈到了这一点，我会更有信心这是正确的选择。但问题是他们没有这样做。他们没问我那些问题，而我也太天真，没意识到：“嘿，他们实际上并没有按照增长负责人应有的胜任力来评估。”执行增长策略需要时间和耐心，而他们并没有。总的来说，那次经历相当失败。我帮他们在旧金山建立了办公室，雇了一群人，结果最后我们关闭了办公室。我不得不解雇了我雇的所有人，包括我自己，这真的一点都不好玩。我认为这一切都归结于他们没有一套关于如何招聘优秀增长人才的强大标准。所以，如果我能稍微帮助创始人做出更好的决策，我认为招聘过程中的错配就会减少。

---

### 00:15:11 Lenny

**English:**
Awesome. Let's get into it. What are the components of this model? And you can put it back up again for folks to follow along in the background.

**中文翻译:**
太棒了。让我们深入探讨一下。这个模型的组成部分有哪些？你可以再次把背景放出来，让大家跟着看。

---

### 00:15:18 Adam Fishman

**English:**
It's coming back.

**中文翻译:**
背景回来了。

---

### 00:15:18 Lenny

**English:**
It's like a TikTok.

**中文翻译:**
像在拍 TikTok 一样。

---

### 00:15:19 Adam Fishman

**English:**
The whole thing looks like a big circle and there's four wedges in that circle, four equal parts. And I think that answer of what are the components, what should people look for, really, I'll give the PM answer, which is it depends. And what does it depend on? It depends on the state of the team and where the skill gaps are. So the goal of the competency model is not to find a unicorn human being that is an 11 out of 10 on every one of these things, because frankly, that person doesn't exist. I am not an 11 out of 10 on these skills and I have been a growth executive at many companies. I consider myself to be pretty good at the job. The goal is to create a well-rounded team so that you're hiring and balancing skills across your team and that you don't have any gaps in your portfolio.

**中文翻译:**
整个模型看起来像一个大圆圈，里面有四个扇形区域，四个相等的部分。关于组成部分是什么、人们应该寻找什么，我会给出一个典型的产品经理（PM）式回答：视情况而定。取决于什么？取决于团队的状态和技能缺口在哪里。胜任力模型的目标不是寻找一个在每一项上都能拿到 11 分（满分 10 分）的“独角兽”人才，因为坦白说，这种人不存在。我也不是每一项都能拿 11 分，但我已经在很多公司担任过增长高管了。我认为自己做得很不错。目标是创建一个全面的团队，这样你就可以在团队中平衡技能，确保你的“技能组合”中没有短板。

---

### 00:16:06 Adam Fishman

**English:**
And so when you think about it, there are four main components to the growth competency model. And the four big components or buckets are growth execution, customer knowledge, growth strategy, and then the last one is communication and influence. And each of those has three really specific skills. And so to give an example, let's break down growth execution for example, which is one of the very first ones that you should be good at if you're a growth practitioner. Within this competency grouping, there's three individual competencies that are channel fluency, experimentation, and what I'd call productizing learnings. And so you can evaluate and ask questions to understand how good people are at these different things and what their experience has been with them.

**中文翻译:**
所以，增长胜任力模型有四个主要组成部分。这四个大类分别是：增长执行（Growth execution）、客户知识（Customer knowledge）、增长策略（Growth strategy），最后一项是沟通与影响力（Communication and influence）。每一类下面都有三项非常具体的技能。举个例子，让我们分解一下“增长执行”，这是增长从业者最先应该擅长的领域之一。在这个胜任力组别中，有三项具体的胜任力：渠道熟练度（Channel fluency）、实验能力（Experimentation）以及我所谓的“将洞察产品化”（Productizing learnings）。你可以通过评估和提问来了解人们在这些方面的擅长程度以及他们的相关经验。

---

### 00:16:54 Adam Fishman

**English:**
So in productizing learnings for example, one of the key things that a growth person has to do is generate hypotheses, learn from those hypotheses and then translate that into changes that they're making in the product. And you want to find somebody who has a track record of at least understanding how to take something they have learned that might be an experiment or something that's very NVP and turn that into something that has hooks into different areas of the product. And so that's a critical skill to evaluate. And one of an example, the overall set of competencies.

**中文翻译:**
以“将洞察产品化”为例，增长人员的核心工作之一是提出假设，从假设中学习，然后将其转化为产品中的改动。你需要找一个有相关经验的人，他至少懂得如何将学到的东西（可能是一个实验或一个非常初期的 MVP）转化为能够接入产品不同区域的功能。所以这是一项需要评估的关键技能。这是整体胜任力集中的一个例子。

---

### 00:17:26 Lenny

**English:**
To throw in a question real quick, is one way to use this model, coming back to your Wyzant example where there's of course misalignment between you and the founder to sit down and look at this circle here and be like, "Here's where I'm strong, here's where maybe we need to hire someone to take over."

**中文翻译:**
快速插一个问题，回到你提到的 Wyzant 的例子，当时你和创始人之间存在分歧。使用这个模型的一种方式是不是坐下来，看着这个圆圈说：“这是我擅长的地方，这是我们可能需要雇人来负责的地方”？

---

### 00:17:41 Adam Fishman

**English:**
Yeah, absolutely. You can almost use it as a reverse interviewing characteristic and say, "What are the competencies you, founder, CEO, care about? What's really important to you for the first person in this role? Or the expectations that you have of what I will bring to the table." And then you can be really candid about what you're good at and what you're not good at, where you're developing. So yeah, I agree with that for sure.

**中文翻译:**
是的，绝对是。你几乎可以把它当作一种“反向面试”的工具，问：“创始人、CEO，你最看重哪些胜任力？对于这个岗位的第一个人，你认为什么最重要？或者你对我能带来的东西有什么期望？”然后你可以非常坦诚地说明你擅长什么、不擅长什么，以及你在哪些方面还在进步。所以我完全同意这一点。

---

### 00:18:06 Lenny

**English:**
Awesome. I know this also plays into evaluating your performance and it could be like, "Hey Adam, here's the three things that we want to focus on in the next cycle."

**中文翻译:**
太棒了。我知道这也可以用于绩效评估，比如：“嘿 Adam，这是我们希望你在下一个周期重点关注的三件事。”

---

### 00:18:13 Adam Fishman

**English:**
For sure. Yeah. It's really a good foundational framework for being really concrete and specific in the feedback that you provide someone. So rather than saying, "Adam, you really need to be more strategic." Everybody's heard that at some point and it's like, "Well, what do you mean?" You can say, "Hey, we need to work on the area of growth strategy and that means I need to see better modeling of loops out of you, better understanding communication of what those loops are." And you can give really concrete feedback.

**中文翻译:**
当然。是的。它确实是一个很好的基础框架，可以让你给出的反馈非常具体明确。与其说“Adam，你真的需要更有战略眼光”（每个人都听过这种话，然后心想“你到底什么意思？”），你可以说：“嘿，我们需要在增长策略方面下功夫，这意味着我希望看到你做出更好的增长环模型，更好地理解并沟通这些环是什么。”这样你就能给出非常具体的反馈。

---

### 00:18:44 Lenny

**English:**
Awesome. So we've talked about growth execution, What's next?

**中文翻译:**
太棒了。我们已经聊了增长执行，接下来是什么？

---

### 00:18:47 Adam Fishman

**English:**
The next one is what I would call customer knowledge. And within customer knowledge there's a set of things and really this is about data fluency and instrumentation, understanding user psychology, which is a big one, and then this idea of being able to experiment and learn over time and how you develop your narrative and your creative approach to talking to customers. I love user psychology and it's one of the things that I think attracted me to growth and to product. I studied consumer psychology when I was in college and I'm just probably would've been a psychologist if not for a growth practitioner, which is a weird other approach I could have taken in my career. But-

**中文翻译:**
下一个是我所谓的“客户知识”。在客户知识中包含一系列内容，核心是数据熟练度和埋点（Instrumentation）、理解用户心理（这是一个大项），以及能够随着时间推移进行实验和学习，还有如何构建叙事和用创意的方式与客户沟通。我热爱用户心理学，这也是吸引我进入增长和产品领域的原因之一。我在大学时学的是消费者心理学，如果不是成了增长从业者，我大概会成为一名心理学家，这可能是我职业生涯的另一种奇特路径。但是——

---

### 00:19:35 Lenny

**English:**
It's not too late to pivot.

**中文翻译:**
现在转型还不晚。

---

### 00:19:37 Adam Fishman

**English:**
... Second career. Yeah, actually, announcing today I'm pivoting the newsletter to just talk about therapy and psychology.

**中文翻译:**
……开启第二职业。是的，事实上，我今天宣布我的时事通讯要转型只聊心理治疗和心理学了。

---

### 00:19:43 Lenny

**English:**
Yes. This is going to be the title of the podcast.

**中文翻译:**
太好了。这将成为本期播客的标题。

---

### 00:19:47 Adam Fishman

**English:**
Awesome. So like user psychology, I think one of the things that people don't easily understand is that most people come to your product with an emotional frame and a lot of people want to appeal to their logical brain right away. And the reality is, don't do that. And so you have to understand the mindset that people are in. How low are their lows? How high are their highs? Why are they seeking out your product? And it often, as I mentioned, stems from some emotional challenge that they're having or something that they're seeking. And it's not because your product is the best chat bot or because it gives the best answers. There's a different thing that they're trying to solve. And only when you address that can you move on to those other things. So that's the second competency is, customer knowledge.

**中文翻译:**
太棒了。关于用户心理学，我认为人们不容易理解的一点是：大多数人带着情感框架来到你的产品面前，而很多人却想立刻诉诸他们的逻辑大脑。现实是，千万别这么做。你必须理解人们所处的心态。他们的低谷有多低？他们的高峰有多高？他们为什么要寻找你的产品？正如我提到的，这通常源于他们面临的某种情感挑战或某种追求。并不是因为你的产品是最好的聊天机器人，或者因为它能给出最好的答案。他们试图解决的是另一件事。只有当你解决了那个问题，你才能继续讨论其他事情。所以这就是第二项胜任力：客户知识。

---

### 00:20:34 Lenny

**English:**
It reminds me of something I mentioned on some podcast recently, this tweet that one of the Collison brothers tweeted about how user research is often misunderstood in that people think you do user research and that informs what you build. And instead the way you think about it is user research informs your model of your customer and that model informs what you build.

**中文翻译:**
这让我想起我最近在某个播客中提到的一件事，Collison 兄弟（Stripe 创始人）之一发过一条推特，说用户研究经常被误解。人们认为你做用户研究是为了直接决定你要造什么。相反，你应该这样想：用户研究是为了完善你对客户的认知模型，而那个模型才决定了你要造什么。

---

### 00:20:56 Adam Fishman

**English:**
Exactly.

**中文翻译:**
没错。

---

### 00:20:56 Lenny

**English:**
And the more user research you do, the more your model evolves to help you understand the customer. And that's been really helpful for me because I never thought of it that way.

**中文翻译:**
你做的用户研究越多，你的模型就越能进化，从而帮助你理解客户。这对我非常有帮助，因为我以前从未从这个角度思考过。

---

### 00:21:04 Adam Fishman

**English:**
Yeah. I think that's a great example. Seeking the solution in a customer interview is never going to work, right? You seek to understand and then you take that away and you can think through what the model should look like and how things should change as a result. Yeah. That's great. I can cover the third and fourth competency-

**中文翻译:**
是的。我认为这是一个很好的例子。在客户访谈中直接寻找解决方案是行不通的，对吧？你寻求的是理解，然后带着这种理解回去思考模型应该是什么样的，以及结果应该如何改变。是的，太棒了。我可以介绍第三和第四项胜任力——

---

### 00:21:24 Lenny

**English:**
That's good.

**中文翻译:**
好的。

---

### 00:21:25 Adam Fishman

**English:**
... and I'll try to be a little more brief on that.

**中文翻译:**
……我会尽量简短一点。

---

### 00:21:27 Lenny

**English:**
No, no. It's good.

**中文翻译:**
不，不，挺好的。

---

### 00:21:28 Adam Fishman

**English:**
The third competency is growth strategy. And now the third and fourth competencies I would say are a bit more advanced topics. And again, remember when I said people index higher or lower on these as they go across their career, I would expect a more junior growth person to not necessarily be a 10 out of 10 on strategy and communication. These are things that you really have to work at a long time. They tend to be softer skills in a lot of cases and you learn best by either getting it very right or getting it very wrong. And so you've got to put in the time to develop these. But in growth strategy, there's three. The first one is growth loop modeling. So really understanding how you grow and where you should be spending your time. What acquires users? What retains them? What monetizes them?

**中文翻译:**
第三项胜任力是“增长策略”。我认为第三和第四项胜任力是稍微高级一些的话题。再次强调，正如我之前说的，人们在职业生涯的不同阶段，在这些项上的得分会有高低。我不指望一个初级增长人员在策略和沟通上能拿到 10 分。这些是需要长期磨练的。在很多情况下，它们更倾向于软技能，而且你通过“大成”或“大败”学到的东西最多。所以你必须投入时间去培养。在增长策略中，有三点：第一是增长环建模（Growth loop modeling），即真正理解你是如何增长的，以及你应该把时间花在哪里。什么在获取用户？什么在留住用户？什么在变现？

---

### 00:22:18 Adam Fishman

**English:**
The second one is capital allocation and forecasting. This is basically where are you deploying either your money, your people, how are you managing the portfolio and how are you projecting that out into the future? And that's a really hard one. You have to become best buddies with your finance friends in order to do that. And so anyways, that's capital allocation and forecasting. And then the third one is prioritization and road mapping. So you have to be able to sequence the work much like in building a product, right? Building your growth strategy, you have to sequence it. That sequence has to make sense based on your growth models. You have to have the capital or the people to allocate to that stuff. And you have to be able to build a series of hypotheses in a series of solutions to test against those hypotheses so that you can learn and then productize to those learnings.

**中文翻译:**
第二点是资本分配与预测（Capital allocation and forecasting）。这基本上是指你把资金或人力投入到哪里，你如何管理这个组合，以及你如何预测未来的情况？这是一个非常难的环节。为了做到这一点，你必须和财务部门的朋友成为铁哥们。总之，这就是资本分配与预测。第三点是优先级排序与路线图制定（Prioritization and road mapping）。你必须能够安排工作的先后顺序，就像打造产品一样，对吧？制定增长策略时，你必须排好序。这个顺序必须基于你的增长模型才有意义。你必须有资金或人力来分配到这些事情上。你必须能够建立一系列假设和一系列解决方案来测试这些假设，以便学习，然后将这些学习成果产品化。

---

### 00:23:09 Adam Fishman

**English:**
And there's a lot of ways to test this stuff. Situational, behavioral, interviewing, I talk a lot about this in my post on hiring growth. There's like very specific questions you can ask to understand what people have done or what they might do in different situations. There's case studies and things like that. So that's the third one. And then the fourth one is communication and influence.

**中文翻译:**
测试这些能力有很多方法。情境面试、行为面试，我在关于招聘增长人才的文章中聊了很多。你可以问一些非常具体的问题，来了解人们在不同情况下做过什么或可能会做什么。还有案例研究之类的。这就是第三个。第四个是沟通与影响力。

---

### 00:23:29 Adam Fishman

**English:**
And I would say, I think you probably know this as a PM, influence is one of the biggest and hardest skills to develop. It's no different in a growth practitioner and in some cases it can even be harder because sometimes people come in with a preconceived notion of what growth is and isn't and you have to change their mind. And so within communication and influence, there's strategic communication. So how do a series of experiments and a series of things that you're trying, fit into the overall picture of a bigger bet that you're taking?

**中文翻译:**
我想说，作为一名产品经理，你可能知道影响力是最重要也最难培养的技能之一。对于增长从业者来说也是如此，在某些情况下甚至更难，因为有时人们对“增长是什么”和“不是什么”带有成见，你必须改变他们的想法。在沟通与影响力中，包含战略沟通：即你正在尝试的一系列实验和事情，如何融入到你正在进行的更大赌注的全局中？

---

### 00:24:06 Adam Fishman

**English:**
How do you lead a team? So team leadership is a big part of communication and influence. And then how do you manage stakeholders? And this is hard in growth because often growth can be viewed as at odds with really thoughtful and quality craftsmanship and product building, but it's not. Those things go hand in hand. And so you really have to win people over on what it means to do growth. And I would say, this is the pinnacle, right? This is the hardest one. It's a lifelong journey. It relies very extensively on understanding people and who you're talking to. And those people can be very different from company to company and the currency that they trade in can be really different. And so this one is one where you have to go back to square one and relearn who the people are that you're working with every time you step into a new role or a new company or get a new leader or something like that. So it can be really challenging and it's never done.

**中文翻译:**
你如何领导团队？团队领导力是沟通与影响力的重要组成部分。然后是你如何管理利益相关者？这在增长工作中很难，因为增长往往被视为与深思熟虑、高质量的工匠精神和产品构建相冲突，但事实并非如此。这些事情是相辅相成的。所以你必须真正赢得人们的认可，让他们理解做增长意味着什么。我想说，这是巅峰，对吧？这是最难的一个。这是一场终身的旅程。它极大地依赖于对人的理解以及你正在与谁交谈。不同公司的这些人可能非常不同，他们看重的“价值货币”也可能完全不同。所以，每当你进入一个新角色、一家新公司，或者换了一个新领导时，你都必须回到原点，重新了解与你合作的人。所以这可能非常具有挑战性，而且永无止境。

---

### 00:25:03 Lenny

**English:**
That component of the competency models, we're the PM of the growth PM role feels like if you were to do these Venn diagram of the two roles, feels like that's a big part of the overlap.

**中文翻译:**
胜任力模型中的那个部分，也就是增长产品经理（Growth PM）角色中的产品经理属性，感觉如果你画一个这两个角色的韦恩图，那会是重叠很大的一部分。

---

### 00:25:13 Adam Fishman

**English:**
Yep, absolutely. There's a lot of overlap between exceptional product managers and exceptional growth practitioners. I think sometimes they just use the skills in different ways. So you need to be great at product strategy to be a product leader, you need to be great at growth strategy to be a growth leader. Just what those things look like can be different between the two. But they're both required skills, required competencies to be exceptional at the role.

**中文翻译:**
是的，绝对如此。卓越的产品经理和卓越的增长从业者之间有很多重叠。我认为有时他们只是以不同的方式使用这些技能。要成为产品领导者，你需要擅长产品策略；要成为增长领导者，你需要擅长增长策略。只是这两者具体表现出来的样子可能有所不同。但它们都是在这个岗位上表现卓越所必需的技能和胜任力。

---

### 00:25:38 Lenny

**English:**
So just to rehash, the four categories are communication influence, growth execution, customer knowledge and growth strategy. You mentioned earlier that people often come to you and they're like, "How do we find another Adam?" And your feedback is one, how do you know that's exactly what you need? And then two, find someone that's up and coming more because it's so hard to find folks like you that are actually ready to take on a head of growth role.

**中文翻译:**
简单复述一下，这四个类别是：沟通与影响力、增长执行、客户知识和增长策略。你之前提到，人们经常来找你说：“我们怎么能再找一个 Adam？”而你的反馈是：第一，你怎么知道这正是你需要的？第二，找一个更有潜力的新秀，因为要找到像你这样已经准备好担任增长负责人的人实在太难了。

---

### 00:26:03 Adam Fishman

**English:**
Yeah.

**中文翻译:**
是的。

---

### 00:26:03 Lenny

**English:**
So a question for you is, one is, do you recommend founders focus on finding someone that's more up and coming and fast learning with a high trajectory? And if so, which of these components would you suggest they look for most?

**中文翻译:**
所以我的问题是：第一，你是否建议创始人专注于寻找那些更有潜力、学习速度快、成长轨迹高的人？如果是这样，你建议他们最看重这些组成部分中的哪一个？

---

### 00:26:19 Adam Fishman

**English:**
One of the challenges of hiring a senior person is that they're all off writing newsletters and making podcast.

**中文翻译:**
招聘资深人士的挑战之一是，他们现在都跑去写时事通讯和做播客了。

---

### 00:26:25 Lenny

**English:**
Right.

**中文翻译:**
没错。

---

### 00:26:25 Adam Fishman

**English:**
Not that we know anybody who does that or anything, but-

**中文翻译:**
倒不是说我们认识谁在干这行，但是——

---

### 00:26:28 Lenny

**English:**
No. That's bullshit. What is that?

**中文翻译:**
不，那是胡扯。那是什么鬼？

---

### 00:26:29 Adam Fishman

**English:**
Yeah. So I don't want to right now go back and work at a company again. I'm enjoying what I'm doing and so it's hard to get me, right? But also you don't want me, I think, when you're doing this for the first time. So I think the key there is smart and driven people for sure. Age and youth is a bit relative I'd say. So I would think about hiring somebody who you might say is less experienced in growth, but they could be very senior in another aspect of their career. You can also benefit from hiring somebody internally who wants to branch out into growth. And one of the benefits that you get from that is a lot of time they have one of those competencies really nailed already. Could be like customer knowledge. They might understand your customer base super well because they're already inside the company.

**中文翻译:**
是的。所以我现在不想再回到公司上班了。我很享受现在做的事，所以很难请到我，对吧？但我也认为，当你第一次做这件事时，你其实并不需要我。所以我认为关键在于寻找聪明且有驱动力的人。年龄和资历是相对的。我会考虑雇佣一个在增长方面经验较少，但在职业生涯其他方面可能非常资深的人。你也可以从内部招聘那些想转行做增长的人中获益。这样做的一个好处是，他们通常已经掌握了其中一项胜任力。比如客户知识，因为他们已经在公司内部，可能非常了解你的客户群。

---

### 00:27:15 Adam Fishman

**English:**
So if you're going to hire a junior person, the key is, how do you help them learn? And I think if you don't know what you're doing as the founder or the leader, it's hard. You're not going to be able to help them yourself. So you've got to be willing to invest in advisors like me, outside education, mentorship, coaching, otherwise, what's going to happen is that very driven, hungry and enthusiastic person is going to run through a lot of brick walls, which is great, except they're going to miss the fact that the door was standing right next to the wall that they just ran through and you're going to end up with a lot of bricks on the ground.

**中文翻译:**
所以如果你要雇佣一个初级人员，关键在于你如何帮助他们学习。我认为如果你作为创始人或领导者自己都不知道该怎么做，那就很难了。你无法亲自帮助他们。所以你必须愿意投资于像我这样的顾问、外部教育、导师或教练。否则，结果就是那个非常有驱动力、渴望成功且充满热情的人会撞破很多堵砖墙——这固然很好，但他们会忽略掉门其实就在他们刚刚撞过的那堵墙旁边，而你最后只会得到满地的碎砖头。

---

### 00:27:54 Lenny

**English:**
Excellent metaphor.

**中文翻译:**
极佳的比喻。

---

### 00:27:56 Adam Fishman

**English:**
Yeah, thank you. And so I have some examples of both hiring people and moving people over in my career. So I think tangible examples are really helpful here. So when I was at Lyft, I had the privilege of hiring that young, smart and driven person a bunch of times, but one of the people who comes to mind is a guy named Ben Lauzier. You should have him on the podcast at some point. He's French, he's very nice to listen to you. He was most recently a VP of product at Thumbtack, but he was definitely not that when I hired him, he was a jack of all trades marketer working at a corporate catering startup when I hired him at Lyft. And he had nailed most of the growth execution and the customer knowledge competencies.

**中文翻译:**
是的，谢谢。在我的职业生涯中，我既有外部招聘的例子，也有内部转岗的例子。我认为具体的例子在这里很有帮助。在 Lyft 时，我有幸多次雇佣那种年轻、聪明且有驱动力的人。其中一个让我想到的人叫 Ben Lauzier。你应该找个时间请他上播客。他是法国人，听他说话很舒服。他最近是 Thumbtack 的产品副总裁，但我雇他时他绝对还没到那个高度。当时他在一家企业餐饮初创公司做全能型营销人员。他已经掌握了大部分增长执行和客户知识方面的胜任力。

---

### 00:28:38 Adam Fishman

**English:**
One was, he was an avid Lyft user himself, so he really understood the product really well. And also, he was just very thoughtful about how he executed, how he experimented. He had done a lot of it and he was very skilled at pulling them off in a very small environment because he had just had to be. And those are the two most important competencies when you're bringing in a younger, earlier stage person because teaching somebody how to execute is not that fun, right? That's a hard skill. The ability to execute is something like executive function skills and things like that. If you haven't developed those by the time you are an adult, I don't know that I'm going to be able to teach you and I'm certainly probably not the right person to teach you. You should definitely get some outside assistance with that. And so I like to get those types of people that have those things if I'm hiring that generally inexperienced growth practitioner.

**中文翻译:**
第一，他自己就是 Lyft 的忠实用户，所以他非常了解产品。第二，他在执行和实验方面非常周密。他做过很多尝试，并且非常擅长在资源匮乏的小环境中完成任务，因为他不得不这么做。当你引入一个年轻、处于早期阶段的人时，这两项是最重要的胜任力，因为教别人如何执行并不好玩，对吧？那是一项硬技能。执行能力类似于执行功能技巧之类的。如果你成年后还没培养出这些能力，我不确定我能不能教会你，而且我也肯定不是教你的合适人选。你绝对应该寻求外部协助。所以，如果要雇佣一个缺乏经验的增长从业者，我喜欢找具备这些特质的人。

---

### 00:29:42 Lenny

**English:**
And the two things you said are customer knowledge and execution. Is that the two you said?

**中文翻译:**
你说的两点是客户知识和执行力。是这两点吗？

---

### 00:29:46 Adam Fishman

**English:**
Yes. Customer knowledge and growth execution. And so let me tell you an execution story about Ben really quick. This comes also down to work ethic too. So we interviewed Ben and it was a long day of interviews in a tiny glass conference room and Lyft was, I don't know, 30 people or something at the time. At one of the interview breaks, Ben had come over and he didn't have his computer and anything like that. And so he was ducking out of work to do the interview. And he actually came out of the office and he's like, "Hey, does anybody have a computer that I can borrow?" And so we gave him this old crappy Chromebook and I was like, "Why do you need a computer?" And he's like, "I have to go edit this file and do this thing and check something in at work and deploy this thing or whatever."

**中文翻译:**
是的。客户知识和增长执行。让我快速给你讲一个关于 Ben 执行力的故事。这也涉及到职业道德。我们面试 Ben 的那天，在小玻璃会议室里进行了一整天的面试，当时 Lyft 大概只有 30 人左右。在一次面试间隙，Ben 走了过来，他当时没带电脑。他是翘班来面试的。他走出办公室问：“嘿，有人能借我一台电脑吗？”我们给了他一台破旧的 Chromebook，我问：“你要电脑干什么？”他说：“我得去编辑一个文件，处理点事，在公司提交点代码并部署一下。”

---

### 00:30:32 Adam Fishman

**English:**
And I'm like, "Wow, this is a guy that really knows how to get stuff done and is so much so that he's pausing his interview process so that he could go get a thing done for his company that he's actively trying to leave, but he's got this work ethic and this execution." And that really stuck with me. And he probably would remember this story if we brought it up. So the time he borrowed a crappy Chromebook laptop to do work at the job that he was trying to leave.

**中文翻译:**
我当时想：“哇，这家伙真的很懂得如何把事情办成，甚至不惜暂停面试流程，去为他正积极准备离开的公司完成一件事。他有这种职业道德和执行力。”这让我印象非常深刻。如果我们提起这件事，他可能还记得。就是那次他借了一台破 Chromebook，在他正打算辞掉的工作上加班。

---

### 00:31:00 Lenny

**English:**
What are the chances that was staged?

**中文翻译:**
这有没有可能是演出来的？

---

### 00:31:01 Adam Fishman

**English:**
He seemed very innocent. So I think not staged.

**中文翻译:**
他看起来非常真诚。所以我认为不是演的。

---

### 00:31:06 Lenny

**English:**
Okay, great.

**中文翻译:**
好，太棒了。

---

### 00:31:06 Adam Fishman

**English:**
But I could be wrong. But now everyone that interviews that is going to ask to borrow a laptop and-

**中文翻译:**
但也可能我错了。不过现在每个面试的人可能都会要求借电脑，然后——

---

### 00:31:10 Lenny

**English:**
That's right.

**中文翻译:**
没错。

---

### 00:31:10 Adam Fishman

**English:**
... check in some work.

**中文翻译:**
……提交点工作。

---

### 00:31:11 Lenny

**English:**
The phone call.

**中文翻译:**
打个电话。

---

### 00:31:13 Adam Fishman

**English:**
Yeah.

**中文翻译:**
是的。

---

### 00:31:13 Lenny

**English:**
"Adam, I need to fix something."

**中文翻译:**
“Adam，我得修个东西。”

---

### 00:31:15 Adam Fishman

**English:**
That's right. So that's Ben. And then on the other side, and I'll cover this one really quickly, and the other side of moving somebody over internally, I had equally great success with that. So there was another person named Sean at Patreon who was a marketer, again, a jack of all trades marketer. And I think I have a propensity and a bias towards folks like that because that's one of the ways that I started my career was in marketing. But anyways, I moved him over from marketing to being a growth PM, an entry level growth PM.

**中文翻译:**
没错。那是 Ben。另一方面，我快速说一下内部转岗，我也取得了同样的成功。Patreon 有一个叫 Sean 的人，他也是一名营销人员，同样是全能型的。我想我对这类人有偏好和偏见，因为我职业生涯的起点之一就是营销。总之，我把他从营销部门调过来担任增长产品经理，一个入门级的增长 PM。

---

### 00:31:47 Adam Fishman

**English:**
And he had a ton of the execution skills, ability to prioritize really well and customer knowledge skills as well, more so on the customer side because he was an internal transfer, so he really knew our customers. He'd spent tons of time talking to people, studying data and things like that. And he had really great fluency with data and a drive to continue improving his ability to access and pull out insights and information. And he turned out to be really great, but just a very different profile of a person than Ben was. And here's an internal hire versus an external hire.

**中文翻译:**
他具备大量的执行技能，能够很好地排定优先级，同时也具备客户知识技能。在客户方面他更强，因为他是内部转岗，所以他非常了解我们的客户。他花了大量时间与人交谈、研究数据等等。他对数据非常熟练，并且有动力不断提高自己获取和提取洞察及信息的能力。事实证明他非常出色，只是他的背景特征与 Ben 完全不同。这就是内部招聘与外部招聘的对比。

---

### 00:32:23 Adam Fishman

**English:**
So you can have success with both, but I think you really have to make sure that there's some foundational things that are in place like that ability to get customer knowledge and execute.

**中文翻译:**
所以两者都可以成功，但我认为你必须确保一些基础的东西到位，比如获取客户知识和执行的能力。

---

### 00:32:34 Lenny

**English:**
If a founder is listening and trying to decide or hiring a head of growth or a new growth person, would you push them one way or the other, internal hire versus finding someone up and coming and smart?

**中文翻译:**
如果有创始人正在听，并试图决定是招聘增长负责人还是新的增长人员，你会倾向于哪种方式：内部招聘，还是寻找聪明有潜力的新人？

---

### 00:32:44 Adam Fishman

**English:**
I tend to skew more towards internal hire to be perfectly honest, because I believe in creating opportunity inside a company. I think it's not done often enough. And I also believe that helping people transition into new roles is a way to get more people into the practice. And one of the ways that can happen is if you take a chance on somebody who has demonstrated a good track record in some other aspect of your business. So I tend to recommend internal. I think you have faster time to results. I think you know what you're getting better and in much less likelihood of making the wrong hire there. So I bias towards internal hires.

**中文翻译:**
老实说，我更倾向于内部招聘。因为我相信在公司内部创造机会，我认为这种做法还不够普遍。我也相信，帮助人们转型到新角色是让更多人进入增长实践的一种方式。其中一种方式就是给那些在业务其他方面表现出色的人一个机会。所以我倾向于推荐内部招聘。我认为这样出成果更快，你更清楚自己招到的是什么样的人，而且招错人的可能性也小得多。所以我偏向于内部招聘。

---

### 00:33:25 Lenny

**English:**
Awesome. And I think partly, I feel that too because there's so much content and training for growth these days that somebody has that background in your company and is already motivated and excited and then can just learn, go to Reforge course, read certain newsletters, feels like it's a lot easier to ramp up. Except, I always feel like if you need someone for SEO or paid growth, that's a hard thing to learn. What's your take there?

**中文翻译:**
太棒了。部分原因我也感同身受，因为现在关于增长的内容和培训非常多。如果公司里有人具备相关背景，并且已经充满动力和热情，他们完全可以通过学习、参加 Reforge 课程、阅读特定的时事通讯来提升。感觉上手容易多了。不过，我总觉得如果需要 SEO 或付费增长方面的人才，那是很难学的。你怎么看？

---

### 00:33:51 Adam Fishman

**English:**
I would bucket that type of person into a specialist. And one of the archetypes that I talk about is this idea of the painter versus the architect versus the surgeon. And the surgeon is your precision person. I don't actually recommend hiring that as your first hire, but when you are onto something and you really need expertise and you don't have that expertise internally, yes, I think hiring externally is the right thing to do at that point because those are really specific skills that some people have taken years to learn. And I can't just teach someone SEO over the course of a weekend and expect that they're really going to get it. In those cases, I think hiring that specialist or that surgeon is the right approach, once you've got some of the foundational stuff in place.

**中文翻译:**
我会把这类人归类为“专家”。我谈到过的一种原型是：画家、建筑师与外科医生。外科医生就是那种精准执行的人。我不建议把这类人作为你的第一个雇员。但当你发现了一些增长苗头，确实需要专业知识，而内部又缺乏这种知识时，是的，我认为那时外部招聘是正确的选择。因为这些是非常具体的技能，有些人花了数年时间才学会。我不可能在周末教某人 SEO，就指望他能真正掌握。在那种情况下，一旦你具备了一些基础的东西，聘请那位专家或“外科医生”就是正确的方法。

---

### 00:34:41 Lenny

**English:**
Awesome. Great. Yeah, it feels like there's still a lot of dark art in those two specialties that take years of experience.

**中文翻译:**
太棒了。是的，感觉这两个专业领域仍然有很多需要多年经验积累的“黑魔法”。

---

### 00:34:49 Lenny

**English:**
This episode is brought to you by Eppo. Eppo is a next generation AB testing platform built by Airbnb alums for modern growth teams. Companies like Netlify, Tenfold and Cameo rely on Apple to power their experiments. Wherever you work, running experiments is increasingly essential, but there are no commercial tools that integrate with a modern grow team stack. This leads to waste of time building internal tools, or trying to run your experiments through a clunky marketing tool. When I was at Airbnb, one of the things that I loved about our experimentation platform was being able to easily slice results by device, by country, and by user stage.

**中文翻译:**
本期节目由 Eppo 赞助。Eppo 是由 Airbnb 校友为现代增长团队打造的下一代 AB 测试平台。Netlify、Tenfold 和 Cameo 等公司都依赖 Eppo 来支持他们的实验。无论你在哪里工作，运行实验都变得越来越重要，但目前还没有能与现代增长团队技术栈集成的商业工具。这导致人们浪费时间构建内部工具，或者试图通过笨重的营销工具来运行实验。当我在 Airbnb 时，我最喜欢我们的实验平台的一点是，能够轻松地按设备、国家和用户阶段来切分结果。

---

### 00:35:26 Lenny

**English:**
Eppo does all that and more, delivering results quickly, avoiding annoying prolonged analytic cycles and helping you easily get to the root cause of any issue you discover. Eppo lets you go beyond basic clickthrough metrics and instead, you turn north star metrics like activation, retention, subscriptions and payments. And Eppo supports test on the front end, the back end, email marketing and even machine learning clients. Check out Eppo at geteppo.com, gete-p-p-o.com and 10x your experiment velocity.

**中文翻译:**
Eppo 不仅能做到这些，还能快速交付结果，避免恼人的漫长分析周期，并帮助你轻松找到发现的任何问题的根本原因。Eppo 让你超越基本的点击率指标，转而关注激活、留存、订阅和支付等北极星指标。Eppo 支持前端、后端、邮件营销甚至机器学习客户端的测试。访问 geteppo.com（g-e-t-e-p-p-o.com）查看 Eppo，让你的实验速度提升 10 倍。

---

### 00:35:59 Lenny

**English:**
This is a good time to segue to our second topic, which is onboarding. I know you're a big proponent of spending time on onboarding, optimizing onboarding. How have you found onboarding to be as a lever for growth and just what gets you excited about investing in onboarding?

**中文翻译:**
现在是进入第二个话题的好时机，即新手引导（Onboarding）。我知道你非常支持在新手引导和优化新手引导上投入时间。你认为新手引导作为增长杠杆的效果如何？是什么让你对投资新手引导感到兴奋？

---

### 00:36:13 Adam Fishman

**English:**
I love onboarding. I probably do at least an onboarding project to at least one with every company that I've worked for and a lot that I advise. The first thing I would say is, onboarding is the only part of your product experience that a hundred percent of people are ever going to touch. Good luck getting a hundred percent feature adoption of anything else in your product right? But onboarding is the thing that you have to go through in order to use the product. It's also the first opportunity that you have as a company to deliver on the promise that you made out in the marketplace.

**中文翻译:**
我热爱新手引导。我为我工作过的每一家公司以及我咨询过的许多公司都至少做过一个新手引导项目。首先我想说的是，新手引导是你的产品体验中唯一一个 100% 的用户都会接触到的部分。祝你好运，看看能不能让产品里的其他功能达到 100% 的采用率？但新手引导是你为了使用产品而必须经历的过程。这也是公司第一次有机会兑现你在市场上许下的承诺。

---

### 00:36:53 Adam Fishman

**English:**
So I like to think of your brand is the promise that you're making and your product experience is your delivery of that promise. And those two things have to be in lockstep with each other or you're going to have mismatched expectations and some really disappointed customers. So this is the first chance that a customer has to be really excited or really disappointed in what they thought they were getting. So don't mess that up.

**中文翻译:**
所以我喜欢把品牌看作是你许下的承诺，而产品体验则是你对该承诺的交付。这两者必须保持步调一致，否则就会出现预期不符，导致客户大失所望。所以，这是客户第一次有机会对他们认为会得到的东西感到兴奋，或者是感到失望。所以，千万别搞砸了。

---

### 00:37:17 Adam Fishman

**English:**
And the third thing I would say is it's also probably the most motivated that someone is going to be about your product since they're typically starting their onboarding journey with you at a time where they're like, "I need this thing really badly that you're selling." And so they're really motivated, right? And so it's an opportunity for you to put some friction in place and learn a lot about them because they will knock down doors to get to your product. So that's why I think it's a super powerful lever for growth. And we worked on this extensively at Lyft, at Patreon, Wyzant, Imperfect Foods just released some onboarding improvements that we had created when I was there, which was nice to see that finally come to light. So yeah, I've done this pretty much everywhere at some point.

**中文翻译:**
第三点我想说的是，这可能也是一个人对你的产品最有动力的时候，因为他们通常是在“我非常需要你卖的这个东西”的时候开始新手引导旅程的。所以他们动力十足，对吧？因此，这是一个让你设置一些摩擦并深入了解他们的机会，因为他们会为了使用你的产品而不顾一切。这就是为什么我认为它是一个超级强大的增长杠杆。我们在 Lyft、Patreon、Wyzant 都广泛开展过这项工作。Imperfect Foods 最近刚刚发布了一些我在那里时创建的新手引导改进方案，很高兴看到它们终于上线了。所以是的，我几乎在每个地方都做过这件事。

---

### 00:38:07 Lenny

**English:**
What impact have you seen from working on onboarding to give people a sense of like, "Wow, this is what I can get if I put some time here."

**中文翻译:**
在新手引导方面的工作带来了什么样的影响？能不能给大家一个直观的感受，比如：“哇，如果我在这里投入时间，我就能得到这样的回报。”

---

### 00:38:15 Adam Fishman

**English:**
Yeah. One of the things that onboarding really drives is habit formation with the product, which leads to retention. And so you should expect to improve your overall cohort retention curves by focusing on the onboarding and activation experience. I have seen companies shift their curve outward by 10, 15, 20 percentage points from making those changes, especially when you consider that churn is most likely to happen in the very earliest usage of the product. If you can get people past that hump, it's a really invaluable part of the product to work on.

**中文翻译:**
是的。新手引导真正推动的事情之一是培养用户对产品的使用习惯，从而带来留存。因此，通过关注新手引导和激活体验，你应该能改善整体的同期群留存曲线（Cohort retention curves）。我见过有些公司通过这些改动，将留存曲线向上提升了 10、15 甚至 20 个百分点。特别是考虑到流失最容易发生在产品使用的极早期阶段。如果你能让用户跨过那个坎，这绝对是产品中极具价值的工作部分。

---

### 00:38:51 Adam Fishman

**English:**
So I'll give you a really concrete example. At Patreon, one of the places we worked on onboarding really extensively and the onboarding experience was one of the teams that we had on growth at Patreon. We did a lot of experimentation around the earliest, what we would call product led sales now, when do you connect a human being with a creator and the onboarding experience and what is that impact and how do you connect them with the right person or with the right creator when there are tens of thousands going through that onboarding journey every week?

**中文翻译:**
我给你举个非常具体的例子。在 Patreon，新手引导是我们投入大量精力的地方之一，新手引导体验也是我们增长团队中的一个小组。我们围绕早期阶段做了大量实验，也就是现在所谓的“产品驱动销售”（Product-led sales）：在新手引导过程中，你什么时候让真人和创作者对接？这种对接的影响是什么？当每周有成千上万的人经历新手引导旅程时，你如何将他们与合适的人或合适的创作者连接起来？

---

### 00:39:25 Adam Fishman

**English:**
What we realized through a lot of experimentation was the idea of connecting someone with a human being the right person at the right time would improve the first month of revenue or the second month of revenue that a creator made on the platform by 25%. Why that mattered is because the second month that you processed payments on the platform was a key input into your LTV on the platform. So by improving a creator's first and second month revenue by 25%, we were then able to improve their overall value on Patreon by an equivalent amount, which is pretty massive. Moving anything by 25% is really impressive.

**中文翻译:**
通过大量实验，我们意识到：在正确的时间将创作者与正确的人（真人）连接起来，能让创作者在平台上的首月或次月收入提高 25%。这之所以重要，是因为在平台上处理支付的第二个月是决定用户终身价值（LTV）的关键输入。因此，通过将创作者的前两个月收入提高 25%，我们就能将他们在 Patreon 上的整体价值提高同样的幅度，这是非常巨大的。任何指标提升 25% 都非常了不起。

---

### 00:40:09 Adam Fishman

**English:**
And so that was human intervention, and then we actually started to productize the stuff that the humans were doing. And so what is not scalable when you're using people becomes very scalable if you can replicate components of that with technology. And so that was the next phase, so we get back to that growth execution thing that I talked about and productizing learnings. That is an example of how you go from, we've learned some things by humans that have made a 25% impact to now we're building these into the product. And so that's a really good example I think, of Patreon and one of the impacts that we had on creator, earnings, retention and their overall success on the platform.

**中文翻译:**
起初是人工干预，然后我们开始将人工所做的事情“产品化”。当你使用人力时，它是不可扩展的；但如果你能用技术复制其中的组成部分，它就会变得非常易于扩展。这就是下一个阶段，回到了我之前提到的“增长执行”和“将洞察产品化”。这就是一个例子：我们通过人工干预学到了一些能产生 25% 影响的东西，现在我们将这些功能内置到产品中。我认为这是 Patreon 的一个很好例子，展示了我们对创作者收入、留存及其在平台上的整体成功所产生的影响。

---

### 00:40:50 Lenny

**English:**
That's an amazing example, in case it's useful to a person working on the onboarding. Can you share any more about what you actually did there? You create some algorithm of this type of person, we'll connect them to a person and then you productize it. Is there anything more you could share there that might be useful to folks?

**中文翻译:**
这是一个很棒的例子，对从事新手引导工作的人很有用。你还能分享更多关于你们具体做了什么的细节吗？比如你们创建了某种算法来识别某类人，然后将他们连接到真人，最后再将其产品化。还有什么可以分享的有用信息吗？

---

### 00:41:06 Adam Fishman

**English:**
Gosh, we did so much. So I'll try to pull out a couple of example. So one of the things that we did, and again, I spoke to the fact that people are really motivated in your onboarding experience, one of the first things we did was we tried to identify better who a creator was in the onboarding experience. And who they were meant how big is their audience on a bunch of the channels where they managed communities, Twitter, Facebook, Instagram, Discord, YouTube, et cetera. And then how engaged was that audience? It's one thing if you make crazy cat videos on YouTube and you have a million subscribers, it's another thing if every time you publish a video, all million of those people watch it, comment on it, share it, et cetera.

**中文翻译:**
天哪，我们做了太多了。我试着举几个例子。其中一件事是——再次强调，人们在新手引导体验中动力十足——我们做的第一件事就是尝试在新手引导过程中更好地识别创作者的身份。所谓“身份”，是指他们在管理的各个社区渠道（Twitter、Facebook、Instagram、Discord、YouTube 等）上有多少受众。以及这些受众的参与度如何？你在 YouTube 上拍疯狂的猫咪视频并拥有一百万订阅者是一回事，但如果你每次发布视频，这一百万人都会观看、评论、分享，那就是另一回事了。

---

### 00:41:49 Adam Fishman

**English:**
And we would ask creators to connect various accounts to Patreon, maybe through authoring with YouTube or Spotify or Instagram or Facebook or something like that, Twitter, and then we would pull in the data into our backend and identify people who had large followings and also heavily engaged followings, based on a set of criteria per channel. And again, this was not just like me inventing this. We had a data scientist team that we worked very closely with to figure out what was important and what wasn't in this model. And then if you were one of those people that had a high propensity for success, high potential creators, we would siphon them off from the regular self-guided onboarding and basically land them in the lap of a human being who could engage with them, reach out, get them even more excited and start talking to them about the best things to do.

**中文翻译:**
我们会要求创作者将各种账号连接到 Patreon，可能是通过 YouTube、Spotify、Instagram、Facebook 或 Twitter 的授权。然后我们将数据导入后台，根据每个渠道的一套标准，识别出那些拥有庞大粉丝群且粉丝参与度极高的人。再次强调，这不只是我凭空想象出来的，我们有一个数据科学家团队，我们紧密合作，找出模型中哪些因素重要，哪些不重要。如果你是那些极具成功潜力的高潜力创作者，我们会将你从常规的自助式新手引导中分流出来，直接交由真人负责。真人会与他们互动、主动联系，让他们更兴奋，并开始告诉他们最该做的事情。

---

### 00:42:46 Adam Fishman

**English:**
And then the productization of that, the best things to do turned out to be things like one of our product principles, which became opinionated defaults, which is basically making it hard to do the wrong thing when you're setting up your Patreon page and easy to do the right thing but not eliminating choice.

**中文翻译:**
然后是产品化。所谓的“最该做的事情”演变成了我们的一个产品原则，即“有主见的默认设置”（Opinionated defaults）。基本上就是让你在设置 Patreon 页面时，很难做错事，很容易做对事，但又不剥夺你的选择权。

---

### 00:43:07 Adam Fishman

**English:**
So the creator could still make the choice to do the wrong thing. They could still set up a single tier when we knew that a three-tiered pricing model actually would work better for them, or they could choose to set up 40 tiers when we knew that the sweet spot was three to five or perhaps make their lowest price tier a dollar instead of what we recommended, which was like three or $5 entry points. So they could do all that stuff, but we made it difficult for them to do it. We put more friction in place when they were trying to change some of those defaults because we had learned across a universe of creators, hundreds of thousands of people what worked best.

**中文翻译:**
创作者仍然可以选择做错事。当我们知道三层定价模型对他们效果更好时，他们仍然可以只设置一层；或者当他们知道 3 到 5 层是最佳点时，他们仍然可以选择设置 40 层；或者把最低价格层设为 1 美元，而不是我们建议的 3 或 5 美元。他们可以做这些事，但我们增加了操作难度。当他们试图更改这些默认设置时，我们会设置更多摩擦，因为我们已经从成千上万的创作者身上学到了什么是最好的做法。

---

### 00:43:52 Adam Fishman

**English:**
And so putting in those guardrails and those default things was a huge lever for us to drive the behavior that we wanted. And again, we learned that from human intervention with the right types of creators, then detecting those people and putting in the guardrails in the product themselves and making those recommendations inside the product experience. And they were pricing tier structure, how you actually write your page, all of that stuff.

**中文翻译:**
因此，设置这些“护栏”和默认选项成了我们引导用户行为的巨大杠杆。再次强调，我们是从对特定类型创作者的人工干预中学到这些的，然后通过识别这些人，在产品中内置护栏，并在产品体验中提供建议。这些建议包括定价层级结构、如何撰写页面内容等等。

---

### 00:44:18 Lenny

**English:**
Such a great example. It reminds me we had exactly the same situation at Airbnb that you just made me think about. We called it smart defaults. What was your term? Opinionated defaults?

**中文翻译:**
非常棒的例子。这让我想起我们在 Airbnb 也有完全相同的情况。我们称之为“智能默认设置”（Smart defaults）。你的术语是什么？“有主见的默认设置”？

---

### 00:44:29 Adam Fishman

**English:**
Opinionated defaults. Yeah.

**中文翻译:**
有主见的默认设置。是的。

---

### 00:44:30 Lenny

**English:**
Yeah, I like that. So at Airbnb we had a bunch of calendar settings when a host signs up, on the host side is where I spent a lot of my time, we had instant book, which is basically you sign up as a host and people can book you instantly. That became the default for Airbnb. And so to make that successful, hosts had to have their calendar be accurate from the beginning. And so what we got to eventually, is we tried to figure out, are you a professional host that knows what you're doing? Are you a mom and pop that's just trying this out? And then based on that, either block your entire calendar, keep it all open, or somewhere in between.

**中文翻译:**
是的，我喜欢这个词。在 Airbnb，房东注册时有一堆日历设置（我大部分时间花在房东端）。我们有“闪订”（Instant Book）功能，基本上就是你注册成为房东，别人就能立即预订。这成了 Airbnb 的默认设置。为了让它成功，房东必须从一开始就确保日历准确。所以我们最终的做法是，尝试弄清楚：你是一个知道自己在做什么的专业房东？还是一个刚刚尝试的小散户？然后根据这个，要么屏蔽你的整个日历，要么全部开放，或者介于两者之间。

---

### 00:45:22 Lenny

**English:**
And it's interesting that it connects to your point about, and I was going to come back to this that, a lot of people think of onboarding as a conversion opportunity and it definitely is. But to your point, even more interestingly, it's a retention opportunity because in the Airbnb case, hosts sign up, they get booked for a day, they don't want to host, they're like, "Shit, what the hell's going on here? I'm out."

**中文翻译:**
有趣的是，这联系到了你的一点（我正想回头聊这个）：很多人把新手引导看作是一个转化机会，它确实是。但正如你所说，更有趣的是，它是一个留存机会。因为在 Airbnb 的例子中，房东注册了，被预订了一天，但他们其实不想接待，然后他们会说：“该死，这到底是怎么回事？我不干了。”

---

### 00:45:22 Adam Fishman

**English:**
Yeah.

**中文翻译:**
没错。

---

### 00:45:22 Lenny

**English:**
And so, I wanted to ask you, how should folks think about onboarding conversion versus retention, and why is it so powerful for retention?

**中文翻译:**
所以我想问你，大家应该如何看待新手引导中的“转化”与“留存”？为什么它对留存如此强大？

---

### 00:45:32 Adam Fishman

**English:**
I actually think if you're doing it right, sometimes conversion should actually decrease a little bit. So you might actually have fewer people getting all the way through successfully, but I think that's okay because a lot of those people were probably not the right people for your product, which means they wouldn't have been engaged customers, they probably would have churned. So just by the nature of actually weeding out some people, you're going to improve retention because the people who are going through are the people who are much more highly qualified. And so I think that's also why onboarding is so challenging because you have to figure out what that sweet spot is, right?

**中文翻译:**
我其实认为，如果你做得对，有时转化率实际上应该稍微下降一点。也就是说，成功走完整个流程的人可能会变少，但我认为这没关系。因为其中很多人可能根本不是你产品的目标受众，这意味着他们不会成为活跃客户，很可能会流失。所以，通过筛选掉一部分人，你反而会提高留存率，因为留下来的人都是更高质量的用户。我认为这也是为什么新手引导如此具有挑战性的原因，因为你必须找到那个平衡点，对吧？

---

### 00:46:17 Adam Fishman

**English:**
You could actually reduce conversion to a point where it's not offset by improvements in retention and you'd be doing the wrong thing. So when you're experimenting, you have to look at these push and pull metrics of these opposing metrics. But overall, I find that the biggest impact that you'll have is on retaining users because you are trying to connect them to the value that your product offers and form a habit. And if you form that habit early on, they're going to stick around because they're going to get it, they're going to get the benefit of the product, and they're going to be excited to stay and then tell more people about it. So that's why I think it's a much bigger impact on retention than conversion.

**中文翻译:**
你可能会把转化率降低到留存率的提升无法弥补的程度，那样你就做错了。所以当你做实验时，你必须观察这些相互博弈的指标。但总的来说，我发现新手引导最大的影响在于留住用户，因为你正试图将他们与产品提供的价值联系起来，并培养一种习惯。如果你在早期就培养了这种习惯，他们就会留下来，因为他们理解了产品，获得了收益，并且会兴奋地留下并告诉更多人。这就是为什么我认为它对留存的影响远大于转化。

---

### 00:47:01 Lenny

**English:**
Obviously retention is a longer tail metric and conversion is immediate.

**中文翻译:**
显然，留存是一个长尾指标，而转化是即时的。

---

### 00:47:06 Adam Fishman

**English:**
Yeah.

**中文翻译:**
是的。

---

### 00:47:07 Lenny

**English:**
Do you have any tips for folks that are like, "Oh my God, how do I know if this conversion hit is worth retention increasing potentially?"

**中文翻译:**
对于那些纠结“天哪，我怎么知道转化率的下降是否值得潜在的留存率提升”的人，你有什么建议吗？

---

### 00:47:13 Adam Fishman

**English:**
Yeah. I think the answer is not wait 90 days to find out, right? Nobody has that time. And so what I tend to do is look at proxy metrics. So there are proxies for things like 90 day retention. As an example at Patreon, one of our proxies around the eventual success of a creator was how quickly they would reach certain dollar thresholds once they launched. And so your velocity to get to your first patron, your first a hundred dollars processed on the platform and that thing had a lot to do with how big and successful you would be, and therefore how well you would retain.

**中文翻译:**
是的。我认为答案不是等 90 天再看结果，对吧？没人有那个时间。所以我倾向于观察“代理指标”（Proxy metrics）。比如 90 天留存率就有其代理指标。以 Patreon 为例，我们衡量创作者最终成功的一个代理指标是：他们发布后达到特定金额门槛的速度。你获得第一个赞助人、在平台上处理前 100 美元的速度，与你未来的规模和成功程度高度相关，因此也与你的留存情况高度相关。

---

### 00:47:52 Adam Fishman

**English:**
And so we looked at very early signals to understand and evaluate how good someone was going to be. We also did a lot of qualitative screening in the beginning. So as people went through, we would take samplings of creators who were onboarding and signing up and launching their pages, and we would actually look at who the creator was and what they were doing. And then we would be able to run it through our model to say, "It looks like we're getting a lot of the right people going through and doing the right behaviors, therefore, we're very confident that they're going to retain better and do the right things." So yeah, proxy metrics are the key there.

**中文翻译:**
所以我们观察非常早期的信号来理解和评估一个人的潜力。我们在开始时也做了大量的定性筛选。当人们走完流程时，我们会对正在进行新手引导、注册并发布页面的创作者进行抽样，实际查看创作者是谁以及他们在做什么。然后我们将其输入模型，得出结论：“看起来我们吸引了很多正确的人，并且他们正在做正确的行为，因此我们非常有信心他们会更好地留存并做正确的事。”所以，代理指标是关键。

---

### 00:48:32 Lenny

**English:**
Awesome. So part of this is find this leading indicator proxy metric, and then to your point, maybe build a little bit of a heuristic that's like, okay, this is qualitatively looking like it's doing the right things to our new users.

**中文翻译:**
太棒了。所以部分工作是找到这个领先指标代理指标，然后正如你所说，建立一点启发式方法，比如：好的，从定性上看，这似乎对我们的新用户起到了正确的作用。

---

### 00:48:45 Adam Fishman

**English:**
Yep.

**中文翻译:**
没错。

---

### 00:48:46 Lenny

**English:**
Maybe our last question on onboarding is, at Airbnb and I imagine many companies, there's this constant desire to, "Let's just redo this whole thing. Let's just redesign it. Let's start again." And my question to you is just, how much is too much on redoing, rethinking, onboarding, optimizing, micro-optimizing? Any answers there?

**中文翻译:**
关于新手引导的最后一个问题：在 Airbnb，我想在很多公司也是如此，总有一种冲动：“让我们把这整个东西重做一遍吧。重新设计，从头开始。”我想问你的是：在重做、重新思考、优化、微调新手引导方面，做到什么程度算过头了？

---

### 00:49:05 Adam Fishman

**English:**
Yeah. I would say first, I very strongly dislike the idea of redesigning something for redesigning sake. So I think that it is true that you should spend a lot of time on onboarding, and you should regularly revisit it as you learn new things about your users. So even at Patreon, we would work on onboarding and then we take a beat, we'd let it go for a while, improved, and then as we learn new things, we would find ways to fold those back into onboarding. So I find that it's acceptable to revisit when you are learning net new principles about your customers or something new about your growth model where onboarding can directly influence.

**中文翻译:**
首先我想说，我非常反感为了重新设计而重新设计。我认为确实应该在新手引导上花很多时间，并且随着你对用户有了新的了解，你应该定期重新审视它。即使在 Patreon，我们也会在新手引导上投入精力，然后停顿一下，让它运行一段时间，改进它。当我们学到新东西时，我们会想办法把这些新知识融入到新手引导中。所以我认为，当你学到了关于客户的全新原则，或者关于增长模型的新知识，且新手引导能直接产生影响时，重新审视它是可以接受的。

---

### 00:49:51 Adam Fishman

**English:**
So as we learned at Patreon what the right tier construction was, or the right way to talk about your Patreon page or the right way to message it in the beginning, we would go back and say, "How do we build this newfound knowledge into an experience that sets someone up for success?" But if we weren't gaining new insights, we weren't just tweaking the onboarding experience and trying to tune it in a very micro way, because the reality is, that doesn't really move the needle that often, especially once you've got it in a pretty good foundational place. And only when you discover something really fundamentally net new, will it have an outsized impact on retention or the success of early users. So don't just redesign for redesign sake, make sure there's a new hard earned insight that you've got before you do it.

**中文翻译:**
比如在 Patreon，当我们了解到正确的层级结构是什么，或者介绍 Patreon 页面的正确方式，或者初期的正确沟通话术时，我们会回头想：“我们如何将这些新发现的知识融入到能让用户成功的体验中？”但如果我们没有获得新的洞察，我们就不会仅仅为了微调而微调新手引导体验。因为现实是，微调通常无法产生显著影响，尤其是当你已经有了一个很好的基础时。只有当你发现了某些根本性的新东西时，它才会对留存或早期用户的成功产生巨大的影响。所以，不要为了重新设计而重新设计，在动手之前，确保你获得了一个来之不易的新洞察。

---

### 00:50:50 Lenny

**English:**
Do you think at scale companies, I don't know, maybe after hundreds of people, they should have a team, like an onboarding optimization team? I find that often is true. And I guess, do you think that makes sense?

**中文翻译:**
你认为对于有一定规模的公司（比如几百人之后），是否应该有一个专门的团队，比如“新手引导优化团队”？我发现通常确实如此。你觉得这有意义吗？

---

### 00:51:03 Adam Fishman

**English:**
Yeah. I think it's very helpful. And the reason I think it's helpful is because I do think it's easy to walk away from onboarding because there's so many other things to work on and to lose sight of the fact this is such a critical part of the experience. And I don't know how many times I've come into a company and they're like, "Yeah, we built that a long time ago and we've never looked at it again. It's been a few years, but we're really having a real problem with retention and people dropping off in the first seven days." And I'm like, "Yeah, I think it's time we take another look at the onboarding experience. Products change quite a bit. Maybe people are getting something that's different than they expect, or maybe we know a lot more that we can use to influence decisions that they make."

**中文翻译:**
是的。我认为这非常有帮助。原因在于，新手引导很容易被忽视，因为有太多其他事情要忙，人们往往会忘记这是体验中如此关键的一部分。我不知道有多少次我进入一家公司，他们会说：“哦，那个流程我们很久以前就建好了，之后就再也没看过。已经过去几年了，但我们现在的留存确实有问题，用户在头七天就流失了。”我会说：“是的，我想是时候重新审视一下新手引导体验了。产品已经变了很多，也许用户得到的东西和他们预期的不一样，或者我们现在掌握了更多可以用来影响他们决策的信息。”

---

### 00:51:50 Adam Fishman

**English:**
So I do think it is beneficial to have that team, or at least a team, that part of their job is the activation experience and therefore some part of their roadmap is working on onboarding and then other aspects of activation. So it may not be what they work on 12 months out of the year, but maybe for a quarter or two in a given year.

**中文翻译:**
所以我确实认为拥有这样一个团队是有益的，或者至少有一个团队，其部分职责是负责“激活体验”，因此他们的路线图中有一部分是关于新手引导以及激活的其他方面。他们可能不需要一年 12 个月都做这个，但可能一年中有一两个季度会专注于此。

---

### 00:52:13 Lenny

**English:**
Cool. And there's a LinkedIn post you wrote with a bunch of examples of onboarding work you've done. So we're going to include them in the show notes for folks that are-

**中文翻译:**
酷。你写过一篇 LinkedIn 帖子，里面有很多你做过的新手引导工作的例子。我们会把它们放在节目简介里，方便那些——

---

### 00:52:20 Adam Fishman

**English:**
Nice.

**中文翻译:**
太好了。

---

### 00:52:20 Lenny

**English:**
... hoping for more examples. Yeah. Okay. Third topic, final topic is around company selection and evaluating where to work. And you have this really cool framework that I think you call PMF for candidates. Can you talk about what that is and then we'll get into it a little bit?

**中文翻译:**
……想要更多例子的人。好的。第三个话题，也是最后一个话题，是关于公司选择和评估去哪里工作。你有一个非常酷的框架，我想你称之为“候选人的 PMF”。你能聊聊那是什么吗？然后我们深入探讨一下。

---

### 00:52:34 Adam Fishman

**English:**
Yeah. I somehow stumbled on that name and it just made sense because of the acronym. But I think I was really motivated to revisit this because as we know in tech there's been a ton of layoffs and very public layoffs because of the economy, the state of funding, things like that. And I don't think we're done yet. I think we're pretty far from being done. But it's really important, and I've been burned by this a few times, to put some power back in the hands of the people who are actually seeking the jobs to understand what are some criteria that are important and these are the criteria that are important to me that help you make decisions about which company I should join, assuming they'll have me. And so the PMF acronym, and we're all familiar with product-market fit, right?

**中文翻译:**
是的。我无意中想到了这个名字，因为这个缩写很贴切。我之所以有动力重新审视这个问题，是因为正如我们所知，由于经济、融资状况等原因，科技行业出现了大量的裁员，而且很多是公开的大规模裁员。我认为这还没结束，离结束还远着呢。但这非常重要——我也曾被坑过几次——要让求职者重新掌握主动权，去理解哪些标准是重要的。这些是我认为重要的标准，它们能帮助你决定应该加入哪家公司（假设他们愿意录用我）。PMF 这个缩写，大家都熟悉“产品市场匹配”（Product-Market Fit），对吧？

---

### 00:53:23 Adam Fishman

**English:**
So in a way it's both the product-market fit for as a candidate with the company, but then also PMF stands for people, mission and financials. And these are my three criteria. They may not be yours, Lenny, or they might not be the average person on the street, but the point is that you should have a set of criteria that you are unapologetically rigorous around and you should learn how to evaluate companies against that set of criteria. First, I guess I'll tell you what by people, mission and financials.

**中文翻译:**
所以在某种程度上，它既是候选人与公司的“产品市场匹配”，同时 PMF 也代表：人（People）、使命（Mission）和财务状况（Financials）。这就是我的三个标准。Lenny，它们可能不是你的标准，也不是路人的标准，但重点是你应该有一套自己坚持并严格执行的标准，并且你应该学会如何根据这套标准来评估公司。首先，我来解释一下“人、使命和财务状况”分别指什么。

---

### 00:53:56 Adam Fishman

**English:**
People are these folks that I am going to enjoy working with everyday that I'm going to be able to have hard conversations with, that I'm going to be able to disagree with and work through those disagreements and feel better on the other side of that productive disagreement, for example, and get to resolutions. What do I think about my peer set, the leaders, the people below me, if that's the role I'm stepping into, et cetera. So that's the people dimension.

**中文翻译:**
“人”是指：这些人是我每天都乐于共事的吗？我能和他们进行艰难的对话吗？我能和他们产生分歧，并解决这些分歧，在经历这种“建设性冲突”后感觉更好并达成解决方案吗？我如何看待我的同僚、领导，以及如果我担任管理职，我如何看待下属等等。这就是人的维度。

---

### 00:54:30 Adam Fishman

**English:**
Mission, which is critically important for me, is that if I join a company and I do my job, which often involves growing that company really big, getting a lot of customers, generating a lot of demand and retention and stuff, I want to make sure that a lot of people have a better outcome in life because of that company's existence. And I don't just mean employees and founders having a good financial outcome, which I think is important. But I also mean in the case of creators on Patreon, we were building a new way for creators to make money, which they could then use to hire people, create more jobs, make better content, and live their life in a sustainable way so that they weren't a starving artist and they weren't living paycheck to paycheck. So that's really important, the mission aspect, that's got to exist.

**中文翻译:**
“使命”对我来说至关重要。如果我加入一家公司并尽职尽责（通常涉及把公司做大、获取大量客户、产生大量需求和留存等），我希望确保因为这家公司的存在，很多人能获得更好的生活结果。我指的不只是员工和创始人获得良好的财务回报（虽然这也很重要），我还指像 Patreon 的例子：我们为创作者建立了一种新的赚钱方式，他们可以用这些钱雇人、创造更多就业、制作更好的内容，并以可持续的方式生活，不再是“饥饿的艺术家”，不再过着入不敷出的生活。所以使命感非常重要，它必须存在。

---

### 00:55:19 Adam Fishman

**English:**
And then the third one is, and I think really important now is this idea of financials or fiscal discipline. You've got a lot of companies who raised boatloads of money or did financial planning during the peak of the pandemic and assumed that their business was going to continue operating at the pace that it was operating forever. A lot of those companies are running out of money, they've seen a hit to demand and they've had to lay people off as a result or make really big strategic swings.

**中文翻译:**
第三个是“财务状况”或“财政纪律”，我认为这在当下非常重要。有很多公司在疫情高峰期筹集了巨额资金或制定了财务计划，并假设他们的业务将永远保持那样的增长速度。现在很多这类公司都快没钱了，需求受到了打击，结果不得不裁员或进行巨大的战略转型。

---

### 00:55:53 Adam Fishman

**English:**
There are plenty of companies that you're not really hearing about that were more conservative in their approach, that understood and were able to look into the future and be really responsible with their money. And those people are not laying off employees. And so they're not all over LinkedIn talking about it because they're not laying people off. There's no hashtag layoff for them. So that's what by financials. And so that's the PMF framework and evaluating across those dimensions is super important. I've done it two times in the last 10 to 15 years, and I've done it poorly, two times in the last 15 years. And Lyft and Patreon are two times where I've done it really well. Wyzant and Imperfect Foods are two times where I personally don't think I've done a good enough job evaluating.

**中文翻译:**
还有很多你可能没怎么听说过的公司，它们的做法更保守，能够洞察未来并对资金非常负责。这些人没有裁员。所以他们不会在 LinkedIn 上到处谈论这件事，因为他们没裁员，也没有属于他们的“#裁员”标签。这就是财务维度的含义。这就是 PMF 框架，跨维度评估超级重要。在过去的 10 到 15 年里，我做对过两次，也做砸过两次。Lyft 和 Patreon 是我做得非常好的两次。Wyzant 和 Imperfect Foods 是我个人认为评估得不够好的两次。

---

### 00:56:41 Adam Fishman

**English:**
Any time where I've shortcutted my criteria, where I've settled for two out of three, or thought one was great, when really it wasn't, has not ended well for me, for the company, it's not that the company imploded, but I found myself out of a job or really frustrated and burned out or something like that. I already talked about the Wyzant example where we had to lay off a bunch of people because the founders expected something very different than what I expected to be able to deliver, that's a big people miss. And Imperfect Foods was somewhat similar, amazing mission, really great financial strategy, fantastic CFO, but a lot of infighting at the C-suite. And it made it really difficult for us to plan and move the company forward together because people were at odds with each other all the time and not resolving disagreements productively. And when that happens, it's hard to be a product or a growth leader because you bear the brunt of the angst that people have. So anyway, so those are a couple examples and some of the characteristics of PMF.

**中文翻译:**
任何时候，只要我降低了标准，只要我满足于“三项中占两项”，或者误以为某一项很好而实际上并非如此，结果对我、对公司都不太好。倒不是说公司倒闭了，而是我发现自己丢了工作，或者感到非常沮丧、精疲力竭。我已经聊过 Wyzant 的例子，因为创始人预期的和我能交付的完全不同，我们不得不裁掉很多人，那是严重的“人”的失误。Imperfect Foods 也有些类似：使命感很棒，财务策略很好，CFO 也非常出色，但高管层（C-suite）内斗严重。这让我们很难共同规划和推动公司前进，因为人们总是意见不合，而且无法建设性地解决分歧。当这种情况发生时，很难做一个产品或增长负责人，因为你会首当其冲地承受人们的焦虑。总之，这些就是 PMF 的一些例子和特征。

---

### 00:57:57 Lenny

**English:**
In the case of Imperfect Foods, what could you have done to have avoided that issue and seen if it was true PMF?

**中文翻译:**
在 Imperfect Foods 的案例中，你本可以做些什么来避免那个问题，并看清它是否真的是“真 PMF”？

---

### 00:58:04 Adam Fishman

**English:**
I would have tried to observe the inner workings of the C-Suite a little bit more closely before I accepted an offer to join the company. I would've attended an executive meeting or joined them on an offsite. And I think, too often, candidates don't feel like they can ask for those things. And it's true, if you're entering the C-suite, you're going to ask for more stuff, you're more experienced. But I also think that's true of a junior employee. You can observe a team meeting, you can observe a product review and understand, you sign an NDA, you promise you won't tell anybody about it, but observe what is happening and the dynamics of that room. Who's doing the talking? How feedback is delivered, is it constructive? Is it antagonistic, et cetera. So you can observe and then you can also ask questions.

**中文翻译:**
在接受入职邀请之前，我会尝试更近距离地观察高管层的内部运作。我会要求参加一次高管会议，或者加入他们的团建（Offsite）。我认为，候选人往往觉得自己不能提出这些要求。确实，如果你要进入高管层，你会要求更多，因为你更有经验。但我认为这对初级员工也适用。你可以观察一次团队会议，观察一次产品评审。你签署保密协议（NDA），承诺不外传，但去观察那个房间里发生了什么以及动态如何。谁在发言？反馈是如何传达的？是建设性的还是对抗性的？你可以观察，也可以提问。

---

### 00:59:00 Adam Fishman

**English:**
So questions that I like to ask are, tell me about the last strategic offsite that you had as a leadership team. Where do people disagree? What was one thing that they disagreed on and where did you end up on that point and how did you get there? And I actually ask them to tell me, it's like a reverse behavioral interview question. I ask them to tell me how they navigated it, and I will ask the CEO that and really dig in on that particular set of questions. Those are the things that I do to evaluate the people dimension, which is one of the hardest, I will say. Financials and mission a little easier to evaluate, but people really require getting to know teams. So it is hard.

**中文翻译:**
我喜欢问的问题包括：告诉我你们领导团队上一次战略团建的情况。人们在哪里产生了分歧？分歧点是什么？你们最终是如何达成一致的？过程是怎样的？我实际上是让他们告诉我——这就像是一个反向的行为面试题。我会要求他们告诉我他们是如何处理的，我会问 CEO 这个问题，并深入挖掘那一组特定的问题。这些就是我用来评估“人”这个维度的方法。我得说，这是最难的维度之一。财务和使命相对容易评估，但“人”真的需要去深入了解团队。所以这很难。

---

### 00:59:43 Lenny

**English:**
That's such a good question to ask. And your point is you can ask that even if you're not a senior leader, you're just ICPM joining a team. Is there anything else you think folks can do? So you said, join some offsites maybe, ask this question that you shared, any other tips for folks just to understand if the people are a good fit? Because it's pretty wild. You're going to spend so much time with these people and you meet them once in a half hour interview and then you have to decide if that's your life for the next four or five, 10 years.

**中文翻译:**
这真是一个非常棒的问题。你的观点是，即使你不是高级领导，只是一个加入团队的基层产品经理（IC PM），你也可以问。你觉得大家还能做些什么吗？你提到了参加团建、问你分享的那个问题，还有其他建议能帮助大家了解“人”是否合适吗？因为这挺疯狂的：你要和这些人共度大量时光，但你只在半小时的面试中见过他们一次，然后你就得决定这是否就是你未来 4 年、5 年甚至 10 年的生活。

---

### 01:00:09 Adam Fishman

**English:**
Well, one thing that I would say is, you're an investor, right? You invest in a lot of companies, you're an angel investor and you have the Airbnb syndicate and things like that. You evaluate companies when you're making an investment decision, right? Because you're investing a sum of money into that company. And so as a result, you do a lot of diligence on companies or read other people's diligence, something like that. When you're interviewing at a company, you are actually investing an even more scarce resource. You're investing your time. There is no way to get more time. We're all on a finite clock. You can always get more money. If you make a bad investment decision, "Okay, we lost there." Provided you didn't bankrupt yourself. Even if you did, you can climb out of bankruptcy. There are things that you can do, but time is fleeting.

**中文翻译:**
我想说的一点是：你是一个投资者，对吧？你投资了很多公司，你是天使投资人，还有 Airbnb 辛迪加之类的。你在做投资决策时会评估公司，对吧？因为你向那家公司投入了一笔钱。因此，你会对公司做大量的尽职调查，或者阅读别人的调查报告。当你去一家公司面试时，你实际上是在投资一种更稀缺的资源：你的时间。时间是无法增加的，我们每个人的时间都是有限的。钱丢了总能再赚，如果你做了一个糟糕的投资决策，“好吧，那笔亏了”，只要你没破产就行。即使破产了，你也能东山再起。但时间一去不复返。

---

### 01:01:29 Adam Fishman

**English:**
And so in this case, you can talk to current or former employees who are not on the interview circuit. And because they are not on the interview circuit, their role as a salesperson in the process is greatly diminished. And they can, especially if they're not at the company anymore, give you some pretty candid feedback on what it's like to work there. So I'll give you a really good example. That was super impressive. A PM who worked for me at Patreon, who you know Tal Raviv-

**中文翻译:**
所以在这种情况下，你可以找那些不在面试流程中的现任或前任员工聊聊。因为他们不在面试流程中，他们作为“推销员”的角色就大大减弱了。他们可以——尤其是如果他们已经不在那家公司了——给你一些关于在那里工作的非常坦诚的反馈。我给你举一个让我印象非常深刻的例子。一个曾在 Patreon 为我工作的 PM，你也认识，Tal Raviv——

---

### 01:02:00 Lenny

**English:**
Shout out Tal.

**中文翻译:**
向 Tal 致敬。

---

### 01:02:01 Adam Fishman

**English:**
Shout out to Tal, who works on this product that we're recording on right now-

**中文翻译:**
向 Tal 致敬，他就在我们现在录音用的这个产品（Riverside）工作——

---

### 01:02:06 Lenny

**English:**
Shout out Riverside.

**中文翻译:**
向 Riverside 致敬。

---

### 01:02:08 Adam Fishman

**English:**
... when he interviewed at Patreon, he asked me for a list of people who I had managed in the past, and he contacted them to talk to them about what it was like to work for me. That was the first time that had actually ever happened in my career. And I was happy to share that with him. And it represented to me a great level of thoughtfulness and insight around him evaluating what he was getting himself into. And he was an ICPM and he asked that of me, who was a VP executive level person at the company.

**中文翻译:**
……当他在 Patreon 面试时，他向我要了一份我过去管理过的人员名单，然后他联系了他们，询问在我的手下工作是什么感觉。那是我职业生涯中第一次遇到这种情况。我很乐意分享给他。这向我展示了他对自己即将面临的环境有着极高的思考深度和洞察力。他当时只是一个基层 PM，却向我这个公司的副总裁级别的高管提出了这个要求。

---

### 01:02:44 Adam Fishman

**English:**
So you can do that. And if a company says no or a person says no, I think that actually says a bit more about them than anything else. If they're trying to withhold that from you. Because why would you? If I'm a great manager, I'm happy to have you talk to people who I've managed before, even people maybe who I had to let go or something like that, right? I'm confident that those were the right decisions and that those people ended up in a better place and they were taken care of with great care. I would actually make a reference of somebody who I have let go before just so that someone could get a real honest truth of what it was like working with me. So anyways, that's my take on PMF and questions to ask.

**中文翻译:**
所以你可以这样做。如果一家公司或一个人拒绝了，我认为这本身就说明了很多问题。如果他们试图对你隐瞒。因为为什么要隐瞒呢？如果我是一个优秀的管理者，我很乐意让你和我以前管理过的人聊聊，甚至是那些我不得不解雇的人，对吧？我有信心那些是正确的决定，而且那些人最后都去了更好的地方，并且得到了妥善的对待。我甚至会提供一个我解雇过的人作为参考，这样别人就能听到关于和我共事的真实情况。总之，这就是我对 PMF 的看法以及该问的问题。

---

### 01:03:30 Lenny

**English:**
I imagine you have PMF with your current world, so maybe just to close, can you just remind folks what you're up to now and where they can find you online and also how listeners can be useful to you?

**中文翻译:**
我想你现在的生活已经达到了 PMF。最后，你能提醒大家你现在在忙什么，在哪里可以在线找到你，以及听众可以如何帮到你吗？

---

### 01:03:42 Adam Fishman

**English:**
First, thanks for having me on, Lenny. This was super fun. I love talking about this stuff and it was great chatting with you. So thanks again for having me.

**中文翻译:**
首先，谢谢你邀请我，Lenny。这超级有趣。我喜欢聊这些东西，和你聊天很愉快。再次感谢。

---

### 01:03:50 Lenny

**English:**
My pleasure.

**中文翻译:**
我的荣幸。

---

### 01:03:51 Adam Fishman

**English:**
There are a few ways to get in touch with me. You can follow me and communicate with me on Twitter. My Twitter handle is Fishman, F-I-S-H-M-A-N AF. And I do respond to messages provided that they're polite. And you can also find me on LinkedIn. Those are the two platforms I live on most frequently, for better or for worse. And then I now have this newsletter, fishmanafnewsletter.com. And a lot of what we talked about today are things that I am publishing in written form on that newsletter and plan to continue publishing going forward. And again, it was inspired by the work that you're doing, Lenny.

**中文翻译:**
有几种方式可以联系我。你可以在 Twitter 上关注我并与我交流，我的账号是 FishmanAF。只要有礼貌，我都会回复消息。你也可以在 LinkedIn 上找到我。无论好坏，这两个是我最常活跃的平台。然后我还有这份时事通讯：fishmanafnewsletter.com。我们今天谈到的很多内容，我都以文字形式发布在那份通讯上，并计划未来继续发布。再次强调，这是受了你的启发，Lenny。

---

### 01:04:29 Adam Fishman

**English:**
So how can people be helpful to me? I think certainly subscribing to the newsletter and joining that community, telling me about the things that are challenging to them so that I can find ways of finding how they meet up with my interests and translating them into written pieces. And then if you're ever interested in exploring an advisory relationship with me or learning more what that looks like, reach out. I'd love to meet you. Advisory work is what pays the bills right now, and my kids need to eat. I probably need to eat a little less, but my kids need to eat. So reach out about an advisory relationship if you're looking for some help on growth or product or general company building. It's what I do.

**中文翻译:**
大家可以如何帮到我？我想，订阅时事通讯并加入那个社区肯定有帮助。告诉我你们面临的挑战，这样我就能找到这些挑战与我兴趣的交集，并把它们写成文章。另外，如果你有兴趣探索与我的咨询合作关系，或者想了解那是怎么回事，请联系我。我很乐意认识你。咨询工作是目前维持我生计的来源，我的孩子们得吃饭。我可能得少吃点，但孩子们得吃饱。所以，如果你在增长、产品或公司构建方面需要帮助，请联系我洽谈咨询事宜。这就是我的专业所在。

---

### 01:05:08 Lenny

**English:**
Adam, you're so full of insights and lessons, and I'm so happy that you've started writing and sharing a lot of these things. Folks should definitely subscribe. Fishmanafnewsletter.com. Adam, thank you for being here.

**中文翻译:**
Adam，你充满了洞察和经验，我很高兴你开始写作并分享这些东西。大家一定要去订阅：fishmanafnewsletter.com。Adam，谢谢你的到来。

---

### 01:05:18 Adam Fishman

**English:**
Yeah, thanks a lot, Lenny. This was awesome.

**中文翻译:**
是的，非常感谢，Lenny。这太棒了。

---

### 01:05:21 Lenny

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcast, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢大家的收听。如果你觉得本期节目有价值，可以在 Apple Podcast、Spotify 或你喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目再见。